/*
 Highcharts JS v9.1.2 (2021-06-16)

 Annotations module

 (c) 2009-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/annotations",["highcharts"],function(w){a(w);a.Highcharts=w;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function w(b,a,n,u){b.hasOwnProperty(a)||(b[a]=u.apply(null,n))}a=a?a._modules:{};w(a,"Extensions/Annotations/Mixins/EventEmitterMixin.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(b,
a){var f=a.addEvent,u=a.fireEvent,l=a.objectEach,m=a.pick,c=a.removeEvent;return{addEvents:function(){var c=this,d=function(d){f(d,b.isTouchDevice?"touchstart":"mousedown",function(d){c.onMouseDown(d)},{passive:!1})};d(this.graphic.element);(c.labels||[]).forEach(function(e){e.options.useHTML&&e.graphic.text&&d(e.graphic.text.element)});l(c.options.events,function(d,e){var b=function(b){"click"===e&&c.cancelClick||d.call(c,c.chart.pointer.normalize(b),c.target)};if(-1===(c.nonDOMEvents||[]).indexOf(e))c.graphic.on(e,
b);else f(c,e,b,{passive:!1})});if(c.options.draggable&&(f(c,"drag",c.onDrag),!c.graphic.renderer.styledMode)){var e={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[c.options.draggable]};c.graphic.css(e);(c.labels||[]).forEach(function(d){d.options.useHTML&&d.graphic.text&&d.graphic.text.css(e)})}c.isUpdating||u(c,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag());this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(c){var d=this,
e=d.chart.pointer;c.preventDefault&&c.preventDefault();if(2!==c.button){c=e.normalize(c);var A=c.chartX;var g=c.chartY;d.cancelClick=!1;d.chart.hasDraggedAnnotation=!0;d.removeDrag=f(b.doc,b.isTouchDevice?"touchmove":"mousemove",function(c){d.hasDragged=!0;c=e.normalize(c);c.prevChartX=A;c.prevChartY=g;u(d,"drag",c);A=c.chartX;g=c.chartY},b.isTouchDevice?{passive:!1}:void 0);d.removeMouseUp=f(b.doc,b.isTouchDevice?"touchend":"mouseup",function(e){d.cancelClick=d.hasDragged;d.hasDragged=!1;d.chart.hasDraggedAnnotation=
!1;u(m(d.target,d),"afterUpdate");d.onMouseUp(e)},b.isTouchDevice?{passive:!1}:void 0)}},onMouseUp:function(c){var d=this.chart;c=this.target||this;var e=d.options.annotations;d=d.annotations.indexOf(c);this.removeDocEvents();e[d]=c.options},onDrag:function(c){if(this.chart.isInsidePlot(c.chartX-this.chart.plotLeft,c.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var d=this.mouseMoveToTranslation(c);"x"===this.options.draggable&&(d.y=0);"y"===this.options.draggable&&(d.x=0);this.points.length?this.translate(d.x,
d.y):(this.shapes.forEach(function(e){e.translate(d.x,d.y)}),this.labels.forEach(function(e){e.translate(d.x,d.y)}));this.redraw(!1)}},mouseMoveToRadians:function(c,d,e){var b=c.prevChartY-e,g=c.prevChartX-d;e=c.chartY-e;c=c.chartX-d;this.chart.inverted&&(d=g,g=b,b=d,d=c,c=e,e=d);return Math.atan2(e,c)-Math.atan2(b,g)},mouseMoveToTranslation:function(c){var d=c.chartX-c.prevChartX;c=c.chartY-c.prevChartY;if(this.chart.inverted){var e=c;c=d;d=e}return{x:d,y:c}},mouseMoveToScale:function(c,d,e){d=(c.chartX-
d||1)/(c.prevChartX-d||1);c=(c.chartY-e||1)/(c.prevChartY-e||1);this.chart.inverted&&(e=c,c=d,d=e);return{x:d,y:c}},destroy:function(){this.removeDocEvents();c(this);this.hcEvents=null}}});w(a,"Extensions/Annotations/ControlPoint.js",[a["Core/Utilities.js"],a["Extensions/Annotations/Mixins/EventEmitterMixin.js"]],function(b,a){var f=b.merge,u=b.pick;return function(){function b(b,c,f,d){this.addEvents=a.addEvents;this.graphic=void 0;this.mouseMoveToRadians=a.mouseMoveToRadians;this.mouseMoveToScale=
a.mouseMoveToScale;this.mouseMoveToTranslation=a.mouseMoveToTranslation;this.onDrag=a.onDrag;this.onMouseDown=a.onMouseDown;this.onMouseUp=a.onMouseUp;this.removeDocEvents=a.removeDocEvents;this.nonDOMEvents=["drag"];this.chart=b;this.target=c;this.options=f;this.index=u(f.index,d)}b.prototype.setVisibility=function(b){this.graphic.attr("visibility",b?"visible":"hidden");this.options.visible=b};b.prototype.render=function(){var b=this.chart,c=this.options;this.graphic=b.renderer.symbol(c.symbol,0,
0,c.width,c.height).add(b.controlPointsGroup).css(c.style);this.setVisibility(c.visible);this.addEvents()};b.prototype.redraw=function(b){this.graphic[b?"animate":"attr"](this.options.positioner.call(this,this.target))};b.prototype.destroy=function(){a.destroy.call(this);this.graphic&&(this.graphic=this.graphic.destroy());this.options=this.target=this.chart=null};b.prototype.update=function(b){var c=this.chart,a=this.target,d=this.index;b=f(!0,this.options,b);this.destroy();this.constructor(c,a,b,
d);this.render(c.controlPointsGroup);this.redraw()};return b}()});w(a,"Extensions/Annotations/MockPoint.js",[a["Core/Series/Series.js"],a["Core/Utilities.js"],a["Core/Axis/Axis.js"]],function(b,a,n){var f=a.defined,l=a.fireEvent;return function(){function a(c,a,d){this.y=this.x=this.ttBelow=this.plotY=this.plotX=this.negative=this.isInside=void 0;this.mock=!0;this.series={visible:!0,chart:c,getPlotBox:b.prototype.getPlotBox};this.target=a||null;this.options=d;this.applyOptions(this.getOptions())}
a.fromPoint=function(c){return new a(c.series.chart,null,{x:c.x,y:c.y,xAxis:c.series.xAxis,yAxis:c.series.yAxis})};a.pointToPixels=function(c,b){var d=c.series,e=d.chart,a=c.plotX,g=c.plotY;e.inverted&&(c.mock?(a=c.plotY,g=c.plotX):(a=e.plotWidth-c.plotY,g=e.plotHeight-c.plotX));d&&!b&&(c=d.getPlotBox(),a+=c.translateX,g+=c.translateY);return{x:a,y:g}};a.pointToOptions=function(c){return{x:c.x,y:c.y,xAxis:c.series.xAxis,yAxis:c.series.yAxis}};a.prototype.hasDynamicOptions=function(){return"function"===
typeof this.options};a.prototype.getOptions=function(){return this.hasDynamicOptions()?this.options(this.target):this.options};a.prototype.applyOptions=function(c){this.command=c.command;this.setAxis(c,"x");this.setAxis(c,"y");this.refresh()};a.prototype.setAxis=function(c,b){b+="Axis";c=c[b];var d=this.series.chart;this.series[b]=c instanceof n?c:f(c)?d[b][c]||d.get(c):null};a.prototype.toAnchor=function(){var c=[this.plotX,this.plotY,0,0];this.series.chart.inverted&&(c[0]=this.plotY,c[1]=this.plotX);
return c};a.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}};a.prototype.isInsidePlot=function(){var c=this.plotX,b=this.plotY,d=this.series.xAxis,e=this.series.yAxis,a={x:c,y:b,isInsidePlot:!0};d&&(a.isInsidePlot=f(c)&&0<=c&&c<=d.len);e&&(a.isInsidePlot=a.isInsidePlot&&f(b)&&0<=b&&b<=e.len);l(this.series.chart,"afterIsInsidePlot",a);return a.isInsidePlot};a.prototype.refresh=function(){var c=this.series,b=c.xAxis;c=c.yAxis;var d=this.getOptions();b?(this.x=d.x,this.plotX=
b.toPixels(d.x,!0)):(this.x=null,this.plotX=d.x);c?(this.y=d.y,this.plotY=c.toPixels(d.y,!0)):(this.y=null,this.plotY=d.y);this.isInside=this.isInsidePlot()};a.prototype.translate=function(c,b,d,e){this.hasDynamicOptions()||(this.plotX+=d,this.plotY+=e,this.refreshOptions())};a.prototype.scale=function(c,b,d,e){if(!this.hasDynamicOptions()){var a=this.plotY*e;this.plotX=(1-d)*c+this.plotX*d;this.plotY=(1-e)*b+a;this.refreshOptions()}};a.prototype.rotate=function(c,b,d){if(!this.hasDynamicOptions()){var e=
Math.cos(d);d=Math.sin(d);var a=this.plotX,g=this.plotY;a-=c;g-=b;this.plotX=a*e-g*d+c;this.plotY=a*d+g*e+b;this.refreshOptions()}};a.prototype.refreshOptions=function(){var c=this.series,b=c.xAxis;c=c.yAxis;this.x=this.options.x=b?this.options.x=b.toValue(this.plotX,!0):this.plotX;this.y=this.options.y=c?c.toValue(this.plotY,!0):this.plotY};return a}()});w(a,"Extensions/Annotations/Mixins/ControllableMixin.js",[a["Extensions/Annotations/ControlPoint.js"],a["Extensions/Annotations/MockPoint.js"],
a["Core/Tooltip.js"],a["Core/Utilities.js"]],function(b,a,n,u){var f=u.isObject,m=u.isString,c=u.merge,G=u.splat;return{init:function(c,b,a){this.annotation=c;this.chart=c.chart;this.options=b;this.points=[];this.controlPoints=[];this.index=a;this.linkPoints();this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var c=this.options;return c.points||c.point&&G(c.point)},attrsFromOptions:function(c){var b=this.constructor.attrsMap,d={},
a,r=this.chart.styledMode;for(a in c){var p=b[a];!p||r&&-1!==["fill","stroke","stroke-width"].indexOf(p)||(d[p]=c[a])}return d},anchor:function(b){var d=b.series.getPlotBox(),a=b.series.chart,g=b.mock?b.toAnchor():n.prototype.getAnchor.call({chart:b.series.chart},b);g={x:g[0]+(this.options.x||0),y:g[1]+(this.options.y||0),height:g[2]||0,width:g[3]||0};return{relativePosition:g,absolutePosition:c(g,{x:g.x+(b.mock?d.translateX:a.plotLeft),y:g.y+(b.mock?d.translateY:a.plotTop)})}},point:function(c,b){if(c&&
c.series)return c;b&&null!==b.series||(f(c)?b=new a(this.chart,this,c):m(c)?b=this.chart.get(c)||null:"function"===typeof c&&(b=c.call(b,this),b=b.series?b:new a(this.chart,this,c)));return b},linkPoints:function(){var c=this.getPointsOptions(),b=this.points,a=c&&c.length||0,g;for(g=0;g<a;g++){var r=this.point(c[g],b[g]);if(!r){b.length=0;return}r.mock&&r.refresh();b[g]=r}return b},addControlPoints:function(){var a=this.options.controlPoints;(a||[]).forEach(function(d,A){d=c(this.options.controlPointOptions,
d);d.index||(d.index=A);a[A]=d;this.controlPoints.push(new b(this.chart,this,d))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(c){this.controlPoints.forEach(function(c){c.render()})},redraw:function(c){this.controlPoints.forEach(function(b){b.redraw(c)})},transform:function(c,b,a,g,r){if(this.chart.inverted){var d=b;b=a;a=d}this.points.forEach(function(d,e){this.transformPoint(c,b,a,g,r,e)},this)},transformPoint:function(c,b,A,g,r,p){var d=this.points[p];d.mock||(d=
this.points[p]=a.fromPoint(d));d[c](b,A,g,r)},translate:function(c,b){this.transform("translate",null,null,c,b)},translatePoint:function(c,b,a){this.transformPoint("translate",null,null,c,b,a)},translateShape:function(c,b){var a=this.annotation.chart,d=this.annotation.userOptions,e=a.annotations.indexOf(this.annotation);a=a.options.annotations[e];this.translatePoint(c,b,0);a[this.collection][this.index].point=this.options.point;d[this.collection][this.index].point=this.options.point},rotate:function(c,
b,a){this.transform("rotate",c,b,a)},scale:function(c,b,a,g){this.transform("scale",c,b,a,g)},setControlPointsVisibility:function(c){this.controlPoints.forEach(function(b){b.setVisibility(c)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy());this.tracker&&(this.tracker=this.tracker.destroy());this.controlPoints.forEach(function(c){c.destroy()});this.options=this.controlPoints=this.points=this.chart=null;this.annotation&&(this.annotation=null)},update:function(b){var a=this.annotation;
b=c(!0,this.options,b);var d=this.graphic.parentGroup;this.destroy();this.constructor(a,b,this.index);this.render(d);this.redraw()}}});w(a,"Extensions/Annotations/Mixins/MarkerMixin.js",[a["Core/Chart/Chart.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(b,a,n){function f(c){return function(b){this.attr(c,"url(#"+b+")")}}var l=n.addEvent,m=n.defined,c=n.merge,G=n.uniqueKey,d={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",
attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};a.prototype.addMarker=function(b,a){var d={attributes:{id:b}},e={stroke:a.color||"none",fill:a.color||"rgba(0, 0, 0, 0.75)"};d.children=a.children&&a.children.map(function(b){return c(e,b)});a=c(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,
refY:0,orient:"auto"}},a,d);a=this.definition(a);a.id=b;return a};a={markerEndSetter:f("marker-end"),markerStartSetter:f("marker-start"),setItemMarkers:function(b){var a=b.options,d=b.chart,e=d.options.defs,p=a.fill,f=m(p)&&"none"!==p?p:a.stroke;["markerStart","markerEnd"].forEach(function(g){var r=a[g],p;if(r){for(p in e){var z=e[p];if((r===(z.attributes&&z.attributes.id)||r===z.id)&&"marker"===z.tagName){var h=z;break}}h&&(r=b[g]=d.renderer.addMarker((a.id||G())+"-"+r,c(h,{color:f})),b.attr(g,r.getAttribute("id")))}})}};
l(b,"afterGetContainer",function(){this.options.defs=c(d,this.options.defs||{})});return a});w(a,"Extensions/Annotations/Controllables/ControllablePath.js",[a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Core/Globals.js"],a["Extensions/Annotations/Mixins/MarkerMixin.js"],a["Core/Utilities.js"]],function(b,a,n,u){var f=u.extend,m="rgba(192,192,192,"+(a.svg?.0001:.002)+")";return function(){function c(c,a,e){this.addControlPoints=b.addControlPoints;this.anchor=b.anchor;this.attr=b.attr;
this.attrsFromOptions=b.attrsFromOptions;this.destroy=b.destroy;this.getPointsOptions=b.getPointsOptions;this.init=b.init;this.linkPoints=b.linkPoints;this.point=b.point;this.rotate=b.rotate;this.scale=b.scale;this.setControlPointsVisibility=b.setControlPointsVisibility;this.setMarkers=n.setItemMarkers;this.transform=b.transform;this.transformPoint=b.transformPoint;this.translate=b.translate;this.translatePoint=b.translatePoint;this.translateShape=b.translateShape;this.update=b.update;this.type="path";
this.init(c,a,e);this.collection="shapes"}c.prototype.toD=function(){var b=this.options.d;if(b)return"function"===typeof b?b.call(this):b;b=this.points;var c=b.length,a=c,f=b[0],g=a&&this.anchor(f).absolutePosition,r=0,p=[];if(g)for(p.push(["M",g.x,g.y]);++r<c&&a;)f=b[r],a=f.command||"L",g=this.anchor(f).absolutePosition,"M"===a?p.push([a,g.x,g.y]):"L"===a?p.push([a,g.x,g.y]):"Z"===a&&p.push([a]),a=f.series.visible;return a?this.chart.renderer.crispLine(p,this.graphic.strokeWidth()):null};c.prototype.shouldBeDrawn=
function(){return b.shouldBeDrawn.call(this)||!!this.options.d};c.prototype.render=function(c){var a=this.options,e=this.attrsFromOptions(a);this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(e).add(c);a.className&&this.graphic.addClass(a.className);this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(c);this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:m,fill:m,"stroke-width":this.graphic.strokeWidth()+
2*a.snap});b.render.call(this);f(this.graphic,{markerStartSetter:n.markerStartSetter,markerEndSetter:n.markerEndSetter});this.setMarkers(this)};c.prototype.redraw=function(c){var a=this.toD(),e=c?"animate":"attr";a?(this.graphic[e]({d:a}),this.tracker[e]({d:a})):(this.graphic.attr({d:"M 0 -9000000000"}),this.tracker.attr({d:"M 0 -9000000000"}));this.graphic.placed=this.tracker.placed=!!a;b.redraw.call(this,c)};c.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",
zIndex:"zIndex"};return c}()});w(a,"Extensions/Annotations/Controllables/ControllableRect.js",[a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Extensions/Annotations/Controllables/ControllablePath.js"],a["Core/Utilities.js"]],function(b,a,n){var f=n.merge;return function(){function l(a,c,f){this.addControlPoints=b.addControlPoints;this.anchor=b.anchor;this.attr=b.attr;this.attrsFromOptions=b.attrsFromOptions;this.destroy=b.destroy;this.getPointsOptions=b.getPointsOptions;this.init=b.init;
this.linkPoints=b.linkPoints;this.point=b.point;this.rotate=b.rotate;this.scale=b.scale;this.setControlPointsVisibility=b.setControlPointsVisibility;this.shouldBeDrawn=b.shouldBeDrawn;this.transform=b.transform;this.transformPoint=b.transformPoint;this.translatePoint=b.translatePoint;this.translateShape=b.translateShape;this.update=b.update;this.type="rect";this.translate=b.translateShape;this.init(a,c,f);this.collection="shapes"}l.prototype.render=function(a){var c=this.attrsFromOptions(this.options);
this.graphic=this.annotation.chart.renderer.rect(0,-9E9,0,0).attr(c).add(a);b.render.call(this)};l.prototype.redraw=function(a){var c=this.anchor(this.points[0]).absolutePosition;if(c)this.graphic[a?"animate":"attr"]({x:c.x,y:c.y,width:this.options.width,height:this.options.height});else this.attr({x:0,y:-9E9});this.graphic.placed=!!c;b.redraw.call(this,a)};l.attrsMap=f(a.attrsMap,{width:"width",height:"height"});return l}()});w(a,"Extensions/Annotations/Controllables/ControllableCircle.js",[a["Extensions/Annotations/Mixins/ControllableMixin.js"],
a["Extensions/Annotations/Controllables/ControllablePath.js"],a["Core/Utilities.js"]],function(b,a,n){var f=n.merge;return function(){function l(a,c,f){this.addControlPoints=b.addControlPoints;this.anchor=b.anchor;this.attr=b.attr;this.attrsFromOptions=b.attrsFromOptions;this.destroy=b.destroy;this.getPointsOptions=b.getPointsOptions;this.init=b.init;this.linkPoints=b.linkPoints;this.point=b.point;this.rotate=b.rotate;this.scale=b.scale;this.setControlPointsVisibility=b.setControlPointsVisibility;
this.shouldBeDrawn=b.shouldBeDrawn;this.transform=b.transform;this.transformPoint=b.transformPoint;this.translatePoint=b.translatePoint;this.translateShape=b.translateShape;this.update=b.update;this.type="circle";this.translate=b.translateShape;this.init(a,c,f);this.collection="shapes"}l.prototype.render=function(a){var c=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9E9,0).attr(c).add(a);b.render.call(this)};l.prototype.redraw=function(a){var c=this.anchor(this.points[0]).absolutePosition;
if(c)this.graphic[a?"animate":"attr"]({x:c.x,y:c.y,r:this.options.r});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!c;b.redraw.call(this,a)};l.prototype.setRadius=function(b){this.options.r=b};l.attrsMap=f(a.attrsMap,{r:"r"});return l}()});w(a,"Extensions/Annotations/Controllables/ControllableLabel.js",[a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Core/FormatUtilities.js"],a["Extensions/Annotations/MockPoint.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Tooltip.js"],
a["Core/Utilities.js"]],function(b,a,n,u,l,m){var c=a.format;a=u.prototype.symbols;var f=m.extend,d=m.isNumber,e=m.pick;m=function(){function a(a,c,d){this.addControlPoints=b.addControlPoints;this.attr=b.attr;this.attrsFromOptions=b.attrsFromOptions;this.destroy=b.destroy;this.getPointsOptions=b.getPointsOptions;this.init=b.init;this.linkPoints=b.linkPoints;this.point=b.point;this.rotate=b.rotate;this.scale=b.scale;this.setControlPointsVisibility=b.setControlPointsVisibility;this.shouldBeDrawn=b.shouldBeDrawn;
this.transform=b.transform;this.transformPoint=b.transformPoint;this.translateShape=b.translateShape;this.update=b.update;this.init(a,c,d);this.collection="labels"}a.alignedPosition=function(a,b){var c=a.align,d=a.verticalAlign,e=(b.x||0)+(a.x||0),g=(b.y||0)+(a.y||0),r,f;"right"===c?r=1:"center"===c&&(r=2);r&&(e+=(b.width-(a.width||0))/r);"bottom"===d?f=1:"middle"===d&&(f=2);f&&(g+=(b.height-(a.height||0))/f);return{x:Math.round(e),y:Math.round(g)}};a.justifiedOptions=function(a,b,c,d){var e=c.align,
g=c.verticalAlign,f=b.box?0:b.padding||0,r=b.getBBox();b={align:e,verticalAlign:g,x:c.x,y:c.y,width:b.width,height:b.height};c=(d.x||0)-a.plotLeft;d=(d.y||0)-a.plotTop;var h=c+f;0>h&&("right"===e?b.align="left":b.x=(b.x||0)-h);h=c+r.width-f;h>a.plotWidth&&("left"===e?b.align="right":b.x=(b.x||0)+a.plotWidth-h);h=d+f;0>h&&("bottom"===g?b.verticalAlign="top":b.y=(b.y||0)-h);h=d+r.height-f;h>a.plotHeight&&("top"===g?b.verticalAlign="bottom":b.y=(b.y||0)+a.plotHeight-h);return b};a.prototype.translatePoint=
function(a,c){b.translatePoint.call(this,a,c,0)};a.prototype.translate=function(b,a){var c=this.annotation.chart,d=this.annotation.userOptions,e=c.annotations.indexOf(this.annotation);e=c.options.annotations[e];c.inverted&&(c=b,b=a,a=c);this.options.x+=b;this.options.y+=a;e[this.collection][this.index].x=this.options.x;e[this.collection][this.index].y=this.options.y;d[this.collection][this.index].x=this.options.x;d[this.collection][this.index].y=this.options.y};a.prototype.render=function(c){var d=
this.options,e=this.attrsFromOptions(d),g=d.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,d.shape,null,null,d.useHTML,null,"annotation-label").attr(e).add(c);this.annotation.chart.styledMode||("contrast"===g.color&&(g.color=this.annotation.chart.renderer.getContrast(-1<a.shapesWithoutBackground.indexOf(d.shape)?"#FFFFFF":d.backgroundColor)),this.graphic.css(d.style).shadow(d.shadow));d.className&&this.graphic.addClass(d.className);this.graphic.labelrank=d.labelrank;b.render.call(this)};
a.prototype.redraw=function(a){var d=this.options,e=this.text||d.format||d.text,g=this.graphic,f=this.points[0];g.attr({text:e?c(e,f.getLabelConfig(),this.annotation.chart):d.formatter.call(f,this)});d=this.anchor(f);(e=this.position(d))?(g.alignAttr=e,e.anchorX=d.absolutePosition.x,e.anchorY=d.absolutePosition.y,g[a?"animate":"attr"](e)):g.attr({x:0,y:-9999});g.placed=!!e;b.redraw.call(this,a)};a.prototype.anchor=function(a){var c=b.anchor.apply(this,arguments),d=this.options.x||0,e=this.options.y||
0;c.absolutePosition.x-=d;c.absolutePosition.y-=e;c.relativePosition.x-=d;c.relativePosition.y-=e;return c};a.prototype.position=function(b){var c=this.graphic,d=this.annotation.chart,g=this.points[0],m=this.options,u=b.absolutePosition,x=b.relativePosition,A=g.series.visible&&n.prototype.isInsidePlot.call(g);b=c.width;b=void 0===b?0:b;var h=c.height;h=void 0===h?0:h;if(A){if(m.distance)var k=l.prototype.getPosition.call({chart:d,distance:e(m.distance,16)},b,h,{plotX:x.x,plotY:x.y,negative:g.negative,
ttBelow:g.ttBelow,h:x.height||x.width});else m.positioner?k=m.positioner.call(this):(g={x:u.x,y:u.y,width:0,height:0},k=a.alignedPosition(f(m,{width:b,height:h}),g),"justify"===this.options.overflow&&(k=a.alignedPosition(a.justifiedOptions(d,c,m,k),g)));m.crop&&(c=k.x-d.plotLeft,m=k.y-d.plotTop,A=d.isInsidePlot(c,m)&&d.isInsidePlot(c+b,m+h))}return A?k:null};a.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"};a.shapesWithoutBackground=
["connector"];return a}();a.connector=function(b,c,a,e,f){var g=f&&f.anchorX;f=f&&f.anchorY;var l=a/2;if(d(g)&&d(f)){var m=[["M",g,f]];var n=c-f;0>n&&(n=-e-n);n<a&&(l=g<b+a/2?n:a-n);f>c+e?m.push(["L",b+l,c+e]):f<c?m.push(["L",b+l,c]):g<b?m.push(["L",b,c+e/2]):g>b+a&&m.push(["L",b+a,c+e/2])}return m||[]};return m});w(a,"Extensions/Annotations/Controllables/ControllableImage.js",[a["Extensions/Annotations/Controllables/ControllableLabel.js"],a["Extensions/Annotations/Mixins/ControllableMixin.js"]],
function(b,a){return function(){function f(b,f,m){this.addControlPoints=a.addControlPoints;this.anchor=a.anchor;this.attr=a.attr;this.attrsFromOptions=a.attrsFromOptions;this.destroy=a.destroy;this.getPointsOptions=a.getPointsOptions;this.init=a.init;this.linkPoints=a.linkPoints;this.point=a.point;this.rotate=a.rotate;this.scale=a.scale;this.setControlPointsVisibility=a.setControlPointsVisibility;this.shouldBeDrawn=a.shouldBeDrawn;this.transform=a.transform;this.transformPoint=a.transformPoint;this.translatePoint=
a.translatePoint;this.translateShape=a.translateShape;this.update=a.update;this.type="image";this.translate=a.translateShape;this.init(b,f,m);this.collection="shapes"}f.prototype.render=function(b){var f=this.attrsFromOptions(this.options),m=this.options;this.graphic=this.annotation.chart.renderer.image(m.src,0,-9E9,m.width,m.height).attr(f).add(b);this.graphic.width=m.width;this.graphic.height=m.height;a.render.call(this)};f.prototype.redraw=function(f){var l=this.anchor(this.points[0]);if(l=b.prototype.position.call(this,
l))this.graphic[f?"animate":"attr"]({x:l.x,y:l.y});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!l;a.redraw.call(this,f)};f.attrsMap={width:"width",height:"height",zIndex:"zIndex"};return f}()});w(a,"Extensions/Annotations/Annotations.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Chart/Chart.js"],a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Extensions/Annotations/Controllables/ControllableRect.js"],a["Extensions/Annotations/Controllables/ControllableCircle.js"],
a["Extensions/Annotations/Controllables/ControllablePath.js"],a["Extensions/Annotations/Controllables/ControllableImage.js"],a["Extensions/Annotations/Controllables/ControllableLabel.js"],a["Extensions/Annotations/ControlPoint.js"],a["Extensions/Annotations/Mixins/EventEmitterMixin.js"],a["Core/Globals.js"],a["Extensions/Annotations/MockPoint.js"],a["Core/Pointer.js"],a["Core/Utilities.js"],a["Core/Color/Palette.js"]],function(a,f,n,u,l,m,c,w,d,e,A,g,r,p,z){var b=a.getDeferredAnimation;a=f.prototype;
var B=p.addEvent,x=p.defined,G=p.destroyObjectProperties,h=p.erase,k=p.extend,t=p.find,v=p.fireEvent,q=p.merge,C=p.pick,y=p.splat;p=p.wrap;var D=function(){function a(a,b){this.annotation=void 0;this.coll="annotations";this.shapesGroup=this.labelsGroup=this.labelCollector=this.group=this.graphic=this.animationConfig=this.collection=void 0;this.chart=a;this.points=[];this.controlPoints=[];this.coll="annotations";this.labels=[];this.shapes=[];this.options=q(this.defaultOptions,b);this.userOptions=b;
b=this.getLabelsAndShapesOptions(this.options,b);this.options.labels=b.labels;this.options.shapes=b.shapes;this.init(a,this.options)}a.prototype.init=function(){var a=this.chart,c=this.options.animation;this.linkPoints();this.addControlPoints();this.addShapes();this.addLabels();this.setLabelCollector();this.animationConfig=b(a,c)};a.prototype.getLabelsAndShapesOptions=function(a,b){var c={};["labels","shapes"].forEach(function(d){a[d]&&(c[d]=y(b[d]).map(function(b,c){return q(a[d][c],b)}))});return c};
a.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(a,b){a=this.initShape(a,b);q(!0,this.options.shapes[b],a.options)},this)};a.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(a,b){a=this.initLabel(a,b);q(!0,this.options.labels[b],a.options)},this)};a.prototype.addClipPaths=function(){this.setClipAxes();this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))};a.prototype.setClipAxes=function(){var a=this.chart.xAxis,
b=this.chart.yAxis,c=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(c,d){return[a[d&&d.point&&d.point.xAxis]||c[0],b[d&&d.point&&d.point.yAxis]||c[1]]},[]);this.clipXAxis=c[0];this.clipYAxis=c[1]};a.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}};a.prototype.setLabelCollector=function(){var a=this;a.labelCollector=function(){return a.labels.reduce(function(a,
b){b.options.allowOverlap||a.push(b.graphic);return a},[])};a.chart.labelCollectors.push(a.labelCollector)};a.prototype.setOptions=function(a){this.options=q(this.defaultOptions,a)};a.prototype.redraw=function(a){this.linkPoints();this.graphic||this.render();this.clipRect&&this.clipRect.animate(this.getClipBox());this.redrawItems(this.shapes,a);this.redrawItems(this.labels,a);n.redraw.call(this,a)};a.prototype.redrawItems=function(a,b){for(var c=a.length;c--;)this.redrawItem(a[c],b)};a.prototype.renderItems=
function(a){for(var b=a.length;b--;)this.renderItem(a[b])};a.prototype.render=function(){var a=this.chart.renderer;this.graphic=a.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add();this.shapesGroup=a.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip);this.labelsGroup=a.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic);this.addClipPaths();this.clipRect&&this.graphic.clip(this.clipRect);this.renderItems(this.shapes);
this.renderItems(this.labels);this.addEvents();n.render.call(this)};a.prototype.setVisibility=function(a){var b=this.options;a=C(a,!b.visible);this.graphic.attr("visibility",a?"visible":"hidden");a||this.setControlPointsVisibility(!1);b.visible=a};a.prototype.setControlPointsVisibility=function(a){var b=function(b){b.setControlPointsVisibility(a)};n.setControlPointsVisibility.call(this,a);this.shapes.forEach(b);this.labels.forEach(b)};a.prototype.destroy=function(){var a=this.chart,b=function(a){a.destroy()};
this.labels.forEach(b);this.shapes.forEach(b);this.clipYAxis=this.clipXAxis=null;h(a.labelCollectors,this.labelCollector);e.destroy.call(this);n.destroy.call(this);G(this,a)};a.prototype.remove=function(){return this.chart.removeAnnotation(this)};a.prototype.update=function(a,b){var c=this.chart,d=this.getLabelsAndShapesOptions(this.userOptions,a),e=c.annotations.indexOf(this);a=q(!0,this.userOptions,a);a.labels=d.labels;a.shapes=d.shapes;this.destroy();this.constructor(c,a);c.options.annotations[e]=
a;this.isUpdating=!0;C(b,!0)&&c.redraw();v(this,"afterUpdate");this.isUpdating=!1};a.prototype.initShape=function(b,c){b=q(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},b);c=new a.shapesMap[b.type](this,b,c);c.itemType="shape";this.shapes.push(c);return c};a.prototype.initLabel=function(a,b){a=q(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},a);b=new w(this,a,b);b.itemType="label";this.labels.push(b);return b};a.prototype.redrawItem=
function(a,b){a.linkPoints();a.shouldBeDrawn()?(a.graphic||this.renderItem(a),a.redraw(C(b,!0)&&a.graphic.placed),a.points.length&&this.adjustVisibility(a)):this.destroyItem(a)};a.prototype.adjustVisibility=function(a){var b=!1,c=a.graphic;a.points.forEach(function(a){!1!==a.series.visible&&!1!==a.visible&&(b=!0)});b?"hidden"===c.visibility&&c.show():c.hide()};a.prototype.destroyItem=function(a){h(this[a.itemType+"s"],a);a.destroy()};a.prototype.renderItem=function(a){a.render("label"===a.itemType?
this.labelsGroup:this.shapesGroup)};a.ControlPoint=d;a.MockPoint=g;a.shapesMap={rect:u,circle:l,path:m,image:c};a.types={};return a}();q(!0,D.prototype,n,e,q(D.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:z.neutralColor100,borderRadius:3,borderWidth:1,className:"highcharts-no-tooltip",crop:!1,formatter:function(){return x(this.y)?this.y:
"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:z.neutralColor100,"stroke-width":2,fill:z.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}}));A.extendAnnotation=function(a,
b,c,d){b=b||D;k(a.prototype,q(b.prototype,c));a.prototype.defaultOptions=q(a.prototype.defaultOptions,d||{})};k(a,{initAnnotation:function(a){a=new (D.types[a.type]||D)(this,a);this.annotations.push(a);return a},addAnnotation:function(a,b){a=this.initAnnotation(a);this.options.annotations.push(a.options);C(b,!0)&&(a.redraw(),a.graphic.attr({opacity:1}));return a},removeAnnotation:function(a){var b=this.annotations,c="annotations"===a.coll?a:t(b,function(b){return b.options.id===a});c&&(v(c,"remove"),
h(this.options.annotations,c.options),h(b,c),c.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox);this.annotations.forEach(function(a){a.redraw();a.graphic.animate({opacity:1},a.animationConfig)})}});a.collectionsWithUpdate.push("annotations");a.collectionsWithInit.annotations=[a.addAnnotation];B(f,"afterInit",function(){this.annotations=[];this.options.annotations||(this.options.annotations=[])});a.callbacks.push(function(a){a.plotBoxClip=this.renderer.clipRect(this.plotBox);
a.controlPointsGroup=a.renderer.g("control-points").attr({zIndex:99}).clip(a.plotBoxClip).add();a.options.annotations.forEach(function(b,c){if(!a.annotations.some(function(a){return a.options===b})){var d=a.initAnnotation(b);a.options.annotations[c]=d.options}});a.drawAnnotations();B(a,"redraw",a.drawAnnotations);B(a,"destroy",function(){a.plotBoxClip.destroy();a.controlPointsGroup.destroy()});B(a,"exportData",function(b){var c=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,
d=!b.dataRows[1].xValues,q=a.options.lang&&a.options.lang.exportData&&a.options.lang.exportData.annotationHeader,e=function(a){if(c){var b=c(a);if(!1!==b)return b}b=q+" "+a;return d?{columnTitle:b,topLevelColumnTitle:b}:b},v=b.dataRows[0].length,C=a.options.exporting&&a.options.exporting.csv&&a.options.exporting.csv.annotations&&a.options.exporting.csv.annotations.itemDelimiter,h=a.options.exporting&&a.options.exporting.csv&&a.options.exporting.csv.annotations&&a.options.exporting.csv.annotations.join;
a.annotations.forEach(function(a){a.options.labelOptions.includeInDataExport&&a.labels.forEach(function(a){if(a.options.text){var c=a.options.text;a.points.forEach(function(a){var d=a.x,q=a.series.xAxis?a.series.xAxis.options.index:-1,e=!1;if(-1===q){a=b.dataRows[0].length;for(var y=Array(a),k=0;k<a;++k)y[k]="";y.push(c);y.xValues=[];y.xValues[q]=d;b.dataRows.push(y);e=!0}e||b.dataRows.forEach(function(a,b){!e&&a.xValues&&void 0!==q&&d===a.xValues[q]&&(h&&a.length>v?a[a.length-1]+=C+c:a.push(c),e=
!0)});if(!e){a=b.dataRows[0].length;y=Array(a);for(k=0;k<a;++k)y[k]="";y[0]=d;y.push(c);y.xValues=[];void 0!==q&&(y.xValues[q]=d);b.dataRows.push(y)}})}})});var y=0;b.dataRows.forEach(function(a){y=Math.max(y,a.length)});for(var k=y-b.dataRows[0].length,D=0;D<k;D++){var f=e(D+1);d?(b.dataRows[0].push(f.topLevelColumnTitle),b.dataRows[1].push(f.columnTitle)):b.dataRows[0].push(f)}})});p(r.prototype,"onContainerMouseDown",function(a){this.chart.hasDraggedAnnotation||a.apply(this,Array.prototype.slice.call(arguments,
1))});return A.Annotation=D});w(a,"Mixins/Navigation.js",[],function(){return{initUpdate:function(a){a.navigation||(a.navigation={updates:[],update:function(a,b){this.updates.forEach(function(f){f.update.call(f.context,a,b)})}})},addUpdate:function(a,f){f.navigation||this.initUpdate(f);f.navigation.updates.push({update:a,context:f})}}});w(a,"Extensions/Annotations/NavigationBindings.js",[a["Extensions/Annotations/Annotations.js"],a["Core/Chart/Chart.js"],a["Mixins/Navigation.js"],a["Core/FormatUtilities.js"],
a["Core/Globals.js"],a["Core/DefaultOptions.js"],a["Core/Utilities.js"]],function(a,f,n,u,l,m,c){function b(a){var b=a.prototype.defaultOptions.events&&a.prototype.defaultOptions.events.click;B(!0,a.prototype.defaultOptions.events,{click:function(a){var c=this,d=c.chart.navigationBindings,q=d.activeAnnotation;b&&b.call(c,a);q!==c?(d.deselectAnnotation(),d.activeAnnotation=c,c.setControlPointsVisibility(!0),g(d,"showPopup",{annotation:c,formType:"annotation-toolbar",options:d.annotationToFields(c),
onSubmit:function(a){var b={};"remove"===a.actionType?(d.activeAnnotation=!1,d.chart.removeAnnotation(c)):(d.fieldsToOptions(a.fields,b),d.deselectAnnotation(),a=b.typeOptions,"measure"===c.options.type&&(a.crosshairY.enabled=0!==a.crosshairY.strokeWidth,a.crosshairX.enabled=0!==a.crosshairX.strokeWidth),c.update(b))}})):g(d,"closePopup");a.activeAnnotation=!0}})}var d=u.format;u=m.setOptions;var e=c.addEvent,w=c.attr,g=c.fireEvent,r=c.isArray,p=c.isFunction,z=c.isNumber,E=c.isObject,B=c.merge,x=
c.objectEach,F=c.pick,h=l.doc,k=l.win,t=function(){function a(a,b){this.selectedButton=this.boundClassNames=void 0;this.chart=a;this.options=b;this.eventsToUnbind=[];this.container=h.getElementsByClassName(this.options.bindingsClassName||"")}a.prototype.initEvents=function(){var a=this,b=a.chart,c=a.container,d=a.options;a.boundClassNames={};x(d.bindings||{},function(b){a.boundClassNames[b.className]=b});[].forEach.call(c,function(b){a.eventsToUnbind.push(e(b,"click",function(c){var d=a.getButtonEvents(b,
c);d&&-1===d.button.className.indexOf("highcharts-disabled-btn")&&a.bindingsButtonClick(d.button,d.events,c)}))});x(d.events||{},function(b,c){p(b)&&a.eventsToUnbind.push(e(a,c,b,{passive:!1}))});a.eventsToUnbind.push(e(b.container,"click",function(c){!b.cancelClick&&b.isInsidePlot(c.chartX-b.plotLeft,c.chartY-b.plotTop,{visiblePlotOnly:!0})&&a.bindingsChartClick(this,c)}));a.eventsToUnbind.push(e(b.container,l.isTouchDevice?"touchmove":"mousemove",function(b){a.bindingsContainerMouseMove(this,b)},
l.isTouchDevice?{passive:!1}:void 0))};a.prototype.initUpdate=function(){var a=this;n.addUpdate(function(b){a.update(b)},this.chart)};a.prototype.bindingsButtonClick=function(a,b,c){var d=this.chart;this.selectedButtonElement&&(g(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&"annotations"===this.currentUserDetails.coll&&d.removeAnnotation(this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1));this.selectedButton=b;this.selectedButtonElement=
a;g(this,"selectButton",{button:a});b.init&&b.init.call(this,a,c);(b.start||b.steps)&&d.renderer.boxWrapper.addClass("highcharts-draw-mode")};a.prototype.bindingsChartClick=function(a,b){a=this.chart;var c=this.selectedButton;a=a.renderer.boxWrapper;var d;if(d=this.activeAnnotation&&!b.activeAnnotation&&b.target.parentNode){a:{d=b.target;var e=k.Element.prototype,h=e.matches||e.msMatchesSelector||e.webkitMatchesSelector,q=null;if(e.closest)q=e.closest.call(d,".highcharts-popup");else{do{if(h.call(d,
".highcharts-popup"))break a;d=d.parentElement||d.parentNode}while(null!==d&&1===d.nodeType)}d=q}d=!d}d&&g(this,"closePopup");c&&c.start&&(this.nextEvent?(this.nextEvent(b,this.currentUserDetails),this.steps&&(this.stepIndex++,c.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=c.steps[this.stepIndex]:(g(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),c.end&&c.end.call(this,b,this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=
null))):(this.currentUserDetails=c.start.call(this,b))&&c.steps?(this.stepIndex=0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=c.steps[this.stepIndex]):(g(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,c.end&&c.end.call(this,b,this.currentUserDetails)))};a.prototype.bindingsContainerMouseMove=function(a,b){this.mouseMoveEvent&&this.mouseMoveEvent(b,this.currentUserDetails)};a.prototype.fieldsToOptions=function(a,
b){x(a,function(a,c){var d=parseFloat(a),e=c.split("."),h=b,k=e.length-1;!z(d)||a.match(/px/g)||c.match(/format/g)||(a=d);""!==a&&"undefined"!==a&&e.forEach(function(b,c){var d=F(e[c+1],"");k===c?h[b]=a:(h[b]||(h[b]=d.match(/\d/g)?[]:{}),h=h[b])})});return b};a.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)};a.prototype.annotationToFields=function(b){function c(a,e,h,v){if(h&&a&&-1===f.indexOf(e)&&(0<=
(h.indexOf&&h.indexOf(e))||h[e]||!0===h))if(r(a))v[e]=[],a.forEach(function(a,b){E(a)?(v[e][b]={},x(a,function(a,d){c(a,d,k[e],v[e][b])})):c(a,0,k[e],v[e])});else if(E(a)){var C={};r(v)?(v.push(C),C[e]={},C=C[e]):v[e]=C;x(a,function(a,b){c(a,b,0===e?h:k[e],C)})}else"format"===e?v[e]=[d(a,b.labels[0].points[0]).toString(),"text"]:r(v)?v.push([a,q(a)]):v[e]=[a,q(a)]}var e=b.options,h=a.annotationsEditable,k=h.nestedOptions,q=this.utils.getFieldType,v=F(e.type,e.shapes&&e.shapes[0]&&e.shapes[0].type,
e.labels&&e.labels[0]&&e.labels[0].itemType,"label"),f=a.annotationsNonEditable[e.langKey]||[],g={langKey:e.langKey,type:v};x(e,function(a,b){"typeOptions"===b?(g[b]={},x(e[b],function(a,d){c(a,d,k,g[b],!0)})):c(a,b,h[v],g)});return g};a.prototype.getClickedClassNames=function(a,b){var c=b.target;b=[];for(var d;c&&((d=w(c,"class"))&&(b=b.concat(d.split(" ").map(function(a){return[a,c]}))),c=c.parentNode,c!==a););return b};a.prototype.getButtonEvents=function(a,b){var c=this,d;this.getClickedClassNames(a,
b).forEach(function(a){c.boundClassNames[a[0]]&&!d&&(d={events:c.boundClassNames[a[0]],button:a[1]})});return d};a.prototype.update=function(a){this.options=B(!0,this.options,a);this.removeEvents();this.initEvents()};a.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(a){a()})};a.prototype.destroy=function(){this.removeEvents()};a.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill",
"strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background",
"line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]};a.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]};return a}();t.prototype.utils={getFieldType:function(a){return{string:"text",number:"number","boolean":"checkbox"}[typeof a]},updateRectSize:function(a,b){var c=b.chart,d=b.options.typeOptions,e=c.pointer.getCoordinates(a);a=c.navigationBindings.utils.getAssignedAxis(e.xAxis);e=c.navigationBindings.utils.getAssignedAxis(e.yAxis);
a&&e&&(a=a.value-d.point.x,d=d.point.y-e.value,b.update({typeOptions:{background:{width:c.inverted?d:a,height:c.inverted?a:d}}}))},getAssignedAxis:function(a){return a.filter(function(a){var b=a.axis.min,c=a.axis.max,d=F(a.axis.minPointOffset,0);return z(b)&&z(c)&&a.value>=b-d&&a.value<=c+d&&!a.axis.options.isInternal})[0]}};f.prototype.initNavigationBindings=function(){var a=this.options;a&&a.navigation&&a.navigation.bindings&&(this.navigationBindings=new t(this,a.navigation),this.navigationBindings.initEvents(),
this.navigationBindings.initUpdate())};e(f,"load",function(){this.initNavigationBindings()});e(f,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});e(t,"deselectButton",function(){this.selectedButtonElement=null});e(a,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});l.Annotation&&(b(a),x(a.types,function(a){b(a)}));u({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",
label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",
bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);var c=this.chart.options.navigation;if(a&&b)return this.chart.addAnnotation(B({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:a.value,y:b.value,xAxis:a.axis.options.index,yAxis:b.axis.options.index},r:5}]},c.annotationsOptions,c.bindings.circleAnnotation.annotationsOptions))},
steps:[function(a,b){var c=b.options.shapes[0].point,d=this.chart.inverted;if(z(c.xAxis)&&z(c.yAxis)){var e=this.chart.xAxis[c.xAxis].toPixels(c.x);c=this.chart.yAxis[c.yAxis].toPixels(c.y);e=Math.max(Math.sqrt(Math.pow(d?c-a.chartX:e-a.chartX,2)+Math.pow(d?e-a.chartY:c-a.chartY,2)),5)}b.update({shapes:[{r:e}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(a){a=this.chart.pointer.getCoordinates(a);var b=this.utils.getAssignedAxis(a.xAxis),c=this.utils.getAssignedAxis(a.yAxis);
if(b&&c){a=b.value;var d=c.value;b=b.axis.options.index;c=c.axis.options.index;var e=this.chart.options.navigation;return this.chart.addAnnotation(B({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:b,yAxis:c,x:a,y:d},{xAxis:b,yAxis:c,x:a,y:d},{xAxis:b,yAxis:c,x:a,y:d},{xAxis:b,yAxis:c,x:a,y:d}]}]},e.annotationsOptions,e.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(a,b){var c=b.options.shapes[0].points,d=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(d.xAxis);
d=this.utils.getAssignedAxis(d.yAxis);a&&d&&(a=a.value,d=d.value,c[1].x=a,c[2].x=a,c[2].y=d,c[3].y=d,b.update({shapes:[{points:c}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);var c=this.chart.options.navigation;if(a&&b)return this.chart.addAnnotation(B({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:a.axis.options.index,
yAxis:b.axis.options.index,x:a.value,y:b.value},overflow:"none",crop:!0}]},c.annotationsOptions,c.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});e(f,"render",function(){var a=this,b=a.navigationBindings;if(a&&b){var c=!1;a.series.forEach(function(a){!a.options.isInternal&&a.visible&&(c=!0)});x(b.boundClassNames,function(b,d){a.navigationBindings&&a.navigationBindings.container&&a.navigationBindings.container[0]&&(d=a.navigationBindings.container[0].querySelectorAll("."+
d))&&("normal"===b.noDataState?d.forEach(function(a){-1!==a.className.indexOf("highcharts-disabled-btn")&&a.classList.remove("highcharts-disabled-btn")}):c?d.forEach(function(a){-1!==a.className.indexOf("highcharts-disabled-btn")&&a.classList.remove("highcharts-disabled-btn")}):d.forEach(function(a){-1===a.className.indexOf("highcharts-disabled-btn")&&(a.className+=" highcharts-disabled-btn")}))})}});e(t,"closePopup",function(){this.deselectAnnotation()});return t});w(a,"Extensions/Annotations/Popup.js",
[a["Core/Globals.js"],a["Extensions/Annotations/NavigationBindings.js"],a["Core/DefaultOptions.js"],a["Core/Pointer.js"],a["Core/Utilities.js"]],function(a,f,n,u,l){var b=a.doc,c=a.isFirefox,w=n.getOptions,d=l.addEvent,e=l.createElement,A=l.defined,g=l.fireEvent,r=l.isArray,p=l.isObject,z=l.isString,E=l.objectEach,B=l.pick,x=l.stableSort;n=l.wrap;var F=/\d/g;n(u.prototype,"onContainerMouseDown",function(a,b){var c=b.target&&b.target.className;z(c)&&0<=c.indexOf("highcharts-popup-field")||a.apply(this,
Array.prototype.slice.call(arguments,1))});a.Popup=function(a,b,c){this.init(a,b,c)};a.Popup.prototype={init:function(a,b,c){this.chart=c;this.container=e("div",{className:"highcharts-popup highcharts-no-tooltip"},null,a);this.lang=this.getLangpack();this.iconsURL=b;this.addCloseBtn()},addCloseBtn:function(){var a=this,b=this.iconsURL;var c=e("div",{className:"highcharts-popup-close"},null,this.container);c.style["background-image"]="url("+(b.match(/png|svg|jpeg|jpg|gif/ig)?b:b+"close.svg")+")";["click",
"touchstart"].forEach(function(b){d(c,b,function(){a.chart?g(a.chart.navigationBindings,"closePopup"):a.closePopup()})})},addColsContainer:function(a){var b=e("div",{className:"highcharts-popup-lhs-col"},null,a);a=e("div",{className:"highcharts-popup-rhs-col"},null,a);e("div",{className:"highcharts-popup-rhs-col-wrapper"},null,a);return{lhsCol:b,rhsCol:a}},addInput:function(a,c,d,f){var h=a.split(".");h=h[h.length-1];var k=this.lang;c="highcharts-"+c+"-"+h;c.match(F)||e("label",{htmlFor:c},void 0,
d).appendChild(b.createTextNode(k[h]||h));e("input",{name:c,value:f[0],type:f[1],className:"highcharts-popup-field"},void 0,d).setAttribute("highcharts-data-name",a)},addButton:function(a,c,f,g,q){var h=this,k=this.closePopup,v=this.getFields;var t=e("button",void 0,void 0,a);t.appendChild(b.createTextNode(c));["click","touchstart"].forEach(function(a){d(t,a,function(){k.call(h);return g(v(q,f))})});return t},getFields:function(a,b){var c=a.querySelectorAll("input"),d=a.querySelectorAll("#highcharts-select-series > option:checked")[0];
a=a.querySelectorAll("#highcharts-select-volume > option:checked")[0];var e,h;var k={actionType:b,linkedTo:d&&d.getAttribute("value"),fields:{}};[].forEach.call(c,function(a){h=a.getAttribute("highcharts-data-name");(e=a.getAttribute("highcharts-data-series-id"))?k.seriesId=a.value:h?k.fields[h]=a.value:k.type=a.value});a&&(k.fields["params.volumeSeriesID"]=a.getAttribute("value"));return k},showPopup:function(){var a=this.container,b=a.querySelectorAll(".highcharts-popup-close")[0];a.innerHTML="";
0<=a.className.indexOf("highcharts-annotation-toolbar")&&(a.classList.remove("highcharts-annotation-toolbar"),a.removeAttribute("style"));a.appendChild(b);a.style.display="block";a.style.height=""},closePopup:function(){B(this.popup&&this.popup.container,this.container).style.display="none"},showForm:function(a,b,c,d){b&&(this.popup=b.navigationBindings.popup,this.showPopup(),"indicators"===a&&this.indicators.addForm.call(this,b,c,d),"annotation-toolbar"===a&&this.annotations.addToolbar.call(this,
b,c,d),"annotation-edit"===a&&this.annotations.addForm.call(this,b,c,d),"flag"===a&&this.annotations.addForm.call(this,b,c,d,!0),this.container.style.height=this.container.offsetHeight+"px")},getLangpack:function(){return w().lang.navigation.popup},annotations:{addToolbar:function(a,c,d){var h=this,f=this.lang,k=this.popup.container,g=this.showForm;-1===k.className.indexOf("highcharts-annotation-toolbar")&&(k.className+=" highcharts-annotation-toolbar");a&&(k.style.top=a.plotTop+10+"px");e("span",
void 0,void 0,k).appendChild(b.createTextNode(B(f[c.langKey]||c.langKey,c.shapes&&c.shapes[0].type)));var t=this.addButton(k,f.removeButton||"remove","remove",d,k);t.className+=" highcharts-annotation-remove-button";t.style["background-image"]="url("+this.iconsURL+"destroy.svg)";t=this.addButton(k,f.editButton||"edit","edit",function(){g.call(h,"annotation-edit",a,c,d)},k);t.className+=" highcharts-annotation-edit-button";t.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(a,
c,d,f){var h=this.popup.container,k=this.lang;if(a){var g=e("h2",{className:"highcharts-popup-main-title"},void 0,h);g.appendChild(b.createTextNode(k[c.langKey]||c.langKey||""));g=e("div",{className:"highcharts-popup-lhs-col highcharts-popup-lhs-full"},null,h);var t=e("div",{className:"highcharts-popup-bottom-row"},null,h);this.annotations.addFormFields.call(this,g,a,"",c,[],!0);this.addButton(t,f?k.addButton||"add":k.saveButton||"save",f?"add":"save",d,h)}},addFormFields:function(a,d,f,g,q,l){var h=
this,k=this.annotations.addFormFields,t=this.addInput,v=this.lang,m,n;d&&(E(g,function(b,c){m=""!==f?f+"."+c:c;p(b)&&(!r(b)||r(b)&&p(b[0])?(n=v[c]||c,n.match(F)||q.push([!0,n,a]),k.call(h,a,d,m,b,q,!1)):q.push([h,m,"annotation",a,b]))}),l&&(x(q,function(a){return a[1].match(/format/g)?-1:1}),c&&q.reverse(),q.forEach(function(a){!0===a[0]?e("span",{className:"highcharts-annotation-title"},void 0,a[2]).appendChild(b.createTextNode(a[1])):t.apply(a[0],a.splice(1))})))}},indicators:{addForm:function(a,
b,c){var d=this.indicators,e=this.lang;if(a){this.tabs.init.call(this,a);b=this.popup.container.querySelectorAll(".highcharts-tab-item-content");this.addColsContainer(b[0]);d.addIndicatorList.call(this,a,b[0],"add");var h=b[0].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(h,e.addButton||"add","add",c,h);this.addColsContainer(b[1]);d.addIndicatorList.call(this,a,b[1],"edit");h=b[1].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(h,e.saveButton||"save","edit",c,h);
this.addButton(h,e.removeButton||"remove","remove",c,h)}},addIndicatorList:function(a,c,f){var h=this,g=c.querySelectorAll(".highcharts-popup-lhs-col")[0];c=c.querySelectorAll(".highcharts-popup-rhs-col")[0];var k="edit"===f,t=k?a.series:a.options.plotOptions,l=this.indicators.addFormFields,m;if(a){var n=e("ul",{className:"highcharts-indicator-list"},null,g);var p=c.querySelectorAll(".highcharts-popup-rhs-col-wrapper")[0];E(t,function(c,f){var g=c.options;if(c.params||g&&g.params){var q=h.indicators.getNameType(c,
f),v=q.type;m=e("li",{className:"highcharts-indicator-list"},void 0,n);m.appendChild(b.createTextNode(q.name));["click","touchstart"].forEach(function(b){d(m,b,function(){l.call(h,a,k?c:t[v],q.type,p);k&&c.options&&e("input",{type:"hidden",name:"highcharts-id-"+v,value:c.options.id},null,p).setAttribute("highcharts-data-series-id",c.options.id)})})}});0<n.childNodes.length&&n.childNodes[0].click()}},getNameType:function(b,c){var d=b.options,e=a.seriesTypes;e=e[c]&&e[c].prototype.nameBase||c.toUpperCase();
d&&d.type&&(c=b.options.type,e=b.name);return{name:e,type:c}},listAllSeries:function(a,c,d,f,g){a="highcharts-"+c+"-type-"+a;var h=this.lang,k;if(d){e("label",{htmlFor:a},null,f).appendChild(b.createTextNode(h[c]||c));var t=e("select",{name:a,className:"highcharts-popup-field"},null,f);t.setAttribute("id","highcharts-select-"+c);d.series.forEach(function(a){k=a.options;!k.params&&k.id&&"highcharts-navigator-series"!==k.id&&e("option",{value:k.id},null,t).appendChild(b.createTextNode(k.name||k.id))});
A(g)&&(t.value=g)}},addFormFields:function(a,c,d,f){var g=c.params||c.options.params,h=this.indicators.getNameType;f.innerHTML="";e("h3",{className:"highcharts-indicator-title"},void 0,f).appendChild(b.createTextNode(h(c,d).name));e("input",{type:"hidden",name:"highcharts-type-"+d,value:d},null,f);this.indicators.listAllSeries.call(this,d,"series",a,f,c.linkedParent&&g.volumeSeriesID);g.volumeSeriesID&&this.indicators.listAllSeries.call(this,d,"volume",a,f,c.linkedParent&&c.linkedParent.options.id);
this.indicators.addParamInputs.call(this,a,"params",g,d,f)},addParamInputs:function(a,b,c,d,e){var f=this,g=this.indicators.addParamInputs,h=this.addInput,k;a&&E(c,function(c,l){k=b+"."+l;void 0!==c&&(p(c)?g.call(f,a,k,c,d,e):"params.volumeSeriesID"!==k&&h.call(f,k,d,e,[c,"text"]))})},getAmount:function(){var a=0;this.series.forEach(function(b){var c=b.options;(b.params||c&&c.params)&&a++});return a}},tabs:{init:function(a){var b=this.tabs,c=this.indicators.getAmount.call(a);a&&(a=b.addMenuItem.call(this,
"add"),b.addMenuItem.call(this,"edit",c),b.addContentItem.call(this,"add"),b.addContentItem.call(this,"edit"),b.switchTabs.call(this,c),b.selectTab.call(this,a,0))},addMenuItem:function(a,c){var d=this.popup.container,f="highcharts-tab-item",g=this.lang;0===c&&(f+=" highcharts-tab-disabled");c=e("span",{className:f},void 0,d);c.appendChild(b.createTextNode(g[a+"Button"]||a));c.setAttribute("highcharts-data-tab-type",a);return c},addContentItem:function(){return e("div",{className:"highcharts-tab-item-content highcharts-no-mousewheel"},
null,this.popup.container)},switchTabs:function(a){var b=this,c;this.popup.container.querySelectorAll(".highcharts-tab-item").forEach(function(e,f){c=e.getAttribute("highcharts-data-tab-type");"edit"===c&&0===a||["click","touchstart"].forEach(function(a){d(e,a,function(){b.tabs.deselectAll.call(b);b.tabs.selectTab.call(b,this,f)})})})},selectTab:function(a,b){var c=this.popup.container.querySelectorAll(".highcharts-tab-item-content");a.className+=" highcharts-tab-item-active";c[b].className+=" highcharts-tab-item-show"},
deselectAll:function(){var a=this.popup.container,b=a.querySelectorAll(".highcharts-tab-item");a=a.querySelectorAll(".highcharts-tab-item-content");var c;for(c=0;c<b.length;c++)b[c].classList.remove("highcharts-tab-item-active"),a[c].classList.remove("highcharts-tab-item-show")}}};d(f,"showPopup",function(b){this.popup||(this.popup=new a.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/9.1.2/gfx/stock-icons/",
this.chart));this.popup.showForm(b.formType,this.chart,b.options,b.onSubmit)});d(f,"closePopup",function(){this.popup&&this.popup.closePopup()});return a.Popup});w(a,"masters/modules/annotations.src.js",[],function(){})});
//# sourceMappingURL=annotations.js.map