/*
 Highcharts JS v9.1.2 (2021-06-16)

 Boost module

 (c) 2010-2021 Highsoft AS
 Author: Torstein Honsi

 License: www.highcharts.com/license

*/
'use strict';(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/boost",["highcharts"],function(r){b(r);b.Highcharts=r;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function r(b,B,w,h){b.hasOwnProperty(B)||(b[B]=h.apply(null,w))}b=b?b._modules:{};r(b,"Extensions/Boost/Boostables.js",[],function(){return"area arearange column columnrange bar line scatter heatmap bubble treemap".split(" ")});
r(b,"Extensions/Boost/BoostableMap.js",[b["Extensions/Boost/Boostables.js"]],function(b){var H={};b.forEach(function(b){H[b]=1});return H});r(b,"Extensions/Boost/WGLShader.js",[b["Core/Utilities.js"]],function(b){var H=b.clamp,w=b.error,h=b.pick;return function(c){function b(){I.length&&w("[highcharts boost] shader error - "+I.join("\n"))}function q(a,l){var d=c.createShader("vertex"===l?c.VERTEX_SHADER:c.FRAGMENT_SHADER);c.shaderSource(d,a);c.compileShader(d);return c.getShaderParameter(d,c.COMPILE_STATUS)?
d:(I.push("when compiling "+l+" shader:\n"+c.getShaderInfoLog(d)),!1)}function m(){function d(a){return c.getUniformLocation(g,a)}var l=q("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}",
"vertex"),m=q("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment");if(!l||!m)return g=!1,b(),!1;
g=c.createProgram();c.attachShader(g,l);c.attachShader(g,m);c.linkProgram(g);if(!c.getProgramParameter(g,c.LINK_STATUS))return I.push(c.getProgramInfoLog(g)),b(),g=!1;c.useProgram(g);c.bindAttribLocation(g,0,"aVertexPosition");e=d("uPMatrix");n=d("pSize");k=d("fillColor");y=d("isBubble");O=d("bubbleSizeAbs");F=d("bubbleSizeByArea");p=d("uSampler");J=d("skipTranslation");x=d("isCircle");a=d("isInverted");return!0}function t(a,l){c&&g&&(a=v[a]=v[a]||c.getUniformLocation(g,a),c.uniform1f(a,l))}var v=
{},g,e,n,k,y,O,F,J,x,a,I=[],p;return c&&!m()?!1:{psUniform:function(){return n},pUniform:function(){return e},fillColorUniform:function(){return k},setBubbleUniforms:function(a,l,p){var d=a.options,e=Number.MAX_VALUE,b=-Number.MAX_VALUE;c&&g&&"bubble"===a.type&&(e=h(d.zMin,H(l,!1===d.displayNegative?d.zThreshold:-Number.MAX_VALUE,e)),b=h(d.zMax,Math.max(b,p)),c.uniform1i(y,1),c.uniform1i(x,1),c.uniform1i(F,"width"!==a.options.sizeBy),c.uniform1i(O,a.options.sizeByAbsoluteValue),t("bubbleZMin",e),
t("bubbleZMax",b),t("bubbleZThreshold",a.options.zThreshold),t("bubbleMinSize",a.minPxSize),t("bubbleMaxSize",a.maxPxSize))},bind:function(){c&&g&&c.useProgram(g)},program:function(){return g},create:m,setUniform:t,setPMatrix:function(a){c&&g&&c.uniformMatrix4fv(e,!1,a)},setColor:function(a){c&&g&&c.uniform4f(k,a[0]/255,a[1]/255,a[2]/255,a[3])},setPointSize:function(a){c&&g&&c.uniform1f(n,a)},setSkipTranslation:function(a){c&&g&&c.uniform1i(J,!0===a?1:0)},setTexture:function(a){c&&g&&c.uniform1i(p,
a)},setDrawAsCircle:function(a){c&&g&&c.uniform1i(x,a?1:0)},reset:function(){c&&g&&(c.uniform1i(y,0),c.uniform1i(x,0))},setInverted:function(d){c&&g&&c.uniform1i(a,d)},destroy:function(){c&&g&&(c.deleteProgram(g),g=!1)}}}});r(b,"Extensions/Boost/WGLVBuffer.js",[],function(){return function(b,B,w){function h(){c&&(b.deleteBuffer(c),u=c=!1);t=0;q=w||2;v=[]}var c=!1,u=!1,q=w||2,m=!1,t=0,v;return{destroy:h,bind:function(){if(!c)return!1;b.vertexAttribPointer(u,q,b.FLOAT,!1,0,0)},data:v,build:function(g,
e,n){var k;v=g||[];if(!(v&&0!==v.length||m))return h(),!1;q=n||q;c&&b.deleteBuffer(c);m||(k=new Float32Array(v));c=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,c);b.bufferData(b.ARRAY_BUFFER,m||k,b.STATIC_DRAW);u=b.getAttribLocation(B.program(),e);b.enableVertexAttribArray(u);return!0},render:function(g,e,n){var k=m?m.length:v.length;if(!c||!k)return!1;if(!g||g>k||0>g)g=0;if(!e||e>k)e=k;b.drawArrays(b[(n||"points").toUpperCase()],g/q,(e-g)/q);return!0},allocate:function(b){t=-1;m=new Float32Array(4*
b)},push:function(b,e,c,k){m&&(m[++t]=b,m[++t]=e,m[++t]=c,m[++t]=k)}}}});r(b,"Extensions/Boost/WGLRenderer.js",[b["Core/Color/Color.js"],b["Extensions/Boost/WGLShader.js"],b["Extensions/Boost/WGLVBuffer.js"],b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,B,w,h,c){var u=b.parse,q=h.doc,m=c.isNumber,t=c.isObject,v=c.merge,g=c.objectEach,e=c.pick;return function(c){function n(a){if(a.isSeriesBoosting){var d=!!a.options.stacking;var b=a.xData||a.options.xData||a.processedXData;d=(d?a.data:b||
a.options.data).length;"treemap"===a.type?d*=12:"heatmap"===a.type?d*=6:ia[a.type]&&(d*=2);return d}return 0}function y(){f.clear(f.COLOR_BUFFER_BIT|f.DEPTH_BUFFER_BIT)}function O(a,d){function b(a){a&&(d.colorData.push(a[0]),d.colorData.push(a[1]),d.colorData.push(a[2]),d.colorData.push(a[3]))}function f(a,d,f,e,p){b(p);A.usePreallocated?(l.push(a,d,f?1:0,e||1),qa+=4):(S.push(a),S.push(d),S.push(f?1:0),S.push(e||1))}function p(){d.segments.length&&(d.segments[d.segments.length-1].to=S.length||qa)}
function e(){d.segments.length&&d.segments[d.segments.length-1].from===(S.length||qa)||(p(),d.segments.push({from:S.length||qa}))}function c(a,d,e,p,l){b(l);f(a+e,d);b(l);f(a,d);b(l);f(a,d+p);b(l);f(a,d+p);b(l);f(a+e,d+p);b(l);f(a+e,d)}function x(a,b){A.useGPUTranslations||(d.skipTranslation=!0,a.x=H.toPixels(a.x,!0),a.y=O.toPixels(a.y,!0));b?S=[a.x,a.y,0,2].concat(S):f(a.x,a.y,0,2)}var I=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),n=a.chart,z=a.options,g=!!z.stacking,aa=z.data,k=a.xAxis.getExtremes(),
m=k.min,h=k.max;k=a.yAxis.getExtremes();var y=k.min,R=k.max,q=a.xData||z.xData||a.processedXData,v=a.yData||z.yData||a.processedYData,F=a.zData||z.zData||a.processedZData,O=a.yAxis,H=a.xAxis,w=a.chart.plotWidth,B=!q||0===q.length,J=z.connectNulls;k=a.points||!1;var Q=!1,r=!1,E,G,L=g?a.data:q||aa,M={x:Number.MAX_VALUE,y:0},ma={x:-Number.MAX_VALUE,y:0},Ja=0,Ka=!1,D,C,P,X,N=-1,Z=!1,ha=!1,na,Y="undefined"===typeof n.index,Ea=!1,Ba=!1,K=!1,Sa=ia[a.type],Ca=!1,La=!0,Ma=!0,Ta=z.zoneAxis||"y",oa=z.zones||
!1,U=!1,Na=z.threshold,Da=!1;if(!(z.boostData&&0<z.boostData.length)){z.gapSize&&(Da="value"!==z.gapUnit?z.gapSize*a.closestPointRange:z.gapSize);if(oa){var pa=[];oa.forEach(function(a,d){if(a.color){var b=u(a.color).rgba;b[0]/=255;b[1]/=255;b[2]/=255;pa[d]=b;U||"undefined"!==typeof a.value||(U=b)}});U||(q=a.pointAttribs&&a.pointAttribs().fill||a.color,U=u(q).rgba,U[0]/=255,U[1]/=255,U[2]/=255)}n.inverted&&(w=a.chart.plotHeight);a.closestPointRangePx=Number.MAX_VALUE;e();if(k&&0<k.length)d.skipTranslation=
!0,d.drawMode="triangles",k[0].node&&k[0].node.levelDynamic&&k.sort(function(a,d){if(a.node){if(a.node.levelDynamic>d.node.levelDynamic)return 1;if(a.node.levelDynamic<d.node.levelDynamic)return-1}return 0}),k.forEach(function(d){var b=d.plotY;if("undefined"!==typeof b&&!isNaN(b)&&null!==d.y&&d.shapeArgs){var f=d.shapeArgs;b=f.x;b=void 0===b?0:b;var l=f.y;l=void 0===l?0:l;var e=f.width;e=void 0===e?0:e;f=f.height;f=void 0===f?0:f;var p=n.styledMode?d.series.colorAttribs(d):p=d.series.pointAttribs(d);
d=p["stroke-width"]||0;K=u(p.fill).rgba;K[0]/=255;K[1]/=255;K[2]/=255;"treemap"===a.type&&(d=d||1,G=u(p.stroke).rgba,G[0]/=255,G[1]/=255,G[2]/=255,c(b,l,e,f,G),d/=2);"heatmap"===a.type&&n.inverted&&(b=H.len-b,l=O.len-l,e=-e,f=-f);c(b+d,l+d,e-2*d,f-2*d,K)}});else{for(k=function(){P=L[++N];if("undefined"===typeof P)return"continue";if(Y)return"break";var b=aa&&aa[N];!B&&t(b,!0)&&b.color&&(K=u(b.color).rgba,K[0]/=255,K[1]/=255,K[2]/=255);B?(D=P[0],C=P[1],L[N+1]&&(ha=L[N+1][0]),L[N-1]&&(Z=L[N-1][0]),
3<=P.length&&(X=P[2],P[2]>d.zMax&&(d.zMax=P[2]),P[2]<d.zMin&&(d.zMin=P[2]))):(D=P,C=v[N],L[N+1]&&(ha=L[N+1]),L[N-1]&&(Z=L[N-1]),F&&F.length&&(X=F[N],F[N]>d.zMax&&(d.zMax=F[N]),F[N]<d.zMin&&(d.zMin=F[N])));if(!J&&(null===D||null===C))return e(),"continue";ha&&ha>=m&&ha<=h&&(Ea=!0);Z&&Z>=m&&Z<=h&&(Ba=!0);I?(B&&(C=P.slice(1,3)),na=C[0],C=C[1]):g&&(D=P.x,C=P.stackY,na=C-P.y);null!==y&&"undefined"!==typeof y&&null!==R&&"undefined"!==typeof R&&(La=C>=y&&C<=R);D>h&&ma.x<h&&(ma.x=D,ma.y=C);D<m&&M.x>m&&(M.x=
D,M.y=C);if(null===C&&J)return"continue";if(null===C||!La&&!Ea&&!Ba)return e(),"continue";(ha>=m||D>=m)&&(Z<=h||D<=h)&&(Ca=!0);if(!Ca&&!Ea&&!Ba)return"continue";Da&&D-Z>Da&&e();if(oa){var l;oa.some(function(a,d){var b=oa[d-1];return"x"===Ta?"undefined"!==typeof a.value&&D<=a.value?(pa[d]&&(!b||D>=b.value)&&(l=pa[d]),!0):!1:"undefined"!==typeof a.value&&C<=a.value?(pa[d]&&(!b||C>=b.value)&&(l=pa[d]),!0):!1});K=l||U||K}if(!A.useGPUTranslations&&(d.skipTranslation=!0,D=H.toPixels(D,!0),C=O.toPixels(C,
!0),D>w&&"points"===d.drawMode))return"continue";d.hasMarkers&&Ca&&!1!==Q&&(a.closestPointRangePx=Math.min(a.closestPointRangePx,Math.abs(D-Q)));if(!A.useGPUTranslations&&!A.usePreallocated&&Q&&1>Math.abs(D-Q)&&r&&1>Math.abs(C-r))return A.debug.showSkipSummary&&++Ja,"continue";if(Sa){E=na;if(!1===na||"undefined"===typeof na)E=0>C?C:0;I||g||(E=Math.max(null===Na?y:Na,y));A.useGPUTranslations||(E=O.toPixels(E,!0));f(D,E,0,0,K)}z.step&&!Ma&&f(D,r,0,2,K);f(D,C,0,"bubble"===a.type?X||1:2,K);Q=D;r=C;Ka=
!0;Ma=!1};N<L.length-1&&"break"!==k(););A.debug.showSkipSummary&&console.log("skipped points:",Ja);Ka||!1===J||"line_strip"!==a.drawMode||(M.x<Number.MAX_VALUE&&x(M,!0),ma.x>-Number.MAX_VALUE&&x(ma))}p()}}function F(){G=[];r.data=S=[];E=[];l&&l.destroy()}function H(a){d&&(d.setUniform("xAxisTrans",a.transA),d.setUniform("xAxisMin",a.min),d.setUniform("xAxisMinPad",a.minPixelPadding),d.setUniform("xAxisPointRange",a.pointRange),d.setUniform("xAxisLen",a.len),d.setUniform("xAxisPos",a.pos),d.setUniform("xAxisCVSCoord",
!a.horiz),d.setUniform("xAxisIsLog",!!a.logarithmic),d.setUniform("xAxisReversed",!!a.reversed))}function x(a){d&&(d.setUniform("yAxisTrans",a.transA),d.setUniform("yAxisMin",a.min),d.setUniform("yAxisMinPad",a.minPixelPadding),d.setUniform("yAxisPointRange",a.pointRange),d.setUniform("yAxisLen",a.len),d.setUniform("yAxisPos",a.pos),d.setUniform("yAxisCVSCoord",!a.horiz),d.setUniform("yAxisIsLog",!!a.logarithmic),d.setUniform("yAxisReversed",!!a.reversed))}function a(a,b){d.setUniform("hasThreshold",
a);d.setUniform("translatedThreshold",b)}function I(p){if(p)R=p.chartWidth||800,Q=p.chartHeight||400;else return!1;if(!(f&&R&&Q&&d))return!1;A.debug.timeRendering&&console.time("gl rendering");f.canvas.width=R;f.canvas.height=Q;d.bind();f.viewport(0,0,R,Q);d.setPMatrix([2/R,0,0,0,0,-(2/Q),0,0,0,0,-2,0,-1,1,-1,1]);1<A.lineWidth&&!h.isMS&&f.lineWidth(A.lineWidth);l.build(r.data,"aVertexPosition",4);l.bind();d.setInverted(p.inverted);G.forEach(function(c,I){var n=c.series.options,k=n.marker;var g="undefined"!==
typeof n.lineWidth?n.lineWidth:1;var z=n.threshold,h=m(z),y=c.series.yAxis.getThreshold(z);z=e(n.marker?n.marker.enabled:null,c.series.xAxis.isRadial?!0:null,c.series.closestPointRangePx>2*((n.marker?n.marker.radius:10)||10));k=Y[k&&k.symbol||c.series.symbol]||Y.circle;if(0!==c.segments.length&&c.segments[0].from!==c.segments[0].to){k.isReady&&(f.bindTexture(f.TEXTURE_2D,k.handle),d.setTexture(k.handle));p.styledMode?k=c.series.markerGroup&&c.series.markerGroup.getStyle("fill"):(k="points"===c.drawMode&&
c.series.pointAttribs&&c.series.pointAttribs().fill||c.series.color,n.colorByPoint&&(k=c.series.chart.options.colors[I]));c.series.fillOpacity&&n.fillOpacity&&(k=(new b(k)).setOpacity(e(n.fillOpacity,1)).get());k=u(k).rgba;A.useAlpha||(k[3]=1);"lines"===c.drawMode&&A.useAlpha&&1>k[3]&&(k[3]/=10);"add"===n.boostBlending?(f.blendFunc(f.SRC_ALPHA,f.ONE),f.blendEquation(f.FUNC_ADD)):"mult"===n.boostBlending||"multiply"===n.boostBlending?f.blendFunc(f.DST_COLOR,f.ZERO):"darken"===n.boostBlending?(f.blendFunc(f.ONE,
f.ONE),f.blendEquation(f.FUNC_MIN)):f.blendFuncSeparate(f.SRC_ALPHA,f.ONE_MINUS_SRC_ALPHA,f.ONE,f.ONE_MINUS_SRC_ALPHA);d.reset();0<c.colorData.length?(d.setUniform("hasColor",1),I=w(f,d),I.build(c.colorData,"aColor",4),I.bind()):f.disableVertexAttribArray(f.getAttribLocation(d.program(),"aColor"));d.setColor(k);H(c.series.xAxis);x(c.series.yAxis);a(h,y);"points"===c.drawMode&&(n.marker&&m(n.marker.radius)?d.setPointSize(2*n.marker.radius):d.setPointSize(1));d.setSkipTranslation(c.skipTranslation);
"bubble"===c.series.type&&d.setBubbleUniforms(c.series,c.zMin,c.zMax);d.setDrawAsCircle(X[c.series.type]||!1);if(0<g||"line_strip"!==c.drawMode)for(g=0;g<c.segments.length;g++)l.render(c.segments[g].from,c.segments[g].to,c.drawMode);if(c.hasMarkers&&z)for(n.marker&&m(n.marker.radius)?d.setPointSize(2*n.marker.radius):d.setPointSize(10),d.setDrawAsCircle(!0),g=0;g<c.segments.length;g++)l.render(c.segments[g].from,c.segments[g].to,"POINTS")}});A.debug.timeRendering&&console.timeEnd("gl rendering");
c&&c();F()}function p(a){y();if(a.renderer.forExport)return I(a);L?I(a):setTimeout(function(){p(a)},1)}var d=!1,l=!1,qa=0,f=!1,R=0,Q=0,S=!1,E=!1,r={},L=!1,G=[],Y={},ia={column:!0,columnrange:!0,bar:!0,area:!0,arearange:!0},X={scatter:!0,bubble:!0},A={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}};return r={allocateBufferForSingleSeries:function(a){var d=
0;A.usePreallocated&&(a.isSeriesBoosting&&(d=n(a)),l.allocate(d))},pushSeries:function(a){0<G.length&&G[G.length-1].hasMarkers&&(G[G.length-1].markerTo=E.length);A.debug.timeSeriesProcessing&&console.time("building "+a.type+" series");var d={segments:[],markerFrom:E.length,colorData:[],series:a,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:a.options.marker?!1!==a.options.marker.enabled:!1,showMarkers:!0,drawMode:{area:"lines",arearange:"lines",areaspline:"line_strip",column:"lines",columnrange:"lines",
bar:"lines",line:"line_strip",scatter:"points",heatmap:"triangles",treemap:"triangles",bubble:"points"}[a.type]||"line_strip"};a.index>=G.length?G.push(d):G[a.index]=d;O(a,d);A.debug.timeSeriesProcessing&&console.timeEnd("building "+a.type+" series")},setSize:function(a,b){R===a&&Q===b||!d||(R=a,Q=b,d.bind(),d.setPMatrix([2/R,0,0,0,0,-(2/Q),0,0,0,0,-2,0,-1,1,-1,1]))},inited:function(){return L},setThreshold:a,init:function(a,b){function c(a,d){var b={isReady:!1,texture:q.createElement("canvas"),handle:f.createTexture()},
c=b.texture.getContext("2d");Y[a]=b;b.texture.width=512;b.texture.height=512;c.mozImageSmoothingEnabled=!1;c.webkitImageSmoothingEnabled=!1;c.msImageSmoothingEnabled=!1;c.imageSmoothingEnabled=!1;c.strokeStyle="rgba(255, 255, 255, 0)";c.fillStyle="#FFF";d(c);try{f.activeTexture(f.TEXTURE0),f.bindTexture(f.TEXTURE_2D,b.handle),f.texImage2D(f.TEXTURE_2D,0,f.RGBA,f.RGBA,f.UNSIGNED_BYTE,b.texture),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_WRAP_S,f.CLAMP_TO_EDGE),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_WRAP_T,
f.CLAMP_TO_EDGE),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_MAG_FILTER,f.LINEAR),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_MIN_FILTER,f.LINEAR),f.bindTexture(f.TEXTURE_2D,null),b.isReady=!0}catch(V){}}var p=0,e=["webgl","experimental-webgl","moz-webgl","webkit-3d"];L=!1;if(!a)return!1;for(A.debug.timeSetup&&console.time("gl setup");p<e.length&&!(f=a.getContext(e[p],{}));p++);if(f)b||F();else return!1;f.enable(f.BLEND);f.blendFunc(f.SRC_ALPHA,f.ONE_MINUS_SRC_ALPHA);f.disable(f.DEPTH_TEST);f.depthFunc(f.LESS);
d=B(f);if(!d)return!1;l=w(f,d);c("circle",function(a){a.beginPath();a.arc(256,256,256,0,2*Math.PI);a.stroke();a.fill()});c("square",function(a){a.fillRect(0,0,512,512)});c("diamond",function(a){a.beginPath();a.moveTo(256,0);a.lineTo(512,256);a.lineTo(256,512);a.lineTo(0,256);a.lineTo(256,0);a.fill()});c("triangle",function(a){a.beginPath();a.moveTo(0,512);a.lineTo(256,0);a.lineTo(512,512);a.lineTo(0,512);a.fill()});c("triangle-down",function(a){a.beginPath();a.moveTo(0,0);a.lineTo(256,512);a.lineTo(512,
0);a.lineTo(0,0);a.fill()});L=!0;A.debug.timeSetup&&console.timeEnd("gl setup");return!0},render:p,settings:A,valid:function(){return!1!==f},clear:y,flush:F,setXAxis:H,setYAxis:x,data:S,gl:function(){return f},allocateBuffer:function(a){var d=0;A.usePreallocated&&(a.series.forEach(function(a){a.isSeriesBoosting&&(d+=n(a))}),l.allocate(d))},destroy:function(){F();l.destroy();d.destroy();f&&(g(Y,function(a){a.handle&&f.deleteTexture(a.handle)}),f.canvas.width=1,f.canvas.height=1)},setOptions:function(a){v(!0,
A,a)}}}});r(b,"Extensions/Boost/BoostAttach.js",[b["Core/Chart/Chart.js"],b["Extensions/Boost/WGLRenderer.js"],b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,B,w,h){var c=w.doc,u=h.error,q;return function(m,h){var v=m.chartWidth,g=m.chartHeight,e=m,n=m.seriesGroup||h.group,k=c.implementation.hasFeature("www.http://w3.org/TR/SVG11/feature#Extensibility","1.1");e=m.isChartSeriesBoosting()?m:h;k=!1;q||(q=c.createElement("canvas"));e.renderTarget||(e.canvas=q,m.renderer.forExport||!k?(e.renderTarget=
m.renderer.image("",0,0,v,g).addClass("highcharts-boost-canvas").add(n),e.boostClear=function(){e.renderTarget.attr({href:""})},e.boostCopy=function(){e.boostResizeTarget();e.renderTarget.attr({href:e.canvas.toDataURL("image/png")})}):(e.renderTargetFo=m.renderer.createElement("foreignObject").add(n),e.renderTarget=c.createElement("canvas"),e.renderTargetCtx=e.renderTarget.getContext("2d"),e.renderTargetFo.element.appendChild(e.renderTarget),e.boostClear=function(){e.renderTarget.width=e.canvas.width;
e.renderTarget.height=e.canvas.height},e.boostCopy=function(){e.renderTarget.width=e.canvas.width;e.renderTarget.height=e.canvas.height;e.renderTargetCtx.drawImage(e.canvas,0,0)}),e.boostResizeTarget=function(){v=m.chartWidth;g=m.chartHeight;(e.renderTargetFo||e.renderTarget).attr({x:0,y:0,width:v,height:g}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1});e instanceof b&&e.markerGroup.translate(m.plotLeft,m.plotTop)},e.boostClipRect=m.renderer.clipRect(),(e.renderTargetFo||e.renderTarget).clip(e.boostClipRect),
e instanceof b&&(e.markerGroup=e.renderer.g().add(n),e.markerGroup.translate(h.xAxis.pos,h.yAxis.pos)));e.canvas.width=v;e.canvas.height=g;e.boostClipRect.attr(m.getBoostClipRect(e));e.boostResizeTarget();e.boostClear();e.ogl||(e.ogl=B(function(){e.ogl.settings.debug.timeBufferCopy&&console.time("buffer copy");e.boostCopy();e.ogl.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),e.ogl.init(e.canvas)||u("[highcharts boost] - unable to init WebGL renderer"),e.ogl.setOptions(m.options.boost||
{}),e instanceof b&&e.ogl.allocateBuffer(m));e.ogl.setSize(v,g);return e.ogl}});r(b,"Extensions/Boost/BoostUtils.js",[b["Core/Globals.js"],b["Extensions/Boost/BoostableMap.js"],b["Extensions/Boost/BoostAttach.js"],b["Core/Utilities.js"]],function(b,B,w,h){function c(){for(var b=[],c=0;c<arguments.length;c++)b[c]=arguments[c];var e=-Number.MAX_VALUE;b.forEach(function(b){if("undefined"!==typeof b&&null!==b&&"undefined"!==typeof b.length&&0<b.length)return e=b.length,!0});return e}function u(b,c,e){b&&
c.renderTarget&&c.canvas&&!(e||c.chart).isChartSeriesBoosting()&&b.render(e||c.chart)}function q(b,c){b&&c.renderTarget&&c.canvas&&!c.chart.isChartSeriesBoosting()&&b.allocateBufferForSingleSeries(c)}function m(b,c,e,g,h,q){h=h||0;g=g||3E3;for(var n=h+g,a=!0;a&&h<n&&h<b.length;)a=c(b[h],h),++h;a&&(h<b.length?q?m(b,c,e,g,h,q):v.requestAnimationFrame?v.requestAnimationFrame(function(){m(b,c,e,g,h)}):setTimeout(function(){m(b,c,e,g,h)}):e&&e())}function t(){var b=0,c,e=["webgl","experimental-webgl",
"moz-webgl","webkit-3d"],h=!1;if("undefined"!==typeof v.WebGLRenderingContext)for(c=g.createElement("canvas");b<e.length;b++)try{if(h=c.getContext(e[b]),"undefined"!==typeof h&&null!==h)return!0}catch(F){}return!1}var v=b.win,g=b.doc,e=h.pick;h={patientMax:c,boostEnabled:function(b){return e(b&&b.options&&b.options.boost&&b.options.boost.enabled,!0)},shouldForceChartSeriesBoosting:function(b){var g=0,h=0,n=e(b.options.boost&&b.options.boost.allowForce,!0);if("undefined"!==typeof b.boostForceChartBoost)return b.boostForceChartBoost;
if(1<b.series.length)for(var m=0;m<b.series.length;m++){var q=b.series[m];0!==q.options.boostThreshold&&!1!==q.visible&&"heatmap"!==q.type&&(B[q.type]&&++h,c(q.processedXData,q.options.data,q.points)>=(q.options.boostThreshold||Number.MAX_VALUE)&&++g)}b.boostForceChartBoost=n&&(h===b.series.length&&0<g||5<g);return b.boostForceChartBoost},renderIfNotSeriesBoosting:u,allocateIfNotSeriesBoosting:q,eachAsync:m,hasWebGLSupport:t,pointDrawHandler:function(b){var c=!0;this.chart.options&&this.chart.options.boost&&
(c="undefined"===typeof this.chart.options.boost.enabled?!0:this.chart.options.boost.enabled);if(!c||!this.isSeriesBoosting)return b.call(this);this.chart.isBoosting=!0;if(b=w(this.chart,this))q(b,this),b.pushSeries(this);u(b,this)}};b.hasWebGLSupport=t;return h});r(b,"Extensions/Boost/BoostInit.js",[b["Core/Chart/Chart.js"],b["Core/Globals.js"],b["Core/Series/Series.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"],b["Extensions/Boost/BoostUtils.js"],b["Extensions/Boost/BoostAttach.js"]],
function(b,B,w,h,c,u,q){var m=B.noop,t=h.seriesTypes,v=c.addEvent,g=c.extend,e=c.fireEvent,n=c.wrap,k=u.eachAsync,y=u.pointDrawHandler,r=u.allocateIfNotSeriesBoosting,H=u.renderIfNotSeriesBoosting,J=u.shouldForceChartSeriesBoosting,x;return function(){g(w.prototype,{renderCanvas:function(){function a(a,b){var d=!1,c="undefined"===typeof g.index,e=!0;if("undefined"===typeof a)return!0;if(!c){if(ka){var l=a[0];var p=a[1]}else l=a,p=v[b];ba?(ka&&(p=a.slice(1,3)),d=p[0],p=p[1]):ja&&(l=a.x,p=a.stackY,
d=p-a.y);wa||(e=p>=B&&p<=y);if(null!==p&&l>=u&&l<=w&&e)if(a=f.toPixels(l,!0),A){if("undefined"===typeof V||a===J){ba||(d=p);if("undefined"===typeof da||p>ca)ca=p,da=b;if("undefined"===typeof V||d<T)T=d,V=b}a!==J&&("undefined"!==typeof V&&(p=h.toPixels(ca,!0),O=h.toPixels(T,!0),ea(a,p,da),O!==p&&ea(a,O,V)),V=da=void 0,J=a)}else p=Math.ceil(h.toPixels(p,!0)),ea(a,p,b)}return!c}function b(){e(c,"renderedCanvas");delete c.buildKDTree;c.buildKDTree();ua.debug.timeKDTree&&console.timeEnd("kd tree building")}
var c=this,d=c.options||{},l=!1,g=c.chart,f=this.xAxis,h=this.yAxis,n=d.xData||c.processedXData,v=d.yData||c.processedYData,t=d.data;l=f.getExtremes();var u=l.min,w=l.max;l=h.getExtremes();var B=l.min,y=l.max,F={},J,A=!!c.sampling,z=!1!==d.enableMouseTracking,O=h.getThreshold(d.threshold),ba=c.pointArrayMap&&"low,high"===c.pointArrayMap.join(","),ja=!!d.stacking,ra=c.cropStart||0,wa=c.requireSorting,ka=!n,T,ca,V,da,ta="x"===d.findNearestPointBy,la=this.xData||this.options.xData||this.processedXData||
!1,ea=function(a,b,d){a=Math.ceil(a);x=ta?a:a+","+b;z&&!F[x]&&(F[x]=!0,g.inverted&&(a=f.len-a,b=h.len-b),va.push({x:la?la[ra+d]:!1,clientX:a,plotX:a,plotY:b,i:ra+d}))};l=q(g,c);g.isBoosting=!0;var ua=l.settings;if(this.visible){(this.points||this.graph)&&this.destroyGraphics();g.isChartSeriesBoosting()?(this.markerGroup&&this.markerGroup!==g.markerGroup&&this.markerGroup.destroy(),this.markerGroup=g.markerGroup,this.renderTarget&&(this.renderTarget=this.renderTarget.destroy())):(this.markerGroup===
g.markerGroup&&(this.markerGroup=void 0),this.markerGroup=c.plotGroup("markerGroup","markers",!0,1,g.seriesGroup));var va=this.points=[];c.buildKDTree=m;l&&(r(l,this),l.pushSeries(c),H(l,this,g));g.renderer.forExport||(ua.debug.timeKDTree&&console.time("kd tree building"),k(ja?c.data:n||t,a,b))}}});["heatmap","treemap"].forEach(function(a){t[a]&&n(t[a].prototype,"drawPoints",y)});t.bubble&&(delete t.bubble.prototype.buildKDTree,n(t.bubble.prototype,"markerAttribs",function(a){return this.isSeriesBoosting?
!1:a.apply(this,[].slice.call(arguments,1))}));t.scatter.prototype.fill=!0;g(t.area.prototype,{fill:!0,fillOpacity:!0,sampling:!0});g(t.column.prototype,{fill:!0,sampling:!0});b.prototype.propsRequireUpdateSeries.push("boost");b.prototype.callbacks.push(function(a){v(a,"predraw",function(){a.boostForceChartBoost=void 0;a.boostForceChartBoost=J(a);a.isBoosting=!1;!a.isChartSeriesBoosting()&&a.didBoost&&(a.didBoost=!1);a.boostClear&&a.boostClear();a.canvas&&a.ogl&&a.isChartSeriesBoosting()&&(a.didBoost=
!0,a.ogl.allocateBuffer(a));a.markerGroup&&a.xAxis&&0<a.xAxis.length&&a.yAxis&&0<a.yAxis.length&&a.markerGroup.translate(a.xAxis[0].pos,a.yAxis[0].pos)});v(a,"render",function(){a.ogl&&a.isChartSeriesBoosting()&&a.ogl.render(a)});var b=-1,c=-1;v(a.pointer,"afterGetHoverData",function(){var d=a.hoverSeries;if(a.markerGroup&&d){var e=a.inverted?d.yAxis:d.xAxis;d=a.inverted?d.xAxis:d.yAxis;if(e&&e.pos!==b||d&&d.pos!==c)a.markerGroup.translate(e.pos,d.pos),b=e.pos,c=d.pos}})})}});r(b,"Extensions/BoostCanvas.js",
[b["Core/Chart/Chart.js"],b["Core/Color/Color.js"],b["Core/Globals.js"],b["Core/Color/Palette.js"],b["Core/Series/Series.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,B,w,h,c,u,q){var m=B.parse,t=w.doc,v=w.noop,g=u.seriesTypes,e=q.addEvent,n=q.extend,k=q.fireEvent,y=q.isNumber,r=q.merge,F=q.pick,H=q.wrap,x;return function(){w.seriesTypes.heatmap&&H(w.seriesTypes.heatmap.prototype,"drawPoints",function(){var a=this.chart,b=this.getContext(),c=this.chart.inverted,d=this.xAxis,
e=this.yAxis;b?(this.points.forEach(function(p){var f=p.plotY;if("undefined"!==typeof f&&!isNaN(f)&&null!==p.y&&b){var l=p.shapeArgs||{};f=l.x;f=void 0===f?0:f;var g=l.y;g=void 0===g?0:g;var x=l.width;x=void 0===x?0:x;l=l.height;l=void 0===l?0:l;p=a.styledMode?p.series.colorAttribs(p):p.series.pointAttribs(p);b.fillStyle=p.fill;c?b.fillRect(e.len-g+d.left,d.len-f+e.top,-l,-x):b.fillRect(f+d.left,g+e.top,x,l)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")});
n(c.prototype,{getContext:function(){var a=this.chart,b=a.chartWidth,c=a.chartHeight,d=a.seriesGroup||this.group,e=this,g=function(a,b,d,c,e,f,p){a.call(this,d,b,c,e,f,p)};a.isChartSeriesBoosting()&&(e=a,d=a.seriesGroup);var f=e.ctx;e.canvas||(e.canvas=t.createElement("canvas"),e.renderTarget=a.renderer.image("",0,0,b,c).addClass("highcharts-boost-canvas").add(d),e.ctx=f=e.canvas.getContext("2d"),a.inverted&&["moveTo","lineTo","rect","arc"].forEach(function(a){H(f,a,g)}),e.boostCopy=function(){e.renderTarget.attr({href:e.canvas.toDataURL("image/png")})},
e.boostClear=function(){f.clearRect(0,0,e.canvas.width,e.canvas.height);e===this&&e.renderTarget.attr({href:""})},e.boostClipRect=a.renderer.clipRect(),e.renderTarget.clip(e.boostClipRect));e.canvas.width!==b&&(e.canvas.width=b);e.canvas.height!==c&&(e.canvas.height=c);e.renderTarget.attr({x:0,y:0,width:b,height:c,style:"pointer-events: none",href:""});e.boostClipRect.attr(a.getBoostClipRect(e));return f},canvasToSVG:function(){this.chart.isChartSeriesBoosting()?this.boostClear&&this.boostClear():
(this.boostCopy||this.chart.boostCopy)&&(this.boostCopy||this.chart.boostCopy)()},cvsLineTo:function(a,b,c){a.lineTo(b,c)},renderCanvas:function(){var a=this,b=a.options,c=a.chart,d=this.xAxis,g=this.yAxis,t=(c.options.boost||{}).timeRendering||!1,f=0,u=a.processedXData,H=a.processedYData,O=b.data,E=d.getExtremes(),J=E.min,L=E.max;E=g.getExtremes();var G=E.min,Y=E.max,ia={},X,A=!!a.sampling,z=b.marker&&b.marker.radius,aa=this.cvsDrawPoint,ba=b.lineWidth?this.cvsLineTo:void 0,ja=z&&1>=z?this.cvsMarkerSquare:
this.cvsMarkerCircle,ra=this.cvsStrokeBatch||1E3,wa=!1!==b.enableMouseTracking,ka;E=b.threshold;var T=g.getThreshold(E),ca=y(E),V=T,da=this.fill,ta=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),la=!!b.stacking,ea=a.cropStart||0;E=c.options.loading;var ua=a.requireSorting,va,Oa=b.connectNulls,Fa=!u,ya,za,fa,sa,xa,W=la?a.data:u||O,Pa=a.fillOpacity?(new B(a.color)).setOpacity(F(b.fillOpacity,.75)).get():a.color,Ga=function(){da?(M.fillStyle=Pa,M.fill()):(M.strokeStyle=a.color,M.lineWidth=b.lineWidth,
M.stroke())},Ha=function(b,d,e,g){0===f&&(M.beginPath(),ba&&(M.lineJoin="round"));c.scroller&&"highcharts-navigator-series"===a.options.className?(d+=c.scroller.top,e&&(e+=c.scroller.top)):d+=c.plotTop;b+=c.plotLeft;va?M.moveTo(b,d):aa?aa(M,b,d,e,ka):ba?ba(M,b,d):ja&&ja.call(a,M,b,d,z,g);f+=1;f===ra&&(Ga(),f=0);ka={clientX:b,plotY:d,yBottom:e}},Qa="x"===b.findNearestPointBy,Ia=this.xData||this.options.xData||this.processedXData||!1,Aa=function(a,b,e){xa=Qa?a:a+","+b;wa&&!ia[xa]&&(ia[xa]=!0,c.inverted&&
(a=d.len-a,b=g.len-b),Ra.push({x:Ia?Ia[ea+e]:!1,clientX:a,plotX:a,plotY:b,i:ea+e}))};this.renderTarget&&this.renderTarget.attr({href:""});(this.points||this.graph)&&this.destroyGraphics();a.plotGroup("group","series",a.visible?"visible":"hidden",b.zIndex,c.seriesGroup);a.markerGroup=a.group;e(a,"destroy",function(){a.markerGroup=null});var Ra=this.points=[];var M=this.getContext();a.buildKDTree=v;this.boostClear&&this.boostClear();this.visible&&(99999<O.length&&(c.options.loading=r(E,{labelStyle:{backgroundColor:m(h.backgroundColor).setOpacity(.75).get(),
padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),q.clearTimeout(x),c.showLoading("Drawing..."),c.options.loading=E),t&&console.time("canvas rendering"),w.eachAsync(W,function(b,e){var f=!1,p=!1,l=!1,x=!1,h="undefined"===typeof c.index,n=!0;if(!h){if(Fa){var m=b[0];var k=b[1];W[e+1]&&(l=W[e+1][0]);W[e-1]&&(x=W[e-1][0])}else m=b,k=H[e],W[e+1]&&(l=W[e+1]),W[e-1]&&(x=W[e-1]);l&&l>=J&&l<=L&&(f=!0);x&&x>=J&&x<=L&&(p=!0);if(ta){Fa&&(k=b.slice(1,3));var I=k[0];k=k[1]}else la&&
(m=b.x,k=b.stackY,I=k-b.y);b=null===k;ua||(n=k>=G&&k<=Y);if(!b&&(m>=J&&m<=L&&n||f||p))if(m=Math.round(d.toPixels(m,!0)),A){if("undefined"===typeof fa||m===X){ta||(I=k);if("undefined"===typeof sa||k>za)za=k,sa=e;if("undefined"===typeof fa||I<ya)ya=I,fa=e}m!==X&&("undefined"!==typeof fa&&(k=g.toPixels(za,!0),T=g.toPixels(ya,!0),Ha(m,ca?Math.min(k,V):k,ca?Math.max(T,V):T,e),Aa(m,k,sa),T!==k&&Aa(m,T,fa)),fa=sa=void 0,X=m)}else k=Math.round(g.toPixels(k,!0)),Ha(m,k,T,e),Aa(m,k,e);va=b&&!Oa;0===e%5E4&&
(a.boostCopy||a.chart.boostCopy)&&(a.boostCopy||a.chart.boostCopy)()}return!h},function(){var b=c.loadingDiv,d=c.loadingShown;Ga();a.canvasToSVG();t&&console.timeEnd("canvas rendering");k(a,"renderedCanvas");d&&(n(b.style,{transition:"opacity 250ms",opacity:0}),c.loadingShown=!1,x=setTimeout(function(){b.parentNode&&b.parentNode.removeChild(b);c.loadingDiv=c.loadingSpan=null},250));delete a.buildKDTree;a.buildKDTree()},c.renderer.forExport?Number.MAX_VALUE:void 0))}});g.scatter.prototype.cvsMarkerCircle=
function(a,b,c,d){a.moveTo(b,c);a.arc(b,c,d,0,2*Math.PI,!1)};g.scatter.prototype.cvsMarkerSquare=function(a,b,c,d){a.rect(b-d,c-d,2*d,2*d)};g.scatter.prototype.fill=!0;g.bubble&&(g.bubble.prototype.cvsMarkerCircle=function(a,b,c,d,e){a.moveTo(b,c);a.arc(b,c,this.radii&&this.radii[e],0,2*Math.PI,!1)},g.bubble.prototype.cvsStrokeBatch=1);n(g.area.prototype,{cvsDrawPoint:function(a,b,c,d,e){e&&b!==e.clientX&&(a.moveTo(e.clientX,e.yBottom),a.lineTo(e.clientX,e.plotY),a.lineTo(b,c),a.lineTo(b,d))},fill:!0,
fillOpacity:!0,sampling:!0});n(g.column.prototype,{cvsDrawPoint:function(a,b,c,d){a.rect(b-1,c,1,d-c)},fill:!0,sampling:!0});b.prototype.callbacks.push(function(a){e(a,"predraw",function(){a.renderTarget&&a.renderTarget.attr({href:""});a.canvas&&a.canvas.getContext("2d").clearRect(0,0,a.canvas.width,a.canvas.height)});e(a,"render",function(){a.boostCopy&&a.boostCopy()})})}});r(b,"Extensions/Boost/BoostOverrides.js",[b["Core/Chart/Chart.js"],b["Core/DefaultOptions.js"],b["Core/Series/Point.js"],b["Core/Series/Series.js"],
b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"],b["Extensions/Boost/BoostUtils.js"],b["Extensions/Boost/Boostables.js"],b["Extensions/Boost/BoostableMap.js"]],function(b,r,w,h,c,u,q,m,t){r=r.getOptions;var v=c.seriesTypes;c=u.addEvent;var g=u.error,e=u.isArray,n=u.isNumber,k=u.pick,y=u.wrap,B=q.boostEnabled,H=q.shouldForceChartSeriesBoosting,J=r().plotOptions;b.prototype.isChartSeriesBoosting=function(){return k(this.options.boost&&this.options.boost.seriesThreshold,50)<=this.series.length||
H(this)};b.prototype.getBoostClipRect=function(b){var a={x:this.plotLeft,y:this.plotTop,width:this.plotWidth,height:this.plotHeight};b===this&&(b=this.inverted?this.xAxis:this.yAxis,1>=b.length?(a.y=Math.min(b[0].pos,a.y),a.height=b[0].pos-this.plotTop+b[0].len):a.height=this.plotHeight);return a};h.prototype.getPoint=function(b){var a=b,c=this.xData||this.options.xData||this.processedXData||!1;!b||b instanceof this.pointClass||(a=(new this.pointClass).init(this,this.options.data[b.i],c?c[b.i]:void 0),
a.category=k(this.xAxis.categories?this.xAxis.categories[a.x]:a.x,a.x),a.dist=b.dist,a.distX=b.distX,a.plotX=b.plotX,a.plotY=b.plotY,a.index=b.i,a.isInside=this.isPointInside(b));return a};y(h.prototype,"searchPoint",function(b){return this.getPoint(b.apply(this,[].slice.call(arguments,1)))});y(w.prototype,"haloPath",function(b){var a=this.series,c=this.plotX,e=this.plotY,d=a.chart.inverted;a.isSeriesBoosting&&d&&(this.plotX=a.yAxis.len-e,this.plotY=a.xAxis.len-c);var g=b.apply(this,Array.prototype.slice.call(arguments,
1));a.isSeriesBoosting&&d&&(this.plotX=c,this.plotY=e);return g});y(h.prototype,"markerAttribs",function(b,a){var c=a.plotX,e=a.plotY,d=this.chart.inverted;this.isSeriesBoosting&&d&&(a.plotX=this.yAxis.len-e,a.plotY=this.xAxis.len-c);var g=b.apply(this,Array.prototype.slice.call(arguments,1));this.isSeriesBoosting&&d&&(a.plotX=c,a.plotY=e);return g});c(h,"destroy",function(){var b=this,a=b.chart;a.markerGroup===b.markerGroup&&(b.markerGroup=null);a.hoverPoints&&(a.hoverPoints=a.hoverPoints.filter(function(a){return a.series===
b}));a.hoverPoint&&a.hoverPoint.series===b&&(a.hoverPoint=null)});y(h.prototype,"getExtremes",function(b){return this.isSeriesBoosting&&this.hasExtremes&&this.hasExtremes()?{}:b.apply(this,Array.prototype.slice.call(arguments,1))});["translate","generatePoints","drawTracker","drawPoints","render"].forEach(function(b){function a(a){var c=this.options.stacking&&("translate"===b||"generatePoints"===b);if(!this.isSeriesBoosting||c||!B(this.chart)||"heatmap"===this.type||"treemap"===this.type||!t[this.type]||
0===this.options.boostThreshold)a.call(this);else if(this[b+"Canvas"])this[b+"Canvas"]()}y(h.prototype,b,a);"translate"===b&&"column bar arearange columnrange heatmap treemap".split(" ").forEach(function(c){v[c]&&y(v[c].prototype,b,a)})});y(h.prototype,"processData",function(b){function a(a){return c.chart.isChartSeriesBoosting()||(a?a.length:0)>=(c.options.boostThreshold||Number.MAX_VALUE)}var c=this,h=this.options.data;B(this.chart)&&t[this.type]?(a(h)&&"heatmap"!==this.type&&"treemap"!==this.type&&
!this.options.stacking&&this.hasExtremes&&this.hasExtremes(!0)||(b.apply(this,Array.prototype.slice.call(arguments,1)),h=this.processedXData),(this.isSeriesBoosting=a(h))?(this.options.data&&this.options.data.length&&(h=this.getFirstValidPoint(this.options.data),n(h)||e(h)||g(12,!1,this.chart)),this.enterBoost()):this.exitBoost&&this.exitBoost()):b.apply(this,Array.prototype.slice.call(arguments,1))});c(h,"hide",function(){this.canvas&&this.renderTarget&&(this.ogl&&this.ogl.clear(),this.boostClear())});
h.prototype.enterBoost=function(){this.alteredByBoost=[];["allowDG","directTouch","stickyTracking"].forEach(function(b){this.alteredByBoost.push({prop:b,val:this[b],own:Object.hasOwnProperty.call(this,b)})},this);this.directTouch=this.allowDG=!1;this.finishedAnimating=this.stickyTracking=!0;this.labelBySeries&&(this.labelBySeries=this.labelBySeries.destroy())};h.prototype.exitBoost=function(){(this.alteredByBoost||[]).forEach(function(b){b.own?this[b.prop]=b.val:delete this[b.prop]},this);this.boostClear&&
this.boostClear()};h.prototype.hasExtremes=function(b){var a=this.options,c=this.xAxis&&this.xAxis.options,e=this.yAxis&&this.yAxis.options,d=this.colorAxis&&this.colorAxis.options;return a.data.length>(a.boostThreshold||Number.MAX_VALUE)&&n(e.min)&&n(e.max)&&(!b||n(c.min)&&n(c.max))&&(!d||n(d.min)&&n(d.max))};h.prototype.destroyGraphics=function(){var b=this,a=this,c=this.points,e,d;if(c)for(d=0;d<c.length;d+=1)(e=c[d])&&e.destroyElements&&e.destroyElements();["graph","area","tracker"].forEach(function(b){a[b]&&
(a[b]=a[b].destroy())});this.getZonesGraphs&&this.getZonesGraphs([["graph","highcharts-graph"]]).forEach(function(a){var c=b[a[0]];c&&(b[a[0]]=c.destroy())})};m.forEach(function(b){J[b]&&(J[b].boostThreshold=5E3,J[b].boostData=[],v[b].prototype.fillOpacity=!0)})});r(b,"Extensions/Boost/NamedColors.js",[b["Core/Color/Color.js"]],function(b){var r={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",
blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",
darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",feldspar:"#d19275",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",
lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslateblue:"#8470ff",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",
mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",
peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",
violetred:"#d02090",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};return b.names=r});r(b,"Extensions/Boost/Boost.js",[b["Extensions/Boost/BoostUtils.js"],b["Extensions/Boost/BoostInit.js"],b["Extensions/BoostCanvas.js"],b["Core/Utilities.js"]],function(b,r,w,h){h=h.error;b=b.hasWebGLSupport;b()?r():"undefined"!==typeof w?w():h(26)});r(b,"masters/modules/boost.src.js",[],function(){})});
//# sourceMappingURL=boost.js.map