"use strict";!function(t){"object"==typeof module&&module.exports?module.exports=t.default=t:"function"==typeof define&&define.amd?define("highcharts/modules/boost",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){function t(e,t,o,i){e.hasOwnProperty(t)||(e[t]=i.apply(null,o))}t(e=e?e._modules:{},"Extensions/Boost/Boostables.js",[],function(){return"area arearange column columnrange bar line scatter heatmap bubble treemap".split(" ")}),t(e,"Extensions/Boost/BoostableMap.js",[e["Extensions/Boost/Boostables.js"]],function(e){var t={};return e.forEach(function(e){t[e]=1}),t}),t(e,"Extensions/Boost/WGLShader.js",[e["Core/Utilities.js"]],function(e){var v=e.clamp,t=e.error,y=e.pick;return function(s){function i(){x.length&&t("[highcharts boost] shader error - "+x.join("\n"))}function r(e,t){var o=s.createShader("vertex"===t?s.VERTEX_SHADER:s.FRAGMENT_SHADER);return s.shaderSource(o,e),s.compileShader(o),s.getShaderParameter(o,s.COMPILE_STATUS)?o:(x.push("when compiling "+t+" shader:\n"+s.getShaderInfoLog(o)),!1)}function e(){function e(e){return s.getUniformLocation(l,e)}var t=r("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}","vertex"),o=r("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment");return t&&o?(l=s.createProgram(),s.attachShader(l,t),s.attachShader(l,o),s.linkProgram(l),s.getProgramParameter(l,s.LINK_STATUS)?(s.useProgram(l),s.bindAttribLocation(l,0,"aVertexPosition"),n=e("uPMatrix"),c=e("pSize"),h=e("fillColor"),f=e("isBubble"),u=e("bubbleSizeAbs"),d=e("bubbleSizeByArea"),m=e("uSampler"),p=e("skipTranslation"),g=e("isCircle"),b=e("isInverted"),!0):(x.push(s.getProgramInfoLog(l)),i(),l=!1)):(l=!1,i(),!1)}function a(e,t){s&&l&&(e=o[e]=o[e]||s.getUniformLocation(l,e),s.uniform1f(e,t))}var l,n,c,h,f,u,d,p,g,b,m,o={},x=[];return!(s&&!e())&&{psUniform:function(){return c},pUniform:function(){return n},fillColorUniform:function(){return h},setBubbleUniforms:function(e,t,o){var i=e.options,r=Number.MAX_VALUE,n=-Number.MAX_VALUE;s&&l&&"bubble"===e.type&&(r=y(i.zMin,v(t,!1===i.displayNegative?i.zThreshold:-Number.MAX_VALUE,r)),n=y(i.zMax,Math.max(n,o)),s.uniform1i(f,1),s.uniform1i(g,1),s.uniform1i(d,"width"!==e.options.sizeBy),s.uniform1i(u,e.options.sizeByAbsoluteValue),a("bubbleZMin",r),a("bubbleZMax",n),a("bubbleZThreshold",e.options.zThreshold),a("bubbleMinSize",e.minPxSize),a("bubbleMaxSize",e.maxPxSize))},bind:function(){s&&l&&s.useProgram(l)},program:function(){return l},create:e,setUniform:a,setPMatrix:function(e){s&&l&&s.uniformMatrix4fv(n,!1,e)},setColor:function(e){s&&l&&s.uniform4f(h,e[0]/255,e[1]/255,e[2]/255,e[3])},setPointSize:function(e){s&&l&&s.uniform1f(c,e)},setSkipTranslation:function(e){s&&l&&s.uniform1i(p,!0===e?1:0)},setTexture:function(e){s&&l&&s.uniform1i(m,e)},setDrawAsCircle:function(e){s&&l&&s.uniform1i(g,e?1:0)},reset:function(){s&&l&&(s.uniform1i(f,0),s.uniform1i(g,0))},setInverted:function(e){s&&l&&s.uniform1i(b,e)},destroy:function(){s&&l&&(s.deleteProgram(l),l=!1)}}}}),t(e,"Extensions/Boost/WGLVBuffer.js",[],function(){return function(r,n,e){function s(){l&&(r.deleteBuffer(l),c=l=!1),u=0,h=e||2,a=[]}var a,l=!1,c=!1,h=e||2,f=!1,u=0;return{destroy:s,bind:function(){if(!l)return!1;r.vertexAttribPointer(c,h,r.FLOAT,!1,0,0)},data:a,build:function(e,t,o){var i;return(a=e||[])&&0!==a.length||f?(h=o||h,l&&r.deleteBuffer(l),f||(i=new Float32Array(a)),l=r.createBuffer(),r.bindBuffer(r.ARRAY_BUFFER,l),r.bufferData(r.ARRAY_BUFFER,f||i,r.STATIC_DRAW),c=r.getAttribLocation(n.program(),t),r.enableVertexAttribArray(c),!0):(s(),!1)},render:function(e,t,o){var i=(f||a).length;return!(!l||!i)&&((!e||i<e||e<0)&&(e=0),(!t||i<t)&&(t=i),r.drawArrays(r[(o||"points").toUpperCase()],e/h,(t-e)/h),!0)},allocate:function(e){u=-1,f=new Float32Array(4*e)},push:function(e,t,o,i){f&&(f[++u]=e,f[++u]=t,f[++u]=o,f[++u]=i)}}}}),t(e,"Extensions/Boost/WGLRenderer.js",[e["Core/Color/Color.js"],e["Extensions/Boost/WGLShader.js"],e["Extensions/Boost/WGLVBuffer.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(x,v,y,A,e){var ae=x.parse,T=A.doc,C=e.isNumber,le=e.isObject,P=e.merge,S=e.objectEach,E=e.pick;return function(e){function o(e){if(e.isSeriesBoosting){var t=!!e.options.stacking,o=e.xData||e.options.xData||e.processedXData,t=(t?e.data:o||e.options.data).length;return"treemap"===e.type?t*=12:"heatmap"===e.type?t*=6:ne[e.type]&&(t*=2),t}return 0}function i(){d.clear(d.COLOR_BUFFER_BIT|d.DEPTH_BUFFER_BIT)}function n(){g=[],t.data=re=[],l=[],oe&&oe.destroy()}function c(e){u&&(u.setUniform("xAxisTrans",e.transA),u.setUniform("xAxisMin",e.min),u.setUniform("xAxisMinPad",e.minPixelPadding),u.setUniform("xAxisPointRange",e.pointRange),u.setUniform("xAxisLen",e.len),u.setUniform("xAxisPos",e.pos),u.setUniform("xAxisCVSCoord",!e.horiz),u.setUniform("xAxisIsLog",!!e.logarithmic),u.setUniform("xAxisReversed",!!e.reversed))}function h(e){u&&(u.setUniform("yAxisTrans",e.transA),u.setUniform("yAxisMin",e.min),u.setUniform("yAxisMinPad",e.minPixelPadding),u.setUniform("yAxisPointRange",e.pointRange),u.setUniform("yAxisLen",e.len),u.setUniform("yAxisPos",e.pos),u.setUniform("yAxisCVSCoord",!e.horiz),u.setUniform("yAxisIsLog",!!e.logarithmic),u.setUniform("yAxisReversed",!!e.reversed))}function f(e,t){u.setUniform("hasThreshold",e),u.setUniform("translatedThreshold",t)}function r(l){return!!l&&(s=l.chartWidth||800,a=l.chartHeight||400,!!(d&&s&&a&&u)&&(se.debug.timeRendering&&console.time("gl rendering"),d.canvas.width=s,d.canvas.height=a,u.bind(),d.viewport(0,0,s,a),u.setPMatrix([2/s,0,0,0,0,-2/a,0,0,0,0,-2,0,-1,1,-1,1]),1<se.lineWidth&&!A.isMS&&d.lineWidth(se.lineWidth),oe.build(t.data,"aVertexPosition",4),oe.bind(),u.setInverted(l.inverted),g.forEach(function(e,t){var o=e.series.options,i=o.marker,r=void 0!==o.lineWidth?o.lineWidth:1,n=o.threshold,s=C(n),a=e.series.yAxis.getThreshold(n),n=E(o.marker?o.marker.enabled:null,!!e.series.xAxis.isRadial||null,e.series.closestPointRangePx>2*((o.marker?o.marker.radius:10)||10)),i=b[i&&i.symbol||e.series.symbol]||b.circle;if(0!==e.segments.length&&e.segments[0].from!==e.segments[0].to){if(i.isReady&&(d.bindTexture(d.TEXTURE_2D,i.handle),u.setTexture(i.handle)),l.styledMode?i=e.series.markerGroup&&e.series.markerGroup.getStyle("fill"):(i="points"===e.drawMode&&e.series.pointAttribs&&e.series.pointAttribs().fill||e.series.color,o.colorByPoint&&(i=e.series.chart.options.colors[t])),e.series.fillOpacity&&o.fillOpacity&&(i=new x(i).setOpacity(E(o.fillOpacity,1)).get()),i=ae(i).rgba,se.useAlpha||(i[3]=1),"lines"===e.drawMode&&se.useAlpha&&i[3]<1&&(i[3]/=10),"add"===o.boostBlending?(d.blendFunc(d.SRC_ALPHA,d.ONE),d.blendEquation(d.FUNC_ADD)):"mult"===o.boostBlending||"multiply"===o.boostBlending?d.blendFunc(d.DST_COLOR,d.ZERO):"darken"===o.boostBlending?(d.blendFunc(d.ONE,d.ONE),d.blendEquation(d.FUNC_MIN)):d.blendFuncSeparate(d.SRC_ALPHA,d.ONE_MINUS_SRC_ALPHA,d.ONE,d.ONE_MINUS_SRC_ALPHA),u.reset(),0<e.colorData.length?(u.setUniform("hasColor",1),(t=y(d,u)).build(e.colorData,"aColor",4),t.bind()):d.disableVertexAttribArray(d.getAttribLocation(u.program(),"aColor")),u.setColor(i),c(e.series.xAxis),h(e.series.yAxis),f(s,a),"points"===e.drawMode&&(o.marker&&C(o.marker.radius)?u.setPointSize(2*o.marker.radius):u.setPointSize(1)),u.setSkipTranslation(e.skipTranslation),"bubble"===e.series.type&&u.setBubbleUniforms(e.series,e.zMin,e.zMax),u.setDrawAsCircle(m[e.series.type]||!1),0<r||"line_strip"!==e.drawMode)for(r=0;r<e.segments.length;r++)oe.render(e.segments[r].from,e.segments[r].to,e.drawMode);if(e.hasMarkers&&n)for(o.marker&&C(o.marker.radius)?u.setPointSize(2*o.marker.radius):u.setPointSize(10),u.setDrawAsCircle(!0),r=0;r<e.segments.length;r++)oe.render(e.segments[r].from,e.segments[r].to,"POINTS")}}),se.debug.timeRendering&&console.timeEnd("gl rendering"),e&&e(),void n()))}var u=!1,oe=!1,ie=0,d=!1,s=0,a=0,re=!1,l=!1,t={},p=!1,g=[],b={},ne={column:!0,columnrange:!0,bar:!0,area:!0,arearange:!0},m={scatter:!0,bubble:!0},se={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}};return t={allocateBufferForSingleSeries:function(e){var t=0;se.usePreallocated&&(e.isSeriesBoosting&&(t=o(e)),oe.allocate(t))},pushSeries:function(e){0<g.length&&g[g.length-1].hasMarkers&&(g[g.length-1].markerTo=l.length),se.debug.timeSeriesProcessing&&console.time("building "+e.type+" series");var t={segments:[],markerFrom:l.length,colorData:[],series:e,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:!!e.options.marker&&!1!==e.options.marker.enabled,showMarkers:!0,drawMode:{area:"lines",arearange:"lines",areaspline:"line_strip",column:"lines",columnrange:"lines",bar:"lines",line:"line_strip",scatter:"points",heatmap:"triangles",treemap:"triangles",bubble:"points"}[e.type]||"line_strip"};e.index>=g.length?g.push(t):g[e.index]=t,function(s,o){function n(e){e&&(o.colorData.push(e[0]),o.colorData.push(e[1]),o.colorData.push(e[2]),o.colorData.push(e[3]))}function a(e,t,o,i,r){n(r),se.usePreallocated?(oe.push(e,t,o?1:0,i||1),ie+=4):(re.push(e),re.push(t),re.push(o?1:0),re.push(i||1))}function e(){o.segments.length&&(o.segments[o.segments.length-1].to=re.length||ie)}function t(){o.segments.length&&o.segments[o.segments.length-1].from===(re.length||ie)||(e(),o.segments.push({from:re.length||ie}))}function l(e,t,o,i,r){n(r),a(e+o,t),n(r),a(e,t),n(r),a(e,t+i),n(r),a(e,t+i),n(r),a(e+o,t+i),n(r),a(e+o,t)}function i(e,t){se.useGPUTranslations||(o.skipTranslation=!0,e.x=T.toPixels(e.x,!0),e.y=A.toPixels(e.y,!0)),t?re=[e.x,e.y,0,2].concat(re):a(e.x,e.y,0,2)}var r=s.pointArrayMap&&"low,high"===s.pointArrayMap.join(","),c=s.chart,h=s.options,f=!!h.stacking,u=h.data,d=s.xAxis.getExtremes(),p=d.min,g=d.max,b=(d=s.yAxis.getExtremes()).min,m=d.max,x=s.xData||h.xData||s.processedXData,v=s.yData||h.yData||s.processedYData,y=s.zData||h.zData||s.processedZData,A=s.yAxis,T=s.xAxis,C=s.chart.plotWidth,P=!x||0===x.length,S=h.connectNulls;d=s.points||!1;var E,k,B,M,w,R,D,U=!1,L=!1,z=f?s.data:x||u,_={x:Number.MAX_VALUE,y:0},G={x:-Number.MAX_VALUE,y:0},j=0,N=!1,X=-1,O=!1,F=!1,I=void 0===c.index,V=!1,W=!1,Y=!1,H=ne[s.type],q=!1,Z=!0,K=!0,J=h.zoneAxis||"y",Q=h.zones||!1,$=!1,ee=h.threshold,te=!1;if(!(h.boostData&&0<h.boostData.length)){if(h.gapSize&&(te="value"!==h.gapUnit?h.gapSize*s.closestPointRange:h.gapSize),Q&&(D=[],Q.forEach(function(e,t){var o;e.color&&((o=ae(e.color).rgba)[0]/=255,o[1]/=255,o[2]/=255,D[t]=o,$||void 0!==e.value||($=o))}),$||(x=s.pointAttribs&&s.pointAttribs().fill||s.color,($=ae(x).rgba)[0]/=255,$[1]/=255,$[2]/=255)),c.inverted&&(C=s.chart.plotHeight),s.closestPointRangePx=Number.MAX_VALUE,t(),d&&0<d.length)o.skipTranslation=!0,o.drawMode="triangles",d[0].node&&d[0].node.levelDynamic&&d.sort(function(e,t){if(e.node){if(e.node.levelDynamic>t.node.levelDynamic)return 1;if(e.node.levelDynamic<t.node.levelDynamic)return-1}return 0}),d.forEach(function(e){var t,o,i,r,n=e.plotY;void 0!==n&&!isNaN(n)&&null!==e.y&&e.shapeArgs&&(n=void 0===(n=(i=e.shapeArgs).x)?0:n,t=void 0===(t=i.y)?0:t,o=void 0===(o=i.width)?0:o,i=void 0===(i=i.height)?0:i,e=(r=c.styledMode?e.series.colorAttribs(e):e.series.pointAttribs(e))["stroke-width"]||0,(Y=ae(r.fill).rgba)[0]/=255,Y[1]/=255,Y[2]/=255,"treemap"===s.type&&(e=e||1,(E=ae(r.stroke).rgba)[0]/=255,E[1]/=255,E[2]/=255,l(n,t,o,i,E),e/=2),"heatmap"===s.type&&c.inverted&&(n=T.len-n,t=A.len-t,o=-o,i=-i),l(n+e,t+e,o-2*e,i-2*e,Y))});else{for(d=function(){if(void 0===(M=z[++X]))return"continue";if(I)return"break";var i,e=u&&u[X];return!P&&le(e,!0)&&e.color&&((Y=ae(e.color).rgba)[0]/=255,Y[1]/=255,Y[2]/=255),P?(k=M[0],B=M[1],z[X+1]&&(F=z[X+1][0]),z[X-1]&&(O=z[X-1][0]),3<=M.length&&(w=M[2],M[2]>o.zMax&&(o.zMax=M[2]),M[2]<o.zMin&&(o.zMin=M[2]))):(k=M,B=v[X],z[X+1]&&(F=z[X+1]),z[X-1]&&(O=z[X-1]),y&&y.length&&(w=y[X],y[X]>o.zMax&&(o.zMax=y[X]),y[X]<o.zMin&&(o.zMin=y[X]))),S||null!==k&&null!==B?(F&&p<=F&&F<=g&&(V=!0),O&&p<=O&&O<=g&&(W=!0),r?(P&&(B=M.slice(1,3)),R=B[0],B=B[1]):f&&(k=M.x,B=M.stackY,R=B-M.y),null!=b&&null!=m&&(Z=b<=B&&B<=m),g<k&&G.x<g&&(G.x=k,G.y=B),k<p&&_.x>p&&(_.x=k,_.y=B),null===B&&S?"continue":null!==B&&(Z||V||W)?(q=(p<=F||p<=k)&&(O<=g||k<=g)||q)||V||W?(te&&te<k-O&&t(),Q&&(Q.some(function(e,t){var o=Q[t-1];return"x"===J?void 0!==e.value&&k<=e.value&&(D[t]&&(!o||k>=o.value)&&(i=D[t]),!0):void 0!==e.value&&B<=e.value&&(D[t]&&(!o||B>=o.value)&&(i=D[t]),!0)}),Y=i||$||Y),!se.useGPUTranslations&&(o.skipTranslation=!0,k=T.toPixels(k,!0),B=A.toPixels(B,!0),C<k&&"points"===o.drawMode)?"continue":(o.hasMarkers&&q&&!1!==U&&(s.closestPointRangePx=Math.min(s.closestPointRangePx,Math.abs(k-U))),!se.useGPUTranslations&&!se.usePreallocated&&U&&Math.abs(k-U)<1&&L&&Math.abs(B-L)<1?(se.debug.showSkipSummary&&++j,"continue"):(H&&(!1!==(M=R)&&void 0!==R||(M=B<0?B:0),r||f||(M=Math.max(null===ee?b:ee,b)),se.useGPUTranslations||(M=A.toPixels(M,!0)),a(k,M,0,0,Y)),h.step&&!K&&a(k,L,0,2,Y),a(k,B,0,"bubble"===s.type?w||1:2,Y),U=k,L=B,void(K=!(N=!0))))):"continue":(t(),"continue")):(t(),"continue")};X<z.length-1&&"break"!==d(););se.debug.showSkipSummary&&console.log("skipped points:",j),N||!1===S||"line_strip"!==s.drawMode||(_.x<Number.MAX_VALUE&&i(_,!0),G.x>-Number.MAX_VALUE&&i(G))}e()}}(e,t),se.debug.timeSeriesProcessing&&console.timeEnd("building "+e.type+" series")},setSize:function(e,t){s===e&&a===t||!u||(s=e,a=t,u.bind(),u.setPMatrix([2/s,0,0,0,0,-2/a,0,0,0,0,-2,0,-1,1,-1,1]))},inited:function(){return p},setThreshold:f,init:function(e,t){function o(e,t){var o={isReady:!1,texture:T.createElement("canvas"),handle:d.createTexture()},i=o.texture.getContext("2d");(b[e]=o).texture.width=512,o.texture.height=512,i.mozImageSmoothingEnabled=!1,i.webkitImageSmoothingEnabled=!1,i.msImageSmoothingEnabled=!1,i.imageSmoothingEnabled=!1,i.strokeStyle="rgba(255, 255, 255, 0)",i.fillStyle="#FFF",t(i);try{d.activeTexture(d.TEXTURE0),d.bindTexture(d.TEXTURE_2D,o.handle),d.texImage2D(d.TEXTURE_2D,0,d.RGBA,d.RGBA,d.UNSIGNED_BYTE,o.texture),d.texParameteri(d.TEXTURE_2D,d.TEXTURE_WRAP_S,d.CLAMP_TO_EDGE),d.texParameteri(d.TEXTURE_2D,d.TEXTURE_WRAP_T,d.CLAMP_TO_EDGE),d.texParameteri(d.TEXTURE_2D,d.TEXTURE_MAG_FILTER,d.LINEAR),d.texParameteri(d.TEXTURE_2D,d.TEXTURE_MIN_FILTER,d.LINEAR),d.bindTexture(d.TEXTURE_2D,null),o.isReady=!0}catch(e){}}var i=0,r=["webgl","experimental-webgl","moz-webgl","webkit-3d"];if(p=!1,!e)return!1;for(se.debug.timeSetup&&console.time("gl setup");i<r.length&&!(d=e.getContext(r[i],{}));i++);return!!d&&(t||n(),d.enable(d.BLEND),d.blendFunc(d.SRC_ALPHA,d.ONE_MINUS_SRC_ALPHA),d.disable(d.DEPTH_TEST),d.depthFunc(d.LESS),!!(u=v(d))&&(oe=y(d,u),o("circle",function(e){e.beginPath(),e.arc(256,256,256,0,2*Math.PI),e.stroke(),e.fill()}),o("square",function(e){e.fillRect(0,0,512,512)}),o("diamond",function(e){e.beginPath(),e.moveTo(256,0),e.lineTo(512,256),e.lineTo(256,512),e.lineTo(0,256),e.lineTo(256,0),e.fill()}),o("triangle",function(e){e.beginPath(),e.moveTo(0,512),e.lineTo(256,0),e.lineTo(512,512),e.lineTo(0,512),e.fill()}),o("triangle-down",function(e){e.beginPath(),e.moveTo(0,0),e.lineTo(256,512),e.lineTo(512,0),e.lineTo(0,0),e.fill()}),p=!0,se.debug.timeSetup&&console.timeEnd("gl setup"),!0))},render:function e(t){if(i(),t.renderer.forExport)return r(t);p?r(t):setTimeout(function(){e(t)},1)},settings:se,valid:function(){return!1!==d},clear:i,flush:n,setXAxis:c,setYAxis:h,data:re,gl:function(){return d},allocateBuffer:function(e){var t=0;se.usePreallocated&&(e.series.forEach(function(e){e.isSeriesBoosting&&(t+=o(e))}),oe.allocate(t))},destroy:function(){n(),oe.destroy(),u.destroy(),d&&(S(b,function(e){e.handle&&d.deleteTexture(e.handle)}),d.canvas.width=1,d.canvas.height=1)},setOptions:function(e){P(!0,se,e)}}}}),t(e,"Extensions/Boost/BoostAttach.js",[e["Core/Chart/Chart.js"],e["Extensions/Boost/WGLRenderer.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(s,a,e,t){var l,c=e.doc,h=t.error;return function(e,t){var o=e.chartWidth,i=e.chartHeight,r=e,n=e.seriesGroup||t.group,r=(c.implementation.hasFeature("www.http://w3.org/TR/SVG11/feature#Extensibility","1.1"),e.isChartSeriesBoosting()?e:t);return l=l||c.createElement("canvas"),r.renderTarget||(r.canvas=l,e.renderer.forExport,r.renderTarget=e.renderer.image("",0,0,o,i).addClass("highcharts-boost-canvas").add(n),r.boostClear=function(){r.renderTarget.attr({href:""})},r.boostCopy=function(){r.boostResizeTarget(),r.renderTarget.attr({href:r.canvas.toDataURL("image/png")})},r.boostResizeTarget=function(){o=e.chartWidth,i=e.chartHeight,(r.renderTargetFo||r.renderTarget).attr({x:0,y:0,width:o,height:i}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1}),r instanceof s&&r.markerGroup.translate(e.plotLeft,e.plotTop)},r.boostClipRect=e.renderer.clipRect(),(r.renderTargetFo||r.renderTarget).clip(r.boostClipRect),r instanceof s&&(r.markerGroup=r.renderer.g().add(n),r.markerGroup.translate(t.xAxis.pos,t.yAxis.pos))),r.canvas.width=o,r.canvas.height=i,r.boostClipRect.attr(e.getBoostClipRect(r)),r.boostResizeTarget(),r.boostClear(),r.ogl||(r.ogl=a(function(){r.ogl.settings.debug.timeBufferCopy&&console.time("buffer copy"),r.boostCopy(),r.ogl.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),r.ogl.init(r.canvas)||h("[highcharts boost] - unable to init WebGL renderer"),r.ogl.setOptions(e.options.boost||{}),r instanceof s&&r.ogl.allocateBuffer(e)),r.ogl.setSize(o,i),r.ogl}}),t(e,"Extensions/Boost/BoostUtils.js",[e["Core/Globals.js"],e["Extensions/Boost/BoostableMap.js"],e["Extensions/Boost/BoostAttach.js"],e["Core/Utilities.js"]],function(e,s,o,t){function a(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var o=-Number.MAX_VALUE;return e.forEach(function(e){if(null!=e&&void 0!==e.length&&0<e.length)return o=e.length,!0}),o}function i(e,t,o){e&&t.renderTarget&&t.canvas&&!(o||t.chart).isChartSeriesBoosting()&&e.render(o||t.chart)}function r(e,t){e&&t.renderTarget&&t.canvas&&!t.chart.isChartSeriesBoosting()&&e.allocateBufferForSingleSeries(t)}function n(){var e,t=0,o=["webgl","experimental-webgl","moz-webgl","webkit-3d"];if(void 0!==c.WebGLRenderingContext)for(e=l.createElement("canvas");t<o.length;t++)try{if(null!=e.getContext(o[t]))return!0}catch(e){}return!1}var c=e.win,l=e.doc,h=t.pick;return t={patientMax:a,boostEnabled:function(e){return h(e&&e.options&&e.options.boost&&e.options.boost.enabled,!0)},shouldForceChartSeriesBoosting:function(e){var t=0,o=0,i=h(e.options.boost&&e.options.boost.allowForce,!0);if(void 0!==e.boostForceChartBoost)return e.boostForceChartBoost;if(1<e.series.length)for(var r=0;r<e.series.length;r++){var n=e.series[r];0!==n.options.boostThreshold&&!1!==n.visible&&"heatmap"!==n.type&&(s[n.type]&&++o,a(n.processedXData,n.options.data,n.points)>=(n.options.boostThreshold||Number.MAX_VALUE)&&++t)}return e.boostForceChartBoost=i&&(o===e.series.length&&0<t||5<t),e.boostForceChartBoost},renderIfNotSeriesBoosting:i,allocateIfNotSeriesBoosting:r,eachAsync:function e(t,o,i,r,n,s){for(var a=(n=n||0)+(r=r||3e3),l=!0;l&&n<a&&n<t.length;)l=o(t[n],n),++n;l&&(n<t.length?s?e(t,o,i,r,n,s):c.requestAnimationFrame?c.requestAnimationFrame(function(){e(t,o,i,r,n)}):setTimeout(function(){e(t,o,i,r,n)}):i&&i())},hasWebGLSupport:n,pointDrawHandler:function(e){var t=!0;if(!(t=this.chart.options&&this.chart.options.boost?void 0===this.chart.options.boost.enabled||this.chart.options.boost.enabled:t)||!this.isSeriesBoosting)return e.call(this);this.chart.isBoosting=!0,(e=o(this.chart,this))&&(r(e,this),e.pushSeries(this)),i(e,this)}},e.hasWebGLSupport=n,t}),t(e,"Extensions/Boost/BoostInit.js",[e["Core/Chart/Chart.js"],e["Core/Globals.js"],e["Core/Series/Series.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Extensions/Boost/BoostUtils.js"],e["Extensions/Boost/BoostAttach.js"]],function(e,t,o,i,r,n,D){var U,L=t.noop,s=i.seriesTypes,a=r.addEvent,l=r.extend,z=r.fireEvent,c=r.wrap,_=n.eachAsync,h=n.pointDrawHandler,G=n.allocateIfNotSeriesBoosting,j=n.renderIfNotSeriesBoosting,f=n.shouldForceChartSeriesBoosting;return function(){l(o.prototype,{renderCanvas:function(){var a,l,c,h,f,e=this,t=e.options||{},o=!1,u=e.chart,d=this.xAxis,p=this.yAxis,i=t.xData||e.processedXData,g=t.yData||e.processedYData,r=t.data,b=(o=d.getExtremes()).min,m=o.max,x=(o=p.getExtremes()).min,v=o.max,n={},y=!!e.sampling,s=!1!==t.enableMouseTracking,A=p.getThreshold(t.threshold),T=e.pointArrayMap&&"low,high"===e.pointArrayMap.join(","),C=!!t.stacking,P=e.cropStart||0,S=e.requireSorting,E=!i,k="x"===t.findNearestPointBy,B=this.xData||this.options.xData||this.processedXData||!1,M=function(e,t,o){e=Math.ceil(e),U=k?e:e+","+t,s&&!n[U]&&(n[U]=!0,u.inverted&&(e=d.len-e,t=p.len-t),w.push({x:!!B&&B[P+o],clientX:e,plotX:e,plotY:t,i:P+o}))};o=D(u,e),u.isBoosting=!0;var w,R=o.settings;this.visible&&((this.points||this.graph)&&this.destroyGraphics(),u.isChartSeriesBoosting()?(this.markerGroup&&this.markerGroup!==u.markerGroup&&this.markerGroup.destroy(),this.markerGroup=u.markerGroup,this.renderTarget&&(this.renderTarget=this.renderTarget.destroy())):(this.markerGroup===u.markerGroup&&(this.markerGroup=void 0),this.markerGroup=e.plotGroup("markerGroup","markers",!0,1,u.seriesGroup)),w=this.points=[],e.buildKDTree=L,o&&(G(o,this),o.pushSeries(e),j(o,this,u)),u.renderer.forExport||(R.debug.timeKDTree&&console.time("kd tree building"),_(C?e.data:i||r,function(e,t){var o,i,r=!1,n=void 0===u.index,s=!0;return void 0===e||(n||(i=E?(o=e[0],e[1]):(o=e,g[t]),T?(r=(i=E?e.slice(1,3):i)[0],i=i[1]):C&&(o=e.x,r=(i=e.stackY)-e.y),S||(s=x<=i&&i<=v),null!==i&&b<=o&&o<=m&&s&&(e=d.toPixels(o,!0),y?(void 0!==h&&e!==a||(T||(r=i),(void 0===f||c<i)&&(c=i,f=t),(void 0===h||r<l)&&(l=r,h=t)),e!==a&&(void 0!==h&&(i=p.toPixels(c,!0),A=p.toPixels(l,!0),M(e,i,f),A!==i&&M(e,A,h)),h=f=void 0,a=e)):(i=Math.ceil(p.toPixels(i,!0)),M(e,i,t)))),!n)},function(){z(e,"renderedCanvas"),delete e.buildKDTree,e.buildKDTree(),R.debug.timeKDTree&&console.timeEnd("kd tree building")})))}}),["heatmap","treemap"].forEach(function(e){s[e]&&c(s[e].prototype,"drawPoints",h)}),s.bubble&&(delete s.bubble.prototype.buildKDTree,c(s.bubble.prototype,"markerAttribs",function(e){return!this.isSeriesBoosting&&e.apply(this,[].slice.call(arguments,1))})),s.scatter.prototype.fill=!0,l(s.area.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),l(s.column.prototype,{fill:!0,sampling:!0}),e.prototype.propsRequireUpdateSeries.push("boost"),e.prototype.callbacks.push(function(o){a(o,"predraw",function(){o.boostForceChartBoost=void 0,o.boostForceChartBoost=f(o),o.isBoosting=!1,!o.isChartSeriesBoosting()&&o.didBoost&&(o.didBoost=!1),o.boostClear&&o.boostClear(),o.canvas&&o.ogl&&o.isChartSeriesBoosting()&&(o.didBoost=!0,o.ogl.allocateBuffer(o)),o.markerGroup&&o.xAxis&&0<o.xAxis.length&&o.yAxis&&0<o.yAxis.length&&o.markerGroup.translate(o.xAxis[0].pos,o.yAxis[0].pos)}),a(o,"render",function(){o.ogl&&o.isChartSeriesBoosting()&&o.ogl.render(o)});var i=-1,r=-1;a(o.pointer,"afterGetHoverData",function(){var e,t=o.hoverSeries;o.markerGroup&&t&&(e=o.inverted?t.yAxis:t.xAxis,t=o.inverted?t.xAxis:t.yAxis,(e&&e.pos!==i||t&&t.pos!==r)&&(o.markerGroup.translate(e.pos,t.pos),i=e.pos,r=t.pos))})})}}),t(e,"Extensions/BoostCanvas.js",[e["Core/Chart/Chart.js"],e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Color/Palette.js"],e["Core/Series/Series.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,K,J,Q,t,o,$){var ee,te=K.parse,a=J.doc,oe=J.noop,i=o.seriesTypes,ie=$.addEvent,re=$.extend,ne=$.fireEvent,se=$.isNumber,ae=$.merge,le=$.pick,l=$.wrap;return function(){J.seriesTypes.heatmap&&l(J.seriesTypes.heatmap.prototype,"drawPoints",function(){var n=this.chart,s=this.getContext(),a=this.chart.inverted,l=this.xAxis,c=this.yAxis;s?(this.points.forEach(function(e){var t,o,i,r=e.plotY;void 0!==r&&!isNaN(r)&&null!==e.y&&s&&(r=void 0===(r=(i=e.shapeArgs||{}).x)?0:r,t=void 0===(t=i.y)?0:t,o=void 0===(o=i.width)?0:o,i=void 0===(i=i.height)?0:i,e=n.styledMode?e.series.colorAttribs(e):e.series.pointAttribs(e),s.fillStyle=e.fill,a?s.fillRect(c.len-t+l.left,l.len-r+c.top,-i,-o):s.fillRect(r+l.left,t+c.top,o,i))}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")}),re(t.prototype,{getContext:function(){function t(e,t,o,i,r,n,s){e.call(this,o,t,i,r,n,s)}var e=this.chart,o=e.chartWidth,i=e.chartHeight,r=e.seriesGroup||this.group,n=this;e.isChartSeriesBoosting()&&(r=(n=e).seriesGroup);var s=n.ctx;return n.canvas||(n.canvas=a.createElement("canvas"),n.renderTarget=e.renderer.image("",0,0,o,i).addClass("highcharts-boost-canvas").add(r),n.ctx=s=n.canvas.getContext("2d"),e.inverted&&["moveTo","lineTo","rect","arc"].forEach(function(e){l(s,e,t)}),n.boostCopy=function(){n.renderTarget.attr({href:n.canvas.toDataURL("image/png")})},n.boostClear=function(){s.clearRect(0,0,n.canvas.width,n.canvas.height),n===this&&n.renderTarget.attr({href:""})},n.boostClipRect=e.renderer.clipRect(),n.renderTarget.clip(n.boostClipRect)),n.canvas.width!==o&&(n.canvas.width=o),n.canvas.height!==i&&(n.canvas.height=i),n.renderTarget.attr({x:0,y:0,width:o,height:i,style:"pointer-events: none",href:""}),n.boostClipRect.attr(e.getBoostClipRect(n)),s},canvasToSVG:function(){this.chart.isChartSeriesBoosting()?this.boostClear&&this.boostClear():(this.boostCopy||this.chart.boostCopy)&&(this.boostCopy||this.chart.boostCopy)()},cvsLineTo:function(e,t,o){e.lineTo(t,o)},renderCanvas:function(){var f,r,u=this,e=u.options,d=u.chart,p=this.xAxis,g=this.yAxis,o=(d.options.boost||{}).timeRendering||!1,n=0,t=u.processedXData,b=u.processedYData,i=e.data,s=p.getExtremes(),m=s.min,x=s.max,v=(s=g.getExtremes()).min,y=s.max,a={},A=!!u.sampling,l=e.marker&&e.marker.radius,c=this.cvsDrawPoint,h=e.lineWidth?this.cvsLineTo:void 0,T=l&&l<=1?this.cvsMarkerSquare:this.cvsMarkerCircle,C=this.cvsStrokeBatch||1e3,P=!1!==e.enableMouseTracking;s=e.threshold;var S=g.getThreshold(s),E=se(s),k=S,B=this.fill,M=u.pointArrayMap&&"low,high"===u.pointArrayMap.join(","),w=!!e.stacking,R=u.cropStart||0;s=d.options.loading;function D(){B?(Z.fillStyle=W,Z.fill()):(Z.strokeStyle=u.color,Z.lineWidth=e.lineWidth,Z.stroke())}function U(e,t,o,i){0===n&&(Z.beginPath(),h&&(Z.lineJoin="round")),d.scroller&&"highcharts-navigator-series"===u.options.className?(t+=d.scroller.top,o&&(o+=d.scroller.top)):t+=d.plotTop,e+=d.plotLeft,z?Z.moveTo(e,t):c?c(Z,e,t,o,r):h?h(Z,e,t):T&&T.call(u,Z,e,t,l,i),(n+=1)===C&&(D(),n=0),r={clientX:e,plotY:t,yBottom:o}}function L(e,t,o){X=Y?e:e+","+t,P&&!a[X]&&(a[X]=!0,d.inverted&&(e=p.len-e,t=g.len-t),q.push({x:!!H&&H[R+o],clientX:e,plotX:e,plotY:t,i:R+o}))}var z,_,G,j,N,X,O=u.requireSorting,F=e.connectNulls,I=!t,V=w?u.data:t||i,W=u.fillOpacity?new K(u.color).setOpacity(le(e.fillOpacity,.75)).get():u.color,Y="x"===e.findNearestPointBy,H=this.xData||this.options.xData||this.processedXData||!1;this.renderTarget&&this.renderTarget.attr({href:""}),(this.points||this.graph)&&this.destroyGraphics(),u.plotGroup("group","series",u.visible?"visible":"hidden",e.zIndex,d.seriesGroup),u.markerGroup=u.group,ie(u,"destroy",function(){u.markerGroup=null});var q=this.points=[],Z=this.getContext();u.buildKDTree=oe,this.boostClear&&this.boostClear(),this.visible&&(99999<i.length&&(d.options.loading=ae(s,{labelStyle:{backgroundColor:te(Q.backgroundColor).setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),$.clearTimeout(ee),d.showLoading("Drawing..."),d.options.loading=s),o&&console.time("canvas rendering"),J.eachAsync(V,function(e,t){var o,i,r,n=!1,s=!1,a=!1,l=!1,c=void 0===d.index,h=!0;return c||(I?(o=e[0],r=e[1],V[t+1]&&(a=V[t+1][0]),V[t-1]&&(l=V[t-1][0])):(o=e,r=b[t],V[t+1]&&(a=V[t+1]),V[t-1]&&(l=V[t-1])),a&&m<=a&&a<=x&&(n=!0),l&&m<=l&&l<=x&&(s=!0),M?(i=(r=I?e.slice(1,3):r)[0],r=r[1]):w&&(o=e.x,i=(r=e.stackY)-e.y),O||(h=v<=r&&r<=y),!(e=null===r)&&(m<=o&&o<=x&&h||n||s)&&(o=Math.round(p.toPixels(o,!0)),A?(void 0!==j&&o!==f||(M||(i=r),(void 0===N||G<r)&&(G=r,N=t),(void 0===j||i<_)&&(_=i,j=t)),o!==f&&(void 0!==j&&(r=g.toPixels(G,!0),S=g.toPixels(_,!0),U(o,E?Math.min(r,k):r,E?Math.max(S,k):S,t),L(o,r,N),S!==r&&L(o,S,j)),j=N=void 0,f=o)):(r=Math.round(g.toPixels(r,!0)),U(o,r,S,t),L(o,r,t))),z=e&&!F,0==t%5e4&&(u.boostCopy||u.chart.boostCopy)&&(u.boostCopy||u.chart.boostCopy)()),!c},function(){var e=d.loadingDiv,t=d.loadingShown;D(),u.canvasToSVG(),o&&console.timeEnd("canvas rendering"),ne(u,"renderedCanvas"),t&&(re(e.style,{transition:"opacity 250ms",opacity:0}),d.loadingShown=!1,ee=setTimeout(function(){e.parentNode&&e.parentNode.removeChild(e),d.loadingDiv=d.loadingSpan=null},250)),delete u.buildKDTree,u.buildKDTree()},d.renderer.forExport?Number.MAX_VALUE:void 0))}}),i.scatter.prototype.cvsMarkerCircle=function(e,t,o,i){e.moveTo(t,o),e.arc(t,o,i,0,2*Math.PI,!1)},i.scatter.prototype.cvsMarkerSquare=function(e,t,o,i){e.rect(t-i,o-i,2*i,2*i)},i.scatter.prototype.fill=!0,i.bubble&&(i.bubble.prototype.cvsMarkerCircle=function(e,t,o,i,r){e.moveTo(t,o),e.arc(t,o,this.radii&&this.radii[r],0,2*Math.PI,!1)},i.bubble.prototype.cvsStrokeBatch=1),re(i.area.prototype,{cvsDrawPoint:function(e,t,o,i,r){r&&t!==r.clientX&&(e.moveTo(r.clientX,r.yBottom),e.lineTo(r.clientX,r.plotY),e.lineTo(t,o),e.lineTo(t,i))},fill:!0,fillOpacity:!0,sampling:!0}),re(i.column.prototype,{cvsDrawPoint:function(e,t,o,i){e.rect(t-1,o,1,i-o)},fill:!0,sampling:!0}),e.prototype.callbacks.push(function(e){ie(e,"predraw",function(){e.renderTarget&&e.renderTarget.attr({href:""}),e.canvas&&e.canvas.getContext("2d").clearRect(0,0,e.canvas.width,e.canvas.height)}),ie(e,"render",function(){e.boostCopy&&e.boostCopy()})})}}),t(e,"Extensions/Boost/BoostOverrides.js",[e["Core/Chart/Chart.js"],e["Core/DefaultOptions.js"],e["Core/Series/Point.js"],e["Core/Series/Series.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Extensions/Boost/BoostUtils.js"],e["Extensions/Boost/Boostables.js"],e["Extensions/Boost/BoostableMap.js"]],function(e,t,o,i,r,n,s,a,l){t=t.getOptions;var c=r.seriesTypes;r=n.addEvent;var h=n.error,f=n.isArray,u=n.isNumber,d=n.pick,p=n.wrap,g=s.boostEnabled,b=s.shouldForceChartSeriesBoosting,m=t().plotOptions;e.prototype.isChartSeriesBoosting=function(){return d(this.options.boost&&this.options.boost.seriesThreshold,50)<=this.series.length||b(this)},e.prototype.getBoostClipRect=function(e){var t={x:this.plotLeft,y:this.plotTop,width:this.plotWidth,height:this.plotHeight};return e===this&&((e=this.inverted?this.xAxis:this.yAxis).length<=1?(t.y=Math.min(e[0].pos,t.y),t.height=e[0].pos-this.plotTop+e[0].len):t.height=this.plotHeight),t},i.prototype.getPoint=function(e){var t=e,o=this.xData||this.options.xData||this.processedXData||!1;return!e||e instanceof this.pointClass||((t=(new this.pointClass).init(this,this.options.data[e.i],o?o[e.i]:void 0)).category=d(this.xAxis.categories?this.xAxis.categories[t.x]:t.x,t.x),t.dist=e.dist,t.distX=e.distX,t.plotX=e.plotX,t.plotY=e.plotY,t.index=e.i,t.isInside=this.isPointInside(e)),t},p(i.prototype,"searchPoint",function(e){return this.getPoint(e.apply(this,[].slice.call(arguments,1)))}),p(o.prototype,"haloPath",function(e){var t=this.series,o=this.plotX,i=this.plotY,r=t.chart.inverted;t.isSeriesBoosting&&r&&(this.plotX=t.yAxis.len-i,this.plotY=t.xAxis.len-o);e=e.apply(this,Array.prototype.slice.call(arguments,1));return t.isSeriesBoosting&&r&&(this.plotX=o,this.plotY=i),e}),p(i.prototype,"markerAttribs",function(e,t){var o=t.plotX,i=t.plotY,r=this.chart.inverted;this.isSeriesBoosting&&r&&(t.plotX=this.yAxis.len-i,t.plotY=this.xAxis.len-o);e=e.apply(this,Array.prototype.slice.call(arguments,1));return this.isSeriesBoosting&&r&&(t.plotX=o,t.plotY=i),e}),r(i,"destroy",function(){var t=this,e=t.chart;e.markerGroup===t.markerGroup&&(t.markerGroup=null),e.hoverPoints&&(e.hoverPoints=e.hoverPoints.filter(function(e){return e.series===t})),e.hoverPoint&&e.hoverPoint.series===t&&(e.hoverPoint=null)}),p(i.prototype,"getExtremes",function(e){return this.isSeriesBoosting&&this.hasExtremes&&this.hasExtremes()?{}:e.apply(this,Array.prototype.slice.call(arguments,1))}),["translate","generatePoints","drawTracker","drawPoints","render"].forEach(function(o){function t(e){var t=this.options.stacking&&("translate"===o||"generatePoints"===o);this.isSeriesBoosting&&!t&&g(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&l[this.type]&&0!==this.options.boostThreshold?this[o+"Canvas"]&&this[o+"Canvas"]():e.call(this)}p(i.prototype,o,t),"translate"===o&&"column bar arearange columnrange heatmap treemap".split(" ").forEach(function(e){c[e]&&p(c[e].prototype,o,t)})}),p(i.prototype,"processData",function(e){function t(e){return o.chart.isChartSeriesBoosting()||(e?e.length:0)>=(o.options.boostThreshold||Number.MAX_VALUE)}var o=this,i=this.options.data;g(this.chart)&&l[this.type]?(t(i)&&"heatmap"!==this.type&&"treemap"!==this.type&&!this.options.stacking&&this.hasExtremes&&this.hasExtremes(!0)||(e.apply(this,Array.prototype.slice.call(arguments,1)),i=this.processedXData),(this.isSeriesBoosting=t(i))?(this.options.data&&this.options.data.length&&(i=this.getFirstValidPoint(this.options.data),u(i)||f(i)||h(12,!1,this.chart)),this.enterBoost()):this.exitBoost&&this.exitBoost()):e.apply(this,Array.prototype.slice.call(arguments,1))}),r(i,"hide",function(){this.canvas&&this.renderTarget&&(this.ogl&&this.ogl.clear(),this.boostClear())}),i.prototype.enterBoost=function(){this.alteredByBoost=[],["allowDG","directTouch","stickyTracking"].forEach(function(e){this.alteredByBoost.push({prop:e,val:this[e],own:Object.hasOwnProperty.call(this,e)})},this),this.directTouch=this.allowDG=!1,this.finishedAnimating=this.stickyTracking=!0,this.labelBySeries&&(this.labelBySeries=this.labelBySeries.destroy())},i.prototype.exitBoost=function(){(this.alteredByBoost||[]).forEach(function(e){e.own?this[e.prop]=e.val:delete this[e.prop]},this),this.boostClear&&this.boostClear()},i.prototype.hasExtremes=function(e){var t=this.options,o=this.xAxis&&this.xAxis.options,i=this.yAxis&&this.yAxis.options,r=this.colorAxis&&this.colorAxis.options;return t.data.length>(t.boostThreshold||Number.MAX_VALUE)&&u(i.min)&&u(i.max)&&(!e||u(o.min)&&u(o.max))&&(!r||u(r.min)&&u(r.max))},i.prototype.destroyGraphics=function(){var e,t,o=this,i=this,r=this.points;if(r)for(t=0;t<r.length;t+=1)(e=r[t])&&e.destroyElements&&e.destroyElements();["graph","area","tracker"].forEach(function(e){i[e]&&(i[e]=i[e].destroy())}),this.getZonesGraphs&&this.getZonesGraphs([["graph","highcharts-graph"]]).forEach(function(e){var t=o[e[0]];t&&(o[e[0]]=t.destroy())})},a.forEach(function(e){m[e]&&(m[e].boostThreshold=5e3,m[e].boostData=[],c[e].prototype.fillOpacity=!0)})}),t(e,"Extensions/Boost/NamedColors.js",[e["Core/Color/Color.js"]],function(e){return e.names={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",feldspar:"#d19275",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslateblue:"#8470ff",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",violetred:"#d02090",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"}}),t(e,"Extensions/Boost/Boost.js",[e["Extensions/Boost/BoostUtils.js"],e["Extensions/Boost/BoostInit.js"],e["Extensions/BoostCanvas.js"],e["Core/Utilities.js"]],function(e,t,o,i){i=i.error,(e=e.hasWebGLSupport)()?t():void 0!==o?o():i(26)}),t(e,"masters/modules/boost.src.js",[],function(){})});