/*
 Highcharts Gantt JS v9.1.2 (2021-06-16)

 Gantt series

 (c) 2016-2021 Lars A. V. Cabrera

 License: www.highcharts.com/license
*/
'use strict';(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/modules/gantt",["highcharts"],function(I){c(I);c.Highcharts=I;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function I(c,q,v,t){c.hasOwnProperty(q)||(c[q]=t.apply(null,v))}c=c?c._modules:{};I(c,"Series/XRange/XRangePoint.js",[c["Core/Series/Point.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],
function(c,q,v){var t=this&&this.__extends||function(){var c=function(r,l){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(l,e){l.__proto__=e}||function(l,e){for(var h in e)e.hasOwnProperty(h)&&(l[h]=e[h])};return c(r,l)};return function(r,l){function y(){this.constructor=r}c(r,l);r.prototype=null===l?Object.create(l):(y.prototype=l.prototype,new y)}}();v=v.extend;q=function(q){function r(){var l=null!==q&&q.apply(this,arguments)||this;l.options=void 0;l.series=void 0;return l}t(r,
q);r.getColorByCategory=function(l,c){var e=l.options.colors||l.chart.options.colors;l=c.y%(e?e.length:l.chart.options.chart.colorCount);return{colorIndex:l,color:e&&e[l]}};r.prototype.resolveColor=function(){var l=this.series;if(l.options.colorByPoint&&!this.options.color){var c=r.getColorByCategory(l,this);l.chart.styledMode||(this.color=c.color);this.options.colorIndex||(this.colorIndex=c.colorIndex)}else this.color||(this.color=l.color)};r.prototype.init=function(){c.prototype.init.apply(this,
arguments);this.y||(this.y=0);return this};r.prototype.setState=function(){c.prototype.setState.apply(this,arguments);this.series.drawPoint(this,this.series.getAnimationVerb())};r.prototype.getLabelConfig=function(){var l=c.prototype.getLabelConfig.call(this),r=this.series.yAxis.categories;l.x2=this.x2;l.yCategory=this.yCategory=r&&r[this.y];return l};r.prototype.isValid=function(){return"number"===typeof this.x&&"number"===typeof this.x2};return r}(q.seriesTypes.column.prototype.pointClass);v(q.prototype,
{tooltipDateKeys:["x","x2"]});return q});I(c,"Series/XRange/XRangeComposition.js",[c["Core/Axis/Axis.js"],c["Core/Utilities.js"]],function(c,q){var v=q.addEvent,t=q.pick;v(c,"afterGetSeriesExtremes",function(){var c=this.series,r;if(this.isXAxis){var l=t(this.dataMax,-Number.MAX_VALUE);c.forEach(function(c){c.x2Data&&c.x2Data.forEach(function(e){e>l&&(l=e,r=!0)})});r&&(this.dataMax=l)}})});I(c,"Series/XRange/XRangeSeries.js",[c["Core/Globals.js"],c["Core/Color/Color.js"],c["Core/Series/SeriesRegistry.js"],
c["Core/Utilities.js"],c["Series/XRange/XRangePoint.js"]],function(c,q,v,t,A){var r=this&&this.__extends||function(){var a=function(b,g){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var g in b)b.hasOwnProperty(g)&&(a[g]=b[g])};return a(b,g)};return function(b,g){function H(){this.constructor=b}a(b,g);b.prototype=null===g?Object.create(g):(H.prototype=g.prototype,new H)}}(),l=q.parse,y=v.series,e=v.seriesTypes.column,h=e.prototype,d=t.clamp,
k=t.correctFloat,F=t.defined;q=t.extend;var J=t.find,E=t.isNumber,b=t.isObject,a=t.merge,m=t.pick;t=function(B){function G(){var b=null!==B&&B.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}r(G,B);G.prototype.init=function(){e.prototype.init.apply(this,arguments);this.options.stacking=void 0};G.prototype.getColumnMetrics=function(){function b(){a.series.forEach(function(b){var a=b.xAxis;b.xAxis=b.yAxis;b.yAxis=a})}var a=this.chart;b();var D=h.getColumnMetrics.call(this);
b();return D};G.prototype.cropData=function(b,a,D,m){a=y.prototype.cropData.call(this,this.x2Data,a,D,m);a.xData=b.slice(a.start,a.end);return a};G.prototype.findPointIndex=function(b){var a=this.cropped,g=this.cropStart,m=this.points,e=b.id;if(e)var d=(d=J(m,function(b){return b.id===e}))?d.index:void 0;"undefined"===typeof d&&(d=(d=J(m,function(a){return a.x===b.x&&a.x2===b.x2&&!a.touched}))?d.index:void 0);a&&E(d)&&E(g)&&d>=g&&(d-=g);return d};G.prototype.translatePoint=function(g){var H=this.xAxis,
D=this.yAxis,e=this.columnMetrics,k=this.options,h=k.minPointLength||0,w=(g.shapeArgs&&g.shapeArgs.width||0)/2,B=this.pointXOffset=e.offset,C=g.plotX,n=m(g.x2,g.x+(g.len||0)),z=H.translate(n,0,0,0,1);n=Math.abs(z-C);var u=this.chart.inverted,f=m(k.borderWidth,1)%2/2,p=e.offset,x=Math.round(e.width);h&&(h-=n,0>h&&(h=0),C-=h/2,z+=h/2);C=Math.max(C,-10);z=d(z,-10,H.len+10);F(g.options.pointWidth)&&(p-=(Math.ceil(g.options.pointWidth)-x)/2,x=Math.ceil(g.options.pointWidth));k.pointPlacement&&E(g.plotY)&&
D.categories&&(g.plotY=D.translate(g.y,0,1,0,1,k.pointPlacement));k={x:Math.floor(Math.min(C,z))+f,y:Math.floor(g.plotY+p)+f,width:Math.round(Math.abs(z-C)),height:x,r:this.options.borderRadius};g.shapeArgs=k;u?g.tooltipPos[1]+=B+w:g.tooltipPos[0]-=w+B-k.width/2;w=k.x;B=w+k.width;0>w||B>H.len?(w=d(w,0,H.len),B=d(B,0,H.len),h=B-w,g.dlBox=a(k,{x:w,width:B-w,centerX:h?h/2:null})):g.dlBox=null;w=g.tooltipPos;B=u?1:0;h=u?0:1;e=this.columnMetrics?this.columnMetrics.offset:-e.width/2;w[B]=u?w[B]+k.width/
2:w[B]+(H.reversed?-1:0)*k.width;w[h]=d(w[h]+(u?-1:1)*e,0,D.len-1);if(D=g.partialFill)b(D)&&(D=D.amount),E(D)||(D=0),g.partShapeArgs=a(k,{r:this.options.borderRadius}),C=Math.max(Math.round(n*D+g.plotX-C),0),g.clipRectArgs={x:H.reversed?k.x+n-C:k.x,y:k.y,width:C,height:k.height}};G.prototype.translate=function(){h.translate.apply(this,arguments);this.points.forEach(function(b){this.translatePoint(b)},this)};G.prototype.drawPoint=function(g,e){var D=this.options,H=this.chart.renderer,d=g.graphic,k=
g.shapeType,w=g.shapeArgs,h=g.partShapeArgs,C=g.clipRectArgs,n=g.partialFill,z=D.stacking&&!D.borderRadius,u=g.state,f=D.states[u||"normal"]||{},p="undefined"===typeof u?"attr":e;u=this.pointAttribs(g,u);f=m(this.chart.options.chart.animation,f.animation);if(g.isNull||!1===g.visible)d&&(g.graphic=d.destroy());else{if(d)d.rect[e](w);else g.graphic=d=H.g("point").addClass(g.getClassName()).add(g.group||this.group),d.rect=H[k](a(w)).addClass(g.getClassName()).addClass("highcharts-partfill-original").add(d);
h&&(d.partRect?(d.partRect[e](a(h)),d.partialClipRect[e](a(C))):(d.partialClipRect=H.clipRect(C.x,C.y,C.width,C.height),d.partRect=H[k](h).addClass("highcharts-partfill-overlay").add(d).clip(d.partialClipRect)));this.chart.styledMode||(d.rect[e](u,f).shadow(D.shadow,null,z),h&&(b(n)||(n={}),b(D.partialFill)&&(n=a(D.partialFill,n)),g=n.fill||l(u.fill).brighten(-.3).get()||l(g.color||this.color).brighten(-.3).get(),u.fill=g,d.partRect[p](u,f).shadow(D.shadow,null,z)))}};G.prototype.drawPoints=function(){var b=
this,a=b.getAnimationVerb();b.points.forEach(function(g){b.drawPoint(g,a)})};G.prototype.getAnimationVerb=function(){return this.chart.pointCount<(this.options.animationLimit||250)?"animate":"attr"};G.prototype.isPointInside=function(b){var a=b.shapeArgs,g=b.plotX,e=b.plotY;return a?"undefined"!==typeof g&&"undefined"!==typeof e&&0<=e&&e<=this.yAxis.len&&0<=(a.x||0)+(a.width||0)&&g<=this.xAxis.len:B.prototype.isPointInside.apply(this,arguments)};G.defaultOptions=a(e.defaultOptions,{colorByPoint:!0,
dataLabels:{formatter:function(){var a=this.point.partialFill;b(a)&&(a=a.amount);if(E(a)&&0<a)return k(100*a)+"%"},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:'<span style="font-size: 10px">{point.x} - {point.x2}</span><br/>',pointFormat:'<span style="color:{point.color}">\u25cf</span> {series.name}: <b>{point.yCategory}</b><br/>'},borderRadius:3,pointRange:0});return G}(e);q(t.prototype,{type:"xrange",parallelArrays:["x","x2","y"],requireSorting:!1,animate:y.prototype.animate,cropShoulder:1,
getExtremesFromAll:!0,autoIncrement:c.noop,buildKDTree:c.noop,pointClass:A});v.registerSeriesType("xrange",t);"";return t});I(c,"Series/Gantt/GanttPoint.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,q){var v=this&&this.__extends||function(){var c=function(r,l){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,e){c.__proto__=e}||function(c,e){for(var h in e)e.hasOwnProperty(h)&&(c[h]=e[h])};return c(r,l)};return function(r,l){function y(){this.constructor=
r}c(r,l);r.prototype=null===l?Object.create(l):(y.prototype=l.prototype,new y)}}(),t=q.pick;return function(c){function r(){var l=null!==c&&c.apply(this,arguments)||this;l.options=void 0;l.series=void 0;return l}v(r,c);r.setGanttPointAliases=function(c){function l(e,h){"undefined"!==typeof h&&(c[e]=h)}l("x",t(c.start,c.x));l("x2",t(c.end,c.x2));l("partialFill",t(c.completed,c.partialFill))};r.prototype.applyOptions=function(l,y){l=c.prototype.applyOptions.call(this,l,y);r.setGanttPointAliases(l);
return l};r.prototype.isValid=function(){return("number"===typeof this.start||"number"===typeof this.x)&&("number"===typeof this.end||"number"===typeof this.x2||this.milestone)};return r}(c.seriesTypes.xrange.prototype.pointClass)});I(c,"Core/Axis/BrokenAxis.js",[c["Core/Axis/Axis.js"],c["Core/Series/Series.js"],c["Extensions/Stacking.js"],c["Core/Utilities.js"]],function(c,q,v,t){var A=t.addEvent,r=t.find,l=t.fireEvent,y=t.isArray,e=t.isNumber,h=t.pick,d;(function(d){function k(){"undefined"!==typeof this.brokenAxis&&
this.brokenAxis.setBreaks(this.options.breaks,!1)}function J(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function E(){var b=this.brokenAxis;if(b&&b.hasBreaks){for(var a=this.tickPositions,g=this.tickPositions.info,e=[],d=0;d<a.length;d++)b.isInAnyBreak(a[d])||e.push(a[d]);this.tickPositions=e;this.tickPositions.info=g}}function b(){this.brokenAxis||(this.brokenAxis=new g(this))}function a(){var b=this.options.connectNulls,a=this.points,g=this.xAxis,e=this.yAxis;if(this.isDirty)for(var d=
a.length;d--;){var m=a[d],k=!(null===m.y&&!1===b)&&(g&&g.brokenAxis&&g.brokenAxis.isInAnyBreak(m.x,!0)||e&&e.brokenAxis&&e.brokenAxis.isInAnyBreak(m.y,!0));m.visible=k?!1:!1!==m.options.visible}}function m(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,h(this.pointArrayMap,["y"]))}function B(b,a){var g=this,d=g.points,m,D,k,C;if(b&&b.brokenAxis&&b.brokenAxis.hasBreaks){var n=b.brokenAxis;a.forEach(function(a){m=n&&n.breakArray||[];D=b.isXAxis?b.min:h(g.options.threshold,b.min);d.forEach(function(n){C=
h(n["stack"+a.toUpperCase()],n[a]);m.forEach(function(f){if(e(D)&&e(C)){k=!1;if(D<f.from&&C>f.to||D>f.from&&C<f.from)k="pointBreak";else if(D<f.from&&C>f.from&&C<f.to||D>f.from&&C>f.to&&C<f.from)k="pointInBreak";k&&l(b,k,{point:n,brk:f})}})})})}}function G(){var b=this.currentDataGrouping,a=b&&b.gapSize;b=this.points.slice();var g=this.yAxis,e=this.options.gapSize,d=b.length-1,m;if(e&&0<d)for("value"!==this.options.gapUnit&&(e*=this.basePointRange),a&&a>e&&a>=this.basePointRange&&(e=a),m=void 0;d--;)m&&
!1!==m.visible||(m=b[d+1]),a=b[d],!1!==m.visible&&!1!==a.visible&&(m.x-a.x>e&&(m=(a.x+m.x)/2,b.splice(d+1,0,{isNull:!0,x:m}),g.stacking&&this.options.stacking&&(m=g.stacking.stacks[this.stackKey][m]=new v(g,g.options.stackLabels,!1,m,this.stack),m.total=0)),m=a);return this.getGraphPath(b)}d.compose=function(g,e){if(-1===g.keepProps.indexOf("brokenAxis")){g.keepProps.push("brokenAxis");var d=q.prototype;d.drawBreaks=B;d.gappedPath=G;A(g,"init",b);A(g,"afterInit",k);A(g,"afterSetTickPositions",E);
A(g,"afterSetOptions",J);A(e,"afterGeneratePoints",a);A(e,"afterRender",m)}return g};var g=function(){function b(b){this.hasBreaks=!1;this.axis=b}b.isInBreak=function(b,a){var g=b.repeat||Infinity,e=b.from,m=b.to-b.from;a=a>=e?(a-e)%g:g-(e-a)%g;return b.inclusive?a<=m:a<m&&0!==a};b.lin2Val=function(a){var g=this.brokenAxis;g=g&&g.breakArray;if(!g||!e(a))return a;var m;for(m=0;m<g.length;m++){var d=g[m];if(d.from>=a)break;else d.to<a?a+=d.len:b.isInBreak(d,a)&&(a+=d.len)}return a};b.val2Lin=function(a){var g=
this.brokenAxis;g=g&&g.breakArray;if(!g||!e(a))return a;var m=a,d;for(d=0;d<g.length;d++){var k=g[d];if(k.to<=a)m-=k.len;else if(k.from>=a)break;else if(b.isInBreak(k,a)){m-=a-k.from;break}}return m};b.prototype.findBreakAt=function(b,a){return r(a,function(a){return a.from<b&&b<a.to})};b.prototype.isInAnyBreak=function(a,g){var m=this.axis,d=m.options.breaks||[],k=d.length,B;if(k&&e(a)){for(;k--;)if(b.isInBreak(d[k],a)){var C=!0;B||(B=h(d[k].showPoints,!m.isXAxis))}var n=C&&g?C&&!B:C}return n};b.prototype.setBreaks=
function(a,g){var m=this,d=m.axis,k=y(a)&&!!a.length;d.isDirty=m.hasBreaks!==k;m.hasBreaks=k;d.options.breaks=d.userOptions.breaks=a;d.forceRedraw=!0;d.series.forEach(function(a){a.isDirty=!0});k||d.val2lin!==b.val2Lin||(delete d.val2lin,delete d.lin2val);k&&(d.userOptions.ordinal=!1,d.lin2val=b.lin2Val,d.val2lin=b.val2Lin,d.setExtremes=function(a,b,n,d,u){if(m.hasBreaks){for(var f=this.options.breaks||[],p;p=m.findBreakAt(a,f);)a=p.to;for(;p=m.findBreakAt(b,f);)b=p.from;b<a&&(b=a)}c.prototype.setExtremes.call(this,
a,b,n,d,u)},d.setAxisTranslation=function(){c.prototype.setAxisTranslation.call(this);m.unitLength=void 0;if(m.hasBreaks){var a=d.options.breaks||[],g=[],n=[],z=h(d.pointRangePadding,0),u=0,f,p=d.userMin||d.min,x=d.userMax||d.max,L;a.forEach(function(a){f=a.repeat||Infinity;e(p)&&e(x)&&(b.isInBreak(a,p)&&(p+=a.to%f-p%f),b.isInBreak(a,x)&&(x-=x%f-a.from%f))});a.forEach(function(a){O=a.from;f=a.repeat||Infinity;if(e(p)&&e(x)){for(;O-f>p;)O-=f;for(;O<p;)O+=f;for(L=O;L<x;L+=f)g.push({value:L,move:"in"}),
g.push({value:L+a.to-a.from,move:"out",size:a.breakSize})}});g.sort(function(f,a){return f.value===a.value?("in"===f.move?0:1)-("in"===a.move?0:1):f.value-a.value});var P=0;var O=p;g.forEach(function(f){P+="in"===f.move?1:-1;1===P&&"in"===f.move&&(O=f.value);0===P&&e(O)&&(n.push({from:O,to:f.value,len:f.value-O-(f.size||0)}),u+=f.value-O-(f.size||0))});m.breakArray=n;e(p)&&e(x)&&e(d.min)&&(m.unitLength=x-p-u+z,l(d,"afterBreaks"),d.staticScale?d.transA=d.staticScale:m.unitLength&&(d.transA*=(x-d.min+
z)/m.unitLength),z&&(d.minPixelPadding=d.transA*(d.minPointOffset||0)),d.min=p,d.max=x)}});h(g,!0)&&d.chart.redraw()};return b}();d.Additions=g})(d||(d={}));return d});I(c,"Core/Axis/GridAxis.js",[c["Core/Axis/Axis.js"],c["Core/Axis/AxisDefaults.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,q,v,t){var A=v.dateFormats,r=t.addEvent,l=t.defined,y=t.erase,e=t.find,h=t.isArray,d=t.isNumber,k=t.merge,F=t.pick,J=t.timeUnits,E=t.wrap,b;(function(a){function b(f,a){var b={width:0,height:0};
a.forEach(function(a){a=f[a];if(t.isObject(a,!0)){var p=t.isObject(a.label,!0)?a.label:{};a=p.getBBox?p.getBBox().height:0;p.textStr&&!d(p.textPxLength)&&(p.textPxLength=p.getBBox().width);var n=d(p.textPxLength)?Math.round(p.textPxLength):0;p.textStr&&(n=Math.round(p.getBBox().width));b.height=Math.max(a,b.height);b.width=Math.max(n,b.width)}});"treegrid"===this.options.type&&this.treeGrid&&this.treeGrid.mapOfPosToGridNode&&(b.width+=this.options.labels.indentation*((this.treeGrid.mapOfPosToGridNode[-1].height||
0)-1));return b}function B(){var f=this.grid;(f&&f.columns||[]).forEach(function(f){f.getOffset()})}function G(f){if(!0===(this.options.grid||{}).enabled){var b=this.axisTitle,p=this.height,n=this.horiz,L=this.left,u=this.offset,x=this.opposite,g=this.options,d=this.top,m=this.width,z=this.tickSize(),e=b&&b.getBBox().width,k=g.title.x,C=g.title.y,h=F(g.title.margin,n?5:10);b=this.chart.renderer.fontMetrics(g.title.style.fontSize,b).f;z=(n?d+p:L)+(n?1:-1)*(x?-1:1)*(z?z[0]/2:0)+(this.side===a.Side.bottom?
b:0);f.titlePosition.x=n?L-(e||0)/2-h+k:z+(x?m:0)+u+k;f.titlePosition.y=n?z-(x?p:0)+(x?b:-b)/2+u+C:d-h+C}}function g(){var f=this.chart,a=this.options.grid;a=void 0===a?{}:a;var b=this.userOptions;if(a.enabled){var p=this.options;p.labels.align=F(p.labels.align,"center");this.categories||(p.showLastLabel=!1);this.labelRotation=0;p.labels.rotation=0}if(a.columns){p=this.grid.columns=[];for(var n=this.grid.columnIndex=0;++n<a.columns.length;){var u=k(b,a.columns[a.columns.length-n-1],{linkedTo:0,type:"category",
scrollbar:{enabled:!1}});delete u.grid.columns;u=new c(this.chart,u);u.grid.isColumn=!0;u.grid.columnIndex=n;y(f.axes,u);y(f[this.coll],u);p.push(u)}}}function H(){var f=this.grid,b=this.options;if(!0===(b.grid||{}).enabled){var p=this.min||0,n=this.max||0;this.maxLabelDimensions=this.getMaxLabelDimensions(this.ticks,this.tickPositions);this.rightWall&&this.rightWall.destroy();if(this.grid&&this.grid.isOuterAxis()&&this.axisLine){var u=b.lineWidth;if(u){u=this.getLinePath(u);var x=u[0],g=u[1],d=((this.tickSize("tick")||
[1])[0]-1)*(this.side===a.Side.top||this.side===a.Side.left?-1:1);"M"===x[0]&&"L"===g[0]&&(this.horiz?(x[2]+=d,g[2]+=d):(x[1]+=d,g[1]+=d));!this.horiz&&this.chart.marginRight&&(x=[x,["L",this.left,x[2]||0]],d=["L",this.chart.chartWidth-this.chart.marginRight,this.toPixels(n+this.tickmarkOffset)],g=[["M",g[1]||0,this.toPixels(n+this.tickmarkOffset)],d],this.grid.upperBorder||0===p%1||(this.grid.upperBorder=this.grid.renderBorder(x)),this.grid.upperBorder&&(this.grid.upperBorder.attr({stroke:b.lineColor,
"stroke-width":b.lineWidth}),this.grid.upperBorder.animate({d:x})),this.grid.lowerBorder||0===n%1||(this.grid.lowerBorder=this.grid.renderBorder(g)),this.grid.lowerBorder&&(this.grid.lowerBorder.attr({stroke:b.lineColor,"stroke-width":b.lineWidth}),this.grid.lowerBorder.animate({d:g})));this.grid.axisLineExtra?(this.grid.axisLineExtra.attr({stroke:b.lineColor,"stroke-width":b.lineWidth}),this.grid.axisLineExtra.animate({d:u})):this.grid.axisLineExtra=this.grid.renderBorder(u);this.axisLine[this.showAxis?
"show":"hide"](!0)}}(f&&f.columns||[]).forEach(function(f){f.render()});!this.horiz&&this.chart.hasRendered&&(this.scrollbar||this.linkedParent&&this.linkedParent.scrollbar)&&(f=this.tickmarkOffset,b=this.tickPositions[this.tickPositions.length-1],u=this.tickPositions[0],(g=this.ticks[u].label)&&(p-u>f?g.hide():g.show()),(g=this.ticks[b].label)&&(b-n>f?g.hide():g.show()),(p=this.ticks[b].mark)&&(b-n<f&&0<b-n&&this.ticks[b].isLast?p.hide():this.ticks[b-1]&&p.show()))}}function D(){var f=this.tickPositions&&
this.tickPositions.info,a=this.options,b=this.userOptions.labels||{};(a.grid||{}).enabled&&(this.horiz?(this.series.forEach(function(f){f.options.pointRange=0}),f&&a.dateTimeLabelFormats&&a.labels&&!l(b.align)&&(!1===a.dateTimeLabelFormats[f.unitName].range||1<f.count)&&(a.labels.align="left",l(b.x)||(a.labels.x=3))):"treegrid"!==this.options.type&&this.grid&&this.grid.columns&&(this.minPointOffset=this.tickInterval))}function A(f){var a=this.options;f=f.userOptions;var b=a&&t.isObject(a.grid,!0)?
a.grid:{};if(!0===b.enabled){var p=k(!0,{className:"highcharts-grid-axis "+(f.className||""),dateTimeLabelFormats:{hour:{list:["%H:%M","%H"]},day:{list:["%A, %e. %B","%a, %e. %b","%E"]},week:{list:["Week %W","W%W"]},month:{list:["%B","%b","%o"]}},grid:{borderWidth:1},labels:{padding:2,style:{fontSize:"13px"}},margin:0,title:{text:null,reserveSpace:!1,rotation:0},units:[["millisecond",[1,10,100]],["second",[1,10]],["minute",[1,5,15]],["hour",[1,6]],["day",[1]],["week",[1]],["month",[1]],["year",null]]},
f);"xAxis"===this.coll&&(l(f.linkedTo)&&!l(f.tickPixelInterval)&&(p.tickPixelInterval=350),l(f.tickPixelInterval)||!l(f.linkedTo)||l(f.tickPositioner)||l(f.tickInterval)||(p.tickPositioner=function(f,a){var b=this.linkedParent&&this.linkedParent.tickPositions&&this.linkedParent.tickPositions.info;if(b){for(var n=p.units||[],u=void 0,x=void 0,g=void 0,L=0;L<n.length;L++)if(n[L][0]===b.unitName){u=L;break}n[u+1]?(g=n[u+1][0],x=(n[u+1][1]||[1])[0]):"year"===b.unitName&&(g="year",x=10*b.count);b=J[g];
this.tickInterval=b*x;return this.getTimeTicks({unitRange:b,count:x,unitName:g},f,a,this.options.startOfWeek)}}));k(!0,this.options,p);this.horiz&&(a.minPadding=F(f.minPadding,0),a.maxPadding=F(f.maxPadding,0));d(a.grid.borderWidth)&&(a.tickWidth=a.lineWidth=b.borderWidth)}}function M(f){f=(f=f.userOptions)&&f.grid||{};var a=f.columns;f.enabled&&a&&k(!0,this.options,a[a.length-1])}function K(){(this.grid.columns||[]).forEach(function(f){f.setScale()})}function w(f){var a=q.defaultLeftAxisOptions,
b=this.horiz,p=this.maxLabelDimensions,n=this.options.grid;n=void 0===n?{}:n;n.enabled&&p&&(a=2*Math.abs(a.labels.x),b=b?n.cellHeight||a+p.height:a+p.width,h(f.tickSize)?f.tickSize[0]=b:f.tickSize=[b,0])}function N(){this.axes.forEach(function(f){(f.grid&&f.grid.columns||[]).forEach(function(f){f.setAxisSize();f.setAxisTranslation()})})}function C(f){var a=this.grid;(a.columns||[]).forEach(function(a){a.destroy(f.keepEvents)});a.columns=void 0}function n(f){f=f.userOptions||{};var a=f.grid||{};a.enabled&&
l(a.borderColor)&&(f.tickColor=f.lineColor=a.borderColor);this.grid||(this.grid=new x(this))}function z(f){var b=this.label,p=this.axis,n=p.reversed,u=p.chart,x=p.options.grid||{},g=p.options.labels,L=g.align,m=a.Side[p.side],z=f.tickmarkOffset,e=p.tickPositions,k=this.pos-z;e=d(e[f.index+1])?e[f.index+1]-z:(p.max||0)+z;var C=p.tickSize("tick");z=C?C[0]:0;C=C?C[1]/2:0;if(!0===x.enabled){if("top"===m){x=p.top+p.offset;var h=x-z}else"bottom"===m?(h=u.chartHeight-p.bottom+p.offset,x=h+z):(x=p.top+p.len-
(p.translate(n?e:k)||0),h=p.top+p.len-(p.translate(n?k:e)||0));"right"===m?(m=u.chartWidth-p.right+p.offset,n=m+z):"left"===m?(n=p.left+p.offset,m=n-z):(m=Math.round(p.left+(p.translate(n?e:k)||0))-C,n=Math.min(Math.round(p.left+(p.translate(n?k:e)||0))-C,p.left+p.len));this.slotWidth=n-m;f.pos.x="left"===L?m:"right"===L?n:m+(n-m)/2;f.pos.y=h+(x-h)/2;u=u.renderer.fontMetrics(g.style.fontSize,b&&b.element);b=b?b.getBBox().height:0;g.useHTML?f.pos.y+=u.b+-(b/2):(b=Math.round(b/u.h),f.pos.y+=(u.b-(u.h-
u.f))/2+-((b-1)*u.h/2));f.pos.x+=p.horiz&&g.x||0}}function u(f){var a=f.axis,b=f.value;if(a.options.grid&&a.options.grid.enabled){var p=a.tickPositions,n=(a.linkedParent||a).series[0],u=b===p[0];p=b===p[p.length-1];var x=n&&e(n.options.data,function(f){return f[a.isXAxis?"x":"y"]===b}),g=void 0;x&&n.is("gantt")&&(g=k(x),v.seriesTypes.gantt.prototype.pointClass.setGanttPointAliases(g));f.isFirst=u;f.isLast=p;f.point=g}}function f(){var f=this.options,a=this.categories,b=this.tickPositions,p=b[0],n=
b[b.length-1],u=this.linkedParent&&this.linkedParent.min||this.min,x=this.linkedParent&&this.linkedParent.max||this.max,g=this.tickInterval;!0!==(f.grid||{}).enabled||a||!this.horiz&&!this.isLinked||(p<u&&p+g>u&&!f.startOnTick&&(b[0]=u),n>x&&n-g<x&&!f.endOnTick&&(b[b.length-1]=x))}function p(f){var a=this.options.grid;return!0===(void 0===a?{}:a).enabled&&this.categories?this.tickInterval:f.apply(this,Array.prototype.slice.call(arguments,1))}(function(f){f[f.top=0]="top";f[f.right=1]="right";f[f.bottom=
2]="bottom";f[f.left=3]="left"})(a.Side||(a.Side={}));a.compose=function(a,x,d){-1===a.keepProps.indexOf("grid")&&(a.keepProps.push("grid"),a.prototype.getMaxLabelDimensions=b,E(a.prototype,"unsquish",p),r(a,"init",n),r(a,"afterGetOffset",B),r(a,"afterGetTitlePosition",G),r(a,"afterInit",g),r(a,"afterRender",H),r(a,"afterSetAxisTranslation",D),r(a,"afterSetOptions",A),r(a,"afterSetOptions",M),r(a,"afterSetScale",K),r(a,"afterTickSize",w),r(a,"trimTicks",f),r(a,"destroy",C));r(x,"afterSetChartSize",
N);r(d,"afterGetLabelPosition",z);r(d,"labelFormat",u);return a};var x=function(){function f(f){this.axis=f}f.prototype.isOuterAxis=function(){var f=this.axis,a=f.grid.columnIndex,b=f.linkedParent&&f.linkedParent.grid.columns||f.grid.columns,p=a?f.linkedParent:f,n=-1,u=0;f.chart[f.coll].forEach(function(a,b){a.side!==f.side||a.options.isInternal||(u=b,a===p&&(n=b))});return u===n&&(d(a)?b.length===a:!0)};f.prototype.renderBorder=function(f){var a=this.axis,b=a.chart.renderer,p=a.options;f=b.path(f).addClass("highcharts-axis-line").add(a.axisBorder);
b.styledMode||f.attr({stroke:p.lineColor,"stroke-width":p.lineWidth,zIndex:7});return f};return f}();a.Additions=x})(b||(b={}));A.E=function(a){return this.dateFormat("%a",a,!0).charAt(0)};A.W=function(a){a=new this.Date(a);var b=(this.get("Day",a)+6)%7,d=new this.Date(a.valueOf());this.set("Date",d,this.get("Date",a)-b+3);b=new this.Date(this.get("FullYear",d),0,1);4!==this.get("Day",b)&&(this.set("Month",a,0),this.set("Date",a,1+(11-this.get("Day",b))%7));return(1+Math.floor((d.valueOf()-b.valueOf())/
6048E5)).toString()};"";return b});I(c,"Gantt/Tree.js",[c["Core/Utilities.js"]],function(c){var q=c.extend,v=c.isNumber,t=c.pick,A=function(c,r){var e=c.reduce(function(e,d){var k=t(d.parent,"");"undefined"===typeof e[k]&&(e[k]=[]);e[k].push(d);return e},{});Object.keys(e).forEach(function(h,d){var k=e[h];""!==h&&-1===r.indexOf(h)&&(k.forEach(function(e){d[""].push(e)}),delete d[h])});return e},r=function(c,y,e,h,d,k){var l=0,J=0,E=k&&k.after,b=k&&k.before;y={data:h,depth:e-1,id:c,level:e,parent:y};
var a,m;"function"===typeof b&&b(y,k);b=(d[c]||[]).map(function(b){var h=r(b.id,c,e+1,b,d,k),g=b.start;b=!0===b.milestone?g:b.end;a=!v(a)||g<a?g:a;m=!v(m)||b>m?b:m;l=l+1+h.descendants;J=Math.max(h.height+1,J);return h});h&&(h.start=t(h.start,a),h.end=t(h.end,m));q(y,{children:b,descendants:l,height:J});"function"===typeof E&&E(y,k);return y};return{getListOfParents:A,getNode:r,getTree:function(c,y){var e=c.map(function(e){return e.id});c=A(c,e);return r("",null,1,null,c,y)}}});I(c,"Core/Axis/TreeGridTick.js",
[c["Core/Color/Palette.js"],c["Core/Utilities.js"]],function(c,q){var v=q.addEvent,t=q.isObject,A=q.isNumber,r=q.pick,l=q.wrap,y;(function(e){function h(){this.treeGrid||(this.treeGrid=new E(this))}function d(b,a){b=b.treeGrid;var d=!b.labelIcon,e=a.renderer,k=a.xy,g=a.options,h=g.width||0,E=g.height||0,l=k.x-h/2-(g.padding||0);k=k.y-E/2;var F=a.collapsed?90:180,J=a.show&&A(k),w=b.labelIcon;w||(b.labelIcon=w=e.path(e.symbols[g.type](g.x||0,g.y||0,h,E)).addClass("highcharts-label-icon").add(a.group));
w.attr({y:J?0:-9999});e.styledMode||w.attr({cursor:"pointer",fill:r(a.color,c.neutralColor60),"stroke-width":1,stroke:g.lineColor,strokeWidth:g.lineWidth||0});w[d?"attr":"animate"]({translateX:l,translateY:k,rotation:F})}function k(b,a,d,e,k,g,c,h,E){var m=r(this.options&&this.options.labels,g);g=this.pos;var B=this.axis,w="treegrid"===B.options.type;b=b.apply(this,[a,d,e,k,m,c,h,E]);w&&(a=m&&t(m.symbol,!0)?m.symbol:{},m=m&&A(m.indentation)?m.indentation:0,g=(g=(B=B.treeGrid.mapOfPosToGridNode)&&
B[g])&&g.depth||1,b.x+=(a.width||0)+2*(a.padding||0)+(g-1)*m);return b}function F(b){var a=this,m=a.pos,e=a.axis,k=a.label,g=e.treeGrid.mapOfPosToGridNode,c=e.options,h=r(a.options&&a.options.labels,c&&c.labels),E=h&&t(h.symbol,!0)?h.symbol:{},l=(g=g&&g[m])&&g.depth;c="treegrid"===c.type;var F=-1<e.tickPositions.indexOf(m);m=e.chart.styledMode;c&&g&&k&&k.element&&k.addClass("highcharts-treegrid-node-level-"+l);b.apply(a,Array.prototype.slice.call(arguments,1));c&&k&&k.element&&g&&g.descendants&&0<
g.descendants&&(e=e.treeGrid.isCollapsed(g),d(a,{color:!m&&k.styles&&k.styles.color||"",collapsed:e,group:k.parentGroup,options:E,renderer:k.renderer,show:F,xy:k.xy}),E="highcharts-treegrid-node-"+(e?"expanded":"collapsed"),k.addClass("highcharts-treegrid-node-"+(e?"collapsed":"expanded")).removeClass(E),m||k.css({cursor:"pointer"}),[k,a.treeGrid.labelIcon].forEach(function(b){b&&!b.attachedTreeGridEvents&&(v(b.element,"mouseover",function(){k.addClass("highcharts-treegrid-node-active");k.renderer.styledMode||
k.css({textDecoration:"underline"})}),v(b.element,"mouseout",function(){var a=t(h.style)?h.style:{};k.removeClass("highcharts-treegrid-node-active");k.renderer.styledMode||k.css({textDecoration:a.textDecoration})}),v(b.element,"click",function(){a.treeGrid.toggleCollapse()}),b.attachedTreeGridEvents=!0)}))}var J=!1;e.compose=function(b){J||(v(b,"init",h),l(b.prototype,"getLabelPosition",k),l(b.prototype,"renderLabel",F),b.prototype.collapse=function(a){this.treeGrid.collapse(a)},b.prototype.expand=
function(a){this.treeGrid.expand(a)},b.prototype.toggleCollapse=function(a){this.treeGrid.toggleCollapse(a)},J=!0)};var E=function(){function b(a){this.tick=a}b.prototype.collapse=function(a){var b=this.tick,d=b.axis,e=d.brokenAxis;e&&d.treeGrid.mapOfPosToGridNode&&(b=d.treeGrid.collapse(d.treeGrid.mapOfPosToGridNode[b.pos]),e.setBreaks(b,r(a,!0)))};b.prototype.expand=function(a){var b=this.tick,d=b.axis,e=d.brokenAxis;e&&d.treeGrid.mapOfPosToGridNode&&(b=d.treeGrid.expand(d.treeGrid.mapOfPosToGridNode[b.pos]),
e.setBreaks(b,r(a,!0)))};b.prototype.toggleCollapse=function(a){var b=this.tick,d=b.axis,e=d.brokenAxis;e&&d.treeGrid.mapOfPosToGridNode&&(b=d.treeGrid.toggleCollapse(d.treeGrid.mapOfPosToGridNode[b.pos]),e.setBreaks(b,r(a,!0)))};return b}();e.Additions=E})(y||(y={}));return y});I(c,"Mixins/TreeSeries.js",[c["Core/Color/Color.js"],c["Core/Utilities.js"]],function(c,q){var v=q.extend,t=q.isArray,A=q.isNumber,r=q.isObject,l=q.merge,y=q.pick;return{getColor:function(e,h){var d=h.index,k=h.mapOptionsToLevel,
l=h.parentColor,r=h.parentColorIndex,E=h.series,b=h.colors,a=h.siblings,m=E.points,B=E.chart.options.chart,G;if(e){m=m[e.i];e=k[e.level]||{};if(k=m&&e.colorByPoint){var g=m.index%(b?b.length:B.colorCount);var H=b&&b[g]}if(!E.chart.styledMode){b=m&&m.options.color;B=e&&e.color;if(G=l)G=(G=e&&e.colorVariation)&&"brightness"===G.key?c.parse(l).brighten(d/a*G.to).get():l;G=y(b,B,H,G,E.color)}var D=y(m&&m.options.colorIndex,e&&e.colorIndex,g,r,h.colorIndex)}return{color:G,colorIndex:D}},getLevelOptions:function(e){var c=
null;if(r(e)){c={};var d=A(e.from)?e.from:1;var k=e.levels;var F={};var J=r(e.defaults)?e.defaults:{};t(k)&&(F=k.reduce(function(e,b){if(r(b)&&A(b.level)){var a=l({},b);var m="boolean"===typeof a.levelIsConstant?a.levelIsConstant:J.levelIsConstant;delete a.levelIsConstant;delete a.level;b=b.level+(m?0:d-1);r(e[b])?v(e[b],a):e[b]=a}return e},{}));k=A(e.to)?e.to:1;for(e=0;e<=k;e++)c[e]=l({},J,r(F[e])?F[e]:{})}return c},setTreeValues:function k(c,d){var h=d.before,l=d.idRoot,E=d.mapIdToNode[l],b=d.points[c.i],
a=b&&b.options||{},m=0,B=[];c.levelDynamic=c.level-(("boolean"===typeof d.levelIsConstant?d.levelIsConstant:1)?0:E.level);c.name=y(b&&b.name,"");c.visible=l===c.id||("boolean"===typeof d.visible?d.visible:!1);"function"===typeof h&&(c=h(c,d));c.children.forEach(function(a,b){var g=v({},d);v(g,{index:b,siblings:c.children.length,visible:c.visible});a=k(a,g);B.push(a);a.visible&&(m+=a.val)});c.visible=0<m||c.visible;h=y(a.value,m);c.children=B;c.childrenTotal=m;c.isLeaf=c.visible&&!m;c.val=h;return c},
updateRootId:function(c){if(r(c)){var d=r(c.options)?c.options:{};d=y(c.rootNode,d.rootId,"");r(c.userOptions)&&(c.userOptions.rootId=d);c.rootNode=d}return d}}});I(c,"Core/Axis/TreeGridAxis.js",[c["Core/Axis/BrokenAxis.js"],c["Core/Axis/GridAxis.js"],c["Gantt/Tree.js"],c["Core/Axis/TreeGridTick.js"],c["Mixins/TreeSeries.js"],c["Core/Utilities.js"]],function(c,q,v,t,A,r){var l=A.getLevelOptions,y=r.addEvent,e=r.find,h=r.fireEvent,d=r.isArray,k=r.isObject,F=r.isString,J=r.merge,E=r.pick,b=r.wrap,a;
(function(a){function m(a,b){var g=a.collapseEnd||0;a=a.collapseStart||0;g>=b&&(a-=.5);return{from:a,to:g,showPoints:!1}}function r(a,b,g){var n=[],d=[],u={},f="boolean"===typeof b?b:!1,p={},x=-1;a=v.getTree(a,{after:function(f){f=p[f.pos];var a=0,b=0;f.children.forEach(function(f){b+=(f.descendants||0)+1;a=Math.max((f.height||0)+1,a)});f.descendants=b;f.height=a;f.collapsed&&d.push(f)},before:function(a){var b=k(a.data,!0)?a.data:{},g=F(b.name)?b.name:"",d=u[a.parent];d=k(d,!0)?p[d.pos]:null;var m=
function(f){return f.name===g},z;f&&k(d,!0)&&(z=e(d.children,m))?(m=z.pos,z.nodes.push(a)):m=x++;p[m]||(p[m]=z={depth:d?d.depth+1:0,name:g,id:b.id,nodes:[a],children:[],pos:m},-1!==m&&n.push(g),k(d,!0)&&d.children.push(z));F(a.id)&&(u[a.id]=a);z&&!0===b.collapsed&&(z.collapsed=!0);a.pos=m}});p=function(f,a){var b=function(f,p,n){var u=p+(-1===p?0:a-1),x=(u-p)/2,g=p+x;f.nodes.forEach(function(f){var a=f.data;k(a,!0)&&(a.y=p+(a.seriesIndex||0),delete a.seriesIndex);f.pos=g});n[g]=f;f.pos=g;f.tickmarkOffset=
x+.5;f.collapseStart=u+.5;f.children.forEach(function(f){b(f,u+1,n);u=(f.collapseEnd||0)-.5});f.collapseEnd=u+.5;return n};return b(f["-1"],-1,{})}(p,g);return{categories:n,mapOfIdToNode:u,mapOfPosToGridNode:p,collapsedNodes:d,tree:a}}function g(a){a.target.axes.filter(function(a){return"treegrid"===a.options.type}).forEach(function(b){var g=b.options||{},n=g.labels,e=g.uniqueNames;g=g.max;var u=0;if(!b.treeGrid.mapOfPosToGridNode||b.series.some(function(f){return!f.hasRendered||f.isDirtyData||f.isDirty})){var f=
b.series.reduce(function(f,a){a.visible&&((a.options.data||[]).forEach(function(b){a.options.keys&&a.options.keys.length&&(b=a.pointClass.prototype.optionsToObject.call({series:a},b),a.pointClass.setGanttPointAliases(b));k(b,!0)&&(b.seriesIndex=u,f.push(b))}),!0===e&&u++);return f},[]);if(g&&f.length<g)for(var p=f.length;p<=g;p++)f.push({name:p+"\u200b"});g=r(f,e||!1,!0===e?u:1);b.categories=g.categories;b.treeGrid.mapOfPosToGridNode=g.mapOfPosToGridNode;b.hasNames=!0;b.treeGrid.tree=g.tree;b.series.forEach(function(a){var b=
(a.options.data||[]).map(function(b){d(b)&&a.options.keys&&a.options.keys.length&&f.forEach(function(f){0<=b.indexOf(f.x)&&0<=b.indexOf(f.x2)&&(b=f)});return k(b,!0)?J(b):b});a.visible&&a.setData(b,!1)});b.treeGrid.mapOptionsToLevel=l({defaults:n,from:1,levels:n&&n.levels,to:b.treeGrid.tree&&b.treeGrid.tree.height});"beforeRender"===a.type&&(b.treeGrid.collapsedNodes=g.collapsedNodes)}})}function H(a,b){var g=this.treeGrid.mapOptionsToLevel||{},n=this.ticks,d=n[b],u;if("treegrid"===this.options.type&&
this.treeGrid.mapOfPosToGridNode){var f=this.treeGrid.mapOfPosToGridNode[b];(g=g[f.depth])&&(u={labels:g});!d&&M?n[b]=new M(this,b,void 0,void 0,{category:f.name,tickmarkOffset:f.tickmarkOffset,options:u}):(d.parameters.category=f.name,d.options=u,d.addLabel())}else a.apply(this,Array.prototype.slice.call(arguments,1))}function D(a,b,d){var n=this,e="treegrid"===d.type;n.treeGrid||(n.treeGrid=new K(n));e&&(y(b,"beforeRender",g),y(b,"beforeRedraw",g),y(b,"addSeries",function(a){a.options.data&&(a=
r(a.options.data,d.uniqueNames||!1,1),n.treeGrid.collapsedNodes=(n.treeGrid.collapsedNodes||[]).concat(a.collapsedNodes))}),y(n,"foundExtremes",function(){n.treeGrid.collapsedNodes&&n.treeGrid.collapsedNodes.forEach(function(a){var f=n.treeGrid.collapse(a);n.brokenAxis&&(n.brokenAxis.setBreaks(f,!1),n.treeGrid.collapsedNodes&&(n.treeGrid.collapsedNodes=n.treeGrid.collapsedNodes.filter(function(f){return a.collapseStart!==f.collapseStart||a.collapseEnd!==f.collapseEnd})))})}),y(n,"afterBreaks",function(){"yAxis"===
n.coll&&!n.staticScale&&n.chart.options.chart.height&&(n.isDirty=!0)}),d=J({grid:{enabled:!0},labels:{align:"left",levels:[{level:void 0},{level:1,style:{fontWeight:"bold"}}],symbol:{type:"triangle",x:-5,y:-5,height:10,width:10,padding:5}},uniqueNames:!1},d,{reversed:!0,grid:{columns:void 0}}));a.apply(n,[b,d]);e&&(n.hasNames=!0,n.options.showLastLabel=!0)}function A(a){var b=this.options;"treegrid"===b.type?(this.min=E(this.userMin,b.min,this.dataMin),this.max=E(this.userMax,b.max,this.dataMax),
h(this,"foundExtremes"),this.setAxisTranslation(),this.tickmarkOffset=.5,this.tickInterval=1,this.tickPositions=this.treeGrid.mapOfPosToGridNode?this.treeGrid.getTickPositions():[]):a.apply(this,Array.prototype.slice.call(arguments,1))}var M;a.compose=function(a,g,d,n){-1===a.keepProps.indexOf("treeGrid")&&(a.keepProps.push("treeGrid"),M=n,b(a.prototype,"generateTick",H),b(a.prototype,"init",D),b(a.prototype,"setTickInterval",A),a.prototype.utils={getNode:v.getNode},q.compose(a,g,n),c.compose(a,d),
t.compose(n));return a};var K=function(){function a(a){this.axis=a}a.prototype.setCollapsedStatus=function(a){var b=this.axis,n=b.chart;b.series.forEach(function(b){var g=b.options.data;if(a.id&&g){var f=n.get(a.id);b=g[b.data.indexOf(f)];f&&b&&(f.collapsed=a.collapsed,b.collapsed=a.collapsed)}})};a.prototype.collapse=function(a){var b=this.axis,n=b.options.breaks||[],g=m(a,b.max);n.push(g);a.collapsed=!0;b.treeGrid.setCollapsedStatus(a);return n};a.prototype.expand=function(a){var b=this.axis,n=
b.options.breaks||[],g=m(a,b.max);a.collapsed=!1;b.treeGrid.setCollapsedStatus(a);return n.reduce(function(a,f){f.to===g.to&&f.from===g.from||a.push(f);return a},[])};a.prototype.getTickPositions=function(){var a=this.axis,b=Math.floor(a.min/a.tickInterval)*a.tickInterval,n=Math.ceil(a.max/a.tickInterval)*a.tickInterval;return Object.keys(a.treeGrid.mapOfPosToGridNode||{}).reduce(function(g,u){u=+u;!(u>=b&&u<=n)||a.brokenAxis&&a.brokenAxis.isInAnyBreak(u)||g.push(u);return g},[])};a.prototype.isCollapsed=
function(a){var b=this.axis,n=b.options.breaks||[],g=m(a,b.max);return n.some(function(a){return a.from===g.from&&a.to===g.to})};a.prototype.toggleCollapse=function(a){return this.isCollapsed(a)?this.expand(a):this.collapse(a)};return a}();a.Additions=K})(a||(a={}));return a});I(c,"Extensions/CurrentDateIndication.js",[c["Core/Axis/Axis.js"],c["Core/Color/Palette.js"],c["Core/Axis/PlotLineOrBand.js"],c["Core/Utilities.js"]],function(c,q,v,t){var A=t.addEvent,r=t.merge;t=t.wrap;var l={color:q.highlightColor20,
width:2,label:{format:"%a, %b %d %Y, %H:%M",formatter:function(c,e){return this.axis.chart.time.dateFormat(e||"",c)},rotation:0,style:{fontSize:"10px"}}};A(c,"afterSetOptions",function(){var c=this.options,e=c.currentDateIndicator;e&&(e="object"===typeof e?r(l,e):r(l),e.value=Date.now(),e.className="highcharts-current-date-indicator",c.plotLines||(c.plotLines=[]),c.plotLines.push(e))});A(v,"render",function(){this.label&&this.label.attr({text:this.getLabelText(this.options.label)})});t(v.prototype,
"getLabelText",function(c,e){var h=this.options;return h&&h.className&&-1!==h.className.indexOf("highcharts-current-date-indicator")&&h.label&&"function"===typeof h.label.formatter?(h.value=Date.now(),h.label.formatter.call(this,h.value,h.label.format)):c.call(this,e)})});I(c,"Extensions/StaticScale.js",[c["Core/Axis/Axis.js"],c["Core/Chart/Chart.js"],c["Core/Utilities.js"]],function(c,q,v){var t=v.addEvent,A=v.defined,r=v.isNumber,l=v.pick;t(c,"afterSetOptions",function(){var c=this.chart.options.chart;
!this.horiz&&r(this.options.staticScale)&&(!c.height||c.scrollablePlotArea&&c.scrollablePlotArea.minHeight)&&(this.staticScale=this.options.staticScale)});q.prototype.adjustHeight=function(){"adjustHeight"!==this.redrawTrigger&&((this.axes||[]).forEach(function(c){var e=c.chart,h=!!e.initiatedScale&&e.options.animation,d=c.options.staticScale;if(c.staticScale&&A(c.min)){var k=l(c.brokenAxis&&c.brokenAxis.unitLength,c.max+c.tickInterval-c.min)*d;k=Math.max(k,d);d=k-e.plotHeight;!e.scrollablePixelsY&&
1<=Math.abs(d)&&(e.plotHeight=k,e.redrawTrigger="adjustHeight",e.setSize(void 0,e.chartHeight+d,h));c.series.forEach(function(d){(d=d.sharedClipKey&&e.sharedClips[d.sharedClipKey])&&d.attr(e.inverted?{width:e.plotHeight}:{height:e.plotHeight})})}}),this.initiatedScale=!0);this.redrawTrigger=null};t(q,"render",q.prototype.adjustHeight)});I(c,"Extensions/ArrowSymbols.js",[c["Core/Renderer/SVG/SVGRenderer.js"]],function(c){function q(c,r,l,q){return[["M",c,r+q/2],["L",c+l,r],["L",c,r+q/2],["L",c+l,r+
q]]}function v(c,r,l,q){return[["M",c+l,r],["L",c,r+q/2],["L",c+l,r+q],["Z"]]}function t(c,r,l,q){return v(c,r,l/2,q)}c=c.prototype.symbols;c.arrow=q;c["arrow-filled"]=v;c["arrow-filled-half"]=t;c["arrow-half"]=function(c,r,l,t){return q(c,r,l/2,t)};c["triangle-left"]=v;c["triangle-left-half"]=t;return c});I(c,"Gantt/Connection.js",[c["Core/Globals.js"],c["Core/DefaultOptions.js"],c["Core/Series/Point.js"],c["Core/Utilities.js"]],function(c,q,v,t){function A(d){var e=d.shapeArgs;return e?{xMin:e.x||
0,xMax:(e.x||0)+(e.width||0),yMin:e.y||0,yMax:(e.y||0)+(e.height||0)}:(e=d.graphic&&d.graphic.getBBox())?{xMin:d.plotX-e.width/2,xMax:d.plotX+e.width/2,yMin:d.plotY-e.height/2,yMax:d.plotY+e.height/2}:null}"";var r=t.defined,l=t.error,y=t.extend,e=t.merge,h=t.objectEach,d=c.deg2rad,k=Math.max,F=Math.min;y(q.defaultOptions,{connectors:{type:"straight",lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});
q=function(){function c(d,b,a){this.toPoint=this.pathfinder=this.graphics=this.fromPoint=this.chart=void 0;this.init(d,b,a)}c.prototype.init=function(d,b,a){this.fromPoint=d;this.toPoint=b;this.options=a;this.chart=d.series.chart;this.pathfinder=this.chart.pathfinder};c.prototype.renderPath=function(d,b,a){var e=this.chart,c=e.styledMode,k=e.pathfinder,g=!e.options.chart.forExport&&!1!==a,h=this.graphics&&this.graphics.path;k.group||(k.group=e.renderer.g().addClass("highcharts-pathfinder-group").attr({zIndex:-1}).add(e.seriesGroup));
k.group.translate(e.plotLeft,e.plotTop);h&&h.renderer||(h=e.renderer.path().add(k.group),c||h.attr({opacity:0}));h.attr(b);d={d:d};c||(d.opacity=1);h[g?"animate":"attr"](d,a);this.graphics=this.graphics||{};this.graphics.path=h};c.prototype.addMarker=function(e,b,a){var c=this.fromPoint.series.chart,k=c.pathfinder;c=c.renderer;var h="start"===e?this.fromPoint:this.toPoint,g=h.getPathfinderAnchorPoint(b);if(b.enabled&&((a="start"===e?a[1]:a[a.length-2])&&"M"===a[0]||"L"===a[0])){a={x:a[1],y:a[2]};
a=h.getRadiansToVector(a,g);g=h.getMarkerVector(a,b.radius,g);a=-a/d;if(b.width&&b.height){var l=b.width;var r=b.height}else l=r=2*b.radius;this.graphics=this.graphics||{};g={x:g.x-l/2,y:g.y-r/2,width:l,height:r,rotation:a,rotationOriginX:g.x,rotationOriginY:g.y};this.graphics[e]?this.graphics[e].animate(g):(this.graphics[e]=c.symbol(b.symbol).addClass("highcharts-point-connecting-path-"+e+"-marker").attr(g).add(k.group),c.styledMode||this.graphics[e].attr({fill:b.color||this.fromPoint.color,stroke:b.lineColor,
"stroke-width":b.lineWidth,opacity:0}).animate({opacity:1},h.series.options.animation))}};c.prototype.getPath=function(d){var b=this.pathfinder,a=this.chart,c=b.algorithms[d.type],k=b.chartObstacles;if("function"!==typeof c)return l('"'+d.type+'" is not a Pathfinder algorithm.'),{path:[],obstacles:[]};c.requiresObstacles&&!k&&(k=b.chartObstacles=b.getChartObstacles(d),a.options.connectors.algorithmMargin=d.algorithmMargin,b.chartObstacleMetrics=b.getObstacleMetrics(k));return c(this.fromPoint.getPathfinderAnchorPoint(d.startMarker),
this.toPoint.getPathfinderAnchorPoint(d.endMarker),e({chartObstacles:k,lineObstacles:b.lineObstacles||[],obstacleMetrics:b.chartObstacleMetrics,hardBounds:{xMin:0,xMax:a.plotWidth,yMin:0,yMax:a.plotHeight},obstacleOptions:{margin:d.algorithmMargin},startDirectionX:b.getAlgorithmStartDirection(d.startMarker)},d))};c.prototype.render=function(){var d=this.fromPoint,b=d.series,a=b.chart,c=a.pathfinder,h=e(a.options.connectors,b.options.connectors,d.options.connectors,this.options),l={};a.styledMode||
(l.stroke=h.lineColor||d.color,l["stroke-width"]=h.lineWidth,h.dashStyle&&(l.dashstyle=h.dashStyle));l["class"]="highcharts-point-connecting-path highcharts-color-"+d.colorIndex;h=e(l,h);r(h.marker.radius)||(h.marker.radius=F(k(Math.ceil((h.algorithmMargin||8)/2)-1,1),5));d=this.getPath(h);a=d.path;d.obstacles&&(c.lineObstacles=c.lineObstacles||[],c.lineObstacles=c.lineObstacles.concat(d.obstacles));this.renderPath(a,l,b.options.animation);this.addMarker("start",e(h.marker,h.startMarker),a);this.addMarker("end",
e(h.marker,h.endMarker),a)};c.prototype.destroy=function(){this.graphics&&(h(this.graphics,function(d){d.destroy()}),delete this.graphics)};return c}();c.Connection=q;y(v.prototype,{getPathfinderAnchorPoint:function(d){var e=A(this);switch(d.align){case "right":var b="xMax";break;case "left":b="xMin"}switch(d.verticalAlign){case "top":var a="yMin";break;case "bottom":a="yMax"}return{x:b?e[b]:(e.xMin+e.xMax)/2,y:a?e[a]:(e.yMin+e.yMax)/2}},getRadiansToVector:function(d,e){var b;r(e)||(b=A(this))&&(e=
{x:(b.xMin+b.xMax)/2,y:(b.yMin+b.yMax)/2});return Math.atan2(e.y-d.y,d.x-e.x)},getMarkerVector:function(d,e,b){var a=2*Math.PI,c=A(this),k=c.xMax-c.xMin,h=c.yMax-c.yMin,g=Math.atan2(h,k),l=!1;k/=2;var r=h/2,F=c.xMin+k;c=c.yMin+r;for(var q=F,t=c,w=1,E=1;d<-Math.PI;)d+=a;for(;d>Math.PI;)d-=a;a=Math.tan(d);d>-g&&d<=g?(E=-1,l=!0):d>g&&d<=Math.PI-g?E=-1:d>Math.PI-g||d<=-(Math.PI-g)?(w=-1,l=!0):w=-1;l?(q+=w*k,t+=E*k*a):(q+=h/(2*a)*w,t+=E*r);b.x!==F&&(q=b.x);b.y!==c&&(t=b.y);return{x:q+e*Math.cos(d),y:t-
e*Math.sin(d)}}});return q});I(c,"Gantt/PathfinderAlgorithms.js",[c["Core/Utilities.js"]],function(c){function q(d,e,c){c=c||0;var k=d.length-1;e-=1e-7;for(var h,b;c<=k;)if(h=k+c>>1,b=e-d[h].xMin,0<b)c=h+1;else if(0>b)k=h-1;else return h;return 0<c?c-1:0}function v(d,e){for(var c=q(d,e.x+1)+1;c--;){var k;if(k=d[c].xMax>=e.x)k=d[c],k=e.x<=k.xMax&&e.x>=k.xMin&&e.y<=k.yMax&&e.y>=k.yMin;if(k)return c}return-1}function t(d){var e=[];if(d.length){e.push(["M",d[0].start.x,d[0].start.y]);for(var c=0;c<d.length;++c)e.push(["L",
d[c].end.x,d[c].end.y])}return e}function A(d,e){d.yMin=y(d.yMin,e.yMin);d.yMax=l(d.yMax,e.yMax);d.xMin=y(d.xMin,e.xMin);d.xMax=l(d.xMax,e.xMax)}var r=c.pick,l=Math.min,y=Math.max,e=Math.abs;c=function(d,c,h){function k(a,b,d,g,c){a={x:a.x,y:a.y};a[b]=d[g||b]+(c||0);return a}function l(a,b,d){var g=e(b[d]-a[d+"Min"])>e(b[d]-a[d+"Max"]);return k(b,d,a,d+(g?"Max":"Min"),g?1:-1)}var b=[],a=r(h.startDirectionX,e(c.x-d.x)>e(c.y-d.y))?"x":"y",m=h.chartObstacles,q=v(m,d);h=v(m,c);if(-1<h){var F=m[h];h=l(F,
c,a);F={start:h,end:c};var g=h}else g=c;-1<q&&(m=m[q],h=l(m,d,a),b.push({start:d,end:h}),h[a]>=d[a]===h[a]>=g[a]&&(a="y"===a?"x":"y",c=d[a]<c[a],b.push({start:h,end:k(h,a,m,a+(c?"Max":"Min"),c?1:-1)}),a="y"===a?"x":"y"));d=b.length?b[b.length-1].end:d;h=k(d,a,g);b.push({start:d,end:h});a=k(h,"y"===a?"x":"y",g);b.push({start:h,end:a});b.push(F);return{path:t(b),obstacles:b}};c.requiresObstacles=!0;var h=function(d,c,h){function k(a,b,d){var f,p=a.x<b.x?1:-1;if(a.x<b.x){var n=a;var c=b}else n=b,c=a;
if(a.y<b.y){var g=a;var e=b}else g=b,e=a;for(f=0>p?l(q(w,c.x),w.length-1):0;w[f]&&(0<p&&w[f].xMin<=c.x||0>p&&w[f].xMax>=n.x);){if(w[f].xMin<=c.x&&w[f].xMax>=n.x&&w[f].yMin<=e.y&&w[f].yMax>=g.y)return d?{y:a.y,x:a.x<b.x?w[f].xMin-1:w[f].xMax+1,obstacle:w[f]}:{x:a.x,y:a.y<b.y?w[f].yMin-1:w[f].yMax+1,obstacle:w[f]};f+=p}return b}function E(a,b,d,f,p){var c=p.soft,n=p.hard,g=f?"x":"y",u={x:b.x,y:b.y},h={x:b.x,y:b.y};p=a[g+"Max"]>=c[g+"Max"];c=a[g+"Min"]<=c[g+"Min"];var m=a[g+"Max"]>=n[g+"Max"];n=a[g+
"Min"]<=n[g+"Min"];var z=e(a[g+"Min"]-b[g]),l=e(a[g+"Max"]-b[g]);d=10>e(z-l)?b[g]<d[g]:l<z;h[g]=a[g+"Min"];u[g]=a[g+"Max"];a=k(b,h,f)[g]!==h[g];b=k(b,u,f)[g]!==u[g];d=a?b?d:!0:b?!1:d;d=c?p?d:!0:p?!1:d;return n?m?d:!0:m?!1:d}function b(a,d,c){if(a.x===d.x&&a.y===d.y)return[];var f=c?"x":"y",p=h.obstacleOptions.margin;var n={soft:{xMin:D,xMax:Q,yMin:M,yMax:K},hard:h.hardBounds};var e=v(w,a);if(-1<e){e=w[e];n=E(e,a,d,c,n);A(e,h.hardBounds);var u=c?{y:a.y,x:e[n?"xMax":"xMin"]+(n?1:-1)}:{x:a.x,y:e[n?"yMax":
"yMin"]+(n?1:-1)};var m=v(w,u);-1<m&&(m=w[m],A(m,h.hardBounds),u[f]=n?y(e[f+"Max"]-p+1,(m[f+"Min"]+e[f+"Max"])/2):l(e[f+"Min"]+p-1,(m[f+"Max"]+e[f+"Min"])/2),a.x===u.x&&a.y===u.y?(g&&(u[f]=n?y(e[f+"Max"],m[f+"Max"])+1:l(e[f+"Min"],m[f+"Min"])-1),g=!g):g=!1);a=[{start:a,end:u}]}else f=k(a,{x:c?d.x:a.x,y:c?a.y:d.y},c),a=[{start:a,end:{x:f.x,y:f.y}}],f[c?"x":"y"]!==d[c?"x":"y"]&&(n=E(f.obstacle,f,d,!c,n),A(f.obstacle,h.hardBounds),n={x:c?f.x:f.obstacle[n?"xMax":"xMin"]+(n?1:-1),y:c?f.obstacle[n?"yMax":
"yMin"]+(n?1:-1):f.y},c=!c,a=a.concat(b({x:f.x,y:f.y},n,c)));return a=a.concat(b(a[a.length-1].end,d,!c))}function a(a,b,d){var f=l(a.xMax-b.x,b.x-a.xMin)<l(a.yMax-b.y,b.y-a.yMin);d=E(a,b,d,f,{soft:h.hardBounds,hard:h.hardBounds});return f?{y:b.y,x:a[d?"xMax":"xMin"]+(d?1:-1)}:{x:b.x,y:a[d?"yMax":"yMin"]+(d?1:-1)}}var m=r(h.startDirectionX,e(c.x-d.x)>e(c.y-d.y)),B=m?"x":"y",F=[],g=!1,H=h.obstacleMetrics,D=l(d.x,c.x)-H.maxWidth-10,Q=y(d.x,c.x)+H.maxWidth+10,M=l(d.y,c.y)-H.maxHeight-10,K=y(d.y,c.y)+
H.maxHeight+10,w=h.chartObstacles;var N=q(w,D);H=q(w,Q);w=w.slice(N,H+1);if(-1<(H=v(w,c))){var C=a(w[H],c,d);F.push({end:c,start:C});c=C}for(;-1<(H=v(w,c));)N=0>c[B]-d[B],C={x:c.x,y:c.y},C[B]=w[H][N?B+"Max":B+"Min"]+(N?1:-1),F.push({end:c,start:C}),c=C;d=b(d,c,m);d=d.concat(F.reverse());return{path:t(d),obstacles:d}};h.requiresObstacles=!0;return{fastAvoid:h,straight:function(d,c){return{path:[["M",d.x,d.y],["L",c.x,c.y]],obstacles:[{start:d,end:c}]}},simpleConnect:c}});I(c,"Gantt/Pathfinder.js",
[c["Gantt/Connection.js"],c["Core/Chart/Chart.js"],c["Core/Globals.js"],c["Core/DefaultOptions.js"],c["Core/Series/Point.js"],c["Core/Utilities.js"],c["Gantt/PathfinderAlgorithms.js"]],function(c,q,v,t,A,r,l){function y(a){var b=a.shapeArgs;return b?{xMin:b.x||0,xMax:(b.x||0)+(b.width||0),yMin:b.y||0,yMax:(b.y||0)+(b.height||0)}:(b=a.graphic&&a.graphic.getBBox())?{xMin:a.plotX-b.width/2,xMax:a.plotX+b.width/2,yMin:a.plotY-b.height/2,yMax:a.plotY+b.height/2}:null}function e(a){for(var d=a.length,c=
0,g,e,h=[],k=function(a,d,c){c=b(c,10);var g=a.yMax+c>d.yMin-c&&a.yMin-c<d.yMax+c,e=a.xMax+c>d.xMin-c&&a.xMin-c<d.xMax+c,f=g?a.xMin>d.xMax?a.xMin-d.xMax:d.xMin-a.xMax:Infinity,p=e?a.yMin>d.yMax?a.yMin-d.yMax:d.yMin-a.yMax:Infinity;return e&&g?c?k(a,d,Math.floor(c/2)):Infinity:B(f,p)};c<d;++c)for(g=c+1;g<d;++g)e=k(a[c],a[g]),80>e&&h.push(e);h.push(80);return m(Math.floor(h.sort(function(a,b){return a-b})[Math.floor(h.length/10)]/2-1),1)}function h(a){if(a.options.pathfinder||a.series.reduce(function(a,
b){b.options&&E(!0,b.options.connectors=b.options.connectors||{},b.options.pathfinder);return a||b.options&&b.options.pathfinder},!1))E(!0,a.options.connectors=a.options.connectors||{},a.options.pathfinder),F('WARNING: Pathfinder options have been renamed. Use "chart.connectors" or "series.connectors" instead.')}"";var d=r.addEvent,k=r.defined,F=r.error,J=r.extend,E=r.merge,b=r.pick,a=r.splat,m=Math.max,B=Math.min;J(t.defaultOptions,{connectors:{type:"straight",lineWidth:1,marker:{enabled:!1,align:"center",
verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});var G=function(){function g(a){this.lineObstacles=this.group=this.connections=this.chartObstacleMetrics=this.chartObstacles=this.chart=void 0;this.init(a)}g.prototype.init=function(a){this.chart=a;this.connections=[];d(a,"redraw",function(){this.pathfinder.update()})};g.prototype.update=function(b){var d=this.chart,g=this,e=g.connections;g.connections=[];d.series.forEach(function(b){b.visible&&
!b.options.isInternal&&b.points.forEach(function(b){var f=b.options;f&&f.dependency&&(f.connect=f.dependency);var p;f=b.options&&b.options.connect&&a(b.options.connect);b.visible&&!1!==b.isInside&&f&&f.forEach(function(a){p=d.get("string"===typeof a?a:a.to);p instanceof A&&p.series.visible&&p.visible&&!1!==p.isInside&&g.connections.push(new c(b,p,"string"===typeof a?{}:a))})})});for(var h=0,m=void 0,k=void 0,l=e.length,n=g.connections.length;h<l;++h){k=!1;for(m=0;m<n;++m)if(e[h].fromPoint===g.connections[m].fromPoint&&
e[h].toPoint===g.connections[m].toPoint){g.connections[m].graphics=e[h].graphics;k=!0;break}k||e[h].destroy()}delete this.chartObstacles;delete this.lineObstacles;g.renderConnections(b)};g.prototype.renderConnections=function(a){a?this.chart.series.forEach(function(a){var b=function(){var b=a.chart.pathfinder;(b&&b.connections||[]).forEach(function(b){b.fromPoint&&b.fromPoint.series===a&&b.render()});a.pathfinderRemoveRenderEvent&&(a.pathfinderRemoveRenderEvent(),delete a.pathfinderRemoveRenderEvent)};
!1===a.options.animation?b():a.pathfinderRemoveRenderEvent=d(a,"afterAnimate",b)}):this.connections.forEach(function(a){a.render()})};g.prototype.getChartObstacles=function(a){for(var d=[],c=this.chart.series,g=b(a.algorithmMargin,0),h,m=0,l=c.length;m<l;++m)if(c[m].visible&&!c[m].options.isInternal){var r=0,n=c[m].points.length,z=void 0;for(z=void 0;r<n;++r)z=c[m].points[r],z.visible&&(z=y(z))&&d.push({xMin:z.xMin-g,xMax:z.xMax+g,yMin:z.yMin-g,yMax:z.yMax+g})}d=d.sort(function(a,f){return a.xMin-
f.xMin});k(a.algorithmMargin)||(h=a.algorithmMargin=e(d),d.forEach(function(a){a.xMin-=h;a.xMax+=h;a.yMin-=h;a.yMax+=h}));return d};g.prototype.getObstacleMetrics=function(a){for(var b=0,d=0,c,g,e=a.length;e--;)c=a[e].xMax-a[e].xMin,g=a[e].yMax-a[e].yMin,b<c&&(b=c),d<g&&(d=g);return{maxHeight:d,maxWidth:b}};g.prototype.getAlgorithmStartDirection=function(a){var b="top"!==a.verticalAlign&&"bottom"!==a.verticalAlign;return"left"!==a.align&&"right"!==a.align?b?void 0:!1:b?!0:void 0};return g}();G.prototype.algorithms=
l;v.Pathfinder=G;J(A.prototype,{getPathfinderAnchorPoint:function(a){var b=y(this);switch(a.align){case "right":var d="xMax";break;case "left":d="xMin"}switch(a.verticalAlign){case "top":var c="yMin";break;case "bottom":c="yMax"}return{x:d?b[d]:(b.xMin+b.xMax)/2,y:c?b[c]:(b.yMin+b.yMax)/2}},getRadiansToVector:function(a,b){var d;k(b)||(d=y(this))&&(b={x:(d.xMin+d.xMax)/2,y:(d.yMin+d.yMax)/2});return Math.atan2(b.y-a.y,a.x-b.x)},getMarkerVector:function(a,b,d){var c=2*Math.PI,e=y(this),g=e.xMax-e.xMin,
h=e.yMax-e.yMin,m=Math.atan2(h,g),k=!1;g/=2;var n=h/2,z=e.xMin+g;e=e.yMin+n;for(var u=z,f=e,p=1,x=1;a<-Math.PI;)a+=c;for(;a>Math.PI;)a-=c;c=Math.tan(a);a>-m&&a<=m?(x=-1,k=!0):a>m&&a<=Math.PI-m?x=-1:a>Math.PI-m||a<=-(Math.PI-m)?(p=-1,k=!0):p=-1;k?(u+=p*g,f+=x*g*c):(u+=h/(2*c)*p,f+=x*n);d.x!==z&&(u=d.x);d.y!==e&&(f=d.y);return{x:u+b*Math.cos(a),y:f-b*Math.sin(a)}}});q.prototype.callbacks.push(function(a){!1!==a.options.connectors.enabled&&(h(a),this.pathfinder=new G(this),this.pathfinder.update(!0))});
return G});I(c,"Series/Gantt/GanttSeries.js",[c["Core/Axis/Axis.js"],c["Core/Chart/Chart.js"],c["Series/Gantt/GanttPoint.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Axis/Tick.js"],c["Core/Utilities.js"],c["Core/Axis/TreeGridAxis.js"]],function(c,q,v,t,A,r,l){var y=this&&this.__extends||function(){var d=function(b,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return d(b,a)};return function(b,
a){function c(){this.constructor=b}d(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),e=t.series,h=t.seriesTypes.xrange,d=r.extend,k=r.isNumber,F=r.merge,J=r.splat;l.compose(c,q,e,A);c=function(d){function b(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}y(b,d);b.prototype.drawPoint=function(a,b){var d=this.options,c=this.chart.renderer,e=a.shapeArgs,m=a.plotY,l=a.graphic,r=a.selected&&"select",q=d.stacking&&!d.borderRadius;
if(a.options.milestone)if(k(m)&&null!==a.y&&!1!==a.visible){e=c.symbols.diamond(e.x||0,e.y||0,e.width||0,e.height||0);if(l)l[b]({d:e});else a.graphic=c.path(e).addClass(a.getClassName(),!0).add(a.group||this.group);this.chart.styledMode||a.graphic.attr(this.pointAttribs(a,r)).shadow(d.shadow,null,q)}else l&&(a.graphic=l.destroy());else h.prototype.drawPoint.call(this,a,b)};b.prototype.translatePoint=function(a){h.prototype.translatePoint.call(this,a);if(a.options.milestone){var b=a.shapeArgs;var d=
b.height||0;a.shapeArgs={x:(b.x||0)-d/2,y:b.y,width:d,height:d}}};b.defaultOptions=F(h.defaultOptions,{grouping:!1,dataLabels:{enabled:!0},tooltip:{headerFormat:'<span style="font-size: 10px">{series.name}</span><br/>',pointFormat:null,pointFormatter:function(){var a=this.series,b=a.chart.tooltip,d=a.xAxis,c=a.tooltipOptions.dateTimeLabelFormats,e=d.options.startOfWeek,h=a.tooltipOptions,k=h.xDateFormat,l=this.options.milestone,r="<b>"+(this.name||this.yCategory)+"</b>";if(h.pointFormat)return this.tooltipFormatter(h.pointFormat);
k||(k=J(b.getDateFormat(d.closestPointRange,this.start,e,c))[0]);b=a.chart.time.dateFormat(k,this.start);a=a.chart.time.dateFormat(k,this.end);r+="<br/>";return l?r+(b+"<br/>"):r+("Start: "+b+"<br/>End: ")+(a+"<br/>")}},connectors:{type:"simpleConnect",animation:{reversed:!0},startMarker:{enabled:!0,symbol:"arrow-filled",radius:4,fill:"#fa0",align:"left"},endMarker:{enabled:!1,align:"right"}}});return b}(h);d(c.prototype,{keyboardMoveVertical:!1,pointArrayMap:["start","end","y"],pointClass:v,setData:e.prototype.setData});
t.registerSeriesType("gantt",c);"";return c});I(c,"Core/Chart/GanttChart.js",[c["Core/Chart/Chart.js"],c["Core/DefaultOptions.js"],c["Core/Utilities.js"]],function(c,q,v){var t=this&&this.__extends||function(){var c=function(e,d){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,c){d.__proto__=c}||function(d,c){for(var e in c)c.hasOwnProperty(e)&&(d[e]=c[e])};return c(e,d)};return function(e,d){function h(){this.constructor=e}c(e,d);e.prototype=null===d?Object.create(d):(h.prototype=
d.prototype,new h)}}(),A=q.getOptions,r=v.isArray,l=v.merge,y=v.splat;c=function(c){function e(){return null!==c&&c.apply(this,arguments)||this}t(e,c);e.prototype.init=function(d,e){var h=A(),k=d.xAxis,q=d.yAxis,b;d.xAxis=d.yAxis=void 0;var a=l(!0,{chart:{type:"gantt"},title:{text:null},legend:{enabled:!1},navigator:{series:{type:"gantt"},yAxis:{type:"category"}}},d,{isGantt:!0});d.xAxis=k;d.yAxis=q;a.xAxis=(r(d.xAxis)?d.xAxis:[d.xAxis||{},{}]).map(function(a,d){1===d&&(b=0);return l(h.xAxis,{grid:{enabled:!0},
opposite:!0,linkedTo:b},a,{type:"datetime"})});a.yAxis=y(d.yAxis||{}).map(function(a){return l(h.yAxis,{grid:{enabled:!0},staticScale:50,reversed:!0,type:a.categories?a.type:"treegrid"},a)});c.prototype.init.call(this,a,e)};return e}(c);(function(c){c.ganttChart=function(e,d,k){return new c(e,d,k)}})(c||(c={}));return c});I(c,"Core/Axis/ScrollbarAxis.js",[c["Core/Utilities.js"]],function(c){var q=c.addEvent,v=c.defined,t=c.pick;return function(){function c(){}c.compose=function(c,l){var r=function(c){var e=
t(c.options&&c.options.min,c.min),d=t(c.options&&c.options.max,c.max);return{axisMin:e,axisMax:d,scrollMin:v(c.dataMin)?Math.min(e,c.min,c.dataMin,t(c.threshold,Infinity)):e,scrollMax:v(c.dataMax)?Math.max(d,c.max,c.dataMax,t(c.threshold,-Infinity)):d}};q(c,"afterInit",function(){var c=this;c.options&&c.options.scrollbar&&c.options.scrollbar.enabled&&(c.options.scrollbar.vertical=!c.horiz,c.options.startOnTick=c.options.endOnTick=!1,c.scrollbar=new l(c.chart.renderer,c.options.scrollbar,c.chart),
q(c.scrollbar,"changed",function(e){var d=r(c),h=d.axisMax,l=d.scrollMin,q=d.scrollMax-l;v(d.axisMin)&&v(h)&&(c.horiz&&!c.reversed||!c.horiz&&c.reversed?(d=l+q*this.to,l+=q*this.from):(d=l+q*(1-this.from),l+=q*(1-this.to)),this.shouldUpdateExtremes(e.DOMType)?c.setExtremes(l,d,!0,"mousemove"!==e.DOMType&&"touchmove"!==e.DOMType,e):this.setRange(this.from,this.to))}))});q(c,"afterRender",function(){var c=r(this),h=c.scrollMin,d=c.scrollMax;c=this.scrollbar;var k=this.axisTitleMargin+(this.titleOffset||
0),l=this.chart.scrollbarsOffsets,q=this.options.margin||0;c&&(this.horiz?(this.opposite||(l[1]+=k),c.position(this.left,this.top+this.height+2+l[1]-(this.opposite?q:0),this.width,this.height),this.opposite||(l[1]+=q),k=1):(this.opposite&&(l[0]+=k),c.position(this.left+this.width+2+l[0]-(this.opposite?0:q),this.top,this.width,this.height),this.opposite&&(l[0]+=q),k=0),l[k]+=c.size+c.options.margin,isNaN(h)||isNaN(d)||!v(this.min)||!v(this.max)||this.min===this.max?c.setRange(0,1):(l=(this.min-h)/
(d-h),h=(this.max-h)/(d-h),this.horiz&&!this.reversed||!this.horiz&&this.reversed?c.setRange(l,h):c.setRange(1-h,1-l)))});q(c,"afterGetOffset",function(){var c=this.horiz?2:1,h=this.scrollbar;h&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[c]+=h.size+h.options.margin)});return c};return c}()});I(c,"Core/ScrollbarDefaults.js",[c["Core/Globals.js"],c["Core/Color/Palette.js"]],function(c,q){return{height:c.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,
minWidth:6,step:.2,zIndex:3,barBackgroundColor:q.neutralColor20,barBorderWidth:1,barBorderColor:q.neutralColor20,buttonArrowColor:q.neutralColor80,buttonBackgroundColor:q.neutralColor10,buttonBorderColor:q.neutralColor20,buttonBorderWidth:1,rifleColor:q.neutralColor80,trackBackgroundColor:q.neutralColor5,trackBorderColor:q.neutralColor5,trackBorderWidth:1}});I(c,"Core/Scrollbar.js",[c["Core/DefaultOptions.js"],c["Core/Globals.js"],c["Core/Axis/ScrollbarAxis.js"],c["Core/ScrollbarDefaults.js"],c["Core/Utilities.js"]],
function(c,q,v,t,A){var r=c.defaultOptions,l=A.addEvent,y=A.correctFloat,e=A.defined,h=A.destroyObjectProperties,d=A.fireEvent,k=A.merge,F=A.pick,J=A.removeEvent;c=function(){function c(b,a,c){this._events=[];this.chart=void 0;this.from=this.chartY=this.chartX=0;this.scrollbar=this.renderer=this.options=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=
void 0;this.trackBorderWidth=1;this.userOptions=void 0;this.y=this.x=0;this.init(b,a,c)}c.compose=function(b){v.compose(b,c)};c.swapXY=function(b,a){a&&b.forEach(function(a){for(var b=a.length,c,d=0;d<b;d+=2)c=a[d+1],"number"===typeof c&&(a[d+1]=a[d+2],a[d+2]=c)});return b};c.prototype.addEvents=function(){var b=this.options.inverted?[1,0]:[0,1],a=this.scrollbarButtons,c=this.scrollbarGroup.element,d=this.track.element,e=this.mouseDownHandler.bind(this),g=this.mouseMoveHandler.bind(this),h=this.mouseUpHandler.bind(this);
b=[[a[b[0]].element,"click",this.buttonToMinClick.bind(this)],[a[b[1]].element,"click",this.buttonToMaxClick.bind(this)],[d,"click",this.trackClick.bind(this)],[c,"mousedown",e],[c.ownerDocument,"mousemove",g],[c.ownerDocument,"mouseup",h]];q.hasTouch&&b.push([c,"touchstart",e],[c.ownerDocument,"touchmove",g],[c.ownerDocument,"touchend",h]);b.forEach(function(a){l.apply(null,a)});this._events=b};c.prototype.buttonToMaxClick=function(b){var a=(this.to-this.from)*F(this.options.step,.2);this.updatePosition(this.from+
a,this.to+a);d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:b})};c.prototype.buttonToMinClick=function(b){var a=y(this.to-this.from)*F(this.options.step,.2);this.updatePosition(y(this.from-a),y(this.to-a));d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:b})};c.prototype.cursorToScrollbarPosition=function(b){var a=this.options;a=a.minWidth>this.calculatedWidth?a.minWidth:0;return{chartX:(b.chartX-this.x-this.xOffset)/(this.barWidth-a),chartY:(b.chartY-
this.y-this.yOffset)/(this.barWidth-a)}};c.prototype.destroy=function(){var b=this,a=b.chart.scroller;b.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(a){b[a]&&b[a].destroy&&(b[a]=b[a].destroy())});a&&b===a.scrollbar&&(a.scrollbar=null,h(a.scrollbarButtons))};c.prototype.drawScrollbarButton=function(b){var a=this.renderer,d=this.scrollbarButtons,e=this.options,h=this.size,g=a.g().add(this.group);d.push(g);g=a.rect().addClass("highcharts-scrollbar-button").add(g);
this.chart.styledMode||g.attr({stroke:e.buttonBorderColor,"stroke-width":e.buttonBorderWidth,fill:e.buttonBackgroundColor});g.attr(g.crisp({x:-.5,y:-.5,width:h+1,height:h+1,r:e.buttonBorderRadius},g.strokeWidth()));g=a.path(c.swapXY([["M",h/2+(b?-1:1),h/2-3],["L",h/2+(b?-1:1),h/2+3],["L",h/2+(b?2:-2),h/2]],e.vertical)).addClass("highcharts-scrollbar-arrow").add(d[b]);this.chart.styledMode||g.attr({fill:e.buttonArrowColor})};c.prototype.init=function(b,a,c){this.scrollbarButtons=[];this.renderer=b;
this.userOptions=a;this.options=k(t,r.scrollbar,a);this.chart=c;this.size=F(this.options.size,this.options.height);a.enabled&&(this.render(),this.addEvents())};c.prototype.mouseDownHandler=function(b){b=this.chart.pointer.normalize(b);b=this.cursorToScrollbarPosition(b);this.chartX=b.chartX;this.chartY=b.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=!0};c.prototype.mouseMoveHandler=function(b){var a=this.chart.pointer.normalize(b),c=this.options.vertical?"chartY":"chartX",e=this.initPositions||
[];!this.grabbedCenter||b.touches&&0===b.touches[0][c]||(a=this.cursorToScrollbarPosition(a)[c],c=this[c],c=a-c,this.hasDragged=!0,this.updatePosition(e[0]+c,e[1]+c),this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:b.type,DOMEvent:b}))};c.prototype.mouseUpHandler=function(b){this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:b.type,DOMEvent:b});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};c.prototype.position=
function(b,a,c,d){var e=this.options.vertical,g=this.rendered?"animate":"attr",h=0;this.x=b;this.y=a+this.trackBorderWidth;this.width=c;this.xOffset=this.height=d;this.yOffset=h;e?(this.width=this.yOffset=c=h=this.size,this.xOffset=a=0,this.barWidth=d-2*c,this.x=b+=this.options.margin):(this.height=this.xOffset=d=a=this.size,this.barWidth=c-2*d,this.y+=this.options.margin);this.group[g]({translateX:b,translateY:this.y});this.track[g]({width:c,height:d});this.scrollbarButtons[1][g]({translateX:e?0:
c-a,translateY:e?d-h:0})};c.prototype.removeEvents=function(){this._events.forEach(function(b){J.apply(null,b)});this._events.length=0};c.prototype.render=function(){var b=this.renderer,a=this.options,d=this.size,e=this.chart.styledMode,h=b.g("scrollbar").attr({zIndex:a.zIndex,translateY:-99999}).add();this.group=h;this.track=b.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:a.trackBorderRadius||0,height:d,width:d}).add(h);e||this.track.attr({fill:a.trackBackgroundColor,stroke:a.trackBorderColor,
"stroke-width":a.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=b.g().add(h);this.scrollbar=b.rect().addClass("highcharts-scrollbar-thumb").attr({height:d,width:d,r:a.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=b.path(c.swapXY([["M",-3,d/4],["L",-3,2*d/3],["M",0,d/4],["L",0,2*d/3],["M",3,d/4],["L",3,2*d/3]],a.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);e||(this.scrollbar.attr({fill:a.barBackgroundColor,
stroke:a.barBorderColor,"stroke-width":a.barBorderWidth}),this.scrollbarRifles.attr({stroke:a.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};c.prototype.setRange=function(b,a){var c=this.options,d=c.vertical,h=c.minWidth,g=this.barWidth,k=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?
"attr":"animate";if(e(g)){var l=g*Math.min(a,1);b=Math.max(b,0);var r=Math.ceil(g*b);this.calculatedWidth=l=y(l-r);l<h&&(r=(g-h+l)*b,l=h);h=Math.floor(r+this.xOffset+this.yOffset);g=l/2-.5;this.from=b;this.to=a;d?(this.scrollbarGroup[k]({translateY:h}),this.scrollbar[k]({height:l}),this.scrollbarRifles[k]({translateY:g}),this.scrollbarTop=h,this.scrollbarLeft=0):(this.scrollbarGroup[k]({translateX:h}),this.scrollbar[k]({width:l}),this.scrollbarRifles[k]({translateX:g}),this.scrollbarLeft=h,this.scrollbarTop=
0);12>=l?this.scrollbarRifles.hide():this.scrollbarRifles.show(!0);!1===c.showFull&&(0>=b&&1<=a?this.group.hide():this.group.show());this.rendered=!0}};c.prototype.shouldUpdateExtremes=function(b){return F(this.options.liveRedraw,q.svg&&!q.isTouchDevice&&!this.chart.isBoosting)||"mouseup"===b||"touchend"===b||!e(b)};c.prototype.trackClick=function(b){var a=this.chart.pointer.normalize(b),c=this.to-this.from,e=this.y+this.scrollbarTop,h=this.x+this.scrollbarLeft;this.options.vertical&&a.chartY>e||
!this.options.vertical&&a.chartX>h?this.updatePosition(this.from+c,this.to+c):this.updatePosition(this.from-c,this.to-c);d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:b})};c.prototype.update=function(b){this.destroy();this.init(this.chart.renderer,k(!0,this.options,b),this.chart)};c.prototype.updatePosition=function(b,a){1<a&&(b=y(1-y(a-b)),a=1);0>b&&(a=y(a-b),b=0);this.from=b;this.to=a};c.defaultOptions=t;return c}();r.scrollbar=k(!0,c.defaultOptions,r.scrollbar);return c});
I(c,"Extensions/RangeSelector.js",[c["Core/Axis/Axis.js"],c["Core/Chart/Chart.js"],c["Core/Globals.js"],c["Core/DefaultOptions.js"],c["Core/Color/Palette.js"],c["Core/Renderer/SVG/SVGElement.js"],c["Core/Utilities.js"]],function(c,q,v,t,A,r,l){function y(a){if(-1!==a.indexOf("%L"))return"text";var b="aAdewbBmoyY".split("").some(function(b){return-1!==a.indexOf("%"+b)}),c="HkIlMS".split("").some(function(b){return-1!==a.indexOf("%"+b)});return b&&c?"datetime-local":b?"date":c?"time":"text"}var e=t.defaultOptions,
h=l.addEvent,d=l.createElement,k=l.css,F=l.defined,J=l.destroyObjectProperties,E=l.discardElement,b=l.extend,a=l.find,m=l.fireEvent,B=l.isNumber,G=l.merge,g=l.objectEach,H=l.pad,D=l.pick,I=l.pInt,M=l.splat;b(e,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",
inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:A.highlightColor80,cursor:"pointer"},labelStyle:{color:A.neutralColor60}}});b(e.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"});var K=function(){function a(b){this.buttons=void 0;this.buttonOptions=a.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;
this.chart=b;this.init(b)}a.prototype.clickButton=function(a,b){var d=this.chart,f=this.buttonOptions[a],p=d.xAxis[0],e=d.scroller&&d.scroller.getUnionExtremes()||p||{},g=e.dataMin,n=e.dataMax,k=p&&Math.round(Math.min(p.max,D(n,p.max))),l=f.type;e=f._range;var z,r=f.dataGrouping;if(null!==g&&null!==n){d.fixedRange=e;this.setSelected(a);r&&(this.forcedDataGrouping=!0,c.prototype.setDataGrouping.call(p||{chart:this.chart},r,!1),this.frozenStates=f.preserveDataGrouping);if("month"===l||"year"===l)if(p){l=
{range:f,max:k,chart:d,dataMin:g,dataMax:n};var q=p.minFromRange.call(l);B(l.newMax)&&(k=l.newMax)}else e=f;else if(e)q=Math.max(k-e,g),k=Math.min(q+e,n);else if("ytd"===l)if(p)"undefined"===typeof n&&(g=Number.MAX_VALUE,n=Number.MIN_VALUE,d.series.forEach(function(a){a=a.xData;g=Math.min(a[0],g);n=Math.max(a[a.length-1],n)}),b=!1),k=this.getYTDExtremes(n,g,d.time.useUTC),q=z=k.min,k=k.max;else{this.deferredYTDClick=a;return}else"all"===l&&p&&(d.navigator&&d.navigator.baseSeries[0]&&(d.navigator.baseSeries[0].xAxis.options.range=
void 0),q=g,k=n);F(q)&&(q+=f._offsetMin);F(k)&&(k+=f._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=a+1);if(p)p.setExtremes(q,k,D(b,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:f});else{var t=M(d.options.xAxis)[0];var C=t.range;t.range=e;var v=t.min;t.min=z;h(d,"load",function(){t.range=C;t.min=v})}m(this,"afterBtnClick")}};a.prototype.setSelected=function(a){this.selected=this.options.selected=a};a.prototype.init=function(a){var b=this,c=a.options.rangeSelector,f=c.buttons||
b.defaultButtons.slice(),d=c.selected,e=function(){var a=b.minInput,f=b.maxInput;a&&a.blur&&m(a,"blur");f&&f.blur&&m(f,"blur")};b.chart=a;b.options=c;b.buttons=[];b.buttonOptions=f;this.eventsToUnbind=[];this.eventsToUnbind.push(h(a.container,"mousedown",e));this.eventsToUnbind.push(h(a,"resize",e));f.forEach(b.computeButtonRange);"undefined"!==typeof d&&f[d]&&this.clickButton(d,!1);this.eventsToUnbind.push(h(a,"load",function(){a.xAxis&&a.xAxis[0]&&h(a.xAxis[0],"setExtremes",function(f){this.max-
this.min!==a.fixedRange&&"rangeSelectorButton"!==f.trigger&&"updatedData"!==f.trigger&&b.forcedDataGrouping&&!b.frozenStates&&this.setDataGrouping(!1,!1)})}))};a.prototype.updateButtonStates=function(){var a=this,b=this.chart,c=this.dropdown,f=b.xAxis[0],d=Math.round(f.max-f.min),e=!f.hasVisibleSeries,g=b.scroller&&b.scroller.getUnionExtremes()||f,h=g.dataMin,k=g.dataMax;b=a.getYTDExtremes(k,h,b.time.useUTC);var l=b.min,m=b.max,r=a.selected,q=B(r),t=a.options.allButtonsEnabled,C=a.buttons;a.buttonOptions.forEach(function(b,
p){var g=b._range,n=b.type,x=b.count||1,u=C[p],z=0,L=b._offsetMax-b._offsetMin;b=p===r;var S=g>k-h,O=g<f.minRange,P=!1,R=!1;g=g===d;("month"===n||"year"===n)&&d+36E5>=864E5*{month:28,year:365}[n]*x-L&&d-36E5<=864E5*{month:31,year:366}[n]*x+L?g=!0:"ytd"===n?(g=m-l+L===d,P=!b):"all"===n&&(g=f.max-f.min>=k-h,R=!b&&q&&g);n=!t&&(S||O||R||e);x=b&&g||g&&!q&&!P||b&&a.frozenStates;n?z=3:x&&(q=!0,z=2);u.state!==z&&(u.setState(z),c&&(c.options[p+1].disabled=n,2===z&&(c.selectedIndex=p+1)),0===z&&r===p&&a.setSelected())})};
a.prototype.computeButtonRange=function(a){var b=a.type,c=a.count||1,f={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(f[b])a._range=f[b]*c;else if("month"===b||"year"===b)a._range=864E5*{month:30,year:365}[b]*c;a._offsetMin=D(a.offsetMin,0);a._offsetMax=D(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin};a.prototype.getInputValue=function(a){a="min"===a?this.minInput:this.maxInput;var b=this.chart.options.rangeSelector,c=this.chart.time;return a?("text"===a.type&&b.inputDateParser||
this.defaultInputDateParser)(a.value,c.useUTC,c):0};a.prototype.setInputValue=function(a,b){var c=this.options,f=this.chart.time,d="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:this.maxDateBox;if(d){var e=d.getAttribute("data-hc-time");e=F(e)?Number(e):void 0;F(b)&&(F(e)&&d.setAttribute("data-hc-time-previous",e),d.setAttribute("data-hc-time",b),e=b);d.value=f.dateFormat(this.inputTypeFormats[d.type]||c.inputEditDateFormat,e);a&&a.attr({text:f.dateFormat(c.inputDateFormat,e)})}};
a.prototype.setInputExtremes=function(a,b,c){if(a="min"===a?this.minInput:this.maxInput){var f=this.inputTypeFormats[a.type],d=this.chart.time;f&&(b=d.dateFormat(f,b),a.min!==b&&(a.min=b),c=d.dateFormat(f,c),a.max!==c&&(a.max=c))}};a.prototype.showInput=function(a){var b="min"===a?this.minDateBox:this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&b&&this.inputGroup){var c="text"===a.type,f=this.inputGroup,d=f.translateX;f=f.translateY;var e=this.options.inputBoxWidth;k(a,{width:c?b.width+
(e?-2:20)+"px":"auto",height:c?b.height-2+"px":"auto",border:"2px solid silver"});c&&e?k(a,{left:d+b.x+"px",top:f+"px"}):k(a,{left:Math.min(Math.round(b.x+d-(a.offsetWidth-b.width)/2),this.chart.chartWidth-a.offsetWidth)+"px",top:f-(a.offsetHeight-b.height)/2+"px"})}};a.prototype.hideInput=function(a){(a="min"===a?this.minInput:this.maxInput)&&k(a,{top:"-9999em",border:0,width:"1px",height:"1px"})};a.prototype.defaultInputDateParser=function(a,b,c){var f=a.split("/").join("-").split(" ").join("T");
-1===f.indexOf("T")&&(f+="T00:00");if(b)f+="Z";else{var d;if(d=v.isSafari)d=f,d=!(6<d.length&&(d.lastIndexOf("-")===d.length-6||d.lastIndexOf("+")===d.length-6));d&&(d=(new Date(f)).getTimezoneOffset()/60,f+=0>=d?"+"+H(-d)+":00":"-"+H(d)+":00")}f=Date.parse(f);B(f)||(a=a.split("-"),f=Date.UTC(I(a[0]),I(a[1])-1,I(a[2])));c&&b&&B(f)&&(f+=c.getTimezoneOffset(f));return f};a.prototype.drawInput=function(a){function c(){var b=h.getInputValue(a),f=g.xAxis[0],c=g.scroller&&g.scroller.xAxis?g.scroller.xAxis:
f,d=c.dataMin;c=c.dataMax;var e=h.maxInput,p=h.minInput;b!==Number(t.getAttribute("data-hc-time-previous"))&&B(b)&&(t.setAttribute("data-hc-time-previous",b),r&&e&&B(d)?b>Number(e.getAttribute("data-hc-time"))?b=void 0:b<d&&(b=d):p&&B(c)&&(b<Number(p.getAttribute("data-hc-time"))?b=void 0:b>c&&(b=c)),"undefined"!==typeof b&&f.setExtremes(r?b:f.min,r?f.max:b,void 0,void 0,{trigger:"rangeSelectorInput"}))}var g=this.chart,f=this.div,p=this.inputGroup,h=this,n=g.renderer.style||{},l=g.renderer,m=g.options.rangeSelector,
r="min"===a,q=e.lang[r?"rangeSelectorFrom":"rangeSelectorTo"];q=l.label(q,0).addClass("highcharts-range-label").attr({padding:q?2:0,height:q?m.inputBoxHeight:0}).add(p);l=l.label("",0).addClass("highcharts-range-input").attr({padding:2,width:m.inputBoxWidth,height:m.inputBoxHeight,"text-align":"center"}).on("click",function(){h.showInput(a);h[a+"Input"].focus()});g.styledMode||l.attr({stroke:m.inputBoxBorderColor,"stroke-width":1});l.add(p);var t=d("input",{name:a,className:"highcharts-range-selector"},
void 0,f);t.setAttribute("type",y(m.inputDateFormat||"%b %e, %Y"));g.styledMode||(q.css(G(n,m.labelStyle)),l.css(G({color:A.neutralColor80},n,m.inputStyle)),k(t,b({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:n.fontSize,fontFamily:n.fontFamily,top:"-9999em"},m.inputStyle)));t.onfocus=function(){h.showInput(a)};t.onblur=function(){t===v.doc.activeElement&&c();h.hideInput(a);h.setInputValue(a);t.blur()};var C=!1;t.onchange=
function(){C||(c(),h.hideInput(a),t.blur())};t.onkeypress=function(a){13===a.keyCode&&c()};t.onkeydown=function(a){C=!0;38!==a.keyCode&&40!==a.keyCode||c()};t.onkeyup=function(){C=!1};return{dateBox:l,input:t,label:q}};a.prototype.getPosition=function(){var a=this.chart,b=a.options.rangeSelector;a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}};a.prototype.getYTDExtremes=function(a,b,c){var f=this.chart.time,d=new f.Date(a),
e=f.get("FullYear",d);c=c?f.Date.UTC(e,0,1):+new f.Date(e,0,1);b=Math.max(b,c);d=d.getTime();return{max:Math.min(a||d,d),min:b}};a.prototype.render=function(a,b){var c=this.chart,f=c.renderer,e=c.container,g=c.options,h=g.rangeSelector,n=D(g.chart.style&&g.chart.style.zIndex,0)+1;g=h.inputEnabled;if(!1!==h.enabled){this.rendered||(this.group=f.g("range-selector-group").attr({zIndex:7}).add(),this.div=d("div",void 0,{position:"relative",height:0,zIndex:n}),this.buttonOptions.length&&this.renderButtons(),
e.parentNode&&e.parentNode.insertBefore(this.div,e),g&&(this.inputGroup=f.g("input-group").add(this.group),f=this.drawInput("min"),this.minDateBox=f.dateBox,this.minLabel=f.label,this.minInput=f.input,f=this.drawInput("max"),this.maxDateBox=f.dateBox,this.maxLabel=f.label,this.maxInput=f.input));if(g&&(this.setInputValue("min",a),this.setInputValue("max",b),a=c.scroller&&c.scroller.getUnionExtremes()||c.xAxis[0]||{},F(a.dataMin)&&F(a.dataMax)&&(c=c.xAxis[0].minRange||0,this.setInputExtremes("min",
a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-c),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+c,a.dataMax)),this.inputGroup)){var k=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(a){if(a){var b=a.getBBox().width;b&&(a.attr({x:k}),k+=b+h.inputSpacing)}})}this.alignElements();this.rendered=!0}};a.prototype.renderButtons=function(){var a=this,b=this.buttons,c=this.options,f=e.lang,g=this.chart.renderer,k=G(c.buttonTheme),l=k&&k.states,
r=k.width||28;delete k.width;delete k.states;this.buttonGroup=g.g("range-selector-buttons").add(this.group);var q=this.dropdown=d("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);h(q,"touchstart",function(){q.style.fontSize="16px"});[[v.isMS?"mouseover":"mouseenter"],[v.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(c){var f=c[0],d=c[1];h(q,f,function(){var c=b[a.currentButtonIndex()];c&&m(c.element,
d||f)})});this.zoomText=g.label(f&&f.rangeSelectorZoom||"",0).attr({padding:c.buttonTheme.padding,height:c.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(c.labelStyle),k["stroke-width"]=D(k["stroke-width"],0));d("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,q);this.buttonOptions.forEach(function(c,f){d("option",{textContent:c.title||c.text},void 0,q);b[f]=g.button(c.text,0,0,function(b){var d=c.events&&c.events.click,
e;d&&(e=d.call(c,b));!1!==e&&a.clickButton(f);a.isActive=!0},k,l&&l.hover,l&&l.select,l&&l.disabled).attr({"text-align":"center",width:r}).add(a.buttonGroup);c.title&&b[f].attr("title",c.title)})};a.prototype.alignElements=function(){var a=this,b=this.buttonGroup,c=this.buttons,f=this.chart,d=this.group,e=this.inputGroup,g=this.options,h=this.zoomText,k=f.options,l=k.exporting&&!1!==k.exporting.enabled&&k.navigation&&k.navigation.buttonOptions;k=g.buttonPosition;var m=g.inputPosition,r=g.verticalAlign,
q=function(b,c){return l&&a.titleCollision(f)&&"top"===r&&"right"===c.align&&c.y-b.getBBox().height-12<(l.y||0)+(l.height||0)+f.spacing[0]?-40:0},t=f.plotLeft;if(d&&k&&m){var C=k.x-f.spacing[3];if(b){this.positionButtons();if(!this.initialButtonGroupWidth){var v=0;h&&(v+=h.getBBox().width+5);c.forEach(function(a,b){v+=a.width;b!==c.length-1&&(v+=g.buttonSpacing)});this.initialButtonGroupWidth=v}t-=f.spacing[3];this.updateButtonStates();h=q(b,k);this.alignButtonGroup(h);d.placed=b.placed=f.hasLoaded}b=
0;e&&(b=q(e,m),"left"===m.align?C=t:"right"===m.align&&(C=-Math.max(f.axisOffset[1],-b)),e.align({y:m.y,width:e.getBBox().width,align:m.align,x:m.x+C-2},!0,f.spacingBox),e.placed=f.hasLoaded);this.handleCollision(b);d.align({verticalAlign:r},!0,f.spacingBox);e=d.alignAttr.translateY;b=d.getBBox().height+20;q=0;"bottom"===r&&(q=(q=f.legend&&f.legend.options)&&"bottom"===q.verticalAlign&&q.enabled&&!q.floating?f.legend.legendHeight+D(q.margin,10):0,b=b+q-20,q=e-b-(g.floating?0:g.y)-(f.titleOffset?f.titleOffset[2]:
0)-10);if("top"===r)g.floating&&(q=0),f.titleOffset&&f.titleOffset[0]&&(q=f.titleOffset[0]),q+=f.margin[0]-f.spacing[0]||0;else if("middle"===r)if(m.y===k.y)q=e;else if(m.y||k.y)q=0>m.y||0>k.y?q-Math.min(m.y,k.y):e-b;d.translate(g.x,g.y+Math.floor(q));k=this.minInput;m=this.maxInput;e=this.dropdown;g.inputEnabled&&k&&m&&(k.style.marginTop=d.translateY+"px",m.style.marginTop=d.translateY+"px");e&&(e.style.marginTop=d.translateY+"px")}};a.prototype.alignButtonGroup=function(a,b){var c=this.chart,f=
this.buttonGroup,d=this.options.buttonPosition,e=c.plotLeft-c.spacing[3],g=d.x-c.spacing[3];"right"===d.align?g+=a-e:"center"===d.align&&(g-=e/2);f&&f.align({y:d.y,width:D(b,this.initialButtonGroupWidth),align:d.align,x:g},!0,c.spacingBox)};a.prototype.positionButtons=function(){var a=this.buttons,b=this.chart,c=this.options,f=this.zoomText,d=b.hasLoaded?"animate":"attr",e=c.buttonPosition,g=b.plotLeft,h=g;f&&"hidden"!==f.visibility&&(f[d]({x:D(g+e.x,g)}),h+=e.x+f.getBBox().width+5);this.buttonOptions.forEach(function(b,
f){if("hidden"!==a[f].visibility)a[f][d]({x:h}),h+=a[f].width+c.buttonSpacing;else a[f][d]({x:g})})};a.prototype.handleCollision=function(a){var b=this,c=this.chart,f=this.buttonGroup,d=this.inputGroup,e=this.options,g=e.buttonPosition,h=e.dropdown,k=e.inputPosition;e=function(){var a=0;b.buttons.forEach(function(b){b=b.getBBox();b.width>a&&(a=b.width)});return a};var n=function(b){if(d&&f){var c=d.alignAttr.translateX+d.alignOptions.x-a+d.getBBox().x+2,e=d.alignOptions.width,p=f.alignAttr.translateX+
f.getBBox().x;return p+b>c&&c+e>p&&g.y<k.y+d.getBBox().height}return!1},l=function(){d&&f&&d.attr({translateX:d.alignAttr.translateX+(c.axisOffset[1]>=-a?0:-a),translateY:d.alignAttr.translateY+f.getBBox().height+10})};if(f){if("always"===h){this.collapseButtons(a);n(e())&&l();return}"never"===h&&this.expandButtons()}d&&f?k.align===g.align||n(this.initialButtonGroupWidth+20)?"responsive"===h?(this.collapseButtons(a),n(e())&&l()):l():"responsive"===h&&this.expandButtons():f&&"responsive"===h&&(this.initialButtonGroupWidth>
c.plotWidth?this.collapseButtons(a):this.expandButtons())};a.prototype.collapseButtons=function(a){var b=this.buttons,c=this.buttonOptions,f=this.chart,d=this.dropdown,e=this.options,g=this.zoomText,h=f.userOptions.rangeSelector&&f.userOptions.rangeSelector.buttonTheme||{},k=function(a){return{text:a?a+" \u25be":"\u25be",width:"auto",paddingLeft:D(e.buttonTheme.paddingLeft,h.padding,8),paddingRight:D(e.buttonTheme.paddingRight,h.padding,8)}};g&&g.hide();var n=!1;c.forEach(function(a,c){c=b[c];2!==
c.state?c.hide():(c.show(),c.attr(k(a.text)),n=!0)});n||(d&&(d.selectedIndex=0),b[0].show(),b[0].attr(k(this.zoomText&&this.zoomText.textStr)));c=e.buttonPosition.align;this.positionButtons();"right"!==c&&"center"!==c||this.alignButtonGroup(a,b[this.currentButtonIndex()].getBBox().width);this.showDropdown()};a.prototype.expandButtons=function(){var a=this.buttons,b=this.buttonOptions,c=this.options,f=this.zoomText;this.hideDropdown();f&&f.show();b.forEach(function(b,f){f=a[f];f.show();f.attr({text:b.text,
width:c.buttonTheme.width||28,paddingLeft:D(c.buttonTheme.paddingLeft,"unset"),paddingRight:D(c.buttonTheme.paddingRight,"unset")});2>f.state&&f.setState(0)});this.positionButtons()};a.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-1:0};a.prototype.showDropdown=function(){var a=this.buttonGroup,b=this.buttons,c=this.chart,f=this.dropdown;if(a&&f){var d=a.translateX;a=a.translateY;b=b[this.currentButtonIndex()].getBBox();k(f,{left:c.plotLeft+
d+"px",top:a+.5+"px",width:b.width+"px",height:b.height+"px"});this.hasVisibleDropdown=!0}};a.prototype.hideDropdown=function(){var a=this.dropdown;a&&(k(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};a.prototype.getHeight=function(){var a=this.options,b=this.group,c=a.y,f=a.buttonPosition.y,d=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=b?b.getBBox(!0).height+13+c:0;b=Math.min(d,f);if(0>d&&0>f||0<d&&0<f)a+=Math.abs(b);return a};a.prototype.titleCollision=
function(a){return!(a.options.title.text||a.options.subtitle.text)};a.prototype.update=function(a){var b=this.chart;G(!0,b.options.rangeSelector,a);this.destroy();this.init(b);this.render()};a.prototype.destroy=function(){var b=this,c=b.minInput,d=b.maxInput;b.eventsToUnbind&&(b.eventsToUnbind.forEach(function(a){return a()}),b.eventsToUnbind=void 0);J(b.buttons);c&&(c.onfocus=c.onblur=c.onchange=null);d&&(d.onfocus=d.onblur=d.onchange=null);g(b,function(c,d){c&&"chart"!==d&&(c instanceof r?c.destroy():
c instanceof window.HTMLElement&&E(c));c!==a.prototype[d]&&(b[d]=null)},this)};return a}();K.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];K.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",
time:"%H:%M:%S"};c.prototype.minFromRange=function(){var a=this.range,b=a.type,c=this.max,d=this.chart.time,f=function(a,c){var f="year"===b?"FullYear":"Month",e=new d.Date(a),g=d.get(f,e);d.set(f,e,g+c);g===d.get(f,e)&&d.set("Date",e,0);return e.getTime()-a};if(B(a)){var e=c-a;var g=a}else e=c+f(c,-a.count),this.chart&&(this.chart.fixedRange=c-e);var h=D(this.dataMin,Number.MIN_VALUE);B(e)||(e=h);e<=h&&(e=h,"undefined"===typeof g&&(g=f(e,a.count)),this.newMax=Math.min(e+g,this.dataMax));B(c)||(e=
void 0);return e};if(!v.RangeSelector){var w=[],N=function(b){function c(){e&&(d=b.xAxis[0].getExtremes(),f=b.legend,k=e&&e.options.verticalAlign,B(d.min)&&e.render(d.min,d.max),f.display&&"top"===k&&k===f.options.verticalAlign&&(g=G(b.spacingBox),g.y="vertical"===f.options.layout?b.plotTop:g.y+e.getHeight(),f.group.placed=!1,f.align(g)))}var d,e=b.rangeSelector,f,g,k;e&&(a(w,function(a){return a[0]===b})||w.push([b,[h(b.xAxis[0],"afterSetExtremes",function(a){e&&e.render(a.min,a.max)}),h(b,"redraw",
c)]]),c())};h(q,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new K(this))});h(q,"beforeRender",function(){var a=this.axes,b=this.rangeSelector;b&&(B(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=
!0)))});h(q,"update",function(a){var b=a.options.rangeSelector;a=this.rangeSelector;var c=this.extraBottomMargin,d=this.extraTopMargin;b&&b.enabled&&!F(a)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=a=new K(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(N(this),b=b&&b.verticalAlign||a.options&&a.options.verticalAlign,a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0)),this.extraBottomMargin!==c||this.extraTopMargin!==
d)&&(this.isDirtyBox=!0)});h(q,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))});h(q,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))});q.prototype.callbacks.push(N);h(q,"destroy",function(){for(var a=0;a<w.length;a++){var b=w[a];if(b[0]===this){b[1].forEach(function(a){return a()});
w.splice(a,1);break}}});v.RangeSelector=K}return K});I(c,"Core/Axis/NavigatorAxis.js",[c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,q){var v=c.isTouchDevice,t=q.addEvent,A=q.correctFloat,r=q.defined,l=q.isNumber,y=q.pick,e=function(){function c(c){this.axis=c}c.prototype.destroy=function(){this.axis=void 0};c.prototype.toFixedRange=function(c,e,h,q){var d=this.axis,b=d.chart;b=b&&b.fixedRange;var a=(d.pointRange||0)/2;c=y(h,d.translate(c,!0,!d.horiz));e=y(q,d.translate(e,!0,!d.horiz));
d=b&&(e-c)/b;r(h)||(c=A(c+a));r(q)||(e=A(e-a));.7<d&&1.3>d&&(q?c=e-b:e=c+b);l(c)&&l(e)||(c=e=void 0);return{min:c,max:e}};return c}();return function(){function c(){}c.compose=function(c){c.keepProps.push("navigatorAxis");t(c,"init",function(){this.navigatorAxis||(this.navigatorAxis=new e(this))});t(c,"zoom",function(c){var d=this.chart.options,e=d.navigator,h=this.navigatorAxis,b=d.chart.pinchType,a=d.rangeSelector;d=d.chart.zoomType;this.isXAxis&&(e&&e.enabled||a&&a.enabled)&&("y"===d?c.zoomed=
!1:(!v&&"xy"===d||v&&"xy"===b)&&this.options.range&&(e=h.previousZoom,r(c.newMin)?h.previousZoom=[this.min,this.max]:e&&(c.newMin=e[0],c.newMax=e[1],h.previousZoom=void 0)));"undefined"!==typeof c.zoomed&&c.preventDefault()})};c.AdditionsClass=e;return c}()});I(c,"Core/Navigator.js",[c["Core/Axis/Axis.js"],c["Core/Chart/Chart.js"],c["Core/Color/Color.js"],c["Core/Globals.js"],c["Core/Axis/NavigatorAxis.js"],c["Core/DefaultOptions.js"],c["Core/Color/Palette.js"],c["Core/Renderer/RendererRegistry.js"],
c["Core/Scrollbar.js"],c["Core/Series/Series.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,q,v,t,A,r,l,y,e,h,d,k){v=v.parse;var F=t.hasTouch,J=t.isTouchDevice,E=r.defaultOptions,b=k.addEvent,a=k.clamp,m=k.correctFloat,B=k.defined,G=k.destroyObjectProperties,g=k.erase,H=k.extend,D=k.find,I=k.isArray,M=k.isNumber,K=k.merge,w=k.pick,N=k.removeEvent,C=k.splat,n=function(a){for(var b=[],c=1;c<arguments.length;c++)b[c-1]=arguments[c];b=[].filter.call(b,M);if(b.length)return Math[a].apply(0,
b)};r="undefined"===typeof d.seriesTypes.areaspline?"line":"areaspline";H(E,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:l.neutralColor5,borderColor:l.neutralColor40},maskFill:v(l.highlightColor60).setOpacity(.3).get(),outlineColor:l.neutralColor20,outlineWidth:1,series:{type:r,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,
firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,
gridLineColor:l.neutralColor10,gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:l.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});y.getRendererType().prototype.symbols["navigator-handle"]=function(a,b,c,d,e){a=(e&&e.width||0)/2;b=Math.round(a/3)+.5;e=e&&e.height||0;return[["M",-a-1,.5],["L",
a,.5],["L",a,e+.5],["L",-a-1,e+.5],["L",-a-1,.5],["M",-b,4],["L",-b,e-3],["M",b-1,4],["L",b-1,e-3]]};var z=function(){function d(a){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(a)}d.prototype.drawHandle=function(a,
b,c,d){var f=this.navigatorOptions.handles.height;this.handles[b][d](c?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(a,10)+.5-f)}:{translateX:Math.round(this.left+parseInt(a,10)),translateY:Math.round(this.top+this.height/2-f/2-1)})};d.prototype.drawOutline=function(a,b,c,d){var f=this.navigatorOptions.maskInside,e=this.outline.strokeWidth(),g=e/2,h=e%2/2;e=this.outlineHeight;var p=this.scrollbarHeight||0,k=this.size,l=this.left-p,m=this.top;c?(l-=g,c=m+b+
h,b=m+a+h,h=[["M",l+e,m-p-h],["L",l+e,c],["L",l,c],["L",l,b],["L",l+e,b],["L",l+e,m+k+p]],f&&h.push(["M",l+e,c-g],["L",l+e,b+g])):(a+=l+p-h,b+=l+p-h,m+=g,h=[["M",l,m],["L",a,m],["L",a,m+e],["L",b,m+e],["L",b,m],["L",l+k+2*p,m]],f&&h.push(["M",a-g,m],["L",b+g,m]));this.outline[d]({d:h})};d.prototype.drawMasks=function(a,b,c,d){var f=this.left,e=this.top,g=this.height;if(c){var h=[f,f,f];var p=[e,e+a,e+b];var k=[g,g,g];var l=[a,b-a,this.size-b]}else h=[f,f+a,f+b],p=[e,e,e],k=[a,b-a,this.size-b],l=[g,
g,g];this.shades.forEach(function(a,b){a[d]({x:h[b],y:p[b],width:k[b],height:l[b]})})};d.prototype.renderElements=function(){var a=this,b=a.navigatorOptions,c=b.maskInside,d=a.chart,e=d.renderer,g,h={cursor:d.inverted?"ns-resize":"ew-resize"};a.navigatorGroup=g=e.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!c,c,!c].forEach(function(c,f){a.shades[f]=e.rect().addClass("highcharts-navigator-mask"+(1===f?"-inside":"-outside")).add(g);d.styledMode||a.shades[f].attr({fill:c?b.maskFill:"rgba(0,0,0,0)"}).css(1===
f&&h)});a.outline=e.path().addClass("highcharts-navigator-outline").add(g);d.styledMode||a.outline.attr({"stroke-width":b.outlineWidth,stroke:b.outlineColor});b.handles.enabled&&[0,1].forEach(function(c){b.handles.inverted=d.inverted;a.handles[c]=e.symbol(b.handles.symbols[c],-b.handles.width/2-1,0,b.handles.width,b.handles.height,b.handles);a.handles[c].attr({zIndex:7-c}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][c]).add(g);if(!d.styledMode){var f=b.handles;
a.handles[c].attr({fill:f.backgroundColor,stroke:f.borderColor,"stroke-width":f.lineWidth}).css(h)}})};d.prototype.update=function(a){(this.series||[]).forEach(function(a){a.baseSeries&&delete a.baseSeries.navigatorSeries});this.destroy();K(!0,this.chart.options.navigator,this.options,a);this.init(this.chart)};d.prototype.render=function(b,c,d,e){var f=this.chart,g=this.scrollbarHeight,h,p=this.xAxis,k=p.pointRange||0;var l=p.navigatorAxis.fake?f.xAxis[0]:p;var n=this.navigatorEnabled,q,r=this.rendered;
var x=f.inverted;var t=f.xAxis[0].minRange,u=f.xAxis[0].options.maxRange;if(!this.hasDragged||B(d)){b=m(b-k/2);c=m(c+k/2);if(!M(b)||!M(c))if(r)d=0,e=w(p.width,l.width);else return;this.left=w(p.left,f.plotLeft+g+(x?f.plotWidth:0));this.size=q=h=w(p.len,(x?f.plotHeight:f.plotWidth)-2*g);f=x?g:h+2*g;d=w(d,p.toPixels(b,!0));e=w(e,p.toPixels(c,!0));M(d)&&Infinity!==Math.abs(d)||(d=0,e=f);b=p.toValue(d,!0);c=p.toValue(e,!0);var v=Math.abs(m(c-b));v<t?this.grabbedLeft?d=p.toPixels(c-t-k,!0):this.grabbedRight&&
(e=p.toPixels(b+t+k,!0)):B(u)&&m(v-k)>u&&(this.grabbedLeft?d=p.toPixels(c-u-k,!0):this.grabbedRight&&(e=p.toPixels(b+u+k,!0)));this.zoomedMax=a(Math.max(d,e),0,q);this.zoomedMin=a(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(d,e),0,q);this.range=this.zoomedMax-this.zoomedMin;q=Math.round(this.zoomedMax);d=Math.round(this.zoomedMin);n&&(this.navigatorGroup.attr({visibility:"visible"}),r=r&&!this.hasDragged?"animate":"attr",this.drawMasks(d,q,x,r),this.drawOutline(d,q,x,r),this.navigatorOptions.handles.enabled&&
(this.drawHandle(d,0,x,r),this.drawHandle(q,1,x,r)));this.scrollbar&&(x?(x=this.top-g,l=this.left-g+(n||!l.opposite?0:(l.titleOffset||0)+l.axisTitleMargin),g=h+2*g):(x=this.top+(n?this.height:-g),l=this.left-g),this.scrollbar.position(l,x,f,g),this.scrollbar.setRange(this.zoomedMin/(h||1),this.zoomedMax/(h||1)));this.rendered=!0}};d.prototype.addMouseEvents=function(){var a=this,c=a.chart,d=c.container,e=[],g,h;a.mouseMoveHandler=g=function(b){a.onMouseMove(b)};a.mouseUpHandler=h=function(b){a.onMouseUp(b)};
e=a.getPartsEvents("mousedown");e.push(b(c.renderTo,"mousemove",g),b(d.ownerDocument,"mouseup",h));F&&(e.push(b(c.renderTo,"touchmove",g),b(d.ownerDocument,"touchend",h)),e.concat(a.getPartsEvents("touchstart")));a.eventsToUnbind=e;a.series&&a.series[0]&&e.push(b(a.series[0].xAxis,"foundExtremes",function(){c.navigator.modifyNavigatorAxisExtremes()}))};d.prototype.getPartsEvents=function(a){var c=this,d=[];["shades","handles"].forEach(function(f){c[f].forEach(function(e,g){d.push(b(e.element,a,function(a){c[f+
"Mousedown"](a,g)}))})});return d};d.prototype.shadesMousedown=function(a,b){a=this.chart.pointer.normalize(a);var c=this.chart,d=this.xAxis,f=this.zoomedMin,e=this.left,g=this.size,h=this.range,p=a.chartX;c.inverted&&(p=a.chartY,e=this.top);if(1===b)this.grabbedCenter=p,this.fixedWidth=h,this.dragOffset=p-f;else{a=p-e-h/2;if(0===b)a=Math.max(0,a);else if(2===b&&a+h>=g)if(a=g-h,this.reversedExtremes){a-=h;var k=this.getUnionExtremes().dataMin}else var l=this.getUnionExtremes().dataMax;a!==f&&(this.fixedWidth=
h,b=d.navigatorAxis.toFixedRange(a,a+h,k,l),B(b.min)&&c.xAxis[0].setExtremes(Math.min(b.min,b.max),Math.max(b.min,b.max),!0,null,{trigger:"navigator"}))}};d.prototype.handlesMousedown=function(a,b){this.chart.pointer.normalize(a);a=this.chart;var c=a.xAxis[0],d=this.reversedExtremes;0===b?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=d?c.min:c.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=d?c.max:c.min);a.fixedRange=null};d.prototype.onMouseMove=
function(a){var b=this,c=b.chart,d=b.left,f=b.navigatorSize,e=b.range,g=b.dragOffset,h=c.inverted;a.touches&&0===a.touches[0].pageX||(a=c.pointer.normalize(a),c=a.chartX,h&&(d=b.top,c=a.chartY),b.grabbedLeft?(b.hasDragged=!0,b.render(0,0,c-d,b.otherHandlePos)):b.grabbedRight?(b.hasDragged=!0,b.render(0,0,b.otherHandlePos,c-d)):b.grabbedCenter&&(b.hasDragged=!0,c<g?c=g:c>f+g-e&&(c=f+g-e),b.render(0,0,c-g,c-g+e)),b.hasDragged&&b.scrollbar&&w(b.scrollbar.options.liveRedraw,t.svg&&!J&&!this.chart.isBoosting)&&
(a.DOMType=a.type,setTimeout(function(){b.onMouseUp(a)},0)))};d.prototype.onMouseUp=function(a){var b=this.chart,c=this.xAxis,d=this.scrollbar,f=a.DOMEvent||a,e=b.inverted,g=this.rendered&&!this.hasDragged?"animate":"attr";if(this.hasDragged&&(!d||!d.hasDragged)||"scrollbar"===a.trigger){d=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var h=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var k=this.fixedExtreme;this.zoomedMax===this.size&&(k=this.reversedExtremes?
d.dataMin:d.dataMax);0===this.zoomedMin&&(h=this.reversedExtremes?d.dataMax:d.dataMin);c=c.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,h,k);B(c.min)&&b.xAxis[0].setExtremes(Math.min(c.min,c.max),Math.max(c.min,c.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:f})}"mousemove"!==a.DOMType&&"touchmove"!==a.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=
null);this.navigatorEnabled&&M(this.zoomedMin)&&M(this.zoomedMax)&&(b=Math.round(this.zoomedMin),a=Math.round(this.zoomedMax),this.shades&&this.drawMasks(b,a,e,g),this.outline&&this.drawOutline(b,a,e,g),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(b,0,e,g),this.drawHandle(a,1,e,g)))};d.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(a){a()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()};
d.prototype.removeBaseSeriesEvents=function(){var a=this.baseSeries||[];this.navigatorEnabled&&a[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&a.forEach(function(a){N(a,"updatedData",this.updatedDataHandler)},this),a[0].xAxis&&N(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};d.prototype.init=function(a){var d=a.options,f=d.navigator,g=f.enabled,h=d.scrollbar,k=h.enabled;d=g?f.height:0;var l=k?h.height:0;this.handles=[];this.shades=[];this.chart=a;this.setBaseSeries();this.height=
d;this.scrollbarHeight=l;this.scrollbarEnabled=k;this.navigatorEnabled=g;this.navigatorOptions=f;this.scrollbarOptions=h;this.outlineHeight=d+l;this.opposite=w(f.opposite,!(g||!a.inverted));var m=this;g=m.baseSeries;h=a.xAxis.length;k=a.yAxis.length;var q=g&&g[0]&&g[0].xAxis||a.xAxis[0]||{options:{}};a.isDirtyBox=!0;m.navigatorEnabled?(m.xAxis=new c(a,K({breaks:q.options.breaks,ordinal:q.options.ordinal},f.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:h,isInternal:!0,
offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},a.inverted?{offsets:[l,0,-l,0],width:d}:{offsets:[0,-l,0,l],height:d})),m.yAxis=new c(a,K(f.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:k,isInternal:!0,reversed:w(f.yAxis&&f.yAxis.reversed,a.yAxis[0]&&a.yAxis[0].reversed,!1),zoomEnabled:!1},a.inverted?{width:d}:{height:d})),g||f.series.data?m.updateNavigatorSeries(!1):0===a.series.length&&(m.unbindRedraw=b(a,"beforeRedraw",function(){0<
a.series.length&&!m.series&&(m.setBaseSeries(),m.unbindRedraw())})),m.reversedExtremes=a.inverted&&!m.xAxis.reversed||!a.inverted&&m.xAxis.reversed,m.renderElements(),m.addMouseEvents()):(m.xAxis={chart:a,navigatorAxis:{fake:!0},translate:function(b,c){var d=a.xAxis[0],f=d.getExtremes(),e=d.len-2*l,g=n("min",d.options.min,f.dataMin);d=n("max",d.options.max,f.dataMax)-g;return c?b*d/e+g:e*(b-g)/d},toPixels:function(a){return this.translate(a)},toValue:function(a){return this.translate(a,!0)}},m.xAxis.navigatorAxis.axis=
m.xAxis,m.xAxis.navigatorAxis.toFixedRange=A.AdditionsClass.prototype.toFixedRange.bind(m.xAxis.navigatorAxis));a.options.scrollbar.enabled&&(a.scrollbar=m.scrollbar=new e(a.renderer,K(a.options.scrollbar,{margin:m.navigatorEnabled?0:10,vertical:a.inverted}),a),b(m.scrollbar,"changed",function(a){var b=m.size,c=b*this.to;b*=this.from;m.hasDragged=m.scrollbar.hasDragged;m.render(0,0,b,c);this.shouldUpdateExtremes(a.DOMType)&&setTimeout(function(){m.onMouseUp(a)})}));m.addBaseSeriesEvents();m.addChartEvents()};
d.prototype.getUnionExtremes=function(a){var b=this.chart.xAxis[0],c=this.xAxis,d=c.options,f=b.options,e;a&&null===b.dataMin||(e={dataMin:w(d&&d.min,n("min",f.min,b.dataMin,c.dataMin,c.min)),dataMax:w(d&&d.max,n("max",f.max,b.dataMax,c.dataMax,c.max))});return e};d.prototype.setBaseSeries=function(a,b){var c=this.chart,d=this.baseSeries=[];a=a||c.options&&c.options.navigator.baseSeries||(c.series.length?D(c.series,function(a){return!a.options.isInternal}).index:0);(c.series||[]).forEach(function(b,
c){b.options.isInternal||!b.options.showInNavigator&&(c!==a&&b.options.id!==a||!1===b.options.showInNavigator)||d.push(b)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,b)};d.prototype.updateNavigatorSeries=function(a,b){var c=this,d=c.chart,f=c.baseSeries,e,g,h=c.navigatorOptions.series,k,l={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},
p=c.series=(c.series||[]).filter(function(a){var b=a.baseSeries;return 0>f.indexOf(b)?(b&&(N(b,"updatedData",c.updatedDataHandler),delete b.navigatorSeries),a.chart&&a.destroy(),!1):!0});f&&f.length&&f.forEach(function(a){var m=a.navigatorSeries,n=H({color:a.color,visible:a.visible},I(h)?E.navigator.series:h);m&&!1===c.navigatorOptions.adaptToUpdatedData||(l.name="Navigator "+f.length,e=a.options||{},k=e.navigatorOptions||{},n.dataLabels=C(n.dataLabels),g=K(e,l,n,k),g.pointRange=w(n.pointRange,k.pointRange,
E.plotOptions[g.type||"line"].pointRange),n=k.data||n.data,c.hasNavigatorData=c.hasNavigatorData||!!n,g.data=n||e.data&&e.data.slice(0),m&&m.options?m.update(g,b):(a.navigatorSeries=d.initSeries(g),a.navigatorSeries.baseSeries=a,p.push(a.navigatorSeries)))});if(h.data&&(!f||!f.length)||I(h))c.hasNavigatorData=!1,h=C(h),h.forEach(function(a,b){l.name="Navigator "+(p.length+1);g=K(E.navigator.series,{color:d.series[b]&&!d.series[b].options.isInternal&&d.series[b].color||d.options.colors[b]||d.options.colors[0]},
l,a);g.data=a.data;g.data&&(c.hasNavigatorData=!0,p.push(d.initSeries(g)))});a&&this.addBaseSeriesEvents()};d.prototype.addBaseSeriesEvents=function(){var a=this,c=a.baseSeries||[];c[0]&&c[0].xAxis&&c[0].eventsToUnbind.push(b(c[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes));c.forEach(function(c){c.eventsToUnbind.push(b(c,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)}));c.eventsToUnbind.push(b(c,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,
!1)}));!1!==this.navigatorOptions.adaptToUpdatedData&&c.xAxis&&c.eventsToUnbind.push(b(c,"updatedData",this.updatedDataHandler));c.eventsToUnbind.push(b(c,"remove",function(){this.navigatorSeries&&(g(a.series,this.navigatorSeries),B(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)};d.prototype.getBaseSeriesMin=function(a){return this.baseSeries.reduce(function(a,b){return Math.min(a,b.xData?b.xData[0]:a)},a)};d.prototype.modifyNavigatorAxisExtremes=
function(){var a=this.xAxis,b;"undefined"!==typeof a.getExtremes&&(!(b=this.getUnionExtremes(!0))||b.dataMin===a.min&&b.dataMax===a.max||(a.min=b.dataMin,a.max=b.dataMax))};d.prototype.modifyBaseAxisExtremes=function(){var a=this.chart.navigator,b=this.getExtremes(),c=b.dataMin,d=b.dataMax;b=b.max-b.min;var e=a.stickToMin,g=a.stickToMax,h=w(this.options.overscroll,0),k=a.series&&a.series[0],l=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(e){var m=c;var n=
m+b}g&&(n=d+h,e||(m=Math.max(c,n-b,a.getBaseSeriesMin(k&&k.xData?k.xData[0]:-Number.MAX_VALUE))));l&&(e||g)&&M(m)&&(this.min=this.userMin=m,this.max=this.userMax=n)}a.stickToMin=a.stickToMax=null};d.prototype.updatedDataHandler=function(){var a=this.chart.navigator,b=this.navigatorSeries;a.stickToMax=a.reversedExtremes?0===Math.round(a.zoomedMin):Math.round(a.zoomedMax)>=Math.round(a.size);a.stickToMin=a.shouldStickToMin(this,a);b&&!a.hasNavigatorData&&(b.options.pointStart=this.xData[0],b.setData(this.options.data,
!1,null,!1))};d.prototype.shouldStickToMin=function(a,b){b=b.getBaseSeriesMin(a.xData[0]);var c=a.xAxis;a=c.max;var d=c.min;c=c.options.range;var e=!0;M(a)&&M(d)&&(e=c&&0<a-b?a-b<c&&!this.chart.fixedRange:d<=b);return e};d.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(b(this.chart,"redraw",function(){var a=this.navigator,b=a&&(a.baseSeries&&a.baseSeries[0]&&a.baseSeries[0].xAxis||this.xAxis[0]);b&&a.render(b.min,b.max)}),b(this.chart,"getMargins",
function(){var a=this.navigator,b=a.opposite?"plotTop":"marginBottom";this.inverted&&(b=a.opposite?"marginRight":"plotLeft");this[b]=(this[b]||0)+(a.navigatorEnabled||!this.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))};d.prototype.destroy=function(){this.removeEvents();this.xAxis&&(g(this.chart.xAxis,this.xAxis),g(this.chart.axes,this.xAxis));this.yAxis&&(g(this.chart.yAxis,this.yAxis),g(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(a){a.destroy&&a.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(a){this[a]&&
this[a].destroy&&this[a].destroy();this[a]=null},this);[this.handles].forEach(function(a){G(a)},this)};return d}();t.Navigator||(t.Navigator=z,A.compose(c),b(q,"beforeShowResetZoom",function(){var a=this.options,b=a.navigator,c=a.rangeSelector;if((b&&b.enabled||c&&c.enabled)&&(!J&&"x"===a.chart.zoomType||J&&"x"===a.chart.pinchType))return!1}),b(q,"beforeRender",function(){var a=this.options;if(a.navigator.enabled||a.scrollbar.enabled)this.scroller=this.navigator=new z(this)}),b(q,"afterSetChartSize",
function(){var a=this.legend,b=this.navigator;if(b){var c=a&&a.options;var d=b.xAxis;var e=b.yAxis;var g=b.scrollbarHeight;this.inverted?(b.left=b.opposite?this.chartWidth-g-b.height:this.spacing[3]+g,b.top=this.plotTop+g):(b.left=w(d.left,this.plotLeft+g),b.top=b.navigatorOptions.top||this.chartHeight-b.height-g-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(c&&"bottom"===c.verticalAlign&&"proximate"!==c.layout&&c.enabled&&!c.floating?a.legendHeight+
w(c.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));d&&e&&(this.inverted?d.options.left=e.options.left=b.left:d.options.top=e.options.top=b.top,d.setAxisSize(),e.setAxisSize())}}),b(q,"update",function(a){var b=a.options.navigator||{},c=a.options.scrollbar||{};this.navigator||this.scroller||!b.enabled&&!c.enabled||(K(!0,this.options.navigator,b),K(!0,this.options.scrollbar,c),delete a.options.navigator,delete a.options.scrollbar)}),b(q,"afterUpdate",function(a){this.navigator||this.scroller||
!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new z(this),w(a.redraw,!0)&&this.redraw(a.animation))}),b(q,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),b(h,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),q.prototype.callbacks.push(function(a){var b=a.navigator;b&&a.xAxis[0]&&(a=a.xAxis[0].getExtremes(),b.render(a.min,a.max))}));t.Navigator=
z;return t.Navigator});I(c,"masters/modules/gantt.src.js",[c["Core/Globals.js"],c["Core/Chart/GanttChart.js"]],function(c,q){c.GanttChart=q;c.ganttChart=q.ganttChart})});
//# sourceMappingURL=gantt.js.map