"use strict";!function(e){"object"==typeof module&&module.exports?module.exports=e.default=e:"function"==typeof define&&define.amd?define("highcharts/modules/networkgraph",["highcharts"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){t=t?t._modules:{};function e(t,e,o,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,o))}e(t,"Mixins/Nodes.js",[t["Core/Globals.js"],t["Core/Series/Point.js"],t["Core/Series/Series.js"],t["Core/Utilities.js"]],function(t,i,s,e){var n=e.defined,r=e.extend,a=e.find,h=e.pick;return t.NodesMixin={createNode:function(t){function e(t,e){return a(t,function(t){return t.id===e})}var o,s=e(this.nodes,t),i=this.pointClass;return s||(o=this.options.nodes&&e(this.options.nodes,t),(s=(new i).init(this,r({className:"highcharts-node",isNode:!0,id:t,y:1},o))).linksTo=[],s.linksFrom=[],s.formatPrefix="node",s.name=s.name||s.options.id||"",s.mass=h(s.options.mass,s.options.marker&&s.options.marker.radius,this.options.marker&&this.options.marker.radius,4),s.getSum=function(){var e=0,o=0;return s.linksTo.forEach(function(t){e+=t.weight}),s.linksFrom.forEach(function(t){o+=t.weight}),Math.max(e,o)},s.offset=function(t,e){for(var o=0,i=0;i<s[e].length;i++){if(s[e][i]===t)return o;o+=s[e][i].weight}},s.hasShape=function(){var e=0;return s.linksTo.forEach(function(t){t.outgoing&&e++}),!s.linksTo.length||e!==s.linksTo.length},this.nodes.push(s)),s},generatePoints:function(){var e=this.chart,o={};s.prototype.generatePoints.call(this),this.nodes||(this.nodes=[]),this.colorCounter=0,this.nodes.forEach(function(t){t.linksFrom.length=0,t.linksTo.length=0,t.level=t.options.level}),this.points.forEach(function(t){n(t.from)&&(o[t.from]||(o[t.from]=this.createNode(t.from)),o[t.from].linksFrom.push(t),t.fromNode=o[t.from],e.styledMode?t.colorIndex=h(t.options.colorIndex,o[t.from].colorIndex):t.color=t.options.color||o[t.from].color),n(t.to)&&(o[t.to]||(o[t.to]=this.createNode(t.to)),o[t.to].linksTo.push(t),t.toNode=o[t.to]),t.name=t.name||t.id},this),this.nodeLookup=o},setData:function(){this.nodes&&(this.nodes.forEach(function(t){t.destroy()}),this.nodes.length=0),s.prototype.setData.apply(this,arguments)},destroy:function(){return this.data=[].concat(this.points||[],this.nodes),s.prototype.destroy.apply(this,arguments)},setNodeState:function(t){var e=arguments,o=this.isNode?this.linksTo.concat(this.linksFrom):[this.fromNode,this.toNode];"select"!==t&&o.forEach(function(t){t&&t.series&&(i.prototype.setState.apply(t,e),t.isNode||(t.fromNode.graphic&&i.prototype.setState.apply(t.fromNode,e),t.toNode&&t.toNode.graphic&&i.prototype.setState.apply(t.toNode,e)))}),i.prototype.setState.apply(this,e)}}}),e(t,"Series/Networkgraph/Integrations.js",[t["Core/Globals.js"]],function(t){t.networkgraphIntegrations={verlet:{attractiveForceFunction:function(t,e){return(e-t)/t},repulsiveForceFunction:function(t,e){return(e-t)/t*(t<e?1:0)},barycenter:function(){var t=this.options.gravitationalConstant,e=this.barycenter.xFactor,o=this.barycenter.yFactor,e=(e-(this.box.left+this.box.width)/2)*t,o=(o-(this.box.top+this.box.height)/2)*t;this.nodes.forEach(function(t){t.fixedPosition||(t.plotX-=e/t.mass/t.degree,t.plotY-=o/t.mass/t.degree)})},repulsive:function(t,e,o){e=e*this.diffTemperature/t.mass/t.degree;t.fixedPosition||(t.plotX+=o.x*e,t.plotY+=o.y*e)},attractive:function(t,e,o){var i=t.getMass(),s=-o.x*e*this.diffTemperature,e=-o.y*e*this.diffTemperature;t.fromNode.fixedPosition||(t.fromNode.plotX-=s*i.fromNode/t.fromNode.degree,t.fromNode.plotY-=e*i.fromNode/t.fromNode.degree),t.toNode.fixedPosition||(t.toNode.plotX+=s*i.toNode/t.toNode.degree,t.toNode.plotY+=e*i.toNode/t.toNode.degree)},integrate:function(t,e){var o=-t.options.friction,i=t.options.maxSpeed,s=e.prevX,n=e.prevY,r=(e.plotX+e.dispX-s)*o,s=(e.plotY+e.dispY-n)*o,n=Math.abs,o=n(r)/(r||1),n=n(s)/(s||1),r=o*Math.min(i,Math.abs(r)),s=n*Math.min(i,Math.abs(s));e.prevX=e.plotX+e.dispX,e.prevY=e.plotY+e.dispY,e.plotX+=r,e.plotY+=s,e.temperature=t.vectorLength({x:r,y:s})},getK:function(t){return Math.pow(t.box.width*t.box.height/t.nodes.length,.5)}},euler:{attractiveForceFunction:function(t,e){return t*t/e},repulsiveForceFunction:function(t,e){return e*e/t},barycenter:function(){var o=this.options.gravitationalConstant,i=this.barycenter.xFactor,s=this.barycenter.yFactor;this.nodes.forEach(function(t){var e;t.fixedPosition||(e=t.getDegree(),t.dispX+=(i-t.plotX)*o*(e=e*(1+e/2))/t.degree,t.dispY+=(s-t.plotY)*o*e/t.degree)})},repulsive:function(t,e,o,i){t.dispX+=o.x/i*e/t.degree,t.dispY+=o.y/i*e/t.degree},attractive:function(t,e,o,i){var s=t.getMass(),n=o.x/i*e,e=o.y/i*e;t.fromNode.fixedPosition||(t.fromNode.dispX-=n*s.fromNode/t.fromNode.degree,t.fromNode.dispY-=e*s.fromNode/t.fromNode.degree),t.toNode.fixedPosition||(t.toNode.dispX+=n*s.toNode/t.toNode.degree,t.toNode.dispY+=e*s.toNode/t.toNode.degree)},integrate:function(t,e){var o;e.dispX+=e.dispX*t.options.friction,e.dispY+=e.dispY*t.options.friction,0!==(o=e.temperature=t.vectorLength({x:e.dispX,y:e.dispY}))&&(e.plotX+=e.dispX/o*Math.min(Math.abs(e.dispX),t.temperature),e.plotY+=e.dispY/o*Math.min(Math.abs(e.dispY),t.temperature))},getK:function(t){return Math.pow(t.box.width*t.box.height/t.nodes.length,.3)}}}}),e(t,"Series/Networkgraph/QuadTree.js",[t["Core/Globals.js"],t["Core/Utilities.js"]],function(t,e){var e=e.extend,s=t.QuadTreeNode=function(t){this.box=t,this.boxSize=Math.min(t.width,t.height),this.nodes=[],this.isInternal=!1,this.body=!1,this.isEmpty=!0};e(s.prototype,{insert:function(t,e){this.isInternal?this.nodes[this.getBoxPosition(t)].insert(t,e-1):(this.isEmpty=!1,this.body?e?(this.isInternal=!0,this.divideBox(),!0!==this.body&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,e-1),this.body=!0),this.nodes[this.getBoxPosition(t)].insert(t,e-1)):((e=new s({top:t.plotX,left:t.plotY,width:.1,height:.1})).body=t,e.isInternal=!1,this.nodes.push(e)):(this.isInternal=!1,this.body=t))},updateMassAndCenter:function(){var e=0,o=0,i=0;this.isInternal?(this.nodes.forEach(function(t){t.isEmpty||(e+=t.mass,o+=t.plotX*t.mass,i+=t.plotY*t.mass)}),o/=e,i/=e):this.body&&(e=this.body.mass,o=this.body.plotX,i=this.body.plotY),this.mass=e,this.plotX=o,this.plotY=i},divideBox:function(){var t=this.box.width/2,e=this.box.height/2;this.nodes[0]=new s({left:this.box.left,top:this.box.top,width:t,height:e}),this.nodes[1]=new s({left:this.box.left+t,top:this.box.top,width:t,height:e}),this.nodes[2]=new s({left:this.box.left+t,top:this.box.top+e,width:t,height:e}),this.nodes[3]=new s({left:this.box.left,top:this.box.top+e,width:t,height:e})},getBoxPosition:function(t){var e=t.plotX<this.box.left+this.box.width/2,t=t.plotY<this.box.top+this.box.height/2,t=e?t?0:3:t?1:2;return t}}),e((t.QuadTree=function(t,e,o,i){this.box={left:t,top:e,width:o,height:i},this.maxDepth=25,this.root=new s(this.box,"0"),this.root.isInternal=!0,this.root.isRoot=!0,this.root.divideBox()}).prototype,{insertNodes:function(t){t.forEach(function(t){this.root.insert(t,this.maxDepth)},this)},visitNodeRecursive:function(t,e,o){var i;t=t||this.root,!1!==(i=t===this.root&&e?e(t):i)&&(t.nodes.forEach(function(t){if(t.isInternal){if(!1===(i=e?e(t):i))return;this.visitNodeRecursive(t,e,o)}else t.body&&e&&e(t.body);o&&o(t)},this),t===this.root&&o&&o(t))},calculateMassAndCenter:function(){this.visitNodeRecursive(null,null,function(t){t.updateMassAndCenter()})}})}),e(t,"Series/Networkgraph/Layouts.js",[t["Core/Chart/Chart.js"],t["Core/Animation/AnimationUtilities.js"],t["Core/Globals.js"],t["Core/Utilities.js"]],function(t,e,o,i){var s=e.setAnimation,n=i.addEvent,r=i.clamp,a=i.defined,e=i.extend,h=i.isFunction,p=i.pick;o.layouts={"reingold-fruchterman":function(){}},e(o.layouts["reingold-fruchterman"].prototype,{init:function(t){this.options=t,this.nodes=[],this.links=[],this.series=[],this.box={x:0,y:0,width:0,height:0},this.setInitialRendering(!0),this.integration=o.networkgraphIntegrations[t.integration],this.enableSimulation=t.enableSimulation,this.attractiveForce=p(t.attractiveForce,this.integration.attractiveForceFunction),this.repulsiveForce=p(t.repulsiveForce,this.integration.repulsiveForceFunction),this.approximation=t.approximation},updateSimulation:function(t){this.enableSimulation=p(t,this.options.enableSimulation)},start:function(){var t=this,e=this.series,o=this.options;t.currentStep=0,t.forces=e[0]&&e[0].forces||[],t.chart=e[0]&&e[0].chart,t.initialRendering&&(t.initPositions(),e.forEach(function(t){t.finishedAnimating=!0,t.render()})),t.setK(),t.resetSimulation(o),t.enableSimulation&&t.step()},step:function(){var e=this,t=this.series;this.options;e.currentStep++,"barnes-hut"===e.approximation&&(e.createQuadTree(),e.quadTree.calculateMassAndCenter()),e.forces.forEach(function(t){e[t+"Forces"](e.temperature)}),e.applyLimits(e.temperature),e.temperature=e.coolDown(e.startTemperature,e.diffTemperature,e.currentStep),e.prevSystemTemperature=e.systemTemperature,e.systemTemperature=e.getSystemTemperature(),e.enableSimulation&&(t.forEach(function(t){t.chart&&t.render()}),e.maxIterations--&&isFinite(e.temperature)&&!e.isStable()?(e.simulation&&o.win.cancelAnimationFrame(e.simulation),e.simulation=o.win.requestAnimationFrame(function(){e.step()})):e.simulation=!1)},stop:function(){this.simulation&&o.win.cancelAnimationFrame(this.simulation)},setArea:function(t,e,o,i){this.box={left:t,top:e,width:o,height:i}},setK:function(){this.k=this.options.linkLength||this.integration.getK(this)},addElementsToCollection:function(t,e){t.forEach(function(t){-1===e.indexOf(t)&&e.push(t)})},removeElementFromCollection:function(t,e){t=e.indexOf(t);-1!==t&&e.splice(t,1)},clear:function(){this.nodes.length=0,this.links.length=0,this.series.length=0,this.resetSimulation()},resetSimulation:function(){this.forcedStop=!1,this.systemTemperature=0,this.setMaxIterations(),this.setTemperature(),this.setDiffTemperature()},restartSimulation:function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))},setMaxIterations:function(t){this.maxIterations=p(t,this.options.maxIterations)},setTemperature:function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},setDiffTemperature:function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},setInitialRendering:function(t){this.initialRendering=t},createQuadTree:function(){this.quadTree=new o.QuadTree(this.box.left,this.box.top,this.box.width,this.box.height),this.quadTree.insertNodes(this.nodes)},initPositions:function(){var t=this.options.initialPositions;h(t)?(t.call(this),this.nodes.forEach(function(t){a(t.prevX)||(t.prevX=t.plotX),a(t.prevY)||(t.prevY=t.plotY),t.dispX=0,t.dispY=0})):"circle"===t?this.setCircularPositions():this.setRandomPositions()},setCircularPositions:function(){var o=this.box,t=this.nodes,e=t.length+1,i=2*Math.PI/e,e=t.filter(function(t){return 0===t.linksTo.length}),s=[],n={},r=this.options.initialPositionRadius;e.forEach(function(t){s.push(t),function e(t){t.linksFrom.forEach(function(t){n[t.toNode.id]||(n[t.toNode.id]=!0,s.push(t.toNode),e(t.toNode))})}(t)}),s.length?t.forEach(function(t){-1===s.indexOf(t)&&s.push(t)}):s=t,s.forEach(function(t,e){t.plotX=t.prevX=p(t.plotX,o.width/2+r*Math.cos(e*i)),t.plotY=t.prevY=p(t.plotY,o.height/2+r*Math.sin(e*i)),t.dispX=0,t.dispY=0})},setRandomPositions:function(){var o=this.box,t=this.nodes,i=t.length+1;function s(t){t=t*t/Math.PI;return t-=Math.floor(t)}t.forEach(function(t,e){t.plotX=t.prevX=p(t.plotX,o.width*s(e)),t.plotY=t.prevY=p(t.plotY,o.height*s(i+e)),t.dispX=0,t.dispY=0})},force:function(t){this.integration[t].apply(this,Array.prototype.slice.call(arguments,1))},barycenterForces:function(){this.getBarycenter(),this.force("barycenter")},getBarycenter:function(){var e=0,o=0,i=0;return this.nodes.forEach(function(t){o+=t.plotX*t.mass,i+=t.plotY*t.mass,e+=t.mass}),this.barycenter={x:o,y:i,xFactor:o/e,yFactor:i/e},this.barycenter},barnesHutApproximation:function(t,e){var o,i,s=this,n=s.getDistXY(t,e),r=s.vectorLength(n);return t!==e&&0!==r&&(e.isInternal?o=!(e.boxSize/r<s.options.theta&&0!==r)||(i=s.repulsiveForce(r,s.k),s.force("repulsive",t,i*e.mass,n,r),!1):(i=s.repulsiveForce(r,s.k),s.force("repulsive",t,i*e.mass,n,r))),o},repulsiveForces:function(){var n=this;"barnes-hut"===n.approximation?n.nodes.forEach(function(e){n.quadTree.visitNodeRecursive(null,function(t){return n.barnesHutApproximation(e,t)})}):n.nodes.forEach(function(s){n.nodes.forEach(function(t){var e,o,i;s===t||s.fixedPosition||(i=n.getDistXY(s,t),0!==(o=n.vectorLength(i))&&(e=n.repulsiveForce(o,n.k),n.force("repulsive",s,e*t.mass,i,o)))})})},attractiveForces:function(){var e,o,i,s=this;s.links.forEach(function(t){t.fromNode&&t.toNode&&(e=s.getDistXY(t.fromNode,t.toNode),0!==(o=s.vectorLength(e))&&(i=s.attractiveForce(o,s.k),s.force("attractive",t,i,e,o)))})},applyLimits:function(){var e=this;e.nodes.forEach(function(t){t.fixedPosition||(e.integration.integrate(e,t),e.applyLimitBox(t,e.box),t.dispX=0,t.dispY=0)})},applyLimitBox:function(t,e){var o=t.radius;t.plotX=r(t.plotX,e.left+o,e.width-o),t.plotY=r(t.plotY,e.top+o,e.height-o)},coolDown:function(t,e,o){return t-e*o},isStable:function(){return Math.abs(this.systemTemperature-this.prevSystemTemperature)<1e-5||this.temperature<=0},getSystemTemperature:function(){return this.nodes.reduce(function(t,e){return t+e.temperature},0)},vectorLength:function(t){return Math.sqrt(t.x*t.x+t.y*t.y)},getDistR:function(t,e){e=this.getDistXY(t,e);return this.vectorLength(e)},getDistXY:function(t,e){var o=t.plotX-e.plotX,e=t.plotY-e.plotY;return{x:o,y:e,absX:Math.abs(o),absY:Math.abs(e)}}}),n(t,"predraw",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(t){t.stop()})}),n(t,"render",function(){var e,o=!1;function t(t){t.maxIterations--&&isFinite(t.temperature)&&!t.isStable()&&!t.enableSimulation&&(t.beforeStep&&t.beforeStep(),t.step(),o=!(e=!1))}if(this.graphLayoutsLookup){for(s(!1,this),this.graphLayoutsLookup.forEach(function(t){t.start()});!e;)e=!0,this.graphLayoutsLookup.forEach(t);o&&this.series.forEach(function(t){t&&t.layout&&t.render()})}}),n(t,"beforePrint",function(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(t){t.updateSimulation(!1)}),this.redraw())}),n(t,"afterPrint",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(t){t.updateSimulation()}),this.redraw()})}),e(t,"Series/Networkgraph/DraggableNodes.js",[t["Core/Chart/Chart.js"],t["Core/Globals.js"],t["Core/Utilities.js"]],function(t,e,o){var n=o.addEvent;e.dragNodesMixin={onMouseDown:function(t,e){e=this.chart.pointer.normalize(e);t.fixedPosition={chartX:e.chartX,chartY:e.chartY,plotX:t.plotX,plotY:t.plotY},t.inDragMode=!0},onMouseMove:function(t,e){var o,i,s,n,r;t.fixedPosition&&t.inDragMode&&(r=(o=this.chart).pointer.normalize(e),i=t.fixedPosition.chartX-r.chartX,s=t.fixedPosition.chartY-r.chartY,e=n=void 0,r=o.graphLayoutsLookup,(5<Math.abs(i)||5<Math.abs(s))&&(n=t.fixedPosition.plotX-i,e=t.fixedPosition.plotY-s,o.isInsidePlot(n,e)&&(t.plotX=n,t.plotY=e,t.hasDragged=!0,this.redrawHalo(t),r.forEach(function(t){t.restartSimulation()}))))},onMouseUp:function(t,e){t.fixedPosition&&(t.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw()),t.inDragMode=t.hasDragged=!1,this.options.fixedDraggable||delete t.fixedPosition)},redrawHalo:function(t){t&&this.halo&&this.halo.attr({d:t.haloPath(this.options.states.hover.halo.size)})}},n(t,"load",function(){var t,o,i,s=this;s.container&&(t=n(s.container,"mousedown",function(t){var e=s.hoverPoint;e&&e.series&&e.series.hasDraggableNodes&&e.series.options.draggable&&(e.series.onMouseDown(e,t),o=n(s.container,"mousemove",function(t){return e&&e.series&&e.series.onMouseMove(e,t)}),i=n(s.container.ownerDocument,"mouseup",function(t){return o(),i(),e&&e.series&&e.series.onMouseUp(e,t)}))})),n(s,"destroy",function(){t()})})}),e(t,"Series/Networkgraph/Networkgraph.js",[t["Core/Globals.js"],t["Mixins/Nodes.js"],t["Core/Series/Point.js"],t["Core/Series/Series.js"],t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(n,o,t,a,e,i){var s,r,h=this&&this.__extends||(s=function(t,e){return(s=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)e.hasOwnProperty(o)&&(t[o]=e[o])})(t,e)},function(t,e){function o(){this.constructor=t}s(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),p=e.seriesTypes,d=i.addEvent,c=i.css,u=i.defined,l=i.extend,f=i.merge,m=i.pick,i=n.dragNodesMixin,f=(h(g,r=a),g.defaultOptions=f(a.defaultOptions,{stickyTracking:!1,inactiveOtherPoints:!0,marker:{enabled:!0,states:{inactive:{opacity:.3,animation:{duration:50}}}},states:{inactive:{linkOpacity:.3,animation:{duration:50}}},dataLabels:{formatter:function(){return this.key},linkFormatter:function(){return this.point.fromNode.name+"<br>"+this.point.toNode.name},linkTextPath:{enabled:!0},textPath:{enabled:!1},style:{transition:"opacity 2000ms"}},link:{color:"rgba(100, 100, 100, 0.5)",width:1},draggable:!0,layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:1,enableSimulation:!1,theta:.5,maxSpeed:10,approximation:"none",type:"reingold-fruchterman",integration:"euler",maxIterations:1e3,gravitationalConstant:.0625,friction:-.981},showInLegend:!1}),g);function g(){var t=null!==r&&r.apply(this,arguments)||this;return t.data=void 0,t.nodes=void 0,t.options=void 0,t.points=void 0,t}l(f.prototype,{forces:["barycenter","repulsive","attractive"],hasDraggableNodes:!0,drawGraph:void 0,isCartesian:!1,requireSorting:!1,directTouch:!0,noSharedTooltip:!0,pointArrayMap:["from","to"],trackerGroups:["group","markerGroup","dataLabelsGroup"],drawTracker:p.column.prototype.drawTracker,animate:void 0,buildKDTree:n.noop,createNode:o.createNode,destroy:function(){this.layout&&this.layout.removeElementFromCollection(this,this.layout.series),o.destroy.call(this)},init:function(){var t=this;return a.prototype.init.apply(this,arguments),d(this,"updatedData",function(){t.layout&&t.layout.stop()}),d(this,"afterUpdate",function(){t.nodes.forEach(function(t){t&&t.series&&t.resolveColor()})}),this},generatePoints:function(){var t,e;for(o.generatePoints.apply(this,arguments),this.options.nodes&&this.options.nodes.forEach(function(t){this.nodeLookup[t.id]||(this.nodeLookup[t.id]=this.createNode(t.id))},this),e=this.nodes.length-1;0<=e;e--)(t=this.nodes[e]).degree=t.getDegree(),t.radius=m(t.marker&&t.marker.radius,this.options.marker&&this.options.marker.radius,0),this.nodeLookup[t.id]||t.remove();this.data.forEach(function(t){t.formatPrefix="link"}),this.indexateNodes()},getPointsCollection:function(){return this.nodes||[]},indexateNodes:function(){this.nodes.forEach(function(t,e){t.index=e})},markerAttribs:function(t,e){e=a.prototype.markerAttribs.call(this,t,e);return u(t.plotY)||(e.y=0),e.x=(t.plotX||0)-(e.width||0)/2,e},translate:function(){this.processedXData||this.processData(),this.generatePoints(),this.deferLayout(),this.nodes.forEach(function(t){t.isInside=!0,t.linksFrom.forEach(function(t){t.shapeType="path",t.y=1})})},deferLayout:function(){var t,e=this.options.layoutAlgorithm,o=this.chart.graphLayoutsStorage,i=this.chart.graphLayoutsLookup,s=this.chart.options.chart;this.visible&&(o||(this.chart.graphLayoutsStorage=o={},this.chart.graphLayoutsLookup=i=[]),(t=o[e.type])||(e.enableSimulation=u(s.forExport)?!s.forExport:e.enableSimulation,o[e.type]=t=new n.layouts[e.type],t.init(e),i.splice(t.index,0,t)),(this.layout=t).setArea(0,0,this.chart.plotWidth,this.chart.plotHeight),t.addElementsToCollection([this],t.series),t.addElementsToCollection(this.nodes,t.nodes),t.addElementsToCollection(this.points,t.links))},render:function(){var t=this,e=t.points,o=t.chart.hoverPoint,i=[];t.points=t.nodes,p.line.prototype.render.call(this),(t.points=e).forEach(function(t){t.fromNode&&t.toNode&&(t.renderLink(),t.redrawLink())}),o&&o.series===t&&t.redrawHalo(o),t.chart.hasRendered&&!t.options.dataLabels.allowOverlap&&(t.nodes.concat(t.points).forEach(function(t){t.dataLabel&&i.push(t.dataLabel)}),t.chart.hideOverlappingLabels(i))},drawDataLabels:function(){var t=this.options.dataLabels.textPath;a.prototype.drawDataLabels.apply(this,arguments),this.points=this.data,this.options.dataLabels.textPath=this.options.dataLabels.linkTextPath,a.prototype.drawDataLabels.apply(this,arguments),this.points=this.nodes,this.options.dataLabels.textPath=t},pointAttribs:function(t,e){var o=e||t&&t.state||"normal",e=a.prototype.pointAttribs.call(this,t,o),o=this.options.states[o];return t&&!t.isNode&&(e=t.getLinkAttributes(),o&&(e={stroke:o.linkColor||e.stroke,dashstyle:o.linkDashStyle||e.dashstyle,opacity:m(o.linkOpacity,e.opacity),"stroke-width":o.linkColor||e["stroke-width"]})),e},redrawHalo:i.redrawHalo,onMouseDown:i.onMouseDown,onMouseMove:i.onMouseMove,onMouseUp:i.onMouseUp,setState:function(t,e){e?(this.points=this.nodes.concat(this.data),a.prototype.setState.apply(this,arguments),this.points=this.data):a.prototype.setState.apply(this,arguments),this.layout.simulation||t||this.render()}});var y,h=(y=a.prototype.pointClass,h(v,y),v);function v(){var t=null!==y&&y.apply(this,arguments)||this;return t.degree=void 0,t.linksFrom=void 0,t.linksTo=void 0,t.options=void 0,t.radius=void 0,t.series=void 0,t.toNode=void 0,t}return l(h.prototype,{setState:o.setNodeState,init:function(){return t.prototype.init.apply(this,arguments),this.series.options.draggable&&!this.series.chart.styledMode&&(d(this,"mouseOver",function(){c(this.series.chart.container,{cursor:"move"})}),d(this,"mouseOut",function(){c(this.series.chart.container,{cursor:"default"})})),this},getDegree:function(){var t=this.isNode?this.linksFrom.length+this.linksTo.length:0;return 0===t?1:t},getLinkAttributes:function(){var t=this.series.options.link,e=this.options;return{"stroke-width":m(e.width,t.width),stroke:e.color||t.color,dashstyle:e.dashStyle||t.dashStyle,opacity:m(e.opacity,t.opacity,1)}},renderLink:function(){var e;this.graphic||(this.graphic=this.series.chart.renderer.path(this.getLinkPath()).addClass(this.getClassName(),!0).add(this.series.group),this.series.chart.styledMode||(e=this.series.pointAttribs(this),this.graphic.attr(e),(this.dataLabels||[]).forEach(function(t){t&&t.attr({opacity:e.opacity})})))},redrawLink:function(){var e,t,o=this.getLinkPath();this.graphic&&(this.shapeArgs={d:o},this.series.chart.styledMode||(e=this.series.pointAttribs(this),this.graphic.attr(e),(this.dataLabels||[]).forEach(function(t){t&&t.attr({opacity:e.opacity})})),this.graphic.animate(this.shapeArgs),t=o[0],o=o[1],"M"===t[0]&&"L"===o[0]&&(this.plotX=(t[1]+o[1])/2,this.plotY=(t[2]+o[2])/2))},getMass:function(){var t=this.fromNode.mass,e=this.toNode.mass,o=t+e;return{fromNode:1-t/o,toNode:1-e/o}},getLinkPath:function(){var t=this.fromNode,e=this.toNode;return t.plotX>e.plotX&&(t=this.toNode,e=this.fromNode),[["M",t.plotX||0,t.plotY||0],["L",e.plotX||0,e.plotY||0]]},isValid:function(){return!this.isNode||u(this.id)},remove:function(t,e){var o,i=this,s=i.series,n=s.options.nodes||[],r=n.length;if(i.isNode){for(s.points=[],[].concat(i.linksFrom).concat(i.linksTo).forEach(function(t){-1<(o=t.fromNode.linksFrom.indexOf(t))&&t.fromNode.linksFrom.splice(o,1),-1<(o=t.toNode.linksTo.indexOf(t))&&t.toNode.linksTo.splice(o,1),a.prototype.removePoint.call(s,s.data.indexOf(t),!1,!1)}),s.points=s.data.slice(),s.nodes.splice(s.nodes.indexOf(i),1);r--;)if(n[r].id===i.options.id){s.options.nodes.splice(r,1);break}i&&i.destroy(),s.isDirty=!0,s.isDirtyData=!0,t&&s.chart.redraw(t)}else s.removePoint(s.data.indexOf(i),t,e)},destroy:function(){return this.isNode&&this.linksFrom.concat(this.linksTo).forEach(function(t){t.destroyElements&&t.destroyElements()}),this.series.layout.removeElementFromCollection(this,this.series.layout[this.isNode?"nodes":"links"]),t.prototype.destroy.apply(this,arguments)}}),f.prototype.pointClass=h,e.registerSeriesType("networkgraph",f),f}),e(t,"masters/modules/networkgraph.src.js",[],function(){})});