"use strict";!function(t){"object"==typeof module&&module.exports?module.exports=t.default=t:"function"==typeof define&&define.amd?define("highcharts/modules/sonification",["highcharts"],function(n){return t(n),t.Highcharts=n,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(n){function t(n,t,i,e){n.hasOwnProperty(t)||(n[t]=e.apply(null,i))}t(n=n?n._modules:{},"Extensions/Sonification/Instrument.js",[n["Core/Globals.js"],n["Core/Utilities.js"]],function(s,n){function t(n){this.init(n)}var i=n.error,e=n.merge,a=n.pick,o=n.uniqueKey,r={type:"oscillator",playCallbackInterval:20,masterVolume:1,oscillator:{waveformShape:"sine"}};return t.prototype.init=function(n){var t;this.initAudioContext()?(this.options=e(r,n),this.id=this.options.id=n&&n.id||o(),this.masterVolume=this.options.masterVolume||0,n=s.audioContext,t=this.destinationNode||n.destination,this.gainNode=n.createGain(),this.setGain(0),(this.panNode=n.createStereoPanner&&n.createStereoPanner())?(this.setPan(0),this.gainNode.connect(this.panNode),this.panNode.connect(t)):this.gainNode.connect(t),"oscillator"===this.options.type&&this.initOscillator(this.options.oscillator),this.playCallbackTimers=[]):i(29)},t.prototype.copy=function(n){return new t(e(this.options,{id:null},n))},t.prototype.initAudioContext=function(){var n=s.win.AudioContext||s.win.webkitAudioContext,t=!!s.audioContext;return!!n&&(s.audioContext=s.audioContext||new n,!t&&s.audioContext&&"running"===s.audioContext.state&&s.audioContext.suspend(),!!(s.audioContext&&s.audioContext.createOscillator&&s.audioContext.createGain))},t.prototype.initOscillator=function(n){this.oscillator=s.audioContext.createOscillator(),this.oscillator.type=n.waveformShape,this.oscillator.connect(this.gainNode),this.oscillatorStarted=!1},t.prototype.setPan=function(n){this.panNode&&this.panNode.pan.setValueAtTime(n,s.audioContext.currentTime)},t.prototype.setGain=function(n,t){var i=this.gainNode;n*=this.masterVolume,i&&(1.2<n&&(console.warn("Highcharts sonification warning: Volume of instrument set too high."),n=1.2),t?(i.gain.setValueAtTime(i.gain.value,s.audioContext.currentTime),i.gain.linearRampToValueAtTime(n,s.audioContext.currentTime+t/1e3)):i.gain.setValueAtTime(n,s.audioContext.currentTime))},t.prototype.cancelGainRamp=function(){this.gainNode&&this.gainNode.gain.cancelScheduledValues(0)},t.prototype.setMasterVolume=function(n){this.masterVolume=n||0},t.prototype.getValidFrequency=function(i,n,t){var e=this.options.allowedFrequencies,o=a(t,1/0),s=a(n,-1/0);return e&&e.length?e.reduce(function(n,t){return Math.abs(t-i)<Math.abs(n-i)&&t<o&&s<t?t:n},1/0):i},t.prototype.clearPlayCallbackTimers=function(){this.playCallbackTimers.forEach(function(n){clearInterval(n)}),this.playCallbackTimers=[]},t.prototype.setFrequency=function(n,t){n=this.getValidFrequency(n,(t=t||{}).min,t.max),"oscillator"===this.options.type&&this.oscillatorPlay(n)},t.prototype.oscillatorPlay=function(n){this.oscillatorStarted||(this.oscillator.start(),this.oscillatorStarted=!0),this.oscillator.frequency.setValueAtTime(n,s.audioContext.currentTime)},t.prototype.preparePlay=function(){this.setGain(.001),"suspended"===s.audioContext.state&&s.audioContext.resume(),this.oscillator&&!this.oscillatorStarted&&(this.oscillator.start(),this.oscillatorStarted=!0)},t.prototype.play=function(n){function t(t,i,e){var o,s=n.duration,a=0,r=u.options.playCallbackInterval;"function"==typeof t?(o=setInterval(function(){var n=++a*r/s;1<=n?(u[i](t(1),e),clearInterval(o)):u[i](t(n),e)},r),u.playCallbackTimers.push(o)):u[i](t,e)}var i,e,u=this,o=n.duration||0;u.id&&("suspended"===s.audioContext.state||this.oscillator&&!this.oscillatorStarted?(u.preparePlay(),setTimeout(function(){u.play(n)},10)):(u.playCallbackTimers.length&&u.clearPlayCallbackTimers(),u.cancelGainRamp(),u.stopOscillatorTimeout&&(clearTimeout(u.stopOscillatorTimeout),delete u.stopOscillatorTimeout),u.stopTimeout&&(clearTimeout(u.stopTimeout),delete u.stopTimeout,u.stopCallback&&(u._play=u.play,u.play=function(){},u.stopCallback("cancelled"),u.play=u._play)),i=o<s.sonification.fadeOutDuration+20,u.stopCallback=n.onEnd,e=function(){delete u.stopTimeout,u.stop(i)},o?(u.stopTimeout=setTimeout(e,i?o:o-s.sonification.fadeOutDuration),t(n.frequency,"setFrequency",{minFrequency:n.minFrequency,maxFrequency:n.maxFrequency}),t(a(n.volume,1),"setGain",4),t(a(n.pan,0),"setPan")):e()))},t.prototype.mute=function(){this.setGain(1e-4,.8*s.sonification.fadeOutDuration)},t.prototype.stop=function(n,t,i){function e(){o.stopOscillatorTimeout&&delete o.stopOscillatorTimeout;try{o.oscillator.stop()}catch(n){}o.oscillator.disconnect(o.gainNode),o.initOscillator(o.options.oscillator),t&&t(i),o.stopCallback&&o.stopCallback(i)}var o=this;o.playCallbackTimers.length&&o.clearPlayCallbackTimers(),o.stopTimeout&&clearTimeout(o.stopTimeout),n?(o.setGain(0),e()):(o.mute(),o.stopOscillatorTimeout=setTimeout(e,s.sonification.fadeOutDuration+100))},t}),t(n,"Extensions/Sonification/MusicalFrequencies.js",[],function(){return[16.351597831287414,17.323914436054505,18.354047994837977,19.445436482630058,20.601722307054366,21.826764464562746,23.12465141947715,24.499714748859326,25.956543598746574,27.5,29.13523509488062,30.86770632850775,32.70319566257483,34.64782887210901,36.70809598967594,38.890872965260115,41.20344461410875,43.653528929125486,46.2493028389543,48.999429497718666,51.91308719749314,55,58.27047018976124,61.7354126570155,65.40639132514966,69.29565774421802,73.41619197935188,77.78174593052023,82.4068892282175,87.30705785825097,92.4986056779086,97.99885899543733,103.82617439498628,110,116.54094037952248,123.47082531403103,130.8127826502993,138.59131548843604,146.8323839587038,155.56349186104046,164.81377845643496,174.61411571650194,184.9972113558172,195.99771799087463,207.65234878997256,220,233.08188075904496,246.94165062806206,261.6255653005986,277.1826309768721,293.6647679174076,311.1269837220809,329.6275569128699,349.2282314330039,369.9944227116344,391.99543598174927,415.3046975799451,440,466.1637615180899,493.8833012561241,523.2511306011972,554.3652619537442,587.3295358348151,622.2539674441618,659.2551138257398,698.4564628660078,739.9888454232688,783.9908719634985,830.6093951598903,880,932.3275230361799,987.7666025122483,1046.5022612023945,1108.7305239074883,1174.6590716696303,1244.5079348883237,1318.5102276514797,1396.9129257320155,1479.9776908465376,1567.981743926997,1661.2187903197805,1760,1864.6550460723597,1975.533205024496,2093.004522404789,2217.4610478149766,2349.31814333926,2489.0158697766474,2637.02045530296,2793.825851464031,2959.955381693075,3135.9634878539946,3322.437580639561,3520,3729.3100921447194,3951.066410048992,4186.009044809578]}),t(n,"Extensions/Sonification/Utilities.js",[n["Extensions/Sonification/MusicalFrequencies.js"],n["Core/Utilities.js"]],function(n,t){function i(n){this.init(n||[])}var s=t.clamp;return i.prototype.init=function(n){this.supportedSignals=n,this.signals={}},i.prototype.registerSignalCallbacks=function(i){var e=this;e.supportedSignals.forEach(function(n){var t=i[n];t&&(e.signals[n]=e.signals[n]||[]).push(t)})},i.prototype.clearSignalCallbacks=function(n){var t=this;n?n.forEach(function(n){t.signals[n]&&delete t.signals[n]}):t.signals={}},i.prototype.emitSignal=function(n,t){var i;return this.signals[n]&&this.signals[n].forEach(function(n){n=n(t),i=void 0!==n?n:i}),i},{musicalFrequencies:n,SignalHandler:i,getMusicalScale:function(e){return n.filter(function(n,t){var i=t%12+1;return e.some(function(n){return n===i})})},calculateDataExtremes:function(n,i){return n.series.reduce(function(t,n){return n.points.forEach(function(n){n=(void 0!==n[i]?n:n.options)[i],t.min=Math.min(t.min,n),t.max=Math.max(t.max,n)}),t},{min:1/0,max:-1/0})},virtualAxisTranslate:function(n,t,i,e){var o=t.max-t.min;return n=i.min+Math.abs(i.max-i.min)*(e?t.max-n:n-t.min)/o,0<o?s(n,i.min,i.max):i.min}}}),t(n,"Extensions/Sonification/InstrumentDefinitions.js",[n["Extensions/Sonification/Instrument.js"],n["Extensions/Sonification/Utilities.js"]],function(t,i){var e={};return["sine","square","triangle","sawtooth"].forEach(function(n){e[n]=new t({oscillator:{waveformShape:n}}),e[n+"Musical"]=new t({allowedFrequencies:i.musicalFrequencies,oscillator:{waveformShape:n}}),e[n+"Major"]=new t({allowedFrequencies:i.getMusicalScale([1,3,5,6,8,10,12]),oscillator:{waveformShape:n}})}),e}),t(n,"Extensions/Sonification/Earcon.js",[n["Core/Globals.js"],n["Core/Utilities.js"]],function(l,n){function t(n){this.init(n||{})}var p=n.error,f=n.merge,m=n.pick,i=n.uniqueKey;return t.prototype.init=function(n){this.options=n,this.options.id||(this.options.id=this.id=i()),this.instrumentsPlaying={}},t.prototype.sonify=function(n){var t=f(this.options,n),s=m(t.volume,1),a=t.pan,r=this,u=n&&n.onEnd,c=r.options.onEnd;t.instruments.forEach(function(n){var t,i="string"==typeof n.instrument?l.sonification.instruments[n.instrument]:n.instrument,e=f(n.playOptions),o="";i&&i.play?n.playOptions&&(e.pan=m(a,e.pan),t=e.onEnd,e.onEnd=function(){delete r.instrumentsPlaying[o],t&&t.apply(this,arguments),Object.keys(r.instrumentsPlaying).length||(u&&u.apply(this,arguments),c&&c.apply(this,arguments))},(n=i.copy()).setMasterVolume(s),o=n.id,(r.instrumentsPlaying[o]=n).play(e)):p(30)})},t.prototype.cancelSonify=function(t){var i=this.instrumentsPlaying,n=i&&Object.keys(i);n&&n.length&&(n.forEach(function(n){i[n].stop(!t,null,"cancelled")}),this.instrumentsPlaying={})},t}),t(n,"Extensions/Sonification/PointSonify.js",[n["Core/Globals.js"],n["Core/Utilities.js"],n["Extensions/Sonification/Utilities.js"]],function(p,n,f){var m=n.error,h=n.merge,d=n.pick,y={minDuration:20,maxDuration:2e3,minVolume:.1,maxVolume:1,minPan:-1,maxPan:1,minFrequency:220,maxFrequency:2200};return{pointSonify:function(n){function s(t,n,i){if("function"==typeof t)return n?function(n){return t(a,c,n)}:t(a,c);if("string"!=typeof t)return t;var e=(n="-"===t.charAt(0))?t.slice(1):t,o=d(a[e],a.options[e]);return c[e]=c[e]||f.calculateDataExtremes(a.series.chart,e),f.virtualAxisTranslate(o,c[e],i,n)}var a=this,r=a.series.chart,u=d(n.masterVolume,r.options.sonification&&r.options.sonification.masterVolume),c=n.dataExtremes||{};(r.sonification.currentlyPlayingPoint=a).sonification=a.sonification||{},a.sonification.instrumentsPlaying=a.sonification.instrumentsPlaying||{};var l=a.sonification.signalHandler=a.sonification.signalHandler||new f.SignalHandler(["onEnd"]);l.clearSignalCallbacks(),l.registerSignalCallbacks({onEnd:n.onEnd}),!a.isNull&&a.visible&&a.series.visible?n.instruments.forEach(function(t){var n="string"==typeof t.instrument?p.sonification.instruments[t.instrument]:t.instrument,i=t.instrumentMapping||{},e=h(y,t.instrumentOptions),o=n.id;n&&n.play?(void 0!==u&&n.setMasterVolume(u),(a.sonification.instrumentsPlaying[n.id]=n).play({frequency:s(i.frequency,!0,{min:e.minFrequency,max:e.maxFrequency}),duration:s(i.duration,!1,{min:e.minDuration,max:e.maxDuration}),pan:s(i.pan,!0,{min:e.minPan,max:e.maxPan}),volume:s(i.volume,!0,{min:e.minVolume,max:e.maxVolume}),onEnd:function(n){t.onEnd&&t.onEnd.apply(this,arguments),r.sonification&&r.sonification.currentlyPlayingPoint&&delete r.sonification.currentlyPlayingPoint,a.sonification&&a.sonification.instrumentsPlaying&&(delete a.sonification.instrumentsPlaying[o],Object.keys(a.sonification.instrumentsPlaying).length||l.emitSignal("onEnd",n))},minFrequency:e.minFrequency,maxFrequency:e.maxFrequency})):m(30)}):l.emitSignal("onEnd")},pointCancelSonify:function(t){var i=this.sonification&&this.sonification.instrumentsPlaying,n=i&&Object.keys(i);n&&n.length&&(n.forEach(function(n){i[n].stop(!t,null,"cancelled")}),this.sonification.instrumentsPlaying={},this.sonification.signalHandler.emitSignal("onEnd","cancelled"))}}}),t(n,"Extensions/Sonification/ChartSonify.js",[n["Core/Globals.js"],n["Core/Series/Point.js"],n["Core/Utilities.js"],n["Extensions/Sonification/Utilities.js"]],function(f,m,n,h){function d(n,t){return"function"==typeof t?t(n):x(n[t],n.options[t])}function y(n,i){return n.points.reduce(function(n,t){return t=d(t,i),n.min=Math.min(n.min,t),n.max=Math.max(n.max,t),n},{min:1/0,max:-1/0})}function g(e,n,t){var i=(n||[]).slice(0);n=e.options.sonification&&e.options.sonification.defaultInstrumentOptions;function o(n){return{instrumentMapping:n.mapping}}return n&&i.push(o(n)),e.series.forEach(function(n){(n=n.options.sonification&&n.options.sonification.instruments)&&(i=i.concat(n.map(o)))}),i.reduce(function(t,i){return Object.keys(i.instrumentMapping||{}).forEach(function(n){"string"!=typeof(n=i.instrumentMapping[n])||t[n]||(t[n]=h.calculateDataExtremes(e,n))}),t},S(t))}function o(n,s){var t,i,e,o,a=s.timeExtremes||y(n,s.pointPlayTime),r=g(n.chart,s.instruments,s.dataExtremes),u=(i=s.instruments,e=r,o=n.points[n.points.length-1],i.reduce(function(n,t){return t="string"==typeof(t=t.instrumentMapping.duration)?0:"function"==typeof t?t(o,e):t,Math.max(n,t)},0)),c=x(s.masterVolume,1),l=s.instruments.map(function(n){var t=("string"==typeof(t=n.instrument)?f.sonification.instruments[t]:t).copy();return S(n,{instrument:t})}),p=(t=c,(i=l).forEach(function(n){"string"!=typeof(n=n.instrument)&&n.setMasterVolume(t)}),i),l=n.points.reduce(function(n,t){var e,i=(e=t,(s.earcons||[]).reduce(function(n,t){var i=t.earcon;return t.condition?(t=t.condition(e))instanceof f.sonification.Earcon?n.push(t):t&&n.push(i):t.onPoint&&e.id===t.onPoint&&n.push(i),n},[])),o=h.virtualAxisTranslate(d(t,s.pointPlayTime),a,{min:0,max:Math.max(s.duration-u,10)});return n.concat(new f.sonification.TimelineEvent({eventObject:t,time:o,id:t.id,playOptions:{instruments:p,dataExtremes:r,masterVolume:c}}),i.map(function(n){return new f.sonification.TimelineEvent({eventObject:n,time:o,playOptions:{volume:c}})}))},[]);return new f.sonification.TimelinePath({events:l,onStart:function(){s.onStart&&s.onStart(n)},onEventStart:function(n){var t=n.options&&n.options.eventObject;if(t instanceof m){if(!t.series.visible&&!t.series.chart.series.some(function(n){return n.visible}))return n.timelinePath.timeline.pause(),n.timelinePath.timeline.resetCursor(),!1;s.onPointStart&&s.onPointStart(n,t)}},onEventEnd:function(n){var t=n.event&&n.event.options&&n.event.options.eventObject;t instanceof m&&s.onPointEnd&&s.onPointEnd(n.event,t)},onEnd:function(){s.onEnd&&s.onEnd(n)},targetDuration:s.duration})}function l(n,t){var i=Math.max(t-n.reduce(function(n,t){return n+(1===(t=C(t)).length&&t[0].options&&t[0].options.silentWait||0)},0),0),e=n.reduce(function(n,t){return n+C(t).reduce(function(n,t){return(t=t.series&&t.seriesOptions&&t.seriesOptions.timeExtremes)?Math.max(n,t.max-t.min):n},0)},0);return n.reduce(function(n,t){return t=C(t).reduce(function(n,t){return t instanceof f.sonification.TimelinePath?n.push(t):t.series&&(t.seriesOptions.duration=t.seriesOptions.duration||h.virtualAxisTranslate(t.seriesOptions.timeExtremes.max-t.seriesOptions.timeExtremes.min,{min:0,max:e},{min:0,max:i}),n.push(o(t.series,t.seriesOptions))),n},[]),n.push(t),n},[])}function s(n,t){if(t&&t.instruments)return t.instruments;function i(i){a(i,function(n,t){null===n&&delete i[t]})}var e=n.chart.options.sonification&&n.chart.options.sonification.defaultInstrumentOptions||{};return(n.options.sonification&&n.options.sonification.instruments||[{}]).map(function(n){return i(n.mapping||{}),i(n),{instrument:n.instrument||e.instrument,instrumentOptions:S(e,n,{mapping:void 0,instrument:void 0}),instrumentMapping:S(e.mapping,n.mapping)}})}function p(n){var t=n.options.sonification||{},i=n.chart.options.sonification||{},e=i.events||{},o=t.events||{};return{onEnd:o.onSeriesEnd||e.onSeriesEnd,onStart:o.onSeriesStart||e.onSeriesStart,onPointEnd:o.onPointEnd||e.onPointEnd,onPointStart:o.onPointStart||e.onPointStart,pointPlayTime:i.defaultInstrumentOptions&&i.defaultInstrumentOptions.mapping&&i.defaultInstrumentOptions.mapping.pointPlayTime,masterVolume:i.masterVolume,instruments:s(n),earcons:t.earcons||i.earcons}}var E=n.find,v=n.isArray,S=n.merge,x=n.pick,C=n.splat,a=n.objectEach;return{chartSonify:function(n){var t,a=(i=n,t=(t=this).options.sonification||{},S({duration:t.duration,afterSeriesWait:t.afterSeriesWait,pointPlayTime:t.defaultInstrumentOptions&&t.defaultInstrumentOptions.mapping&&t.defaultInstrumentOptions.mapping.pointPlayTime,order:t.order,onSeriesStart:t.events&&t.events.onSeriesStart,onSeriesEnd:t.events&&t.events.onSeriesEnd,onEnd:t.events&&t.events.onEnd},i));this.sonification.timeline&&this.sonification.timeline.pause(),this.sonification.duration=a.duration;var i,o,s,e,r,u,c=g(this,a.instruments,a.dataExtremes);i=a.order,o=this,s=function(n){return t=n,i=c,o=(e=a).seriesOptions||{},s=t.chart.options.sonification&&t.chart.options.sonification.defaultInstrumentOptions&&t.chart.options.sonification.defaultInstrumentOptions.mapping&&t.chart.options.sonification.defaultInstrumentOptions.mapping.pointPlayTime||"x",n=p(t),S(n,{dataExtremes:i,timeExtremes:y(t,s),instruments:e.instruments||n.instruments,onStart:e.onSeriesStart||n.onStart,onEnd:e.onSeriesEnd||n.onEnd,earcons:e.earcons||n.earcons,masterVolume:x(e.masterVolume,n.masterVolume)},v(o)?E(o,function(n){return n.id===x(t.id,t.options.id)})||{}:o,{pointPlayTime:s});var t,i,e,o,s},"sequential"===i||"simultaneous"===i?(e=o.series.reduce(function(n,t){return t.visible&&!1!==(t.options.sonification&&t.options.sonification.enabled)&&n.push({series:t,seriesOptions:s(t)}),n},[]),"simultaneous"===i&&(e=[e])):e=i.reduce(function(n,t){return(t=C(t).reduce(function(n,t){var i,e;return"string"==typeof t?(e=o.get(t)).visible&&(i={series:e,seriesOptions:s(e)}):t instanceof f.sonification.Earcon&&(i=new f.sonification.TimelinePath({events:[new f.sonification.TimelineEvent({eventObject:t})]})),(i=t.silentWait?new f.sonification.TimelinePath({silentWait:t.silentWait}):i)&&n.push(i),n},[])).length&&n.push(t),n},[]),r=n=e,(n=l(n=(u=a.afterSeriesWait||0)?r.reduce(function(n,t,i){return t=C(t),n.push(t),i<r.length-1&&t.some(function(n){return n.series})&&n.push(new f.sonification.TimelinePath({silentWait:u})),n},[]):r,a.duration)).forEach(function(n){var o;o=(n=n).reduce(function(n,t){return(t=t.events)&&t.length&&(n.min=Math.min(t[0].time,n.min),n.max=Math.max(t[t.length-1].time,n.max)),n},{min:1/0,max:-1/0}),n.forEach(function(n){var t=n.events,i=t&&t.length,e=[];i&&t[0].time<=o.min||e.push(new f.sonification.TimelineEvent({time:o.min})),i&&t[t.length-1].time>=o.max||e.push(new f.sonification.TimelineEvent({time:o.max})),e.length&&n.addTimelineEvents(e)})}),this.sonification.timeline=new f.sonification.Timeline({paths:n,onEnd:a.onEnd}),this.sonification.timeline.play()},seriesSonify:function(n){var t=this.chart.options.sonification,i=this.options.sonification,t=o(this,n=S({duration:i&&i.duration||t&&t.duration},p(this),n));(i=this.chart.sonification).timeline&&i.timeline.pause(),i.duration=n.duration,i.timeline=new f.sonification.Timeline({paths:[t]}),i.timeline.play()},pause:function(n){this.sonification.timeline?this.sonification.timeline.pause(x(n,!0)):this.sonification.currentlyPlayingPoint&&this.sonification.currentlyPlayingPoint.cancelSonify(n)},resume:function(n){this.sonification.timeline&&this.sonification.timeline.play(n)},rewind:function(n){this.sonification.timeline&&this.sonification.timeline.rewind(n)},cancel:function(n){this.pauseSonify(n),this.resetSonifyCursor()},getCurrentPoints:function(){if(this.sonification.timeline){var t=this.sonification.timeline.getCursor();return Object.keys(t).map(function(n){return t[n].eventObject}).filter(function(n){return n instanceof m})}return[]},setCursor:function(n){var t=this.sonification.timeline;t&&C(n).forEach(function(n){t.setCursor(n.id)})},resetCursor:function(){this.sonification.timeline&&this.sonification.timeline.resetCursor()},resetCursorEnd:function(){this.sonification.timeline&&this.sonification.timeline.resetCursorEnd()}}}),t(n,"Extensions/Sonification/Timeline.js",[n["Core/Globals.js"],n["Core/Utilities.js"],n["Extensions/Sonification/Utilities.js"]],function(t,n,i){function e(n){this.init(n||{})}function o(n){this.init(n)}function s(n){this.init(n||{})}var a=n.merge,c=n.splat,r=n.uniqueKey;return e.prototype.init=function(n){this.options=n,this.time=n.time||0,this.id=this.options.id=n.id||r()},e.prototype.play=function(n){var t=this.options.eventObject,i=this.options.onEnd,e=n&&n.onEnd,o=this.options.playOptions&&this.options.playOptions.onEnd;n=a(this.options.playOptions,n),t&&t.sonify?(n.onEnd=i||e||o?function(){var t=arguments;[i,e,o].forEach(function(n){n&&n.apply(this,t)})}:void 0,t.sonify(n)):(e&&e(),i&&i())},e.prototype.cancel=function(n){this.options.eventObject.cancelSonify(n)},o.prototype.init=function(n){this.options=n,this.id=this.options.id=n.id||r(),this.cursor=0,this.eventsPlaying={},this.events=n.silentWait?[new e({time:0}),new e({time:n.silentWait})]:this.options.events,this.targetDuration=n.targetDuration||n.silentWait,this.sortEvents(),this.updateEventIdMap(),this.signalHandler=new i.SignalHandler(["playOnEnd","masterOnEnd","onStart","onEventStart","onEventEnd"]),this.signalHandler.registerSignalCallbacks(a(n,{masterOnEnd:n.onEnd}))},o.prototype.sortEvents=function(){this.events=this.events.sort(function(n,t){return n.time-t.time})},o.prototype.updateEventIdMap=function(){this.eventIdMap=this.events.reduce(function(n,t,i){return n[t.id]=i,n},{})},o.prototype.addTimelineEvents=function(n){this.events=this.events.concat(n),this.sortEvents(),this.updateEventIdMap()},o.prototype.getCursor=function(){return this.events[this.cursor]},o.prototype.setCursor=function(n){return void 0!==(n=this.eventIdMap[n])&&(this.cursor=n,!0)},o.prototype.play=function(n){this.pause(),this.signalHandler.emitSignal("onStart"),this.signalHandler.clearSignalCallbacks(["playOnEnd"]),this.signalHandler.registerSignalCallbacks({playOnEnd:n}),this.playEvents(1)},o.prototype.rewind=function(n){this.pause(),this.signalHandler.emitSignal("onStart"),this.signalHandler.clearSignalCallbacks(["playOnEnd"]),this.signalHandler.registerSignalCallbacks({playOnEnd:n}),this.playEvents(-1)},o.prototype.resetCursor=function(){this.cursor=0},o.prototype.resetCursorEnd=function(){this.cursor=this.events.length-1},o.prototype.pause=function(t){var i=this;clearTimeout(i.nextScheduledPlay),Object.keys(i.eventsPlaying).forEach(function(n){i.eventsPlaying[n]&&i.eventsPlaying[n].cancel(t)}),i.eventsPlaying={}},o.prototype.playEvents=function(n){function t(n){e.signalHandler.emitSignal("masterOnEnd",n),e.signalHandler.emitSignal("playOnEnd",n)}var i,e=this,o=e.events[this.cursor],s=e.events[this.cursor+n];!1===(o.timelinePath=e).signalHandler.emitSignal("onEventStart",o)?t({event:o,cancelled:!0}):((e.eventsPlaying[o.id]=o).play({onEnd:function(n){n={event:o,cancelled:!!n},delete e.eventsPlaying[o.id],e.signalHandler.emitSignal("onEventEnd",n),s||t(n)}}),s&&((i=Math.abs(s.time-o.time))<1?(e.cursor+=n,e.playEvents(n)):this.nextScheduledPlay=setTimeout(function(){e.cursor+=n,e.playEvents(n)},i)))},s.prototype.init=function(n){this.options=n,this.cursor=0,this.paths=n.paths||[],this.pathsPlaying={},this.signalHandler=new i.SignalHandler(["playOnEnd","masterOnEnd","onPathStart","onPathEnd"]),this.signalHandler.registerSignalCallbacks(a(n,{masterOnEnd:n.onEnd}))},s.prototype.play=function(n){this.pause(),this.signalHandler.clearSignalCallbacks(["playOnEnd"]),this.signalHandler.registerSignalCallbacks({playOnEnd:n}),this.playPaths(1)},s.prototype.rewind=function(n){this.pause(),this.signalHandler.clearSignalCallbacks(["playOnEnd"]),this.signalHandler.registerSignalCallbacks({playOnEnd:n}),this.playPaths(-1)},s.prototype.playPaths=function(e){var o,s,a,n,r=this,u=r.signalHandler;r.paths.length?(o=c(this.paths[this.cursor]),s=this.paths[this.cursor+e],a=0,o.forEach(function(n){n&&(n.timeline=r,setTimeout(function(){var i;i=n,u.emitSignal("onPathStart",i),(r.pathsPlaying[i.id]=i)[0<e?"play":"rewind"](function(n){n=n&&n.cancelled;var t={path:i,cancelled:n};delete r.pathsPlaying[i.id],u.emitSignal("onPathEnd",t),++a>=o.length&&(s&&!n?(r.cursor+=e,c(s).forEach(function(n){n[0<e?"resetCursor":"resetCursorEnd"]()}),r.playPaths(e)):(u.emitSignal("playOnEnd",t),u.emitSignal("masterOnEnd",t)))})},t.sonification.fadeOutDuration))})):(u.emitSignal("playOnEnd",n={cancelled:!1}),u.emitSignal("masterOnEnd",n))},s.prototype.pause=function(t){var i=this;Object.keys(i.pathsPlaying).forEach(function(n){i.pathsPlaying[n]&&i.pathsPlaying[n].pause(t)}),i.pathsPlaying={}},s.prototype.resetCursor=function(){this.paths.forEach(function(n){c(n).forEach(function(n){n.resetCursor()})}),this.cursor=0},s.prototype.resetCursorEnd=function(){this.paths.forEach(function(n){c(n).forEach(function(n){n.resetCursorEnd()})}),this.cursor=this.paths.length-1},s.prototype.setCursor=function(t){return this.paths.some(function(n){return c(n).some(function(n){return n.setCursor(t)})})},s.prototype.getCursor=function(){return this.getCurrentPlayingPaths().reduce(function(n,t){return n[t.id]=t.getCursor(),n},{})},s.prototype.atStart=function(){return!this.cursor&&!c(this.paths[0]).some(function(n){return n.cursor})},s.prototype.getCurrentPlayingPaths=function(){return this.paths.length?c(this.paths[this.cursor]):[]},{TimelineEvent:e,TimelinePath:o,Timeline:s}}),t(n,"Extensions/Sonification/Options.js",[],function(){return{sonification:{enabled:!1,duration:2500,afterSeriesWait:700,masterVolume:1,order:"sequential",defaultInstrumentOptions:{instrument:"sineMusical",minFrequency:392,maxFrequency:1046,mapping:{pointPlayTime:"x",duration:200,frequency:"y"}}}}}),t(n,"Extensions/Sonification/Sonification.js",[n["Core/Chart/Chart.js"],n["Core/Globals.js"],n["Core/DefaultOptions.js"],n["Core/Series/Point.js"],n["Core/Series/Series.js"],n["Core/Utilities.js"],n["Extensions/Sonification/Instrument.js"],n["Extensions/Sonification/InstrumentDefinitions.js"],n["Extensions/Sonification/Earcon.js"],n["Extensions/Sonification/PointSonify.js"],n["Extensions/Sonification/ChartSonify.js"],n["Extensions/Sonification/Utilities.js"],n["Extensions/Sonification/Timeline.js"],n["Extensions/Sonification/Options.js"]],function(n,t,i,e,o,s,a,r,u,c,l,p,f,m){i=i.defaultOptions;var h=s.addEvent,d=s.extend,y=s.merge;t.sonification={fadeOutDuration:20,utilities:p,Instrument:a,instruments:r,Earcon:u,TimelineEvent:f.TimelineEvent,TimelinePath:f.TimelinePath,Timeline:f.Timeline},y(!0,i,m),e.prototype.sonify=c.pointSonify,e.prototype.cancelSonify=c.pointCancelSonify,o.prototype.sonify=l.seriesSonify,d(n.prototype,{sonify:l.chartSonify,pauseSonify:l.pause,resumeSonify:l.resume,rewindSonify:l.rewind,cancelSonify:l.cancel,getCurrentSonifyPoints:l.getCurrentPoints,setSonifyCursor:l.setCursor,resetSonifyCursor:l.resetCursor,resetSonifyCursorEnd:l.resetCursorEnd}),h(n,"init",function(){this.sonification={}}),h(n,"update",function(n){(n=n.options.sonification)&&y(!0,this.options.sonification,n)})}),t(n,"masters/modules/sonification.src.js",[],function(){})});