"use strict";!function(t){"object"==typeof module&&module.exports?module.exports=t.default=t:"function"==typeof define&&define.amd?define("highcharts/modules/sonification",["highcharts"],function(n){return t(n),t.Highcharts=n,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(n){n=n?n._modules:{};function t(n,t,i,e){n.hasOwnProperty(t)||(n[t]=e.apply(null,i))}t(n,"Extensions/Sonification/Instrument.js",[n["Core/Globals.js"],n["Core/Utilities.js"]],function(s,n){var i=n.error,e=n.merge,a=n.pick,o=n.uniqueKey,r={type:"oscillator",playCallbackInterval:20,masterVolume:1,oscillator:{waveformShape:"sine"}};function t(n){this.init(n)}return t.prototype.init=function(n){var t;this.initAudioContext()?(this.options=e(r,n),this.id=this.options.id=n&&n.id||o(),this.masterVolume=this.options.masterVolume||0,t=s.audioContext,n=this.destinationNode||t.destination,this.gainNode=t.createGain(),this.setGain(0),this.panNode=t.createStereoPanner&&t.createStereoPanner(),this.panNode?(this.setPan(0),this.gainNode.connect(this.panNode),this.panNode.connect(n)):this.gainNode.connect(n),"oscillator"===this.options.type&&this.initOscillator(this.options.oscillator),this.playCallbackTimers=[]):i(29)},t.prototype.copy=function(n){return new t(e(this.options,{id:null},n))},t.prototype.initAudioContext=function(){var n=s.win.AudioContext||s.win.webkitAudioContext,t=!!s.audioContext;return!!n&&(s.audioContext=s.audioContext||new n,!t&&s.audioContext&&"running"===s.audioContext.state&&s.audioContext.suspend(),!!(s.audioContext&&s.audioContext.createOscillator&&s.audioContext.createGain))},t.prototype.initOscillator=function(n){var t=s.audioContext;this.oscillator=t.createOscillator(),this.oscillator.type=n.waveformShape,this.oscillator.connect(this.gainNode),this.oscillatorStarted=!1},t.prototype.setPan=function(n){this.panNode&&this.panNode.pan.setValueAtTime(n,s.audioContext.currentTime)},t.prototype.setGain=function(n,t){var i=this.gainNode,n=n*this.masterVolume;i&&(1.2<n&&(console.warn("Highcharts sonification warning: Volume of instrument set too high."),n=1.2),t?(i.gain.setValueAtTime(i.gain.value,s.audioContext.currentTime),i.gain.linearRampToValueAtTime(n,s.audioContext.currentTime+t/1e3)):i.gain.setValueAtTime(n,s.audioContext.currentTime))},t.prototype.cancelGainRamp=function(){this.gainNode&&this.gainNode.gain.cancelScheduledValues(0)},t.prototype.setMasterVolume=function(n){this.masterVolume=n||0},t.prototype.getValidFrequency=function(i,n,t){var e=this.options.allowedFrequencies,o=a(t,1/0),s=a(n,-1/0);return e&&e.length?e.reduce(function(n,t){return Math.abs(t-i)<Math.abs(n-i)&&t<o&&s<t?t:n},1/0):i},t.prototype.clearPlayCallbackTimers=function(){this.playCallbackTimers.forEach(function(n){clearInterval(n)}),this.playCallbackTimers=[]},t.prototype.setFrequency=function(n,t){t=t||{},t=this.getValidFrequency(n,t.min,t.max);"oscillator"===this.options.type&&this.oscillatorPlay(t)},t.prototype.oscillatorPlay=function(n){this.oscillatorStarted||(this.oscillator.start(),this.oscillatorStarted=!0),this.oscillator.frequency.setValueAtTime(n,s.audioContext.currentTime)},t.prototype.preparePlay=function(){this.setGain(.001),"suspended"===s.audioContext.state&&s.audioContext.resume(),this.oscillator&&!this.oscillatorStarted&&(this.oscillator.start(),this.oscillatorStarted=!0)},t.prototype.play=function(n){function t(t,i,e){var o,s=n.duration,a=0,r=u.options.playCallbackInterval;"function"==typeof t?(o=setInterval(function(){var n=++a*r/s;1<=n?(u[i](t(1),e),clearInterval(o)):u[i](t(n),e)},r),u.playCallbackTimers.push(o)):u[i](t,e)}var u=this,i=n.duration||0;if(u.id){if("suspended"===s.audioContext.state||this.oscillator&&!this.oscillatorStarted)return u.preparePlay(),void setTimeout(function(){u.play(n)},10);u.playCallbackTimers.length&&u.clearPlayCallbackTimers(),u.cancelGainRamp(),u.stopOscillatorTimeout&&(clearTimeout(u.stopOscillatorTimeout),delete u.stopOscillatorTimeout),u.stopTimeout&&(clearTimeout(u.stopTimeout),delete u.stopTimeout,u.stopCallback&&(u._play=u.play,u.play=function(){},u.stopCallback("cancelled"),u.play=u._play));var e=i<s.sonification.fadeOutDuration+20;u.stopCallback=n.onEnd;var o=function(){delete u.stopTimeout,u.stop(e)};i?(u.stopTimeout=setTimeout(o,e?i:i-s.sonification.fadeOutDuration),t(n.frequency,"setFrequency",{minFrequency:n.minFrequency,maxFrequency:n.maxFrequency}),t(a(n.volume,1),"setGain",4),t(a(n.pan,0),"setPan")):o()}},t.prototype.mute=function(){this.setGain(1e-4,.8*s.sonification.fadeOutDuration)},t.prototype.stop=function(n,t,i){function e(){o.stopOscillatorTimeout&&delete o.stopOscillatorTimeout;try{o.oscillator.stop()}catch(n){}o.oscillator.disconnect(o.gainNode),o.initOscillator(o.options.oscillator),t&&t(i),o.stopCallback&&o.stopCallback(i)}var o=this;o.playCallbackTimers.length&&o.clearPlayCallbackTimers(),o.stopTimeout&&clearTimeout(o.stopTimeout),n?(o.setGain(0),e()):(o.mute(),o.stopOscillatorTimeout=setTimeout(e,s.sonification.fadeOutDuration+100))},t}),t(n,"Extensions/Sonification/MusicalFrequencies.js",[],function(){return[16.351597831287414,17.323914436054505,18.354047994837977,19.445436482630058,20.601722307054366,21.826764464562746,23.12465141947715,24.499714748859326,25.956543598746574,27.5,29.13523509488062,30.86770632850775,32.70319566257483,34.64782887210901,36.70809598967594,38.890872965260115,41.20344461410875,43.653528929125486,46.2493028389543,48.999429497718666,51.91308719749314,55,58.27047018976124,61.7354126570155,65.40639132514966,69.29565774421802,73.41619197935188,77.78174593052023,82.4068892282175,87.30705785825097,92.4986056779086,97.99885899543733,103.82617439498628,110,116.54094037952248,123.47082531403103,130.8127826502993,138.59131548843604,146.8323839587038,155.56349186104046,164.81377845643496,174.61411571650194,184.9972113558172,195.99771799087463,207.65234878997256,220,233.08188075904496,246.94165062806206,261.6255653005986,277.1826309768721,293.6647679174076,311.1269837220809,329.6275569128699,349.2282314330039,369.9944227116344,391.99543598174927,415.3046975799451,440,466.1637615180899,493.8833012561241,523.2511306011972,554.3652619537442,587.3295358348151,622.2539674441618,659.2551138257398,698.4564628660078,739.9888454232688,783.9908719634985,830.6093951598903,880,932.3275230361799,987.7666025122483,1046.5022612023945,1108.7305239074883,1174.6590716696303,1244.5079348883237,1318.5102276514797,1396.9129257320155,1479.9776908465376,1567.981743926997,1661.2187903197805,1760,1864.6550460723597,1975.533205024496,2093.004522404789,2217.4610478149766,2349.31814333926,2489.0158697766474,2637.02045530296,2793.825851464031,2959.955381693075,3135.9634878539946,3322.437580639561,3520,3729.3100921447194,3951.066410048992,4186.009044809578]}),t(n,"Extensions/Sonification/Utilities.js",[n["Extensions/Sonification/MusicalFrequencies.js"],n["Core/Utilities.js"]],function(n,t){var a=t.clamp;function i(n){this.init(n||[])}return i.prototype.init=function(n){this.supportedSignals=n,this.signals={}},i.prototype.registerSignalCallbacks=function(i){var e=this;e.supportedSignals.forEach(function(n){var t=i[n];t&&(e.signals[n]=e.signals[n]||[]).push(t)})},i.prototype.clearSignalCallbacks=function(n){var t=this;n?n.forEach(function(n){t.signals[n]&&delete t.signals[n]}):t.signals={}},i.prototype.emitSignal=function(n,t){var i;return this.signals[n]&&this.signals[n].forEach(function(n){n=n(t);i=void 0!==n?n:i}),i},{musicalFrequencies:n,SignalHandler:i,getMusicalScale:function(e){return n.filter(function(n,t){var i=t%12+1;return e.some(function(n){return n===i})})},calculateDataExtremes:function(n,i){return n.series.reduce(function(t,n){return n.points.forEach(function(n){n=(void 0!==n[i]?n:n.options)[i];t.min=Math.min(t.min,n),t.max=Math.max(t.max,n)}),t},{min:1/0,max:-1/0})},virtualAxisTranslate:function(n,t,i,e){var o=t.max-t.min,s=Math.abs(i.max-i.min),t=e?t.max-n:n-t.min,t=i.min+s*t/o;return 0<o?a(t,i.min,i.max):i.min}}}),t(n,"Extensions/Sonification/InstrumentDefinitions.js",[n["Extensions/Sonification/Instrument.js"],n["Extensions/Sonification/Utilities.js"]],function(t,i){var e={};return["sine","square","triangle","sawtooth"].forEach(function(n){e[n]=new t({oscillator:{waveformShape:n}}),e[n+"Musical"]=new t({allowedFrequencies:i.musicalFrequencies,oscillator:{waveformShape:n}}),e[n+"Major"]=new t({allowedFrequencies:i.getMusicalScale([1,3,5,6,8,10,12]),oscillator:{waveformShape:n}})}),e}),t(n,"Extensions/Sonification/Earcon.js",[n["Core/Globals.js"],n["Core/Utilities.js"]],function(l,n){var p=n.error,f=n.merge,m=n.pick,t=n.uniqueKey;function i(n){this.init(n||{})}return i.prototype.init=function(n){this.options=n,this.options.id||(this.options.id=this.id=t()),this.instrumentsPlaying={}},i.prototype.sonify=function(n){var t=f(this.options,n),s=m(t.volume,1),a=t.pan,r=this,u=n&&n.onEnd,c=r.options.onEnd;t.instruments.forEach(function(n){var t,i="string"==typeof n.instrument?l.sonification.instruments[n.instrument]:n.instrument,e=f(n.playOptions),o="";i&&i.play?n.playOptions&&(e.pan=m(a,e.pan),t=e.onEnd,e.onEnd=function(){delete r.instrumentsPlaying[o],t&&t.apply(this,arguments),Object.keys(r.instrumentsPlaying).length||(u&&u.apply(this,arguments),c&&c.apply(this,arguments))},(i=i.copy()).setMasterVolume(s),o=i.id,(r.instrumentsPlaying[o]=i).play(e)):p(30)})},i.prototype.cancelSonify=function(t){var i=this.instrumentsPlaying,n=i&&Object.keys(i);n&&n.length&&(n.forEach(function(n){i[n].stop(!t,null,"cancelled")}),this.instrumentsPlaying={})},i}),t(n,"Extensions/Sonification/PointSonify.js",[n["Core/Globals.js"],n["Core/Utilities.js"],n["Extensions/Sonification/Utilities.js"]],function(p,n,f){var m=n.error,h=n.merge,d=n.pick,y={minDuration:20,maxDuration:2e3,minVolume:.1,maxVolume:1,minPan:-1,maxPan:1,minFrequency:220,maxFrequency:2200};return{pointSonify:function(n){function s(t,n,i){if("function"==typeof t)return n?function(n){return t(a,c,n)}:t(a,c);if("string"!=typeof t)return t;var e="-"===t.charAt(0),o=e?t.slice(1):t,n=d(a[o],a.options[o]);return c[o]=c[o]||f.calculateDataExtremes(a.series.chart,o),f.virtualAxisTranslate(n,c[o],i,e)}var a=this,r=a.series.chart,u=d(n.masterVolume,r.options.sonification&&r.options.sonification.masterVolume),c=n.dataExtremes||{};(r.sonification.currentlyPlayingPoint=a).sonification=a.sonification||{},a.sonification.instrumentsPlaying=a.sonification.instrumentsPlaying||{};var l=a.sonification.signalHandler=a.sonification.signalHandler||new f.SignalHandler(["onEnd"]);l.clearSignalCallbacks(),l.registerSignalCallbacks({onEnd:n.onEnd}),!a.isNull&&a.visible&&a.series.visible?n.instruments.forEach(function(t){var n="string"==typeof t.instrument?p.sonification.instruments[t.instrument]:t.instrument,i=t.instrumentMapping||{},e=h(y,t.instrumentOptions),o=n.id;n&&n.play?(void 0!==u&&n.setMasterVolume(u),(a.sonification.instrumentsPlaying[n.id]=n).play({frequency:s(i.frequency,!0,{min:e.minFrequency,max:e.maxFrequency}),duration:s(i.duration,!1,{min:e.minDuration,max:e.maxDuration}),pan:s(i.pan,!0,{min:e.minPan,max:e.maxPan}),volume:s(i.volume,!0,{min:e.minVolume,max:e.maxVolume}),onEnd:function(n){t.onEnd&&t.onEnd.apply(this,arguments),r.sonification&&r.sonification.currentlyPlayingPoint&&delete r.sonification.currentlyPlayingPoint,a.sonification&&a.sonification.instrumentsPlaying&&(delete a.sonification.instrumentsPlaying[o],Object.keys(a.sonification.instrumentsPlaying).length||l.emitSignal("onEnd",n))},minFrequency:e.minFrequency,maxFrequency:e.maxFrequency})):m(30)}):l.emitSignal("onEnd")},pointCancelSonify:function(t){var i=this.sonification&&this.sonification.instrumentsPlaying,n=i&&Object.keys(i);n&&n.length&&(n.forEach(function(n){i[n].stop(!t,null,"cancelled")}),this.sonification.instrumentsPlaying={},this.sonification.signalHandler.emitSignal("onEnd","cancelled"))}}}),t(n,"Extensions/Sonification/ChartSonify.js",[n["Core/Globals.js"],n["Core/Series/Point.js"],n["Core/Utilities.js"],n["Extensions/Sonification/Utilities.js"]],function(p,f,n,m){var c=n.find,l=n.isArray,h=n.merge,d=n.pick,y=n.splat,o=n.objectEach;function g(n,t){return"function"==typeof t?t(n):d(n[t],n.options[t])}function v(n,i){return n.points.reduce(function(n,t){t=g(t,i);return n.min=Math.min(n.min,t),n.max=Math.max(n.max,t),n},{min:1/0,max:-1/0})}function E(e,n,t){function i(n){return{instrumentMapping:n.mapping}}var o=(n||[]).slice(0),n=e.options.sonification&&e.options.sonification.defaultInstrumentOptions;return n&&o.push(i(n)),e.series.forEach(function(n){n=n.options.sonification&&n.options.sonification.instruments;n&&(o=o.concat(n.map(i)))}),o.reduce(function(t,i){return Object.keys(i.instrumentMapping||{}).forEach(function(n){n=i.instrumentMapping[n];"string"!=typeof n||t[n]||(t[n]=m.calculateDataExtremes(e,n))}),t},h(t))}function s(n,s){var t,i,e,o,a=s.timeExtremes||v(n,s.pointPlayTime),r=E(n.chart,s.instruments,s.dataExtremes),u=(i=s.instruments,e=r,o=n.points[n.points.length-1],i.reduce(function(n,t){t=t.instrumentMapping.duration,t="string"==typeof t?0:"function"==typeof t?t(o,e):t;return Math.max(n,t)},0)),c=d(s.masterVolume,1),i=s.instruments.map(function(n){var t=n.instrument,t=("string"==typeof t?p.sonification.instruments[t]:t).copy();return h(n,{instrument:t})}),l=(t=c,(i=i).forEach(function(n){n=n.instrument;"string"!=typeof n&&n.setMasterVolume(t)}),i),i=n.points.reduce(function(n,t){var o,i=(o=t,(s.earcons||[]).reduce(function(n,t){var i,e=t.earcon;return t.condition?(i=t.condition(o))instanceof p.sonification.Earcon?n.push(i):i&&n.push(e):t.onPoint&&o.id===t.onPoint&&n.push(e),n},[])),e=m.virtualAxisTranslate(g(t,s.pointPlayTime),a,{min:0,max:Math.max(s.duration-u,10)});return n.concat(new p.sonification.TimelineEvent({eventObject:t,time:e,id:t.id,playOptions:{instruments:l,dataExtremes:r,masterVolume:c}}),i.map(function(n){return new p.sonification.TimelineEvent({eventObject:n,time:e,playOptions:{volume:c}})}))},[]);return new p.sonification.TimelinePath({events:i,onStart:function(){s.onStart&&s.onStart(n)},onEventStart:function(n){var t=n.options&&n.options.eventObject;if(t instanceof f){if(!t.series.visible&&!t.series.chart.series.some(function(n){return n.visible}))return n.timelinePath.timeline.pause(),n.timelinePath.timeline.resetCursor(),!1;s.onPointStart&&s.onPointStart(n,t)}},onEventEnd:function(n){var t=n.event&&n.event.options&&n.event.options.eventObject;t instanceof f&&s.onPointEnd&&s.onPointEnd(n.event,t)},onEnd:function(){s.onEnd&&s.onEnd(n)},targetDuration:s.duration})}function S(n,t){var e=Math.max(t-n.reduce(function(n,t){t=y(t);return n+(1===t.length&&t[0].options&&t[0].options.silentWait||0)},0),0),o=n.reduce(function(n,t){return n+y(t).reduce(function(n,t){t=t.series&&t.seriesOptions&&t.seriesOptions.timeExtremes;return t?Math.max(n,t.max-t.min):n},0)},0);return n.reduce(function(n,t){t=y(t).reduce(function(n,t){var i;return t instanceof p.sonification.TimelinePath?n.push(t):t.series&&(t.seriesOptions.duration=t.seriesOptions.duration||(i=t.seriesOptions.timeExtremes.max-t.seriesOptions.timeExtremes.min,m.virtualAxisTranslate(i,{min:0,max:o},{min:0,max:e})),n.push(s(t.series,t.seriesOptions))),n},[]);return n.push(t),n},[])}function a(n,t){if(t&&t.instruments)return t.instruments;function i(i){o(i,function(n,t){null===n&&delete i[t]})}var e=n.chart.options.sonification&&n.chart.options.sonification.defaultInstrumentOptions||{},n=n.options.sonification&&n.options.sonification.instruments||[{}];return n.map(function(n){return i(n.mapping||{}),i(n),{instrument:n.instrument||e.instrument,instrumentOptions:h(e,n,{mapping:void 0,instrument:void 0}),instrumentMapping:h(e.mapping,n.mapping)}})}function x(n){var t=n.options.sonification||{},i=n.chart.options.sonification||{},e=i.events||{},o=t.events||{};return{onEnd:o.onSeriesEnd||e.onSeriesEnd,onStart:o.onSeriesStart||e.onSeriesStart,onPointEnd:o.onPointEnd||e.onPointEnd,onPointStart:o.onPointStart||e.onPointStart,pointPlayTime:i.defaultInstrumentOptions&&i.defaultInstrumentOptions.mapping&&i.defaultInstrumentOptions.mapping.pointPlayTime,masterVolume:i.masterVolume,instruments:a(n),earcons:t.earcons||i.earcons}}return{chartSonify:function(n){var t,a=(t=(t=this).options.sonification||{},h({duration:t.duration,afterSeriesWait:t.afterSeriesWait,pointPlayTime:t.defaultInstrumentOptions&&t.defaultInstrumentOptions.mapping&&t.defaultInstrumentOptions.mapping.pointPlayTime,order:t.order,onSeriesStart:t.events&&t.events.onSeriesStart,onSeriesEnd:t.events&&t.events.onSeriesEnd,onEnd:t.events&&t.events.onEnd},n));this.sonification.timeline&&this.sonification.timeline.pause(),this.sonification.duration=a.duration;var o,s,e,r,u=E(this,a.instruments,a.dataExtremes),i=(n=a.order,o=this,s=function(n){return t=n,i=u,o=(e=a).seriesOptions||{},s=t.chart.options.sonification&&t.chart.options.sonification.defaultInstrumentOptions&&t.chart.options.sonification.defaultInstrumentOptions.mapping&&t.chart.options.sonification.defaultInstrumentOptions.mapping.pointPlayTime||"x",n=x(t),h(n,{dataExtremes:i,timeExtremes:v(t,s),instruments:e.instruments||n.instruments,onStart:e.onSeriesStart||n.onStart,onEnd:e.onSeriesEnd||n.onEnd,earcons:e.earcons||n.earcons,masterVolume:d(e.masterVolume,n.masterVolume)},l(o)?c(o,function(n){return n.id===d(t.id,t.options.id)})||{}:o,{pointPlayTime:s});var t,i,e,o,s},"sequential"===n||"simultaneous"===n?(i=o.series.reduce(function(n,t){return t.visible&&!1!==(t.options.sonification&&t.options.sonification.enabled)&&n.push({series:t,seriesOptions:s(t)}),n},[]),"simultaneous"===n&&(i=[i])):i=n.reduce(function(n,t){t=y(t).reduce(function(n,t){var i,e;return"string"==typeof t?(e=o.get(t)).visible&&(i={series:e,seriesOptions:s(e)}):t instanceof p.sonification.Earcon&&(i=new p.sonification.TimelinePath({events:[new p.sonification.TimelineEvent({eventObject:t})]})),(i=t.silentWait?new p.sonification.TimelinePath({silentWait:t.silentWait}):i)&&n.push(i),n},[]);return t.length&&n.push(t),n},[]),i);e=i,(i=S(i=(r=a.afterSeriesWait||0)?e.reduce(function(n,t,i){t=y(t);return n.push(t),i<e.length-1&&t.some(function(n){return n.series})&&n.push(new p.sonification.TimelinePath({silentWait:r})),n},[]):e,a.duration)).forEach(function(n){var o;o=(n=n).reduce(function(n,t){t=t.events;return t&&t.length&&(n.min=Math.min(t[0].time,n.min),n.max=Math.max(t[t.length-1].time,n.max)),n},{min:1/0,max:-1/0}),n.forEach(function(n){var t=n.events,i=t&&t.length,e=[];i&&t[0].time<=o.min||e.push(new p.sonification.TimelineEvent({time:o.min})),i&&t[t.length-1].time>=o.max||e.push(new p.sonification.TimelineEvent({time:o.max})),e.length&&n.addTimelineEvents(e)})}),this.sonification.timeline=new p.sonification.Timeline({paths:i,onEnd:a.onEnd}),this.sonification.timeline.play()},seriesSonify:function(n){var t=(e=n,t=(i=this).chart.options.sonification,n=i.options.sonification,h({duration:n&&n.duration||t&&t.duration},x(i),e)),i=s(this,t),e=this.chart.sonification;e.timeline&&e.timeline.pause(),e.duration=t.duration,e.timeline=new p.sonification.Timeline({paths:[i]}),e.timeline.play()},pause:function(n){this.sonification.timeline?this.sonification.timeline.pause(d(n,!0)):this.sonification.currentlyPlayingPoint&&this.sonification.currentlyPlayingPoint.cancelSonify(n)},resume:function(n){this.sonification.timeline&&this.sonification.timeline.play(n)},rewind:function(n){this.sonification.timeline&&this.sonification.timeline.rewind(n)},cancel:function(n){this.pauseSonify(n),this.resetSonifyCursor()},getCurrentPoints:function(){var t;return this.sonification.timeline?(t=this.sonification.timeline.getCursor(),Object.keys(t).map(function(n){return t[n].eventObject}).filter(function(n){return n instanceof f})):[]},setCursor:function(n){var t=this.sonification.timeline;t&&y(n).forEach(function(n){t.setCursor(n.id)})},resetCursor:function(){this.sonification.timeline&&this.sonification.timeline.resetCursor()},resetCursorEnd:function(){this.sonification.timeline&&this.sonification.timeline.resetCursorEnd()}}}),t(n,"Extensions/Sonification/Timeline.js",[n["Core/Globals.js"],n["Core/Utilities.js"],n["Extensions/Sonification/Utilities.js"]],function(t,n,i){var s=n.merge,c=n.splat,e=n.uniqueKey;function o(n){this.init(n||{})}function a(n){this.init(n)}function r(n){this.init(n||{})}return o.prototype.init=function(n){this.options=n,this.time=n.time||0,this.id=this.options.id=n.id||e()},o.prototype.play=function(n){var t=this.options.eventObject,i=this.options.onEnd,e=n&&n.onEnd,o=this.options.playOptions&&this.options.playOptions.onEnd,n=s(this.options.playOptions,n);t&&t.sonify?(n.onEnd=i||e||o?function(){var t=arguments;[i,e,o].forEach(function(n){n&&n.apply(this,t)})}:void 0,t.sonify(n)):(e&&e(),i&&i())},o.prototype.cancel=function(n){this.options.eventObject.cancelSonify(n)},a.prototype.init=function(n){this.options=n,this.id=this.options.id=n.id||e(),this.cursor=0,this.eventsPlaying={},this.events=n.silentWait?[new o({time:0}),new o({time:n.silentWait})]:this.options.events,this.targetDuration=n.targetDuration||n.silentWait,this.sortEvents(),this.updateEventIdMap(),this.signalHandler=new i.SignalHandler(["playOnEnd","masterOnEnd","onStart","onEventStart","onEventEnd"]),this.signalHandler.registerSignalCallbacks(s(n,{masterOnEnd:n.onEnd}))},a.prototype.sortEvents=function(){this.events=this.events.sort(function(n,t){return n.time-t.time})},a.prototype.updateEventIdMap=function(){this.eventIdMap=this.events.reduce(function(n,t,i){return n[t.id]=i,n},{})},a.prototype.addTimelineEvents=function(n){this.events=this.events.concat(n),this.sortEvents(),this.updateEventIdMap()},a.prototype.getCursor=function(){return this.events[this.cursor]},a.prototype.setCursor=function(n){n=this.eventIdMap[n];return void 0!==n&&(this.cursor=n,!0)},a.prototype.play=function(n){this.pause(),this.signalHandler.emitSignal("onStart"),this.signalHandler.clearSignalCallbacks(["playOnEnd"]),this.signalHandler.registerSignalCallbacks({playOnEnd:n}),this.playEvents(1)},a.prototype.rewind=function(n){this.pause(),this.signalHandler.emitSignal("onStart"),this.signalHandler.clearSignalCallbacks(["playOnEnd"]),this.signalHandler.registerSignalCallbacks({playOnEnd:n}),this.playEvents(-1)},a.prototype.resetCursor=function(){this.cursor=0},a.prototype.resetCursorEnd=function(){this.cursor=this.events.length-1},a.prototype.pause=function(t){var i=this;clearTimeout(i.nextScheduledPlay),Object.keys(i.eventsPlaying).forEach(function(n){i.eventsPlaying[n]&&i.eventsPlaying[n].cancel(t)}),i.eventsPlaying={}},a.prototype.playEvents=function(n){function t(n){e.signalHandler.emitSignal("masterOnEnd",n),e.signalHandler.emitSignal("playOnEnd",n)}var i,e=this,o=e.events[this.cursor],s=e.events[this.cursor+n];!1!==(o.timelinePath=e).signalHandler.emitSignal("onEventStart",o)?((e.eventsPlaying[o.id]=o).play({onEnd:function(n){n={event:o,cancelled:!!n};delete e.eventsPlaying[o.id],e.signalHandler.emitSignal("onEventEnd",n),s||t(n)}}),s&&((i=Math.abs(s.time-o.time))<1?(e.cursor+=n,e.playEvents(n)):this.nextScheduledPlay=setTimeout(function(){e.cursor+=n,e.playEvents(n)},i))):t({event:o,cancelled:!0})},r.prototype.init=function(n){this.options=n,this.cursor=0,this.paths=n.paths||[],this.pathsPlaying={},this.signalHandler=new i.SignalHandler(["playOnEnd","masterOnEnd","onPathStart","onPathEnd"]),this.signalHandler.registerSignalCallbacks(s(n,{masterOnEnd:n.onEnd}))},r.prototype.play=function(n){this.pause(),this.signalHandler.clearSignalCallbacks(["playOnEnd"]),this.signalHandler.registerSignalCallbacks({playOnEnd:n}),this.playPaths(1)},r.prototype.rewind=function(n){this.pause(),this.signalHandler.clearSignalCallbacks(["playOnEnd"]),this.signalHandler.registerSignalCallbacks({playOnEnd:n}),this.playPaths(-1)},r.prototype.playPaths=function(e){var o=this,s=o.signalHandler;if(!o.paths.length){var n={cancelled:!1};return s.emitSignal("playOnEnd",n),void s.emitSignal("masterOnEnd",n)}var a=c(this.paths[this.cursor]),r=this.paths[this.cursor+e],u=0;a.forEach(function(n){n&&(n.timeline=o,setTimeout(function(){var i;i=n,s.emitSignal("onPathStart",i),(o.pathsPlaying[i.id]=i)[0<e?"play":"rewind"](function(n){var t=n&&n.cancelled,n={path:i,cancelled:t};delete o.pathsPlaying[i.id],s.emitSignal("onPathEnd",n),++u>=a.length&&(r&&!t?(o.cursor+=e,c(r).forEach(function(n){n[0<e?"resetCursor":"resetCursorEnd"]()}),o.playPaths(e)):(s.emitSignal("playOnEnd",n),s.emitSignal("masterOnEnd",n)))})},t.sonification.fadeOutDuration))})},r.prototype.pause=function(t){var i=this;Object.keys(i.pathsPlaying).forEach(function(n){i.pathsPlaying[n]&&i.pathsPlaying[n].pause(t)}),i.pathsPlaying={}},r.prototype.resetCursor=function(){this.paths.forEach(function(n){c(n).forEach(function(n){n.resetCursor()})}),this.cursor=0},r.prototype.resetCursorEnd=function(){this.paths.forEach(function(n){c(n).forEach(function(n){n.resetCursorEnd()})}),this.cursor=this.paths.length-1},r.prototype.setCursor=function(t){return this.paths.some(function(n){return c(n).some(function(n){return n.setCursor(t)})})},r.prototype.getCursor=function(){return this.getCurrentPlayingPaths().reduce(function(n,t){return n[t.id]=t.getCursor(),n},{})},r.prototype.atStart=function(){return!this.cursor&&!c(this.paths[0]).some(function(n){return n.cursor})},r.prototype.getCurrentPlayingPaths=function(){return this.paths.length?c(this.paths[this.cursor]):[]},{TimelineEvent:o,TimelinePath:a,Timeline:r}}),t(n,"Extensions/Sonification/Options.js",[],function(){return{sonification:{enabled:!1,duration:2500,afterSeriesWait:700,masterVolume:1,order:"sequential",defaultInstrumentOptions:{instrument:"sineMusical",minFrequency:392,maxFrequency:1046,mapping:{pointPlayTime:"x",duration:200,frequency:"y"}}}}}),t(n,"Extensions/Sonification/Sonification.js",[n["Core/Chart/Chart.js"],n["Core/Globals.js"],n["Core/DefaultOptions.js"],n["Core/Series/Point.js"],n["Core/Series/Series.js"],n["Core/Utilities.js"],n["Extensions/Sonification/Instrument.js"],n["Extensions/Sonification/InstrumentDefinitions.js"],n["Extensions/Sonification/Earcon.js"],n["Extensions/Sonification/PointSonify.js"],n["Extensions/Sonification/ChartSonify.js"],n["Extensions/Sonification/Utilities.js"],n["Extensions/Sonification/Timeline.js"],n["Extensions/Sonification/Options.js"]],function(n,t,i,e,o,s,a,r,u,c,l,p,f,m){var h=i.defaultOptions,d=s.addEvent,i=s.extend,y=s.merge;t.sonification={fadeOutDuration:20,utilities:p,Instrument:a,instruments:r,Earcon:u,TimelineEvent:f.TimelineEvent,TimelinePath:f.TimelinePath,Timeline:f.Timeline},y(!0,h,m),e.prototype.sonify=c.pointSonify,e.prototype.cancelSonify=c.pointCancelSonify,o.prototype.sonify=l.seriesSonify,i(n.prototype,{sonify:l.chartSonify,pauseSonify:l.pause,resumeSonify:l.resume,rewindSonify:l.rewind,cancelSonify:l.cancel,getCurrentSonifyPoints:l.getCurrentPoints,setSonifyCursor:l.setCursor,resetSonifyCursor:l.resetCursor,resetSonifyCursorEnd:l.resetCursorEnd}),d(n,"init",function(){this.sonification={}}),d(n,"update",function(n){n=n.options.sonification;n&&y(!0,this.options.sonification,n)})}),t(n,"masters/modules/sonification.src.js",[],function(){})});