/*
 Highstock JS v9.1.2 (2021-06-16)

 Highcharts Stock as a plugin for Highcharts

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(J){a(J);a.Highcharts=J;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function J(a,t,x,y){a.hasOwnProperty(t)||(a[t]=y.apply(null,x))}a=a?a._modules:{};J(a,"Core/Axis/NavigatorAxis.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,t){var x=a.isTouchDevice,y=t.addEvent,
n=t.correctFloat,G=t.defined,w=t.isNumber,v=t.pick,c=function(){function b(b){this.axis=b}b.prototype.destroy=function(){this.axis=void 0};b.prototype.toFixedRange=function(b,c,a,P){var g=this.axis,C=g.chart;C=C&&C.fixedRange;var O=(g.pointRange||0)/2;b=v(a,g.translate(b,!0,!g.horiz));c=v(P,g.translate(c,!0,!g.horiz));g=C&&(c-b)/C;G(a)||(b=n(b+O));G(P)||(c=n(c-O));.7<g&&1.3>g&&(P?b=c-C:c=b+C);w(b)&&w(c)||(b=c=void 0);return{min:b,max:c}};return b}();return function(){function b(){}b.compose=function(b){b.keepProps.push("navigatorAxis");
y(b,"init",function(){this.navigatorAxis||(this.navigatorAxis=new c(this))});y(b,"zoom",function(b){var c=this.chart.options,a=c.navigator,g=this.navigatorAxis,C=c.chart.pinchType,O=c.rangeSelector;c=c.chart.zoomType;this.isXAxis&&(a&&a.enabled||O&&O.enabled)&&("y"===c?b.zoomed=!1:(!x&&"xy"===c||x&&"xy"===C)&&this.options.range&&(a=g.previousZoom,G(b.newMin)?g.previousZoom=[this.min,this.max]:a&&(b.newMin=a[0],b.newMax=a[1],g.previousZoom=void 0)));"undefined"!==typeof b.zoomed&&b.preventDefault()})};
b.AdditionsClass=c;return b}()});J(a,"Core/Axis/ScrollbarAxis.js",[a["Core/Utilities.js"]],function(a){var t=a.addEvent,x=a.defined,y=a.pick;return function(){function a(){}a.compose=function(a,n){var w=function(c){var b=y(c.options&&c.options.min,c.min),a=y(c.options&&c.options.max,c.max);return{axisMin:b,axisMax:a,scrollMin:x(c.dataMin)?Math.min(b,c.min,c.dataMin,y(c.threshold,Infinity)):b,scrollMax:x(c.dataMax)?Math.max(a,c.max,c.dataMax,y(c.threshold,-Infinity)):a}};t(a,"afterInit",function(){var c=
this;c.options&&c.options.scrollbar&&c.options.scrollbar.enabled&&(c.options.scrollbar.vertical=!c.horiz,c.options.startOnTick=c.options.endOnTick=!1,c.scrollbar=new n(c.chart.renderer,c.options.scrollbar,c.chart),t(c.scrollbar,"changed",function(b){var a=w(c),g=a.axisMax,q=a.scrollMin,n=a.scrollMax-q;x(a.axisMin)&&x(g)&&(c.horiz&&!c.reversed||!c.horiz&&c.reversed?(a=q+n*this.to,q+=n*this.from):(a=q+n*(1-this.from),q+=n*(1-this.to)),this.shouldUpdateExtremes(b.DOMType)?c.setExtremes(q,a,!0,"mousemove"!==
b.DOMType&&"touchmove"!==b.DOMType,b):this.setRange(this.from,this.to))}))});t(a,"afterRender",function(){var c=w(this),b=c.scrollMin,a=c.scrollMax;c=this.scrollbar;var g=this.axisTitleMargin+(this.titleOffset||0),q=this.chart.scrollbarsOffsets,n=this.options.margin||0;c&&(this.horiz?(this.opposite||(q[1]+=g),c.position(this.left,this.top+this.height+2+q[1]-(this.opposite?n:0),this.width,this.height),this.opposite||(q[1]+=n),g=1):(this.opposite&&(q[0]+=g),c.position(this.left+this.width+2+q[0]-(this.opposite?
0:n),this.top,this.width,this.height),this.opposite&&(q[0]+=n),g=0),q[g]+=c.size+c.options.margin,isNaN(b)||isNaN(a)||!x(this.min)||!x(this.max)||this.min===this.max?c.setRange(0,1):(q=(this.min-b)/(a-b),b=(this.max-b)/(a-b),this.horiz&&!this.reversed||!this.horiz&&this.reversed?c.setRange(q,b):c.setRange(1-b,1-q)))});t(a,"afterGetOffset",function(){var c=this.horiz?2:1,b=this.scrollbar;b&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[c]+=b.size+b.options.margin)});return a};return a}()});
J(a,"Core/ScrollbarDefaults.js",[a["Core/Globals.js"],a["Core/Color/Palette.js"]],function(a,t){return{height:a.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:t.neutralColor20,barBorderWidth:1,barBorderColor:t.neutralColor20,buttonArrowColor:t.neutralColor80,buttonBackgroundColor:t.neutralColor10,buttonBorderColor:t.neutralColor20,buttonBorderWidth:1,rifleColor:t.neutralColor80,trackBackgroundColor:t.neutralColor5,
trackBorderColor:t.neutralColor5,trackBorderWidth:1}});J(a,"Core/Scrollbar.js",[a["Core/DefaultOptions.js"],a["Core/Globals.js"],a["Core/Axis/ScrollbarAxis.js"],a["Core/ScrollbarDefaults.js"],a["Core/Utilities.js"]],function(a,t,x,y,n){var G=a.defaultOptions,w=n.addEvent,v=n.correctFloat,c=n.defined,b=n.destroyObjectProperties,E=n.fireEvent,g=n.merge,q=n.pick,P=n.removeEvent;a=function(){function a(a,b,c){this._events=[];this.chart=void 0;this.from=this.chartY=this.chartX=0;this.scrollbar=this.renderer=
this.options=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=void 0;this.trackBorderWidth=1;this.userOptions=void 0;this.y=this.x=0;this.init(a,b,c)}a.compose=function(b){x.compose(b,a)};a.swapXY=function(a,b){b&&a.forEach(function(a){for(var b=a.length,C,h=0;h<b;h+=2)C=a[h+1],"number"===typeof C&&(a[h+1]=a[h+2],a[h+2]=C)});return a};a.prototype.addEvents=
function(){var a=this.options.inverted?[1,0]:[0,1],b=this.scrollbarButtons,c=this.scrollbarGroup.element,B=this.track.element,l=this.mouseDownHandler.bind(this),h=this.mouseMoveHandler.bind(this),p=this.mouseUpHandler.bind(this);a=[[b[a[0]].element,"click",this.buttonToMinClick.bind(this)],[b[a[1]].element,"click",this.buttonToMaxClick.bind(this)],[B,"click",this.trackClick.bind(this)],[c,"mousedown",l],[c.ownerDocument,"mousemove",h],[c.ownerDocument,"mouseup",p]];t.hasTouch&&a.push([c,"touchstart",
l],[c.ownerDocument,"touchmove",h],[c.ownerDocument,"touchend",p]);a.forEach(function(a){w.apply(null,a)});this._events=a};a.prototype.buttonToMaxClick=function(a){var b=(this.to-this.from)*q(this.options.step,.2);this.updatePosition(this.from+b,this.to+b);E(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.buttonToMinClick=function(a){var b=v(this.to-this.from)*q(this.options.step,.2);this.updatePosition(v(this.from-b),v(this.to-b));E(this,"changed",{from:this.from,
to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.cursorToScrollbarPosition=function(a){var b=this.options;b=b.minWidth>this.calculatedWidth?b.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/(this.barWidth-b),chartY:(a.chartY-this.y-this.yOffset)/(this.barWidth-b)}};a.prototype.destroy=function(){var a=this,c=a.chart.scroller;a.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(b){a[b]&&a[b].destroy&&(a[b]=a[b].destroy())});c&&a===c.scrollbar&&
(c.scrollbar=null,b(c.scrollbarButtons))};a.prototype.drawScrollbarButton=function(b){var c=this.renderer,C=this.scrollbarButtons,B=this.options,l=this.size,h=c.g().add(this.group);C.push(h);h=c.rect().addClass("highcharts-scrollbar-button").add(h);this.chart.styledMode||h.attr({stroke:B.buttonBorderColor,"stroke-width":B.buttonBorderWidth,fill:B.buttonBackgroundColor});h.attr(h.crisp({x:-.5,y:-.5,width:l+1,height:l+1,r:B.buttonBorderRadius},h.strokeWidth()));h=c.path(a.swapXY([["M",l/2+(b?-1:1),
l/2-3],["L",l/2+(b?-1:1),l/2+3],["L",l/2+(b?2:-2),l/2]],B.vertical)).addClass("highcharts-scrollbar-arrow").add(C[b]);this.chart.styledMode||h.attr({fill:B.buttonArrowColor})};a.prototype.init=function(a,b,c){this.scrollbarButtons=[];this.renderer=a;this.userOptions=b;this.options=g(y,G.scrollbar,b);this.chart=c;this.size=q(this.options.size,this.options.height);b.enabled&&(this.render(),this.addEvents())};a.prototype.mouseDownHandler=function(a){a=this.chart.pointer.normalize(a);a=this.cursorToScrollbarPosition(a);
this.chartX=a.chartX;this.chartY=a.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=!0};a.prototype.mouseMoveHandler=function(a){var b=this.chart.pointer.normalize(a),c=this.options.vertical?"chartY":"chartX",B=this.initPositions||[];!this.grabbedCenter||a.touches&&0===a.touches[0][c]||(b=this.cursorToScrollbarPosition(b)[c],c=this[c],c=b-c,this.hasDragged=!0,this.updatePosition(B[0]+c,B[1]+c),this.hasDragged&&E(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,
DOMEvent:a}))};a.prototype.mouseUpHandler=function(a){this.hasDragged&&E(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};a.prototype.position=function(a,b,c,B){var l=this.options.vertical,h=this.rendered?"animate":"attr",p=0;this.x=a;this.y=b+this.trackBorderWidth;this.width=c;this.xOffset=this.height=B;this.yOffset=p;l?(this.width=this.yOffset=c=p=this.size,this.xOffset=b=0,this.barWidth=B-
2*c,this.x=a+=this.options.margin):(this.height=this.xOffset=B=b=this.size,this.barWidth=c-2*B,this.y+=this.options.margin);this.group[h]({translateX:a,translateY:this.y});this.track[h]({width:c,height:B});this.scrollbarButtons[1][h]({translateX:l?0:c-b,translateY:l?B-p:0})};a.prototype.removeEvents=function(){this._events.forEach(function(a){P.apply(null,a)});this._events.length=0};a.prototype.render=function(){var b=this.renderer,c=this.options,g=this.size,B=this.chart.styledMode,l=b.g("scrollbar").attr({zIndex:c.zIndex,
translateY:-99999}).add();this.group=l;this.track=b.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:c.trackBorderRadius||0,height:g,width:g}).add(l);B||this.track.attr({fill:c.trackBackgroundColor,stroke:c.trackBorderColor,"stroke-width":c.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=b.g().add(l);this.scrollbar=b.rect().addClass("highcharts-scrollbar-thumb").attr({height:g,width:g,r:c.barBorderRadius||
0}).add(this.scrollbarGroup);this.scrollbarRifles=b.path(a.swapXY([["M",-3,g/4],["L",-3,2*g/3],["M",0,g/4],["L",0,2*g/3],["M",3,g/4],["L",3,2*g/3]],c.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);B||(this.scrollbar.attr({fill:c.barBackgroundColor,stroke:c.barBorderColor,"stroke-width":c.barBorderWidth}),this.scrollbarRifles.attr({stroke:c.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%
2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};a.prototype.setRange=function(a,b){var g=this.options,B=g.vertical,l=g.minWidth,h=this.barWidth,p=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(c(h)){var D=h*Math.min(b,1);a=Math.max(a,0);var K=Math.ceil(h*a);this.calculatedWidth=D=v(D-K);D<l&&(K=(h-l+D)*a,D=l);l=Math.floor(K+this.xOffset+this.yOffset);h=D/2-.5;this.from=a;this.to=b;B?(this.scrollbarGroup[p]({translateY:l}),
this.scrollbar[p]({height:D}),this.scrollbarRifles[p]({translateY:h}),this.scrollbarTop=l,this.scrollbarLeft=0):(this.scrollbarGroup[p]({translateX:l}),this.scrollbar[p]({width:D}),this.scrollbarRifles[p]({translateX:h}),this.scrollbarLeft=l,this.scrollbarTop=0);12>=D?this.scrollbarRifles.hide():this.scrollbarRifles.show(!0);!1===g.showFull&&(0>=a&&1<=b?this.group.hide():this.group.show());this.rendered=!0}};a.prototype.shouldUpdateExtremes=function(a){return q(this.options.liveRedraw,t.svg&&!t.isTouchDevice&&
!this.chart.isBoosting)||"mouseup"===a||"touchend"===a||!c(a)};a.prototype.trackClick=function(a){var b=this.chart.pointer.normalize(a),c=this.to-this.from,B=this.y+this.scrollbarTop,l=this.x+this.scrollbarLeft;this.options.vertical&&b.chartY>B||!this.options.vertical&&b.chartX>l?this.updatePosition(this.from+c,this.to+c):this.updatePosition(this.from-c,this.to-c);E(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.update=function(a){this.destroy();this.init(this.chart.renderer,
g(!0,this.options,a),this.chart)};a.prototype.updatePosition=function(a,b){1<b&&(a=v(1-v(b-a)),b=1);0>a&&(b=v(b-a),a=0);this.from=a;this.to=b};a.defaultOptions=y;return a}();G.scrollbar=g(!0,a.defaultOptions,G.scrollbar);return a});J(a,"Core/Navigator.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxis.js"],a["Core/DefaultOptions.js"],a["Core/Color/Palette.js"],a["Core/Renderer/RendererRegistry.js"],a["Core/Scrollbar.js"],a["Core/Series/Series.js"],
a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,t,x,y,n,G,w,v,c,b,E,g){x=x.parse;var q=y.hasTouch,P=y.isTouchDevice,Q=G.defaultOptions,C=g.addEvent,O=g.clamp,H=g.correctFloat,B=g.defined,l=g.destroyObjectProperties,h=g.erase,p=g.extend,D=g.find,K=g.isArray,L=g.isNumber,A=g.merge,F=g.pick,u=g.removeEvent,r=g.splat,m=function(k){for(var d=[],f=1;f<arguments.length;f++)d[f-1]=arguments[f];d=[].filter.call(d,L);if(d.length)return Math[k].apply(0,d)};G="undefined"===typeof E.seriesTypes.areaspline?
"line":"areaspline";p(Q,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:w.neutralColor5,borderColor:w.neutralColor40},maskFill:x(w.highlightColor60).setOpacity(.3).get(),outlineColor:w.neutralColor20,outlineWidth:1,series:{type:G,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",
units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:w.neutralColor10,gridLineWidth:1,tickPixelInterval:200,
labels:{align:"left",style:{color:w.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});v.getRendererType().prototype.symbols["navigator-handle"]=function(k,d,f,z,e){k=(e&&e.width||0)/2;d=Math.round(k/3)+.5;e=e&&e.height||0;return[["M",-k-1,.5],["L",k,.5],["L",k,e+.5],["L",-k-1,e+.5],["L",-k-1,.5],["M",-d,4],["L",
-d,e-3],["M",d-1,4],["L",d-1,e-3]]};var e=function(){function e(d){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(d)}e.prototype.drawHandle=function(d,f,e,m){var z=this.navigatorOptions.handles.height;this.handles[f][m](e?
{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(d,10)+.5-z)}:{translateX:Math.round(this.left+parseInt(d,10)),translateY:Math.round(this.top+this.height/2-z/2-1)})};e.prototype.drawOutline=function(d,f,e,m){var z=this.navigatorOptions.maskInside,k=this.outline.strokeWidth(),a=k/2,b=k%2/2;k=this.outlineHeight;var r=this.scrollbarHeight||0,c=this.size,I=this.left-r,h=this.top;e?(I-=a,e=h+f+b,f=h+d+b,b=[["M",I+k,h-r-b],["L",I+k,e],["L",I,e],["L",I,f],["L",I+k,
f],["L",I+k,h+c+r]],z&&b.push(["M",I+k,e-a],["L",I+k,f+a])):(d+=I+r-b,f+=I+r-b,h+=a,b=[["M",I,h],["L",d,h],["L",d,h+k],["L",f,h+k],["L",f,h],["L",I+c+2*r,h]],z&&b.push(["M",d-a,h],["L",f+a,h]));this.outline[m]({d:b})};e.prototype.drawMasks=function(d,f,e,m){var z=this.left,k=this.top,a=this.height;if(e){var b=[z,z,z];var r=[k,k+d,k+f];var c=[a,a,a];var I=[d,f-d,this.size-f]}else b=[z,z+d,z+f],r=[k,k,k],c=[d,f-d,this.size-f],I=[a,a,a];this.shades.forEach(function(d,f){d[m]({x:b[f],y:r[f],width:c[f],
height:I[f]})})};e.prototype.renderElements=function(){var d=this,f=d.navigatorOptions,e=f.maskInside,k=d.chart,m=k.renderer,a,b={cursor:k.inverted?"ns-resize":"ew-resize"};d.navigatorGroup=a=m.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!e,e,!e].forEach(function(e,z){d.shades[z]=m.rect().addClass("highcharts-navigator-mask"+(1===z?"-inside":"-outside")).add(a);k.styledMode||d.shades[z].attr({fill:e?f.maskFill:"rgba(0,0,0,0)"}).css(1===z&&b)});d.outline=m.path().addClass("highcharts-navigator-outline").add(a);
k.styledMode||d.outline.attr({"stroke-width":f.outlineWidth,stroke:f.outlineColor});f.handles.enabled&&[0,1].forEach(function(e){f.handles.inverted=k.inverted;d.handles[e]=m.symbol(f.handles.symbols[e],-f.handles.width/2-1,0,f.handles.width,f.handles.height,f.handles);d.handles[e].attr({zIndex:7-e}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][e]).add(a);if(!k.styledMode){var z=f.handles;d.handles[e].attr({fill:z.backgroundColor,stroke:z.borderColor,"stroke-width":z.lineWidth}).css(b)}})};
e.prototype.update=function(d){(this.series||[]).forEach(function(d){d.baseSeries&&delete d.baseSeries.navigatorSeries});this.destroy();A(!0,this.chart.options.navigator,this.options,d);this.init(this.chart)};e.prototype.render=function(d,f,e,k){var z=this.chart,m=this.scrollbarHeight,a,b=this.xAxis,r=b.pointRange||0;var c=b.navigatorAxis.fake?z.xAxis[0]:b;var I=this.navigatorEnabled,h,p=this.rendered;var u=z.inverted;var l=z.xAxis[0].minRange,A=z.xAxis[0].options.maxRange;if(!this.hasDragged||B(e)){d=
H(d-r/2);f=H(f+r/2);if(!L(d)||!L(f))if(p)e=0,k=F(b.width,c.width);else return;this.left=F(b.left,z.plotLeft+m+(u?z.plotWidth:0));this.size=h=a=F(b.len,(u?z.plotHeight:z.plotWidth)-2*m);z=u?m:a+2*m;e=F(e,b.toPixels(d,!0));k=F(k,b.toPixels(f,!0));L(e)&&Infinity!==Math.abs(e)||(e=0,k=z);d=b.toValue(e,!0);f=b.toValue(k,!0);var D=Math.abs(H(f-d));D<l?this.grabbedLeft?e=b.toPixels(f-l-r,!0):this.grabbedRight&&(k=b.toPixels(d+l+r,!0)):B(A)&&H(D-r)>A&&(this.grabbedLeft?e=b.toPixels(f-A-r,!0):this.grabbedRight&&
(k=b.toPixels(d+A+r,!0)));this.zoomedMax=O(Math.max(e,k),0,h);this.zoomedMin=O(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(e,k),0,h);this.range=this.zoomedMax-this.zoomedMin;h=Math.round(this.zoomedMax);e=Math.round(this.zoomedMin);I&&(this.navigatorGroup.attr({visibility:"visible"}),p=p&&!this.hasDragged?"animate":"attr",this.drawMasks(e,h,u,p),this.drawOutline(e,h,u,p),this.navigatorOptions.handles.enabled&&(this.drawHandle(e,0,u,p),this.drawHandle(h,1,u,p)));this.scrollbar&&(u?(u=this.top-
m,c=this.left-m+(I||!c.opposite?0:(c.titleOffset||0)+c.axisTitleMargin),m=a+2*m):(u=this.top+(I?this.height:-m),c=this.left-m),this.scrollbar.position(c,u,z,m),this.scrollbar.setRange(this.zoomedMin/(a||1),this.zoomedMax/(a||1)));this.rendered=!0}};e.prototype.addMouseEvents=function(){var d=this,f=d.chart,e=f.container,k=[],m,a;d.mouseMoveHandler=m=function(f){d.onMouseMove(f)};d.mouseUpHandler=a=function(f){d.onMouseUp(f)};k=d.getPartsEvents("mousedown");k.push(C(f.renderTo,"mousemove",m),C(e.ownerDocument,
"mouseup",a));q&&(k.push(C(f.renderTo,"touchmove",m),C(e.ownerDocument,"touchend",a)),k.concat(d.getPartsEvents("touchstart")));d.eventsToUnbind=k;d.series&&d.series[0]&&k.push(C(d.series[0].xAxis,"foundExtremes",function(){f.navigator.modifyNavigatorAxisExtremes()}))};e.prototype.getPartsEvents=function(d){var f=this,e=[];["shades","handles"].forEach(function(k){f[k].forEach(function(m,z){e.push(C(m.element,d,function(d){f[k+"Mousedown"](d,z)}))})});return e};e.prototype.shadesMousedown=function(d,
f){d=this.chart.pointer.normalize(d);var e=this.chart,k=this.xAxis,m=this.zoomedMin,a=this.left,b=this.size,r=this.range,c=d.chartX;e.inverted&&(c=d.chartY,a=this.top);if(1===f)this.grabbedCenter=c,this.fixedWidth=r,this.dragOffset=c-m;else{d=c-a-r/2;if(0===f)d=Math.max(0,d);else if(2===f&&d+r>=b)if(d=b-r,this.reversedExtremes){d-=r;var h=this.getUnionExtremes().dataMin}else var u=this.getUnionExtremes().dataMax;d!==m&&(this.fixedWidth=r,f=k.navigatorAxis.toFixedRange(d,d+r,h,u),B(f.min)&&e.xAxis[0].setExtremes(Math.min(f.min,
f.max),Math.max(f.min,f.max),!0,null,{trigger:"navigator"}))}};e.prototype.handlesMousedown=function(d,f){this.chart.pointer.normalize(d);d=this.chart;var e=d.xAxis[0],k=this.reversedExtremes;0===f?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=k?e.min:e.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=k?e.max:e.min);d.fixedRange=null};e.prototype.onMouseMove=function(d){var f=this,e=f.chart,k=f.left,m=f.navigatorSize,a=f.range,b=f.dragOffset,
r=e.inverted;d.touches&&0===d.touches[0].pageX||(d=e.pointer.normalize(d),e=d.chartX,r&&(k=f.top,e=d.chartY),f.grabbedLeft?(f.hasDragged=!0,f.render(0,0,e-k,f.otherHandlePos)):f.grabbedRight?(f.hasDragged=!0,f.render(0,0,f.otherHandlePos,e-k)):f.grabbedCenter&&(f.hasDragged=!0,e<b?e=b:e>m+b-a&&(e=m+b-a),f.render(0,0,e-b,e-b+a)),f.hasDragged&&f.scrollbar&&F(f.scrollbar.options.liveRedraw,y.svg&&!P&&!this.chart.isBoosting)&&(d.DOMType=d.type,setTimeout(function(){f.onMouseUp(d)},0)))};e.prototype.onMouseUp=
function(d){var f=this.chart,e=this.xAxis,k=this.scrollbar,m=d.DOMEvent||d,a=f.inverted,b=this.rendered&&!this.hasDragged?"animate":"attr";if(this.hasDragged&&(!k||!k.hasDragged)||"scrollbar"===d.trigger){k=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var r=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var c=this.fixedExtreme;this.zoomedMax===this.size&&(c=this.reversedExtremes?k.dataMin:k.dataMax);0===this.zoomedMin&&(r=this.reversedExtremes?k.dataMax:k.dataMin);
e=e.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,r,c);B(e.min)&&f.xAxis[0].setExtremes(Math.min(e.min,e.max),Math.max(e.min,e.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:m})}"mousemove"!==d.DOMType&&"touchmove"!==d.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&L(this.zoomedMin)&&L(this.zoomedMax)&&(f=Math.round(this.zoomedMin),
d=Math.round(this.zoomedMax),this.shades&&this.drawMasks(f,d,a,b),this.outline&&this.drawOutline(f,d,a,b),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(f,0,a,b),this.drawHandle(d,1,a,b)))};e.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(d){d()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()};e.prototype.removeBaseSeriesEvents=function(){var d=this.baseSeries||[];this.navigatorEnabled&&
d[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&d.forEach(function(d){u(d,"updatedData",this.updatedDataHandler)},this),d[0].xAxis&&u(d[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};e.prototype.init=function(d){var f=d.options,e=f.navigator,k=e.enabled,b=f.scrollbar,r=b.enabled;f=k?e.height:0;var h=r?b.height:0;this.handles=[];this.shades=[];this.chart=d;this.setBaseSeries();this.height=f;this.scrollbarHeight=h;this.scrollbarEnabled=r;this.navigatorEnabled=k;this.navigatorOptions=
e;this.scrollbarOptions=b;this.outlineHeight=f+h;this.opposite=F(e.opposite,!(k||!d.inverted));var u=this;k=u.baseSeries;b=d.xAxis.length;r=d.yAxis.length;var p=k&&k[0]&&k[0].xAxis||d.xAxis[0]||{options:{}};d.isDirtyBox=!0;u.navigatorEnabled?(u.xAxis=new a(d,A({breaks:p.options.breaks,ordinal:p.options.ordinal},e.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:b,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},
d.inverted?{offsets:[h,0,-h,0],width:f}:{offsets:[0,-h,0,h],height:f})),u.yAxis=new a(d,A(e.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:r,isInternal:!0,reversed:F(e.yAxis&&e.yAxis.reversed,d.yAxis[0]&&d.yAxis[0].reversed,!1),zoomEnabled:!1},d.inverted?{width:f}:{height:f})),k||e.series.data?u.updateNavigatorSeries(!1):0===d.series.length&&(u.unbindRedraw=C(d,"beforeRedraw",function(){0<d.series.length&&!u.series&&(u.setBaseSeries(),u.unbindRedraw())})),u.reversedExtremes=d.inverted&&
!u.xAxis.reversed||!d.inverted&&u.xAxis.reversed,u.renderElements(),u.addMouseEvents()):(u.xAxis={chart:d,navigatorAxis:{fake:!0},translate:function(e,f){var k=d.xAxis[0],a=k.getExtremes(),b=k.len-2*h,z=m("min",k.options.min,a.dataMin);k=m("max",k.options.max,a.dataMax)-z;return f?e*k/b+z:b*(e-z)/k},toPixels:function(d){return this.translate(d)},toValue:function(d){return this.translate(d,!0)}},u.xAxis.navigatorAxis.axis=u.xAxis,u.xAxis.navigatorAxis.toFixedRange=n.AdditionsClass.prototype.toFixedRange.bind(u.xAxis.navigatorAxis));
d.options.scrollbar.enabled&&(d.scrollbar=u.scrollbar=new c(d.renderer,A(d.options.scrollbar,{margin:u.navigatorEnabled?0:10,vertical:d.inverted}),d),C(u.scrollbar,"changed",function(d){var e=u.size,f=e*this.to;e*=this.from;u.hasDragged=u.scrollbar.hasDragged;u.render(0,0,e,f);this.shouldUpdateExtremes(d.DOMType)&&setTimeout(function(){u.onMouseUp(d)})}));u.addBaseSeriesEvents();u.addChartEvents()};e.prototype.getUnionExtremes=function(d){var e=this.chart.xAxis[0],k=this.xAxis,a=k.options,b=e.options,
r;d&&null===e.dataMin||(r={dataMin:F(a&&a.min,m("min",b.min,e.dataMin,k.dataMin,k.min)),dataMax:F(a&&a.max,m("max",b.max,e.dataMax,k.dataMax,k.max))});return r};e.prototype.setBaseSeries=function(d,e){var f=this.chart,k=this.baseSeries=[];d=d||f.options&&f.options.navigator.baseSeries||(f.series.length?D(f.series,function(d){return!d.options.isInternal}).index:0);(f.series||[]).forEach(function(e,f){e.options.isInternal||!e.options.showInNavigator&&(f!==d&&e.options.id!==d||!1===e.options.showInNavigator)||
k.push(e)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,e)};e.prototype.updateNavigatorSeries=function(d,e){var f=this,k=f.chart,m=f.baseSeries,a,b,c=f.navigatorOptions.series,h,l={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},D=f.series=(f.series||[]).filter(function(d){var e=d.baseSeries;return 0>m.indexOf(e)?(e&&(u(e,
"updatedData",f.updatedDataHandler),delete e.navigatorSeries),d.chart&&d.destroy(),!1):!0});m&&m.length&&m.forEach(function(d){var z=d.navigatorSeries,u=p({color:d.color,visible:d.visible},K(c)?Q.navigator.series:c);z&&!1===f.navigatorOptions.adaptToUpdatedData||(l.name="Navigator "+m.length,a=d.options||{},h=a.navigatorOptions||{},u.dataLabels=r(u.dataLabels),b=A(a,l,u,h),b.pointRange=F(u.pointRange,h.pointRange,Q.plotOptions[b.type||"line"].pointRange),u=h.data||u.data,f.hasNavigatorData=f.hasNavigatorData||
!!u,b.data=u||a.data&&a.data.slice(0),z&&z.options?z.update(b,e):(d.navigatorSeries=k.initSeries(b),d.navigatorSeries.baseSeries=d,D.push(d.navigatorSeries)))});if(c.data&&(!m||!m.length)||K(c))f.hasNavigatorData=!1,c=r(c),c.forEach(function(d,e){l.name="Navigator "+(D.length+1);b=A(Q.navigator.series,{color:k.series[e]&&!k.series[e].options.isInternal&&k.series[e].color||k.options.colors[e]||k.options.colors[0]},l,d);b.data=d.data;b.data&&(f.hasNavigatorData=!0,D.push(k.initSeries(b)))});d&&this.addBaseSeriesEvents()};
e.prototype.addBaseSeriesEvents=function(){var d=this,e=d.baseSeries||[];e[0]&&e[0].xAxis&&e[0].eventsToUnbind.push(C(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes));e.forEach(function(e){e.eventsToUnbind.push(C(e,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)}));e.eventsToUnbind.push(C(e,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)}));!1!==this.navigatorOptions.adaptToUpdatedData&&e.xAxis&&e.eventsToUnbind.push(C(e,"updatedData",
this.updatedDataHandler));e.eventsToUnbind.push(C(e,"remove",function(){this.navigatorSeries&&(h(d.series,this.navigatorSeries),B(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)};e.prototype.getBaseSeriesMin=function(d){return this.baseSeries.reduce(function(d,e){return Math.min(d,e.xData?e.xData[0]:d)},d)};e.prototype.modifyNavigatorAxisExtremes=function(){var d=this.xAxis,e;"undefined"!==typeof d.getExtremes&&(!(e=this.getUnionExtremes(!0))||
e.dataMin===d.min&&e.dataMax===d.max||(d.min=e.dataMin,d.max=e.dataMax))};e.prototype.modifyBaseAxisExtremes=function(){var d=this.chart.navigator,e=this.getExtremes(),k=e.dataMin,m=e.dataMax;e=e.max-e.min;var a=d.stickToMin,b=d.stickToMax,r=F(this.options.overscroll,0),c=d.series&&d.series[0],u=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(a){var h=k;var p=h+e}b&&(p=m+r,a||(h=Math.max(k,p-e,d.getBaseSeriesMin(c&&c.xData?c.xData[0]:-Number.MAX_VALUE))));
u&&(a||b)&&L(h)&&(this.min=this.userMin=h,this.max=this.userMax=p)}d.stickToMin=d.stickToMax=null};e.prototype.updatedDataHandler=function(){var d=this.chart.navigator,e=this.navigatorSeries;d.stickToMax=d.reversedExtremes?0===Math.round(d.zoomedMin):Math.round(d.zoomedMax)>=Math.round(d.size);d.stickToMin=d.shouldStickToMin(this,d);e&&!d.hasNavigatorData&&(e.options.pointStart=this.xData[0],e.setData(this.options.data,!1,null,!1))};e.prototype.shouldStickToMin=function(d,e){e=e.getBaseSeriesMin(d.xData[0]);
var f=d.xAxis;d=f.max;var k=f.min;f=f.options.range;var m=!0;L(d)&&L(k)&&(m=f&&0<d-e?d-e<f&&!this.chart.fixedRange:k<=e);return m};e.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(C(this.chart,"redraw",function(){var d=this.navigator,e=d&&(d.baseSeries&&d.baseSeries[0]&&d.baseSeries[0].xAxis||this.xAxis[0]);e&&d.render(e.min,e.max)}),C(this.chart,"getMargins",function(){var d=this.navigator,e=d.opposite?"plotTop":"marginBottom";this.inverted&&
(e=d.opposite?"marginRight":"plotLeft");this[e]=(this[e]||0)+(d.navigatorEnabled||!this.inverted?d.outlineHeight:0)+d.navigatorOptions.margin}))};e.prototype.destroy=function(){this.removeEvents();this.xAxis&&(h(this.chart.xAxis,this.xAxis),h(this.chart.axes,this.xAxis));this.yAxis&&(h(this.chart.yAxis,this.yAxis),h(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(d){d.destroy&&d.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(d){this[d]&&
this[d].destroy&&this[d].destroy();this[d]=null},this);[this.handles].forEach(function(d){l(d)},this)};return e}();y.Navigator||(y.Navigator=e,n.compose(a),C(t,"beforeShowResetZoom",function(){var e=this.options,d=e.navigator,f=e.rangeSelector;if((d&&d.enabled||f&&f.enabled)&&(!P&&"x"===e.chart.zoomType||P&&"x"===e.chart.pinchType))return!1}),C(t,"beforeRender",function(){var k=this.options;if(k.navigator.enabled||k.scrollbar.enabled)this.scroller=this.navigator=new e(this)}),C(t,"afterSetChartSize",
function(){var e=this.legend,d=this.navigator;if(d){var f=e&&e.options;var m=d.xAxis;var a=d.yAxis;var b=d.scrollbarHeight;this.inverted?(d.left=d.opposite?this.chartWidth-b-d.height:this.spacing[3]+b,d.top=this.plotTop+b):(d.left=F(m.left,this.plotLeft+b),d.top=d.navigatorOptions.top||this.chartHeight-d.height-b-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(f&&"bottom"===f.verticalAlign&&"proximate"!==f.layout&&f.enabled&&!f.floating?e.legendHeight+
F(f.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));m&&a&&(this.inverted?m.options.left=a.options.left=d.left:m.options.top=a.options.top=d.top,m.setAxisSize(),a.setAxisSize())}}),C(t,"update",function(e){var d=e.options.navigator||{},f=e.options.scrollbar||{};this.navigator||this.scroller||!d.enabled&&!f.enabled||(A(!0,this.options.navigator,d),A(!0,this.options.scrollbar,f),delete e.options.navigator,delete e.options.scrollbar)}),C(t,"afterUpdate",function(k){this.navigator||this.scroller||
!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new e(this),F(k.redraw,!0)&&this.redraw(k.animation))}),C(t,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),C(b,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),t.prototype.callbacks.push(function(e){var d=e.navigator;d&&e.xAxis[0]&&(e=e.xAxis[0].getExtremes(),d.render(e.min,e.max))}));y.Navigator=
e;return y.Navigator});J(a,"Core/Axis/OrdinalAxis.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,t,x,y,n){var G=n.addEvent,w=n.correctFloat,v=n.css,c=n.defined,b=n.error,E=n.pick,g=n.timeUnits,q;(function(a){var q=function(){function a(a){this.index={};this.axis=a}a.prototype.beforeSetTickPositions=function(){var a=this.axis,b=a.ordinal,c=[],l,h=!1,p=a.getExtremes(),D=p.min,g=p.max,q,A=a.isXAxis&&!!a.options.breaks;
p=a.options.ordinal;var F=Number.MAX_VALUE,u=a.chart.options.chart.ignoreHiddenSeries,r;if(p||A){a.series.forEach(function(e,d){l=[];if(!(u&&!1===e.visible||!1===e.takeOrdinalPosition&&!A)&&(c=c.concat(e.processedXData),m=c.length,c.sort(function(d,e){return d-e}),F=Math.min(F,E(e.closestPointRange,F)),m)){for(d=0;d<m-1;)c[d]!==c[d+1]&&l.push(c[d+1]),d++;l[0]!==c[0]&&l.unshift(c[0]);c=l}e.isSeriesBoosting&&(r=!0)});r&&(c.length=0);var m=c.length;if(2<m){var e=c[1]-c[0];for(q=m-1;q--&&!h;)c[q+1]-c[q]!==
e&&(h=!0);!a.options.keepOrdinalPadding&&(c[0]-D>e||g-c[c.length-1]>e)&&(h=!0)}else a.options.overscroll&&(2===m?F=c[1]-c[0]:1===m?(F=a.options.overscroll,c=[c[0],c[0]+F]):F=b.overscrollPointsRange);h||a.forceOrdinal?(a.options.overscroll&&(b.overscrollPointsRange=F,c=c.concat(b.getOverscrollPositions())),b.positions=c,e=a.ordinal2lin(Math.max(D,c[0]),!0),q=Math.max(a.ordinal2lin(Math.min(g,c[c.length-1]),!0),1),b.slope=g=(g-D)/(q-e),b.offset=D-e*g):(b.overscrollPointsRange=E(a.closestPointRange,
b.overscrollPointsRange),b.positions=a.ordinal.slope=b.offset=void 0)}a.isOrdinal=p&&h;b.groupIntervalFactor=null};a.findIndexOf=function(a,b,c){for(var l=0,h=a.length-1,p;l<=h;){p=Math.floor((l+h)/2);if(a[p]===b)return p;a[p]<b?l=p+1:h=p-1}return c?p:-1};a.prototype.getExtendedPositions=function(){var a=this,b=a.axis,c=b.constructor.prototype,l=b.chart,h=b.series[0].currentDataGrouping,p=a.index,D=h?h.count+h.unitName:"raw",g=b.options.overscroll,q=b.getExtremes(),A;p||(p=a.index={});if(!p[D]){var F=
{series:[],chart:l,forceOrdinal:!1,getExtremes:function(){return{min:q.dataMin,max:q.dataMax+g}},getGroupPixelWidth:c.getGroupPixelWidth,getTimeTicks:c.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:c.ordinal2lin,val2lin:c.val2lin};F.ordinal.axis=F;b.series.forEach(function(b){A={xAxis:F,xData:b.xData.slice(),chart:l,destroyGroupedData:x.noop,getProcessedData:y.prototype.getProcessedData};A.xData=A.xData.concat(a.getOverscrollPositions());
A.options={dataGrouping:h?{enabled:!0,forced:!0,approximation:"open",units:[[h.unitName,[h.count]]]}:{enabled:!1}};F.series.push(A);b.processData.apply(A);A.closestPointRange!==A.basePointRange&&A.currentDataGrouping&&(F.forceOrdinal=!0)});b.ordinal.beforeSetTickPositions.apply({axis:F});p[D]=F.ordinal.positions}return p[D]};a.prototype.getGroupIntervalFactor=function(a,b,c){c=c.processedXData;var l=c.length,h=[];var p=this.groupIntervalFactor;if(!p){for(p=0;p<l-1;p++)h[p]=c[p+1]-c[p];h.sort(function(a,
b){return a-b});h=h[Math.floor(l/2)];a=Math.max(a,c[0]);b=Math.min(b,c[l-1]);this.groupIntervalFactor=p=l*h/(b-a)}return p};a.prototype.getIndexOfPoint=function(b,c){var g=this.axis;b=(b-(this.slope?this.slope*g.transA:0))/(g.translationSlope*(this.slope||g.closestPointRange||this.overscrollPointsRange));return a.findIndexOf(c,this.positions?this.positions[0]:0)+b};a.prototype.getOverscrollPositions=function(){var a=this.axis,b=a.options.overscroll,g=this.overscrollPointsRange,l=[],h=a.dataMax;if(c(g))for(l.push(h);h<=
a.dataMax+b;)h+=g,l.push(h);return l};a.prototype.postProcessTickInterval=function(a){var b=this.axis,c=this.slope;return c?b.options.breaks?b.closestPointRange||a:a/(c/b.closestPointRange):a};return a}();a.Composition=q;a.compose=function(q,n,E){q.keepProps.push("ordinal");var B=q.prototype;q.prototype.getTimeTicks=function(a,h,p,D,q,n,A){void 0===q&&(q=[]);void 0===n&&(n=0);var l=0,u,r,m={},e=[],k=-Number.MAX_VALUE,d=this.options.tickPixelInterval,f=this.chart.time,z=[];if(!this.options.ordinal&&
!this.options.breaks||!q||3>q.length||"undefined"===typeof h)return f.getTimeTicks.apply(f,arguments);var I=q.length;for(u=0;u<I;u++){var K=u&&q[u-1]>p;q[u]<h&&(l=u);if(u===I-1||q[u+1]-q[u]>5*n||K){if(q[u]>k){for(r=f.getTimeTicks(a,q[l],q[u],D);r.length&&r[0]<=k;)r.shift();r.length&&(k=r[r.length-1]);z.push(e.length);e=e.concat(r)}l=u+1}if(K)break}if(r){r=r.info;if(A&&r.unitRange<=g.hour){u=e.length-1;for(l=1;l<u;l++)if(f.dateFormat("%d",e[l])!==f.dateFormat("%d",e[l-1])){m[e[l]]="day";var M=!0}M&&
(m[e[0]]="day");r.higherRanks=m}r.segmentStarts=z;e.info=r}else b(12,!1,this.chart);if(A&&c(d)){l=r=e.length;M=[];f=void 0;for(z=[];l--;)u=this.translate(e[l]),f&&(z[l]=f-u),M[l]=f=u;z.sort();z=z[Math.floor(z.length/2)];z<.6*d&&(z=null);l=e[r-1]>p?r-1:r;for(f=void 0;l--;)u=M[l],r=Math.abs(f-u),f&&r<.8*d&&(null===z||r<.8*z)?(m[e[l]]&&!m[e[l+1]]?(r=l+1,f=u):r=l,e.splice(r,1)):f=u}return e};B.index2val=function(a){var b=this.ordinal.positions;if(!b)return a;var c=b.length-1;if(0>a)a=b[0];else if(a>c)a=
b[c];else{c=Math.floor(a);var l=a-c}return"undefined"!==typeof l&&"undefined"!==typeof b[c]?b[c]+(l?l*(b[c+1]-b[c]):0):a};B.lin2val=function(a){var b=this.ordinal,c=b.positions;if(!c)return a;var l=(a-(this.old?this.old.min:this.min))*(this.old?this.old.transA:this.transA);a>this.left&&a<this.left+this.len||(b.extendedOrdinalPositions||(b.extendedOrdinalPositions=b.getExtendedPositions()),c=b.extendedOrdinalPositions);if(c&&c.length){a=b.getIndexOfPoint(l,c);b=w(a%1);if(0<=a&&a<c.length)return c[Math.floor(a)]+
b*(c[Math.ceil(a)]-c[Math.floor(a)]);b=c.length;l=c[0];c=c[b-1];var g=(c-l)/(b-1);return 0>a?l+g*a:c+g*(a-b)}return a};B.val2lin=function(a,b){var c=this.ordinal,h=c.positions;if(h){var l=h.length,g,A=void 0;for(g=l;g--;)if(h[g]===a){A=g;break}for(g=l-1;g--;)if(a>h[g]||0===g){a=(a-h[g])/(h[g+1]-h[g]);A=g+a;break}b=b?A:c.slope*(A||0)+c.offset}else b=a;return b};B.ordinal2lin=B.val2lin;G(q,"afterInit",function(){this.ordinal||(this.ordinal=new a.Composition(this))});G(q,"foundExtremes",function(){this.isXAxis&&
c(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&c(this.userMin)&&(this.min+=this.options.overscroll))});G(q,"afterSetScale",function(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)});G(q,"initialAxisTranslation",function(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),
this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))});G(n,"pan",function(a){var b=this.xAxis[0],c=b.options.overscroll,l=a.originalEvent.chartX,g=this.options.chart.panning,q=!1;if(g&&"y"!==g.type&&b.options.ordinal&&b.series.length){var A=this.mouseDownX,n=b.getExtremes(),u=n.dataMax,r=n.min,m=n.max,e=void 0;e=this.hoverPoints;var k=b.closestPointRange||b.ordinal&&b.ordinal.overscrollPointsRange;A=(A-l)/(b.translationSlope*(b.ordinal.slope||k));k={ordinal:{positions:b.ordinal.getExtendedPositions()}};
var d=void 0,f=void 0,z=b.index2val,I=b.val2lin,R=void 0;k.ordinal.positions?1<Math.abs(A)&&(e&&e.forEach(function(d){d.setState()}),0>A?(f=k,R=b.ordinal.positions?b:k):(f=b.ordinal.positions?b:k,R=k),d=R.ordinal.positions,u>d[d.length-1]&&d.push(u),this.fixedRange=m-r,e=b.navigatorAxis.toFixedRange(null,null,z.apply(f,[I.apply(f,[r,!0])+A]),z.apply(R,[I.apply(R,[m,!0])+A])),e.min>=Math.min(n.dataMin,r)&&e.max<=Math.max(u,m)+c&&b.setExtremes(e.min,e.max,!0,!1,{trigger:"pan"}),this.mouseDownX=l,v(this.container,
{cursor:"move"})):q=!0}else q=!0;q||g&&/y/.test(g.type)?c&&(b.max=b.dataMax+c):a.preventDefault()});G(E,"updatedData",function(){var a=this.xAxis;a&&a.options.ordinal&&delete a.ordinal.index})}})(q||(q={}));q.compose(a,t,y);return q});J(a,"Core/Axis/BrokenAxis.js",[a["Core/Axis/Axis.js"],a["Core/Series/Series.js"],a["Extensions/Stacking.js"],a["Core/Utilities.js"]],function(a,t,x,y){var n=y.addEvent,G=y.find,w=y.fireEvent,v=y.isArray,c=y.isNumber,b=y.pick,E;(function(g){function q(){"undefined"!==
typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function E(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function y(){var a=this.brokenAxis;if(a&&a.hasBreaks){for(var b=this.tickPositions,c=this.tickPositions.info,h=[],g=0;g<b.length;g++)a.isInAnyBreak(b[g])||h.push(b[g]);this.tickPositions=h;this.tickPositions.info=c}}function C(){this.brokenAxis||(this.brokenAxis=new h(this))}function N(){var a=this.options.connectNulls,b=this.points,c=this.xAxis,
h=this.yAxis;if(this.isDirty)for(var g=b.length;g--;){var l=b[g],u=!(null===l.y&&!1===a)&&(c&&c.brokenAxis&&c.brokenAxis.isInAnyBreak(l.x,!0)||h&&h.brokenAxis&&h.brokenAxis.isInAnyBreak(l.y,!0));l.visible=u?!1:!1!==l.options.visible}}function H(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,b(this.pointArrayMap,["y"]))}function B(a,h){var g=this,l=g.points,A,p,u,r;if(a&&a.brokenAxis&&a.brokenAxis.hasBreaks){var m=a.brokenAxis;h.forEach(function(e){A=m&&m.breakArray||[];p=a.isXAxis?
a.min:b(g.options.threshold,a.min);l.forEach(function(k){r=b(k["stack"+e.toUpperCase()],k[e]);A.forEach(function(d){if(c(p)&&c(r)){u=!1;if(p<d.from&&r>d.to||p>d.from&&r<d.from)u="pointBreak";else if(p<d.from&&r>d.from&&r<d.to||p>d.from&&r>d.to&&r<d.from)u="pointInBreak";u&&w(a,u,{point:k,brk:d})}})})})}}function l(){var a=this.currentDataGrouping,b=a&&a.gapSize;a=this.points.slice();var c=this.yAxis,h=this.options.gapSize,g=a.length-1,l;if(h&&0<g)for("value"!==this.options.gapUnit&&(h*=this.basePointRange),
b&&b>h&&b>=this.basePointRange&&(h=b),l=void 0;g--;)l&&!1!==l.visible||(l=a[g+1]),b=a[g],!1!==l.visible&&!1!==b.visible&&(l.x-b.x>h&&(l=(b.x+l.x)/2,a.splice(g+1,0,{isNull:!0,x:l}),c.stacking&&this.options.stacking&&(l=c.stacking.stacks[this.stackKey][l]=new x(c,c.options.stackLabels,!1,l,this.stack),l.total=0)),l=b);return this.getGraphPath(a)}g.compose=function(a,b){if(-1===a.keepProps.indexOf("brokenAxis")){a.keepProps.push("brokenAxis");var c=t.prototype;c.drawBreaks=B;c.gappedPath=l;n(a,"init",
C);n(a,"afterInit",q);n(a,"afterSetTickPositions",y);n(a,"afterSetOptions",E);n(b,"afterGeneratePoints",N);n(b,"afterRender",H)}return a};var h=function(){function h(a){this.hasBreaks=!1;this.axis=a}h.isInBreak=function(a,b){var c=a.repeat||Infinity,h=a.from,l=a.to-a.from;b=b>=h?(b-h)%c:c-(h-b)%c;return a.inclusive?b<=l:b<l&&0!==b};h.lin2Val=function(a){var b=this.brokenAxis;b=b&&b.breakArray;if(!b||!c(a))return a;var l;for(l=0;l<b.length;l++){var g=b[l];if(g.from>=a)break;else g.to<a?a+=g.len:h.isInBreak(g,
a)&&(a+=g.len)}return a};h.val2Lin=function(a){var b=this.brokenAxis;b=b&&b.breakArray;if(!b||!c(a))return a;var l=a,g;for(g=0;g<b.length;g++){var q=b[g];if(q.to<=a)l-=q.len;else if(q.from>=a)break;else if(h.isInBreak(q,a)){l-=a-q.from;break}}return l};h.prototype.findBreakAt=function(a,b){return G(b,function(b){return b.from<a&&a<b.to})};h.prototype.isInAnyBreak=function(a,l){var g=this.axis,q=g.options.breaks||[],p=q.length,u;if(p&&c(a)){for(;p--;)if(h.isInBreak(q[p],a)){var r=!0;u||(u=b(q[p].showPoints,
!g.isXAxis))}var m=r&&l?r&&!u:r}return m};h.prototype.setBreaks=function(l,g){var q=this,p=q.axis,n=v(l)&&!!l.length;p.isDirty=q.hasBreaks!==n;q.hasBreaks=n;p.options.breaks=p.userOptions.breaks=l;p.forceRedraw=!0;p.series.forEach(function(a){a.isDirty=!0});n||p.val2lin!==h.val2Lin||(delete p.val2lin,delete p.lin2val);n&&(p.userOptions.ordinal=!1,p.lin2val=h.lin2Val,p.val2lin=h.val2Lin,p.setExtremes=function(b,c,m,e,k){if(q.hasBreaks){for(var d=this.options.breaks||[],f;f=q.findBreakAt(b,d);)b=f.to;
for(;f=q.findBreakAt(c,d);)c=f.from;c<b&&(c=b)}a.prototype.setExtremes.call(this,b,c,m,e,k)},p.setAxisTranslation=function(){a.prototype.setAxisTranslation.call(this);q.unitLength=void 0;if(q.hasBreaks){var u=p.options.breaks||[],r=[],m=[],e=b(p.pointRangePadding,0),k=0,d,f=p.userMin||p.min,z=p.userMax||p.max,l;u.forEach(function(e){d=e.repeat||Infinity;c(f)&&c(z)&&(h.isInBreak(e,f)&&(f+=e.to%d-f%d),h.isInBreak(e,z)&&(z-=z%d-e.from%d))});u.forEach(function(e){M=e.from;d=e.repeat||Infinity;if(c(f)&&
c(z)){for(;M-d>f;)M-=d;for(;M<f;)M+=d;for(l=M;l<z;l+=d)r.push({value:l,move:"in"}),r.push({value:l+e.to-e.from,move:"out",size:e.breakSize})}});r.sort(function(d,e){return d.value===e.value?("in"===d.move?0:1)-("in"===e.move?0:1):d.value-e.value});var g=0;var M=f;r.forEach(function(d){g+="in"===d.move?1:-1;1===g&&"in"===d.move&&(M=d.value);0===g&&c(M)&&(m.push({from:M,to:d.value,len:d.value-M-(d.size||0)}),k+=d.value-M-(d.size||0))});q.breakArray=m;c(f)&&c(z)&&c(p.min)&&(q.unitLength=z-f-k+e,w(p,
"afterBreaks"),p.staticScale?p.transA=p.staticScale:q.unitLength&&(p.transA*=(z-p.min+e)/q.unitLength),e&&(p.minPixelPadding=p.transA*(p.minPointOffset||0)),p.min=f,p.max=z)}});b(g,!0)&&p.chart.redraw()};return h}();g.Additions=h})(E||(E={}));return E});J(a,"masters/modules/broken-axis.src.js",[a["Core/Globals.js"],a["Core/Axis/BrokenAxis.js"]],function(a,t){t.compose(a.Axis,a.Series)});J(a,"Extensions/DataGrouping.js",[a["Core/Axis/Axis.js"],a["Core/Axis/DateTimeAxis.js"],a["Core/FormatUtilities.js"],
a["Core/Globals.js"],a["Core/Series/Point.js"],a["Core/Series/Series.js"],a["Core/Tooltip.js"],a["Core/DefaultOptions.js"],a["Core/Utilities.js"]],function(a,t,x,y,n,G,w,v,c){var b=x.format,E=G.prototype;x=c.addEvent;var g=c.arrayMax,q=c.arrayMin,P=c.correctFloat,Q=c.defined,C=c.error,N=c.extend,H=c.isNumber,B=c.merge,l=c.pick;"";var h=y.approximations={sum:function(a){var b=a.length;if(!b&&a.hasNulls)var m=null;else if(b)for(m=0;b--;)m+=a[b];return m},average:function(a){var b=a.length;a=h.sum(a);
H(a)&&b&&(a=P(a/b));return a},averages:function(){var a=[];[].forEach.call(arguments,function(b){a.push(h.average(b))});return"undefined"===typeof a[0]?void 0:a},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},high:function(a){return a.length?g(a):a.hasNulls?null:void 0},low:function(a){return a.length?q(a):a.hasNulls?null:void 0},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},ohlc:function(a,b,m,e){a=h.open(a);b=h.high(b);m=h.low(m);e=h.close(e);if(H(a)||H(b)||
H(m)||H(e))return[a,b,m,e]},range:function(a,b){a=h.low(a);b=h.high(b);if(H(a)||H(b))return[a,b];if(null===a&&null===b)return null}};c=function(a,b,m,e){var k=this,d=k.data,f=k.options&&k.options.data,c=[],r=[],l=[],g=a.length,u=!!b,q=[],p=k.pointArrayMap,n=p&&p.length,E=["x"].concat(p||["y"]),w=this.options.dataGrouping&&this.options.dataGrouping.groupAll,A=0,C=0,t;e="function"===typeof e?e:h[e]?h[e]:h[k.getDGApproximation&&k.getDGApproximation()||"average"];n?p.forEach(function(){q.push([])}):q.push([]);
var y=n||1;for(t=0;t<=g&&!(a[t]>=m[0]);t++);for(t;t<=g;t++){for(;"undefined"!==typeof m[A+1]&&a[t]>=m[A+1]||t===g;){var v=m[A];k.dataGroupInfo={start:w?C:k.cropStart+C,length:q[0].length};var x=e.apply(k,q);k.pointClass&&!Q(k.dataGroupInfo.options)&&(k.dataGroupInfo.options=B(k.pointClass.prototype.optionsToObject.call({series:k},k.options.data[k.cropStart+C])),E.forEach(function(d){delete k.dataGroupInfo.options[d]}));"undefined"!==typeof x&&(c.push(v),r.push(x),l.push(k.dataGroupInfo));C=t;for(v=
0;v<y;v++)q[v].length=0,q[v].hasNulls=!1;A+=1;if(t===g)break}if(t===g)break;if(p){v=k.options.dataGrouping&&k.options.dataGrouping.groupAll?t:k.cropStart+t;x=d&&d[v]||k.pointClass.prototype.applyOptions.apply({series:k},[f[v]]);var D=void 0;for(v=0;v<n;v++)D=x[p[v]],H(D)?q[v].push(D):null===D&&(q[v].hasNulls=!0)}else v=u?b[t]:null,H(v)?q[0].push(v):null===v&&(q[0].hasNulls=!0)}return{groupedXData:c,groupedYData:r,groupMap:l}};var p={approximations:h,groupData:c},D=E.processData,K=E.generatePoints,
L={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},A={line:{},spline:{},area:{},areaspline:{},
arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5}},F=y.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];E.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};E.groupData=c;E.processData=
function(){var a=this.chart,b=this.options.dataGrouping,m=!1!==this.allowDG&&b&&l(b.enabled,a.options.isStock),e=this.visible||!a.options.chart.ignoreHiddenSeries,k,d=this.currentDataGrouping,f=!1;this.forceCrop=m;this.groupPixelWidth=null;this.hasProcessed=!0;m&&!this.requireSorting&&(this.requireSorting=f=!0);m=!1===D.apply(this,arguments)||!m;f&&(this.requireSorting=!1);if(!m){this.destroyGroupedData();var c=b.groupAll?this.xData:this.processedXData,h=b.groupAll?this.yData:this.processedYData;
m=a.plotSizeX;f=this.xAxis;var g=f.options.ordinal,q=this.groupPixelWidth=f.getGroupPixelWidth&&f.getGroupPixelWidth();if(q&&c&&c.length){this.isDirty=k=!0;this.points=null;var p=f.getExtremes();var n=p.min;p=p.max;g=g&&f.ordinal&&f.ordinal.getGroupIntervalFactor(n,p,this)||1;m=f.getTimeTicks(t.AdditionsClass.prototype.normalizeTimeTickInterval(q*(p-n)/m*g,b.units||F),Math.min(n,c[0]),Math.max(p,c[c.length-1]),f.options.startOfWeek,c,this.closestPointRange);q=E.groupData.apply(this,[c,h,m,b.approximation]);
c=q.groupedXData;h=q.groupedYData;g=0;b&&b.smoothed&&c.length&&(b.firstAnchor="firstPoint",b.anchor="middle",b.lastAnchor="lastPoint",C(32,!1,a,{"dataGrouping.smoothed":"use dataGrouping.anchor"}));a=c;var v=this.options.dataGrouping;n=this.currentDataGrouping&&this.currentDataGrouping.gapSize;if(v&&this.xData&&n&&this.groupMap){var B=a.length-1;var A=v.anchor;var w=l(v.firstAnchor,A);v=l(v.lastAnchor,A);if(A&&"start"!==A){var y=n*{middle:.5,end:1}[A];for(A=a.length-1;A--&&0<A;)a[A]+=y}if(w&&"start"!==
w&&this.xData[0]>=a[0]){A=this.groupMap[0].start;y=this.groupMap[0].length;var x=void 0;H(A)&&H(y)&&(x=A+(y-1));a[0]={middle:a[0]+.5*n,end:a[0]+n,firstPoint:this.xData[0],lastPoint:x&&this.xData[x]}[w]}v&&"start"!==v&&n&&a[B]>=p-n&&(p=this.groupMap[this.groupMap.length-1].start,a[B]={middle:a[B]+.5*n,end:a[B]+n,firstPoint:p&&this.xData[p],lastPoint:this.xData[this.xData.length-1]}[v])}for(p=1;p<m.length;p++)m.info.segmentStarts&&-1!==m.info.segmentStarts.indexOf(p)||(g=Math.max(m[p]-m[p-1],g));p=
m.info;p.gapSize=g;this.closestPointRange=m.info.totalRange;this.groupMap=q.groupMap;if(e){e=c;if(Q(e[0])&&H(f.min)&&H(f.dataMin)&&e[0]<f.min){if(!Q(f.options.min)&&f.min<=f.dataMin||f.min===f.dataMin)f.min=Math.min(e[0],f.min);f.dataMin=Math.min(e[0],f.dataMin)}if(Q(e[e.length-1])&&H(f.max)&&H(f.dataMax)&&e[e.length-1]>f.max){if(!Q(f.options.max)&&H(f.dataMax)&&f.max>=f.dataMax||f.max===f.dataMax)f.max=Math.max(e[e.length-1],f.max);f.dataMax=Math.max(e[e.length-1],f.dataMax)}}b.groupAll&&(b=this.cropData(c,
h,f.min,f.max,1),c=b.xData,h=b.yData,this.cropStart=b.start);this.processedXData=c;this.processedYData=h}else this.groupMap=null;this.hasGroupedData=k;this.currentDataGrouping=p;this.preventGraphAnimation=(d&&d.totalRange)!==(p&&p.totalRange)}};E.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(a,b){a&&(this.groupedData[b]=a.destroy?a.destroy():null)},this),this.groupedData.length=0)};E.generatePoints=function(){K.apply(this);this.destroyGroupedData();this.groupedData=
this.hasGroupedData?this.points:null};x(n,"update",function(){if(this.dataGroup)return C(24,!1,this.series.chart),!1});x(w,"headerFormatter",function(a){var c=this.chart,m=c.time,e=a.labelConfig,k=e.series,d=k.tooltipOptions,f=k.options.dataGrouping,z=d.xDateFormat,h=k.xAxis,g=d[(a.isFooter?"footer":"header")+"Format"];if(h&&"datetime"===h.options.type&&f&&H(e.key)){var l=k.currentDataGrouping;f=f.dateTimeLabelFormats||L.dateTimeLabelFormats;if(l)if(d=f[l.unitName],1===l.count)z=d[0];else{z=d[1];
var p=d[2]}else!z&&f&&(z=this.getXDateFormat(e,d,h));z=m.dateFormat(z,e.key);p&&(z+=m.dateFormat(p,e.key+l.totalRange-1));k.chart.styledMode&&(g=this.styledModeFormat(g));a.text=b(g,{point:N(e.point,{key:z}),series:k},c);a.preventDefault()}});x(G,"destroy",E.destroyGroupedData);x(G,"afterSetOptions",function(a){a=a.options;var b=this.type,c=this.chart.options.plotOptions,e=v.defaultOptions.plotOptions[b].dataGrouping,k=this.useCommonDataGrouping&&L;if(A[b]||k){e||(e=B(L,A[b]));var d=this.chart.rangeSelector;
a.dataGrouping=B(k,e,c.series&&c.series.dataGrouping,c[b].dataGrouping,this.userOptions.dataGrouping,!a.isInternal&&d&&H(d.selected)&&d.buttonOptions[d.selected].dataGrouping)}});x(a,"afterSetScale",function(){this.series.forEach(function(a){a.hasProcessed=!1})});a.prototype.getGroupPixelWidth=function(){var a=this.series,b=a.length,c,e=0,k=!1,d;for(c=b;c--;)(d=a[c].options.dataGrouping)&&(e=Math.max(e,l(d.groupPixelWidth,L.groupPixelWidth)));for(c=b;c--;)(d=a[c].options.dataGrouping)&&a[c].hasProcessed&&
(b=(a[c].processedXData||a[c].data).length,a[c].groupPixelWidth||b>this.chart.plotSizeX/e||b&&d.forced)&&(k=!0);return k?e:0};a.prototype.setDataGrouping=function(b,c){var m;c=l(c,!0);b||(b={forced:!1,units:null});if(this instanceof a)for(m=this.series.length;m--;)this.series[m].update({dataGrouping:b},!1);else this.chart.options.series.forEach(function(a){a.dataGrouping=b},!1);this.ordinal&&(this.ordinal.slope=void 0);c&&this.chart.redraw()};y.dataGrouping=p;"";return p});J(a,"Series/OHLC/OHLCPoint.js",
[a["Core/Series/SeriesRegistry.js"]],function(a){var t=this&&this.__extends||function(){var a=function(t,n){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,n){a.__proto__=n}||function(a,n){for(var v in n)n.hasOwnProperty(v)&&(a[v]=n[v])};return a(t,n)};return function(t,n){function x(){this.constructor=t}a(t,n);t.prototype=null===n?Object.create(n):(x.prototype=n.prototype,new x)}}();return function(a){function y(){var n=null!==a&&a.apply(this,arguments)||this;n.close=void 0;n.high=
void 0;n.low=void 0;n.open=void 0;n.options=void 0;n.plotClose=void 0;n.plotOpen=void 0;n.series=void 0;return n}t(y,a);y.prototype.getClassName=function(){return a.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")};y.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)};y.prototype.resolveColor=function(){a.prototype.resolveColor.call(this);this.resolveUpColor()};
y.prototype.getZone=function(){var n=a.prototype.getZone.call(this);this.resolveUpColor();return n};return y}(a.seriesTypes.column.prototype.pointClass)});J(a,"Series/OHLC/OHLCSeries.js",[a["Series/OHLC/OHLCPoint.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,t,x){var y=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};
return a(c,b)};return function(c,b){function n(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(n.prototype=b.prototype,new n)}}(),n=t.seriesTypes.column,G=x.extend,w=x.merge;x=function(a){function c(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;b.yData=void 0;return b}y(c,a);c.prototype.drawPoints=function(){var a=this,c=a.chart,g=function(a,b,c){var g=a[0];a=a[1];"number"===typeof g[2]&&(g[2]=Math.max(c+b,g[2]));"number"===typeof a[2]&&
(a[2]=Math.min(c-b,a[2]))};a.points.forEach(function(b){var q=b.graphic,n=!q;if("undefined"!==typeof b.plotY){q||(b.graphic=q=c.renderer.path().add(a.group));c.styledMode||q.attr(a.pointAttribs(b,b.selected&&"select"));var t=q.strokeWidth();var v=t%2/2;var w=Math.round(b.plotX)-v;var B=Math.round(b.shapeArgs.width/2);var l=[["M",w,Math.round(b.yBottom)],["L",w,Math.round(b.plotHigh)]];if(null!==b.open){var h=Math.round(b.plotOpen)+v;l.push(["M",w,h],["L",w-B,h]);g(l,t/2,h)}null!==b.close&&(h=Math.round(b.plotClose)+
v,l.push(["M",w,h],["L",w+B,h]),g(l,t/2,h));q[n?"attr":"animate"]({d:l}).addClass(b.getClassName(),!0)}})};c.prototype.init=function(){a.prototype.init.apply(this,arguments);this.options.stacking=void 0};c.prototype.pointAttribs=function(b,c){c=a.prototype.pointAttribs.call(this,b,c);var g=this.options;delete c.fill;!b.options.color&&g.upColor&&b.open<b.close&&(c.stroke=g.upColor);return c};c.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]};c.prototype.translate=function(){var b=
this,c=b.yAxis,g=!!b.modifyValue,q=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];a.prototype.translate.apply(b);b.points.forEach(function(a){[a.open,a.high,a.low,a.close,a.low].forEach(function(n,t){null!==n&&(g&&(n=b.modifyValue(n)),a[q[t]]=c.toPixels(n,!0))});a.tooltipPos[1]=a.plotHigh+c.pos-b.chart.plotTop})};c.defaultOptions=w(n.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},
threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0});return c}(n);G(x.prototype,{animate:null,directTouch:!1,pointArrayMap:["open","high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});x.prototype.pointClass=a;t.registerSeriesType("ohlc",x);"";return x});J(a,"Series/Candlestick/CandlestickSeries.js",[a["Core/DefaultOptions.js"],a["Core/Color/Palette.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,t,x,y){var n=
this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function g(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(g.prototype=c.prototype,new g)}}(),G=a.defaultOptions;a=x.seriesTypes;var w=a.column,v=a.ohlc,c=y.merge;y=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=
void 0;b.options=void 0;b.points=void 0;return b}n(b,a);b.prototype.pointAttribs=function(a,b){var c=w.prototype.pointAttribs.call(this,a,b),g=this.options,q=a.open<a.close,n=g.lineColor||this.color,t=a.color||this.color;c["stroke-width"]=g.lineWidth;c.fill=a.options.color||(q?g.upColor||t:t);c.stroke=a.options.lineColor||(q?g.upLineColor||n:n);b&&(a=g.states[b],c.fill=a.color||c.fill,c.stroke=a.lineColor||c.stroke,c["stroke-width"]=a.lineWidth||c["stroke-width"]);return c};b.prototype.drawPoints=
function(){var a=this,b=a.chart,c=a.yAxis.reversed;a.points.forEach(function(g){var n=g.graphic,q=!n;if("undefined"!==typeof g.plotY){n||(g.graphic=n=b.renderer.path().add(a.group));a.chart.styledMode||n.attr(a.pointAttribs(g,g.selected&&"select")).shadow(a.options.shadow);var t=n.strokeWidth()%2/2;var v=Math.round(g.plotX)-t;var l=g.plotOpen;var h=g.plotClose;var p=Math.min(l,h);l=Math.max(l,h);var w=Math.round(g.shapeArgs.width/2);h=c?l!==g.yBottom:Math.round(p)!==Math.round(g.plotHigh);var y=c?
Math.round(p)!==Math.round(g.plotHigh):l!==g.yBottom;p=Math.round(p)+t;l=Math.round(l)+t;t=[];t.push(["M",v-w,l],["L",v-w,p],["L",v+w,p],["L",v+w,l],["Z"],["M",v,p],["L",v,h?Math.round(c?g.yBottom:g.plotHigh):p],["M",v,l],["L",v,y?Math.round(c?g.plotHigh:g.yBottom):l]);n[q?"attr":"animate"]({d:t}).addClass(g.getClassName(),!0)}})};b.defaultOptions=c(v.defaultOptions,G.plotOptions,{states:{hover:{lineWidth:2}},tooltip:G.plotOptions.ohlc.tooltip,threshold:null,lineColor:t.neutralColor100,lineWidth:1,
upColor:t.backgroundColor,stickyTracking:!0});return b}(v);x.registerSeriesType("candlestick",y);"";return y});J(a,"Series/Flags/FlagsPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,t){var x=this&&this.__extends||function(){var a=function(n,t){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(n,t)};return function(n,t){function v(){this.constructor=n}a(n,t);
n.prototype=null===t?Object.create(t):(v.prototype=t.prototype,new v)}}(),y=t.isNumber;return function(a){function n(){var n=null!==a&&a.apply(this,arguments)||this;n.options=void 0;n.series=void 0;return n}x(n,a);n.prototype.isValid=function(){return y(this.y)||"undefined"===typeof this.y};n.prototype.hasNewShapeType=function(){var a=this.options.shape||this.series.options.shape;return this.graphic&&a&&a!==this.graphic.symbolKey};return n}(a.seriesTypes.column.prototype.pointClass)});J(a,"Mixins/OnSeries.js",
[a["Series/Column/ColumnSeries.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,t,x){var y=a.prototype,n=t.prototype,G=x.defined,w=x.stableSort;return{getPlotBox:function(){return n.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){y.translate.apply(this);var a=this,c=a.options,b=a.chart,n=a.points,g=n.length-1,q,t=c.onSeries;t=t&&b.get(t);c=c.onKey||"y";var x=t&&t.options.step,C=t&&t.points,N=C&&C.length,H=b.inverted,B=a.xAxis,
l=a.yAxis,h=0,p;if(t&&t.visible&&N){h=(t.pointXOffset||0)+(t.barW||0)/2;b=t.currentDataGrouping;var D=C[N-1].x+(b?b.totalRange:0);w(n,function(a,b){return a.x-b.x});for(c="plot"+c[0].toUpperCase()+c.substr(1);N--&&n[g];){var K=C[N];b=n[g];b.y=K.y;if(K.x<=b.x&&"undefined"!==typeof K[c]){if(b.x<=D&&(b.plotY=K[c],K.x<b.x&&!x&&(p=C[N+1])&&"undefined"!==typeof p[c])){var L=(b.x-K.x)/(p.x-K.x);b.plotY+=L*(p[c]-K[c]);b.y+=L*(p.y-K.y)}g--;N++;if(0>g)break}}}n.forEach(function(b,c){b.plotX+=h;if("undefined"===
typeof b.plotY||H)0<=b.plotX&&b.plotX<=B.len?H?(b.plotY=B.translate(b.x,0,1,0,1),b.plotX=G(b.y)?l.translate(b.y,0,0,0,1):0):b.plotY=(B.opposite?0:a.yAxis.len)+B.offset:b.shapeArgs={};if((q=n[c-1])&&q.plotX===b.plotX){"undefined"===typeof q.stackIndex&&(q.stackIndex=0);var g=q.stackIndex+1}b.stackIndex=g});this.onSeries=t}}});J(a,"Series/Flags/FlagsSymbols.js",[a["Core/Renderer/RendererRegistry.js"],a["Core/Renderer/SVG/SVGRenderer.js"]],function(a,t){function x(a){y[a+"pin"]=function(n,t,v,c,b){var w=
b&&b.anchorX;b=b&&b.anchorY;"circle"===a&&c>v&&(n-=Math.round((c-v)/2),v=c);var g=y[a](n,t,v,c);if(w&&b){var q=w;"circle"===a?q=n+v/2:(n=g[0],v=g[1],"M"===n[0]&&"L"===v[0]&&(q=(n[1]+v[1])/2));g.push(["M",q,t>b?t:t+c],["L",w,b]);g=g.concat(y.circle(w-1,b-1,2,2))}return g}}var y=t.prototype.symbols;y.flag=function(a,t,w,v,c){var b=c&&c.anchorX||a;c=c&&c.anchorY||t;var n=y.circle(b-1,c-1,2,2);n.push(["M",b,c],["L",a,t+v],["L",a,t],["L",a+w,t],["L",a+w,t+v],["L",a,t+v],["Z"]);return n};x("circle");x("square");
a=a.getRendererType();a!==t&&(a.prototype.symbols.circlepin=y.circlepin,a.prototype.symbols.flag=y.flag,a.prototype.symbols.squarepin=y.squarepin);return y});J(a,"Series/Flags/FlagsSeries.js",[a["Series/Flags/FlagsPoint.js"],a["Core/Globals.js"],a["Mixins/OnSeries.js"],a["Core/Color/Palette.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,t,x,y,n,G,w){var v=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function h(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(h.prototype=c.prototype,new h)}}(),c=t.noop,b=n.series,E=n.seriesTypes.column,g=w.addEvent,q=w.defined,N=w.extend,J=w.merge,C=w.objectEach,O=w.wrap;w=function(a){function c(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;
return b}v(c,a);c.prototype.animate=function(a){a&&this.setClip()};c.prototype.drawPoints=function(){var a=this.points,b=this.chart,c=b.renderer,g=b.inverted,n=this.options,v=n.y,A,w=this.yAxis,u={},r=[];for(A=a.length;A--;){var m=a[A];var e=(g?m.plotY:m.plotX)>this.xAxis.len;var k=m.plotX;var d=m.stackIndex;var f=m.options.shape||n.shape;var z=m.plotY;"undefined"!==typeof z&&(z=m.plotY+v-("undefined"!==typeof d&&d*n.stackDistance));m.anchorX=d?void 0:m.plotX;var I=d?void 0:m.plotY;var y="flag"!==
f;d=m.graphic;"undefined"!==typeof z&&0<=k&&!e?(d&&m.hasNewShapeType()&&(d=d.destroy()),d||(d=m.graphic=c.label("",null,null,f,null,null,n.useHTML).addClass("highcharts-point").add(this.markerGroup),m.graphic.div&&(m.graphic.div.point=m),d.isNew=!0),d.attr({align:y?"center":"left",width:n.width,height:n.height,"text-align":n.textAlign}),b.styledMode||d.attr(this.pointAttribs(m)).css(J(n.style,m.style)).shadow(n.shadow),0<k&&(k-=d.strokeWidth()%2),f={y:z,anchorY:I},n.allowOverlapX&&(f.x=k,f.anchorX=
m.anchorX),d.attr({text:m.options.title||n.title||"A"})[d.isNew?"attr":"animate"](f),n.allowOverlapX||(u[m.plotX]?u[m.plotX].size=Math.max(u[m.plotX].size,d.width):u[m.plotX]={align:y?.5:0,size:d.width,target:k,anchorX:k}),m.tooltipPos=[k,z+w.pos-b.plotTop]):d&&(m.graphic=d.destroy())}n.allowOverlapX||(C(u,function(a){a.plotX=a.anchorX;r.push(a)}),t.distribute(r,g?w.len:this.xAxis.len,100),a.forEach(function(a){var b=a.graphic&&u[a.plotX];b&&(a.graphic[a.graphic.isNew?"attr":"animate"]({x:b.pos+b.align*
b.size,anchorX:a.anchorX}),q(b.pos)?a.graphic.isNew=!1:(a.graphic.attr({x:-9999,anchorX:-9999}),a.graphic.isNew=!0))}));n.useHTML&&O(this.markerGroup,"on",function(a){return G.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})};c.prototype.drawTracker=function(){var b=this.points;a.prototype.drawTracker.call(this);b.forEach(function(a){var c=a.graphic;c&&(a.unbindMouseOver&&a.unbindMouseOver(),a.unbindMouseOver=g(c.element,"mouseover",function(){0<a.stackIndex&&
!a.raised&&(a._y=c.y,c.attr({y:a._y-8}),a.raised=!0);b.forEach(function(b){b!==a&&b.raised&&b.graphic&&(b.graphic.attr({y:b._y}),b.raised=!1)})}))})};c.prototype.pointAttribs=function(a,b){var c=this.options,g=a&&a.color||this.color,h=c.lineColor,l=a&&a.lineWidth;a=a&&a.fillColor||c.fillColor;b&&(a=c.states[b].fillColor,h=c.states[b].lineColor,l=c.states[b].lineWidth);return{fill:a||g,stroke:h||g,"stroke-width":l||c.lineWidth||0}};c.prototype.setClip=function(){b.prototype.setClip.apply(this,arguments);
!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])};c.defaultOptions=J(E.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:y.backgroundColor,lineWidth:1,states:{hover:{lineColor:y.neutralColor100,fillColor:y.highlightColor20}},style:{fontSize:"11px",fontWeight:"bold"}});return c}(E);N(w.prototype,{allowDG:!1,buildKDTree:c,
forceCrop:!0,getPlotBox:x.getPlotBox,init:b.prototype.init,invertGroups:c,invertible:!1,noSharedTooltip:!0,pointClass:a,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],translate:x.translate});n.registerSeriesType("flags",w);"";"";return w});J(a,"Extensions/RangeSelector.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/DefaultOptions.js"],a["Core/Color/Palette.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,t,x,y,n,G,w){function v(a){if(-1!==
a.indexOf("%L"))return"text";var b="aAdewbBmoyY".split("").some(function(b){return-1!==a.indexOf("%"+b)}),e="HkIlMS".split("").some(function(b){return-1!==a.indexOf("%"+b)});return b&&e?"datetime-local":b?"date":e?"time":"text"}var c=y.defaultOptions,b=w.addEvent,E=w.createElement,g=w.css,q=w.defined,N=w.destroyObjectProperties,J=w.discardElement,C=w.extend,O=w.find,H=w.fireEvent,B=w.isNumber,l=w.merge,h=w.objectEach,p=w.pad,D=w.pick,K=w.pInt,L=w.splat;C(c,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,
buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:n.highlightColor80,cursor:"pointer"},labelStyle:{color:n.neutralColor60}}});
C(c.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"});var A=function(){function r(a){this.buttons=void 0;this.buttonOptions=r.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=a;this.init(a)}r.prototype.clickButton=function(c,e){var k=this.chart,d=this.buttonOptions[c],f=k.xAxis[0],m=k.scroller&&k.scroller.getUnionExtremes()||f||{},g=m.dataMin,h=m.dataMax,r=f&&Math.round(Math.min(f.max,D(h,f.max))),l=d.type;m=d._range;var n,p=d.dataGrouping;
if(null!==g&&null!==h){k.fixedRange=m;this.setSelected(c);p&&(this.forcedDataGrouping=!0,a.prototype.setDataGrouping.call(f||{chart:this.chart},p,!1),this.frozenStates=d.preserveDataGrouping);if("month"===l||"year"===l)if(f){l={range:d,max:r,chart:k,dataMin:g,dataMax:h};var t=f.minFromRange.call(l);B(l.newMax)&&(r=l.newMax)}else m=d;else if(m)t=Math.max(r-m,g),r=Math.min(t+m,h);else if("ytd"===l)if(f)"undefined"===typeof h&&(g=Number.MAX_VALUE,h=Number.MIN_VALUE,k.series.forEach(function(a){a=a.xData;
g=Math.min(a[0],g);h=Math.max(a[a.length-1],h)}),e=!1),r=this.getYTDExtremes(h,g,k.time.useUTC),t=n=r.min,r=r.max;else{this.deferredYTDClick=c;return}else"all"===l&&f&&(k.navigator&&k.navigator.baseSeries[0]&&(k.navigator.baseSeries[0].xAxis.options.range=void 0),t=g,r=h);q(t)&&(t+=d._offsetMin);q(r)&&(r+=d._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=c+1);if(f)f.setExtremes(t,r,D(e,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:d});else{var u=L(k.options.xAxis)[0];var v=
u.range;u.range=m;var w=u.min;u.min=n;b(k,"load",function(){u.range=v;u.min=w})}H(this,"afterBtnClick")}};r.prototype.setSelected=function(a){this.selected=this.options.selected=a};r.prototype.init=function(a){var e=this,c=a.options.rangeSelector,d=c.buttons||e.defaultButtons.slice(),f=c.selected,m=function(){var a=e.minInput,b=e.maxInput;a&&a.blur&&H(a,"blur");b&&b.blur&&H(b,"blur")};e.chart=a;e.options=c;e.buttons=[];e.buttonOptions=d;this.eventsToUnbind=[];this.eventsToUnbind.push(b(a.container,
"mousedown",m));this.eventsToUnbind.push(b(a,"resize",m));d.forEach(e.computeButtonRange);"undefined"!==typeof f&&d[f]&&this.clickButton(f,!1);this.eventsToUnbind.push(b(a,"load",function(){a.xAxis&&a.xAxis[0]&&b(a.xAxis[0],"setExtremes",function(b){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==b.trigger&&"updatedData"!==b.trigger&&e.forcedDataGrouping&&!e.frozenStates&&this.setDataGrouping(!1,!1)})}))};r.prototype.updateButtonStates=function(){var a=this,b=this.chart,c=this.dropdown,
d=b.xAxis[0],f=Math.round(d.max-d.min),g=!d.hasVisibleSeries,h=b.scroller&&b.scroller.getUnionExtremes()||d,r=h.dataMin,l=h.dataMax;b=a.getYTDExtremes(l,r,b.time.useUTC);var n=b.min,p=b.max,t=a.selected,q=B(t),u=a.options.allButtonsEnabled,v=a.buttons;a.buttonOptions.forEach(function(b,e){var k=b._range,m=b.type,z=b.count||1,h=v[e],I=0,w=b._offsetMax-b._offsetMin;b=e===t;var A=k>l-r,y=k<d.minRange,M=!1,x=!1;k=k===f;("month"===m||"year"===m)&&f+36E5>=864E5*{month:28,year:365}[m]*z-w&&f-36E5<=864E5*
{month:31,year:366}[m]*z+w?k=!0:"ytd"===m?(k=p-n+w===f,M=!b):"all"===m&&(k=d.max-d.min>=l-r,x=!b&&q&&k);m=!u&&(A||y||x||g);z=b&&k||k&&!q&&!M||b&&a.frozenStates;m?I=3:z&&(q=!0,I=2);h.state!==I&&(h.setState(I),c&&(c.options[e+1].disabled=m,2===I&&(c.selectedIndex=e+1)),0===I&&t===e&&a.setSelected())})};r.prototype.computeButtonRange=function(a){var b=a.type,c=a.count||1,d={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(d[b])a._range=d[b]*c;else if("month"===b||"year"===b)a._range=
864E5*{month:30,year:365}[b]*c;a._offsetMin=D(a.offsetMin,0);a._offsetMax=D(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin};r.prototype.getInputValue=function(a){a="min"===a?this.minInput:this.maxInput;var b=this.chart.options.rangeSelector,c=this.chart.time;return a?("text"===a.type&&b.inputDateParser||this.defaultInputDateParser)(a.value,c.useUTC,c):0};r.prototype.setInputValue=function(a,b){var e=this.options,d=this.chart.time,c="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:
this.maxDateBox;if(c){var m=c.getAttribute("data-hc-time");m=q(m)?Number(m):void 0;q(b)&&(q(m)&&c.setAttribute("data-hc-time-previous",m),c.setAttribute("data-hc-time",b),m=b);c.value=d.dateFormat(this.inputTypeFormats[c.type]||e.inputEditDateFormat,m);a&&a.attr({text:d.dateFormat(e.inputDateFormat,m)})}};r.prototype.setInputExtremes=function(a,b,c){if(a="min"===a?this.minInput:this.maxInput){var d=this.inputTypeFormats[a.type],e=this.chart.time;d&&(b=e.dateFormat(d,b),a.min!==b&&(a.min=b),c=e.dateFormat(d,
c),a.max!==c&&(a.max=c))}};r.prototype.showInput=function(a){var b="min"===a?this.minDateBox:this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&b&&this.inputGroup){var c="text"===a.type,d=this.inputGroup,f=d.translateX;d=d.translateY;var m=this.options.inputBoxWidth;g(a,{width:c?b.width+(m?-2:20)+"px":"auto",height:c?b.height-2+"px":"auto",border:"2px solid silver"});c&&m?g(a,{left:f+b.x+"px",top:d+"px"}):g(a,{left:Math.min(Math.round(b.x+f-(a.offsetWidth-b.width)/2),this.chart.chartWidth-
a.offsetWidth)+"px",top:d-(a.offsetHeight-b.height)/2+"px"})}};r.prototype.hideInput=function(a){(a="min"===a?this.minInput:this.maxInput)&&g(a,{top:"-9999em",border:0,width:"1px",height:"1px"})};r.prototype.defaultInputDateParser=function(a,b,c){var d=a.split("/").join("-").split(" ").join("T");-1===d.indexOf("T")&&(d+="T00:00");if(b)d+="Z";else{var e;if(e=x.isSafari)e=d,e=!(6<e.length&&(e.lastIndexOf("-")===e.length-6||e.lastIndexOf("+")===e.length-6));e&&(e=(new Date(d)).getTimezoneOffset()/60,
d+=0>=e?"+"+p(-e)+":00":"-"+p(e)+":00")}d=Date.parse(d);B(d)||(a=a.split("-"),d=Date.UTC(K(a[0]),K(a[1])-1,K(a[2])));c&&b&&B(d)&&(d+=c.getTimezoneOffset(d));return d};r.prototype.drawInput=function(a){function b(){var b=m.getInputValue(a),d=k.xAxis[0],e=k.scroller&&k.scroller.xAxis?k.scroller.xAxis:d,c=e.dataMin;e=e.dataMax;var f=m.maxInput,g=m.minInput;b!==Number(u.getAttribute("data-hc-time-previous"))&&B(b)&&(u.setAttribute("data-hc-time-previous",b),t&&f&&B(c)?b>Number(f.getAttribute("data-hc-time"))?
b=void 0:b<c&&(b=c):g&&B(e)&&(b<Number(g.getAttribute("data-hc-time"))?b=void 0:b>e&&(b=e)),"undefined"!==typeof b&&d.setExtremes(t?b:d.min,t?d.max:b,void 0,void 0,{trigger:"rangeSelectorInput"}))}var k=this.chart,d=this.div,f=this.inputGroup,m=this,h=k.renderer.style||{},r=k.renderer,p=k.options.rangeSelector,t="min"===a,q=c.lang[t?"rangeSelectorFrom":"rangeSelectorTo"];q=r.label(q,0).addClass("highcharts-range-label").attr({padding:q?2:0,height:q?p.inputBoxHeight:0}).add(f);r=r.label("",0).addClass("highcharts-range-input").attr({padding:2,
width:p.inputBoxWidth,height:p.inputBoxHeight,"text-align":"center"}).on("click",function(){m.showInput(a);m[a+"Input"].focus()});k.styledMode||r.attr({stroke:p.inputBoxBorderColor,"stroke-width":1});r.add(f);var u=E("input",{name:a,className:"highcharts-range-selector"},void 0,d);u.setAttribute("type",v(p.inputDateFormat||"%b %e, %Y"));k.styledMode||(q.css(l(h,p.labelStyle)),r.css(l({color:n.neutralColor80},h,p.inputStyle)),g(u,C({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",
width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:h.fontSize,fontFamily:h.fontFamily,top:"-9999em"},p.inputStyle)));u.onfocus=function(){m.showInput(a)};u.onblur=function(){u===x.doc.activeElement&&b();m.hideInput(a);m.setInputValue(a);u.blur()};var w=!1;u.onchange=function(){w||(b(),m.hideInput(a),u.blur())};u.onkeypress=function(a){13===a.keyCode&&b()};u.onkeydown=function(a){w=!0;38!==a.keyCode&&40!==a.keyCode||b()};u.onkeyup=function(){w=!1};return{dateBox:r,input:u,label:q}};r.prototype.getPosition=
function(){var a=this.chart,b=a.options.rangeSelector;a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}};r.prototype.getYTDExtremes=function(a,b,c){var d=this.chart.time,e=new d.Date(a),k=d.get("FullYear",e);c=c?d.Date.UTC(k,0,1):+new d.Date(k,0,1);b=Math.max(b,c);e=e.getTime();return{max:Math.min(a||e,e),min:b}};r.prototype.render=function(a,b){var e=this.chart,d=e.renderer,c=e.container,m=e.options,g=m.rangeSelector,h=D(m.chart.style&&
m.chart.style.zIndex,0)+1;m=g.inputEnabled;if(!1!==g.enabled){this.rendered||(this.group=d.g("range-selector-group").attr({zIndex:7}).add(),this.div=E("div",void 0,{position:"relative",height:0,zIndex:h}),this.buttonOptions.length&&this.renderButtons(),c.parentNode&&c.parentNode.insertBefore(this.div,c),m&&(this.inputGroup=d.g("input-group").add(this.group),d=this.drawInput("min"),this.minDateBox=d.dateBox,this.minLabel=d.label,this.minInput=d.input,d=this.drawInput("max"),this.maxDateBox=d.dateBox,
this.maxLabel=d.label,this.maxInput=d.input));if(m&&(this.setInputValue("min",a),this.setInputValue("max",b),a=e.scroller&&e.scroller.getUnionExtremes()||e.xAxis[0]||{},q(a.dataMin)&&q(a.dataMax)&&(e=e.xAxis[0].minRange||0,this.setInputExtremes("min",a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-e),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+e,a.dataMax)),this.inputGroup)){var r=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(a){if(a){var b=
a.getBBox().width;b&&(a.attr({x:r}),r+=b+g.inputSpacing)}})}this.alignElements();this.rendered=!0}};r.prototype.renderButtons=function(){var a=this,e=this.buttons,k=this.options,d=c.lang,f=this.chart.renderer,g=l(k.buttonTheme),h=g&&g.states,r=g.width||28;delete g.width;delete g.states;this.buttonGroup=f.g("range-selector-buttons").add(this.group);var n=this.dropdown=E("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);
b(n,"touchstart",function(){n.style.fontSize="16px"});[[x.isMS?"mouseover":"mouseenter"],[x.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(d){var c=d[0],f=d[1];b(n,c,function(){var b=e[a.currentButtonIndex()];b&&H(b.element,f||c)})});this.zoomText=f.label(d&&d.rangeSelectorZoom||"",0).attr({padding:k.buttonTheme.padding,height:k.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(k.labelStyle),g["stroke-width"]=D(g["stroke-width"],
0));E("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,n);this.buttonOptions.forEach(function(b,d){E("option",{textContent:b.title||b.text},void 0,n);e[d]=f.button(b.text,0,0,function(e){var c=b.events&&b.events.click,f;c&&(f=c.call(b,e));!1!==f&&a.clickButton(d);a.isActive=!0},g,h&&h.hover,h&&h.select,h&&h.disabled).attr({"text-align":"center",width:r}).add(a.buttonGroup);b.title&&e[d].attr("title",b.title)})};r.prototype.alignElements=function(){var a=this,b=this.buttonGroup,c=this.buttons,
d=this.chart,f=this.group,g=this.inputGroup,h=this.options,r=this.zoomText,l=d.options,n=l.exporting&&!1!==l.exporting.enabled&&l.navigation&&l.navigation.buttonOptions;l=h.buttonPosition;var p=h.inputPosition,t=h.verticalAlign,q=function(b,e){return n&&a.titleCollision(d)&&"top"===t&&"right"===e.align&&e.y-b.getBBox().height-12<(n.y||0)+(n.height||0)+d.spacing[0]?-40:0},u=d.plotLeft;if(f&&l&&p){var v=l.x-d.spacing[3];if(b){this.positionButtons();if(!this.initialButtonGroupWidth){var w=0;r&&(w+=r.getBBox().width+
5);c.forEach(function(a,b){w+=a.width;b!==c.length-1&&(w+=h.buttonSpacing)});this.initialButtonGroupWidth=w}u-=d.spacing[3];this.updateButtonStates();r=q(b,l);this.alignButtonGroup(r);f.placed=b.placed=d.hasLoaded}b=0;g&&(b=q(g,p),"left"===p.align?v=u:"right"===p.align&&(v=-Math.max(d.axisOffset[1],-b)),g.align({y:p.y,width:g.getBBox().width,align:p.align,x:p.x+v-2},!0,d.spacingBox),g.placed=d.hasLoaded);this.handleCollision(b);f.align({verticalAlign:t},!0,d.spacingBox);g=f.alignAttr.translateY;b=
f.getBBox().height+20;q=0;"bottom"===t&&(q=(q=d.legend&&d.legend.options)&&"bottom"===q.verticalAlign&&q.enabled&&!q.floating?d.legend.legendHeight+D(q.margin,10):0,b=b+q-20,q=g-b-(h.floating?0:h.y)-(d.titleOffset?d.titleOffset[2]:0)-10);if("top"===t)h.floating&&(q=0),d.titleOffset&&d.titleOffset[0]&&(q=d.titleOffset[0]),q+=d.margin[0]-d.spacing[0]||0;else if("middle"===t)if(p.y===l.y)q=g;else if(p.y||l.y)q=0>p.y||0>l.y?q-Math.min(p.y,l.y):g-b;f.translate(h.x,h.y+Math.floor(q));l=this.minInput;p=
this.maxInput;g=this.dropdown;h.inputEnabled&&l&&p&&(l.style.marginTop=f.translateY+"px",p.style.marginTop=f.translateY+"px");g&&(g.style.marginTop=f.translateY+"px")}};r.prototype.alignButtonGroup=function(a,b){var e=this.chart,d=this.buttonGroup,c=this.options.buttonPosition,m=e.plotLeft-e.spacing[3],g=c.x-e.spacing[3];"right"===c.align?g+=a-m:"center"===c.align&&(g-=m/2);d&&d.align({y:c.y,width:D(b,this.initialButtonGroupWidth),align:c.align,x:g},!0,e.spacingBox)};r.prototype.positionButtons=function(){var a=
this.buttons,b=this.chart,c=this.options,d=this.zoomText,f=b.hasLoaded?"animate":"attr",g=c.buttonPosition,h=b.plotLeft,r=h;d&&"hidden"!==d.visibility&&(d[f]({x:D(h+g.x,h)}),r+=g.x+d.getBBox().width+5);this.buttonOptions.forEach(function(b,d){if("hidden"!==a[d].visibility)a[d][f]({x:r}),r+=a[d].width+c.buttonSpacing;else a[d][f]({x:h})})};r.prototype.handleCollision=function(a){var b=this,c=this.chart,d=this.buttonGroup,f=this.inputGroup,m=this.options,g=m.buttonPosition,h=m.dropdown,r=m.inputPosition;
m=function(){var a=0;b.buttons.forEach(function(b){b=b.getBBox();b.width>a&&(a=b.width)});return a};var l=function(b){if(f&&d){var e=f.alignAttr.translateX+f.alignOptions.x-a+f.getBBox().x+2,c=f.alignOptions.width,k=d.alignAttr.translateX+d.getBBox().x;return k+b>e&&e+c>k&&g.y<r.y+f.getBBox().height}return!1},n=function(){f&&d&&f.attr({translateX:f.alignAttr.translateX+(c.axisOffset[1]>=-a?0:-a),translateY:f.alignAttr.translateY+d.getBBox().height+10})};if(d){if("always"===h){this.collapseButtons(a);
l(m())&&n();return}"never"===h&&this.expandButtons()}f&&d?r.align===g.align||l(this.initialButtonGroupWidth+20)?"responsive"===h?(this.collapseButtons(a),l(m())&&n()):n():"responsive"===h&&this.expandButtons():d&&"responsive"===h&&(this.initialButtonGroupWidth>c.plotWidth?this.collapseButtons(a):this.expandButtons())};r.prototype.collapseButtons=function(a){var b=this.buttons,c=this.buttonOptions,d=this.chart,f=this.dropdown,m=this.options,g=this.zoomText,h=d.userOptions.rangeSelector&&d.userOptions.rangeSelector.buttonTheme||
{},r=function(a){return{text:a?a+" \u25be":"\u25be",width:"auto",paddingLeft:D(m.buttonTheme.paddingLeft,h.padding,8),paddingRight:D(m.buttonTheme.paddingRight,h.padding,8)}};g&&g.hide();var l=!1;c.forEach(function(a,d){d=b[d];2!==d.state?d.hide():(d.show(),d.attr(r(a.text)),l=!0)});l||(f&&(f.selectedIndex=0),b[0].show(),b[0].attr(r(this.zoomText&&this.zoomText.textStr)));c=m.buttonPosition.align;this.positionButtons();"right"!==c&&"center"!==c||this.alignButtonGroup(a,b[this.currentButtonIndex()].getBBox().width);
this.showDropdown()};r.prototype.expandButtons=function(){var a=this.buttons,b=this.buttonOptions,c=this.options,d=this.zoomText;this.hideDropdown();d&&d.show();b.forEach(function(b,d){d=a[d];d.show();d.attr({text:b.text,width:c.buttonTheme.width||28,paddingLeft:D(c.buttonTheme.paddingLeft,"unset"),paddingRight:D(c.buttonTheme.paddingRight,"unset")});2>d.state&&d.setState(0)});this.positionButtons()};r.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-
1:0};r.prototype.showDropdown=function(){var a=this.buttonGroup,b=this.buttons,c=this.chart,d=this.dropdown;if(a&&d){var f=a.translateX;a=a.translateY;b=b[this.currentButtonIndex()].getBBox();g(d,{left:c.plotLeft+f+"px",top:a+.5+"px",width:b.width+"px",height:b.height+"px"});this.hasVisibleDropdown=!0}};r.prototype.hideDropdown=function(){var a=this.dropdown;a&&(g(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};r.prototype.getHeight=function(){var a=this.options,b=this.group,
c=a.y,d=a.buttonPosition.y,f=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=b?b.getBBox(!0).height+13+c:0;b=Math.min(f,d);if(0>f&&0>d||0<f&&0<d)a+=Math.abs(b);return a};r.prototype.titleCollision=function(a){return!(a.options.title.text||a.options.subtitle.text)};r.prototype.update=function(a){var b=this.chart;l(!0,b.options.rangeSelector,a);this.destroy();this.init(b);this.render()};r.prototype.destroy=function(){var a=this,b=a.minInput,c=a.maxInput;a.eventsToUnbind&&(a.eventsToUnbind.forEach(function(a){return a()}),
a.eventsToUnbind=void 0);N(a.buttons);b&&(b.onfocus=b.onblur=b.onchange=null);c&&(c.onfocus=c.onblur=c.onchange=null);h(a,function(b,c){b&&"chart"!==c&&(b instanceof G?b.destroy():b instanceof window.HTMLElement&&J(b));b!==r.prototype[c]&&(a[c]=null)},this)};return r}();A.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},
{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];A.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};a.prototype.minFromRange=function(){var a=this.range,b=a.type,c=this.max,k=this.chart.time,d=function(a,d){var c="year"===b?"FullYear":"Month",e=new k.Date(a),f=k.get(c,e);k.set(c,e,f+d);f===k.get(c,e)&&k.set("Date",e,0);return e.getTime()-a};if(B(a)){var f=c-a;var g=a}else f=c+d(c,-a.count),this.chart&&(this.chart.fixedRange=
c-f);var h=D(this.dataMin,Number.MIN_VALUE);B(f)||(f=h);f<=h&&(f=h,"undefined"===typeof g&&(g=d(f,a.count)),this.newMax=Math.min(f+g,this.dataMax));B(c)||(f=void 0);return f};if(!x.RangeSelector){var F=[],u=function(a){function c(){k&&(e=a.xAxis[0].getExtremes(),d=a.legend,g=k&&k.options.verticalAlign,B(e.min)&&k.render(e.min,e.max),d.display&&"top"===g&&g===d.options.verticalAlign&&(f=l(a.spacingBox),f.y="vertical"===d.options.layout?a.plotTop:f.y+k.getHeight(),d.group.placed=!1,d.align(f)))}var e,
k=a.rangeSelector,d,f,g;k&&(O(F,function(b){return b[0]===a})||F.push([a,[b(a.xAxis[0],"afterSetExtremes",function(a){k&&k.render(a.min,a.max)}),b(a,"redraw",c)]]),c())};b(t,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new A(this))});b(t,"beforeRender",function(){var a=this.axes,b=this.rangeSelector;b&&(B(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),
this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))});b(t,"update",function(a){var b=a.options.rangeSelector;a=this.rangeSelector;var c=this.extraBottomMargin,k=this.extraTopMargin;b&&b.enabled&&!q(a)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=a=new A(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(u(this),b=b&&b.verticalAlign||a.options&&
a.options.verticalAlign,a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0)),this.extraBottomMargin!==c||this.extraTopMargin!==k)&&(this.isDirtyBox=!0)});b(t,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))});b(t,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=
a),this.extraBottomMargin&&(this.marginBottom+=a))});t.prototype.callbacks.push(u);b(t,"destroy",function(){for(var a=0;a<F.length;a++){var b=F[a];if(b[0]===this){b[1].forEach(function(a){return a()});F.splice(a,1);break}}});x.RangeSelector=A}return A});J(a,"Core/Chart/StockChart.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/FormatUtilities.js"],a["Core/DefaultOptions.js"],a["Core/Color/Palette.js"],a["Core/Series/Point.js"],a["Core/Series/Series.js"],
a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,t,x,y,n,G,w,v,c,b){function E(a,b){return"xAxis"===a?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:"yAxis"===a?{labels:{y:-2},opposite:r(b.opposite,!0),showLastLabel:!(!b.categories&&"category"!==b.type),title:{text:null}}:{}}function g(a,b){if("xAxis"===a){a=C();var d={type:"datetime",categories:void 0};r(b.navigator&&b.navigator.enabled,a.navigator.enabled,
!0)&&(d.startOnTick=!1,d.endOnTick=!1);return d}return{}}var q=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return a(b,d)};return function(b,d){function c(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),J=a.animObject,N=y.format,C=n.getOptions,O=w.prototype.tooltipFormatter;a=v.prototype;
var H=a.init,B=a.processData;a=b.addEvent;var l=b.arrayMax,h=b.arrayMin,p=b.clamp,D=b.defined,K=b.extend,L=b.find,A=b.isNumber,F=b.isString,u=b.merge,r=b.pick,m=b.splat;b=function(a){function b(){return null!==a&&a.apply(this,arguments)||this}q(b,a);b.prototype.init=function(b,c){var d=C(),e=b.xAxis,f=b.yAxis,k=r(b.navigator&&b.navigator.enabled,d.navigator.enabled,!0);b.xAxis=b.yAxis=void 0;k=u({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:k},scrollbar:{enabled:r(d.scrollbar&&
d.scrollbar.enabled,!0)},rangeSelector:{enabled:r(d.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:r(d.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},b,{isStock:!0});b.xAxis=e;b.yAxis=f;k.xAxis=m(b.xAxis||{}).map(function(a,c){return u(E("xAxis",a),d.xAxis,d.xAxis&&d.xAxis[c],a,g("xAxis",b))});k.yAxis=m(b.yAxis||{}).map(function(a,b){return u(E("yAxis",a),d.yAxis,d.yAxis&&d.yAxis[b],a)});a.prototype.init.call(this,k,c)};b.prototype.createAxis=function(b,c){c.axis=u(E(b,c.axis),
c.axis,g(b,this.userOptions));return a.prototype.createAxis.call(this,b,c)};return b}(x);(function(a){a.stockChart=function(b,d,c){return new a(b,d,c)}})(b||(b={}));a(v,"setOptions",function(a){var b;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?b={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(b={marker:{enabled:!1,radius:2}}),b&&(a.plotOptions[this.type]=u(a.plotOptions[this.type],b)))});a(t,"autoLabelAlign",function(a){var b=this.chart,d=this.options;b=b._labelPanes=
b._labelPanes||{};var c=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(d=d.top+","+d.height,!b[d]&&c.enabled&&(15===c.x&&(c.x=0),"undefined"===typeof c.align&&(c.align="right"),b[d]=this,a.align="right",a.preventDefault()))});a(t,"destroy",function(){var a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});a(t,"getPlotLinePath",function(a){function b(a){var b="xAxis"===a?"yAxis":"xAxis";a=
d.options[b];return A(a)?[e[b][a]]:F(a)?[e.get(a)]:c.map(function(a){return a[b]})}var d=this,c=this.isLinked&&!this.series?this.linkedParent.series:this.series,e=d.chart,g=e.renderer,h=d.left,l=d.top,m,n,q,t,u=[],v=[],w=a.translatedValue,y=a.value,x=a.force;if(e.options.isStock&&!1!==a.acrossPanes&&"xAxis"===d.coll||"yAxis"===d.coll){a.preventDefault();v=b(d.coll);var B=d.isXAxis?e.yAxis:e.xAxis;B.forEach(function(a){if(D(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var b=a.isXAxis?"yAxis":
"xAxis";b=D(a.options[b])?e[b][a.options[b]]:e[b][0];d===b&&v.push(a)}});var C=v.length?[]:[d.isXAxis?e.yAxis[0]:e.xAxis[0]];v.forEach(function(a){-1!==C.indexOf(a)||L(C,function(b){return b.pos===a.pos&&b.len===a.len})||C.push(a)});var E=r(w,d.translate(y,null,null,a.old));A(E)&&(d.horiz?C.forEach(function(a){var b;n=a.pos;t=n+a.len;m=q=Math.round(E+d.transB);"pass"!==x&&(m<h||m>h+d.width)&&(x?m=q=p(m,h,h+d.width):b=!0);b||u.push(["M",m,n],["L",q,t])}):C.forEach(function(a){var b;m=a.pos;q=m+a.len;
n=t=Math.round(l+d.height-E);"pass"!==x&&(n<l||n>l+d.height)&&(x?n=t=p(n,l,l+d.height):b=!0);b||u.push(["M",m,n],["L",q,t])}));a.path=0<u.length?g.crispPolyLine(u,a.lineWidth||1):null}});c.prototype.crispPolyLine=function(a,b){for(var d=0;d<a.length;d+=2){var c=a[d],e=a[d+1];c[1]===e[1]&&(c[1]=e[1]=Math.round(c[1])-b%2/2);c[2]===e[2]&&(c[2]=e[2]=Math.round(c[2])+b%2/2)}return a};a(t,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});a(t,"afterDrawCrosshair",
function(a){var b,c;if(this.crosshair&&this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&A(this.min)&&A(this.max)){var e=this.chart,g=this.logarithmic,h=this.crosshair.label,l=this.horiz,m=this.opposite,n=this.left,p=this.top,q=this.crossLabel,t=h.format,u="",v="inside"===this.options.tickPosition,w=!1!==this.crosshair.snap,y=0,x=a.e||this.cross&&this.cross.e;a=a.point;var B=this.min,C=this.max;g&&(B=g.lin2log(B),C=g.lin2log(C));g=l?"center":m?"right"===this.labelAlign?"right":"left":
"left"===this.labelAlign?"left":"center";q||(q=this.crossLabel=e.renderer.label("",0,void 0,h.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(a?a.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:h.align||g,padding:r(h.padding,8),r:r(h.borderRadius,3),zIndex:2}).add(this.labelGroup),e.styledMode||q.attr({fill:h.backgroundColor||a&&a.series&&a.series.color||G.neutralColor60,stroke:h.borderColor||"","stroke-width":h.borderWidth||0}).css(K({color:G.backgroundColor,
fontWeight:"normal",fontSize:"11px",textAlign:"center"},h.style||{})));l?(g=w?(a.plotX||0)+n:x.chartX,p+=m?0:this.height):(g=m?this.width+n:0,p=w?(a.plotY||0)+p:x.chartY);t||h.formatter||(this.dateTime&&(u="%b %d, %Y"),t="{value"+(u?":"+u:"")+"}");u=w?this.isXAxis?a.x:a.y:this.toValue(l?x.chartX:x.chartY);w=a?a.series.isPointInside(a):A(u)&&u>B&&u<C;x="";t?x=N(t,{value:u},e):h.formatter&&A(u)&&(x=h.formatter.call(this,u));q.attr({text:x,x:g,y:p,visibility:w?"visible":"hidden"});h=q.getBBox();if(A(q.y))if(l){if(v&&
!m||!v&&m)p=q.y-h.height}else p=q.y-h.height/2;l?(b=n-h.x,c=n+this.width-h.x):(b="left"===this.labelAlign?n:0,c="right"===this.labelAlign?n+this.width:e.chartWidth);q.translateX<b&&(y=b-q.translateX);q.translateX+h.width>=c&&(y=-(q.translateX+h.width-c));q.attr({x:g+y,y:p,anchorX:l?g:this.opposite?0:e.chartWidth,anchorY:l?this.opposite?e.chartHeight:0:p+h.height/2})}});v.prototype.init=function(){H.apply(this,arguments);this.initCompare(this.options.compare)};v.prototype.setCompare=function(a){this.initCompare(a);
this.userOptions.compare=a};v.prototype.initCompare=function(a){this.modifyValue="value"===a||"percent"===a?function(b,c){var d=this.compareValue;return"undefined"!==typeof b&&"undefined"!==typeof d?(b="value"===a?b-d:b/d*100-(100===this.options.compareBase?0:100),c&&(c.change=b),b):0}:null;this.chart.hasRendered&&(this.isDirty=!0)};v.prototype.processData=function(a){var b,c=-1,e=!0===this.options.compareStart?0:1;B.apply(this,arguments);if(this.xAxis&&this.processedYData){var g=this.processedXData;
var h=this.processedYData;var l=h.length;this.pointArrayMap&&(c=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(b=0;b<l-e;b++){var m=h[b]&&-1<c?h[b][c]:h[b];if(A(m)&&g[b+e]>=this.xAxis.min&&0!==m){this.compareValue=m;break}}}};a(v,"afterGetExtremes",function(a){a=a.dataExtremes;if(this.modifyValue&&a){var b=[this.modifyValue(a.dataMin),this.modifyValue(a.dataMax)];a.dataMin=h(b);a.dataMax=l(b)}});t.prototype.setCompare=function(a,b){this.isXAxis||(this.series.forEach(function(b){b.setCompare(a)}),
r(b,!0)&&this.chart.redraw())};w.prototype.tooltipFormatter=function(a){var b=this.series.chart.numberFormatter;a=a.replace("{point.change}",(0<this.change?"+":"")+b(this.change,r(this.series.tooltipOptions.changeDecimals,2)));return O.apply(this,[a])};a(v,"render",function(){var a=this.chart;if(!(a.is3d&&a.is3d()||a.polar)&&this.xAxis&&!this.xAxis.isRadial&&!1!==this.options.clip){var b=this.yAxis.len;if(this.xAxis.axisLine){var c=a.plotTop+a.plotHeight-this.yAxis.pos-this.yAxis.len,f=Math.floor(this.xAxis.axisLine.strokeWidth()/
2);0<=c&&(b-=Math.max(f-c,0))}if(!a.hasLoaded||!this.clipBox&&this.isDirty&&!this.isDirtyData)this.clipBox=this.clipBox||u(a.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=b;a.hasRendered&&(c=J(this.options.animation),c=this.getSharedClipKey(c),f=a.sharedClips[c])&&(f.animate({width:this.xAxis.len,height:b}),(a=a.sharedClips[c+"m"])&&a.animate({width:this.xAxis.len}))}});a(x,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(u(!0,this.options.scrollbar,a.scrollbar),
this.navigator.update({},!1),delete a.scrollbar)});"";return b});J(a,"masters/modules/stock.src.js",[a["Core/Globals.js"],a["Core/Scrollbar.js"],a["Core/Chart/StockChart.js"]],function(a,t,x){a.Scrollbar=t;a.StockChart=a.stockChart=x.stockChart;t.compose(a.Axis)})});
//# sourceMappingURL=stock.js.map